package com.ejianc.foundation.usercenter.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.usercenter.hystrix.FaceHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(name= "ejc-idm-web", url="${common.env.feign-client-url}", path="ejc-idm-web", fallback = FaceHystrix.class)
public interface IFaceAndIdCardService {

    /**
     * 校验照片是否包含可用人脸，通过，返回true，不通过返回false
     *
     * @param imgUrl 人脸照片地址
     *
     * @return {@link CommonResponse}<{@link Boolean}>
     */
    @GetMapping(value = "/api/aliyun/checkFaceQuality")
    CommonResponse<Boolean> checkFaceQuality(@RequestParam("imgUrl") String imgUrl);


    /**
     * 校验照片是否包含可用人脸，通过，返回true，不通过返回false
     *
     * @param bytes 人脸照片byte数组
     *
     * @return {@link CommonResponse}<{@link Boolean}>
     */
    @PostMapping(value = "/api/aliyun/checkFaceQualityByte")
    CommonResponse<Boolean> checkFaceQualityByte(@RequestBody byte[] bytes);


    /**
     * 人脸照片活体检查
     * 通过，返回true，不通过返回false
     *
     * @param imgUrl
     *
     * @return
     */
    @GetMapping(value = "/api/aliyun/liveCheck")
    CommonResponse<Boolean> liveCheck(@RequestParam("imgUrl") String imgUrl);


    /**
     * 对比两张图片是否是同一个人
     * 是，返回true，不是返回false
     * 支持URL与Base64编码字符串混合输入。
     * 例如：输入imgUrlA和imgBase64B的值，不输入imgUrlB和imgBase64A的值,合法。
     * param 的键值
     * @param imgUrlA
     * @param imgUrlB
     * @param imgBase64A
     * @param imgBase64B
     * @return
     */
    @PostMapping(value = "/api/aliyun/compareFace")
    CommonResponse<Boolean> compareFace(@RequestBody JSONObject param);


    /**
     * 对比两张图片是否是同一个人 支持戴口罩进行识别
     *
     * 仅支持Base64编码字符串输入。
     *
     * param 的键值
     * @param imgBase64A
     * @param imgBase64B
     * @return 是，返回true，不是返回false
     */
    @PostMapping(value = "/api/aliyun/compareFaceWithMask")
    CommonResponse<Boolean> compareFaceWithMask(@RequestBody JSONObject param);

    /**
     * 创建人脸数据库用户
     * @param userId
     * @param userName
     * @return
     */
    @GetMapping(value = "/api/aliyun/createFaceDbUser")
    CommonResponse<Boolean> createFaceDbUser(@RequestParam("userId") Long userId,@RequestParam("userName") String userName);

    /**
     * 更新人脸数据库用户
     * @param userId
     * @param userName
     * @return
     */
    @GetMapping(value = "/api/aliyun/updateFaceDbUser")
    CommonResponse<Boolean> updateFaceDbUser(@RequestParam("userId") Long userId,@RequestParam("userName") String userName);

    /**
     * 删除人脸数据库用户
     * @param userId
     * @return
     */
    @GetMapping(value = "/api/aliyun/deleteFaceDbUser")
    CommonResponse<Boolean> deleteFaceDbUser(@RequestParam("userId") Long userId);


    /**
     * 查询人脸数据库用户是否存在
     * true 已存在，false不存在
     * @param userId
     * @return
     */
    @GetMapping(value = "/api/aliyun/getFaceDbUser")
    CommonResponse<Boolean> getFaceDbUser(@RequestParam("userId") Long userId);


    /**
     * 根据照片，查询符合照片的员工id
     *
     * @param imgUrl
     * @return userId
     */
    @GetMapping(value = "/api/aliyun/getUserByFaceImg")
    CommonResponse<List<Long>> getUserByFaceImg(@RequestParam("imgUrl") String imgUrl);


    /**
     * 根据照片，查询符合照片的员工id
     *
     * @param bytes
     * @return userId
     */
    @PostMapping(value = "/api/aliyun/getUserByFaceImgByte")
    CommonResponse<List<Long>> getUserByFaceImgByte(@RequestBody byte[] bytes);


    /**
     * 添加人脸数据到指定用户
     *
     * @param userId
     * @param imageUrl
     * @return
     */
    @GetMapping(value = "/api/aliyun/addFaceToUser")
    CommonResponse<Boolean> addFaceToUser(@RequestParam("userId") Long userId,@RequestParam("imageUrl") String imageUrl);


    /**
     * 身份证件是否翻拍校验
     * true 翻拍，false 直拍
     * @param imageUrl
     * @return
     */
    @GetMapping(value = "/api/aliyun/detectCardScreenshot")
    CommonResponse<Boolean> detectCardScreenshot(@RequestParam("imageUrl") String imageUrl);


    /**
     * 身份证件 信息识别
     * true 翻拍，false 直拍
     * @param imageUrl
     * @param side face：人像面  back：国徽面
     * @return side 是 back 才返回startDate，endDate，issue
     *
     * {
     *     name:姓名,
     *     gender:性别：男、女,
     *     nationality:民族:汉,
     *     birthDate:出生19901122,
     *     address:住址,
     *     idNumber:身份证号,
     *
     *     startDate:起始有效期20200102,
     *     endDate:截止有效期20290102,
     *     issue:颁发机关：xxx公安局
     * }
     */
    @GetMapping(value = "/api/aliyun/recognizeIdentityCardInfo")
    CommonResponse<JSONObject> recognizeIdentityCardInfo(@RequestParam("imageUrl") String imageUrl,@RequestParam("side")  String side);

    
}
