package com.ejianc.foundation.news.vo;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 公告表
 * 
 * @author generator
 * 
 */
public class GonggaoVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String code; // 编号
    private String name; // 标题
    private String noticeType; // 公告类型： 系统升级sysUp，系统维护sysDev，平台活动sysAct，其他other，到期提醒endTime
    private String noticeWay; // 提醒方式： 首次登录弹窗firstSignIn，期间每次登录弹窗eachSignIn，期间每天首次登录弹窗eachDaySignIn，不弹窗noAlert
    private String noticeScope; // 可见范围: 全部租户all，公有云租户saas，协同租户coop，指定租户assign
    private String noticeScopeTenantIds; // 可见范围租户id
    private String noticeAbstract; // 摘要
    private String publicWay; // 发布方式: 手动发布hand，自定发布auto
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date publicTime; // 发布时间
    private String publicStatus; // 发布状态 未上线free，已上线onLine，已下线offLine
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date noticeEndTime; // 弹窗提醒截止时间
    private String content; // 内容
    private Boolean tenantShow; // 租户公告列表是否显示

    List<GonggaoSubVO> tenants = new ArrayList<>();

    public List<GonggaoSubVO> getTenants() {
        return tenants;
    }

    public void setTenants(List<GonggaoSubVO> tenants) {
        this.tenants = tenants;
    }

    public Boolean getTenantShow() {
        return tenantShow;
    }

    public void setTenantShow(Boolean tenantShow) {
        this.tenantShow = tenantShow;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getNoticeType() {
        return noticeType;
    }

    public void setNoticeType(String noticeType) {
        this.noticeType = noticeType;
    }
    public String getNoticeWay() {
        return noticeWay;
    }

    public void setNoticeWay(String noticeWay) {
        this.noticeWay = noticeWay;
    }
    public String getNoticeScope() {
        return noticeScope;
    }

    public void setNoticeScope(String noticeScope) {
        this.noticeScope = noticeScope;
    }
    public String getNoticeScopeTenantIds() {
        return noticeScopeTenantIds;
    }

    public void setNoticeScopeTenantIds(String noticeScopeTenantIds) {
        this.noticeScopeTenantIds = noticeScopeTenantIds;
    }
    public String getNoticeAbstract() {
        return noticeAbstract;
    }

    public void setNoticeAbstract(String noticeAbstract) {
        this.noticeAbstract = noticeAbstract;
    }
    public String getPublicWay() {
        return publicWay;
    }

    public void setPublicWay(String publicWay) {
        this.publicWay = publicWay;
    }
    public Date getPublicTime() {
        return publicTime;
    }

    public void setPublicTime(Date publicTime) {
        this.publicTime = publicTime;
    }
    public String getPublicStatus() {
        return publicStatus;
    }

    public void setPublicStatus(String publicStatus) {
        this.publicStatus = publicStatus;
    }
    public Date getNoticeEndTime() {
        return noticeEndTime;
    }

    public void setNoticeEndTime(Date noticeEndTime) {
        this.noticeEndTime = noticeEndTime;
    }
    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }
    
}
