package com.ejianc.foundation.usercenter.api;

import com.ejianc.foundation.usercenter.hystrix.SupplierUserProjectHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @date 2022/2/22 11:57
 */
@FeignClient(name= "ejc-idm-web", url="${common.env.feign-client-url}", path="ejc-idm-web", fallback = SupplierUserProjectHystrix.class)
public interface ISupplierUserProjectApi {

    /**
     * 供方（公有云）使用，根据用户id查询该用户拥有的私有化项目id集合
     * @param userId
     * @return
     */
    @GetMapping(value = "/api/supplierUserProject/getProjectIdsByUserId")
    CommonResponse<List<Long>> getProjectIdsByUserId(@RequestParam(value = "userId") Long userId);

    /**
     * 供方（公有云）使用，业务数据保存时候，调用该接口，保存业务数据里面的项目信息，供后续业务使用
     * @param projectId 项目id
     * @param code 项目code
     * @param name 项目name
     * @param cooperation 该项目所在的私有化企业id，也就是systemid，企业表的id
     * @return
     */
    @GetMapping(value = "/api/supplierUserProject/saveSupplierProject")
    CommonResponse<Boolean> saveSupplierProject(
            @RequestParam(value = "projectId") Long projectId,
            @RequestParam(value = "code") String code,
            @RequestParam(value = "name") String name,
            @RequestParam(value = "cooperation") Long cooperation
    );

}
