package com.ejianc.foundation.wzxtUserProject.api;

import java.util.List;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.foundation.wzxtUserProject.hystrix.WzxtUserProjectRelationHystrix;
import com.ejianc.foundation.wzxtUserProject.vo.WzxtUserProjectRelationVO;
import com.ejianc.framework.core.response.CommonResponse;

/**
 * 用户项目的rpc服务
 * 
 * @author liyongjia
 *
 */
@FeignClient(name= "ejc-idm-web", url="${common.env.feign-client-url}", path="ejc-idm-web", fallback = WzxtUserProjectRelationHystrix.class)
public interface IWzxtUserProjectRelationApi {

	/**
	 * 用户获取有权限的项目，为空代表全部项目的权限
	 * 
	 * @return
	 */
	@RequestMapping(value = "/api/userProject/queryProjectByUserId", method = RequestMethod.GET)
	@ResponseBody
    CommonResponse<List<WzxtUserProjectRelationVO>> queryProjectByUserId(@RequestParam("userId") Long userId);

	/**
	 * 根据项目+供应商获取对应有消息接收权限的用户
	 * 
	 * @return
	 */
	@RequestMapping(value = "/api/userProject/queryUserByProjectAndTenant", method = RequestMethod.GET)
	@ResponseBody
    CommonResponse<List<UserVO>> queryUserByProjectAndTenant(@RequestParam("projectId") Long projectId, @RequestParam("tenantId") Long tenantId);
	

}
