package com.ejianc.foundation.permission.vo;

import java.util.ArrayList;
import java.util.List;

import com.ejianc.framework.skeleton.template.BaseVO;

public class AppVO extends BaseVO {

	private static final long serialVersionUID = 1L;
	
	private Long moduleId;// 应用分组Id

	private String moduleName;// 应用编码

	private String code;// 应用编码

	private String name;// 应用名称

	private Integer source;// 应用来源 1内部  2外部

	private Integer classify;// 应用分类 1运营  2业务  3运营+业务

	private String type;// 应用类型 1PC 2移动

	private String pcUrl;// pc地址

	private String mobileUrl;// 移动地址

	private Integer btnPower;// 按钮权限 1启用 2停用

	private String notes;// 备注
	
	private String sequence;// 排序
	
	private String appIconSrc;// 应用图标预览地址

	private String classifyName;// 应用分类 1运营  2业务  3运营+业务
	
	private String openMode;// 打开方式，1、系统内页签，2、浏览器页签
	
	private Long userId;// 供方协同---用户
	/**
	 * 应用新增页面路径，仅用于pc菜单使用
	 */
	private String appAddPath;

	private List<ButtonVO> children = new ArrayList<>();

	/** 应用挂载的单据类型 */
	private List<AppBillVO> billTypes = new ArrayList<>();

	public List<AppBillVO> getBillTypes() {
		return billTypes;
	}

	public void setBillTypes(List<AppBillVO> billTypes) {
		this.billTypes = billTypes;
	}

	private String typeAppName;
	public Long getModuleId() {
		return moduleId;
	}

	public void setModuleId(Long moduleId) {
		this.moduleId = moduleId;
	}

	public String getModuleName() {
		return moduleName;
	}

	public void setModuleName(String moduleName) {
		this.moduleName = moduleName;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Integer getSource() {
		return source;
	}

	public void setSource(Integer source) {
		this.source = source;
	}

	public Integer getClassify() {
		return classify;
	}

	public void setClassify(Integer classify) {
		this.classify = classify;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getPcUrl() {
		return pcUrl;
	}

	public void setPcUrl(String pcUrl) {
		this.pcUrl = pcUrl;
	}

	public String getMobileUrl() {
		return mobileUrl;
	}

	public void setMobileUrl(String mobileUrl) {
		this.mobileUrl = mobileUrl;
	}

	public Integer getBtnPower() {
		return btnPower;
	}

	public void setBtnPower(Integer btnPower) {
		this.btnPower = btnPower;
	}

	public String getNotes() {
		return notes;
	}

	public void setNotes(String notes) {
		this.notes = notes;
	}

	public String getSequence() {
		return sequence;
	}

	public void setSequence(String sequence) {
		this.sequence = sequence;
	}

	public List<ButtonVO> getChildren() {
//		if(children == null) {
//			children = new ArrayList<>();
//		}
		return children;
	}

	public void setChildren(List<ButtonVO> children) {
		this.children = children;
	}

	public String getAppIconSrc() {
		return appIconSrc;
	}

	public void setAppIconSrc(String appIconSrc) {
		this.appIconSrc = appIconSrc;
	}

	public String getClassifyName() {
		if(classify==1){
			return "运营";
		}else if(classify == 2){
			return "业务";
		}else if(classify == 3){
			return "运营+业务";
		}else if(classify == 5){
			return "协同";
		}
		return classifyName;
	}

	public String getTypeName() {
		if("1".equals(type)){
			return "PC";//应用类型 1PC 2移动
		}else if("2".equals(type)){
			return "移动";
		}else if("1,2".equals(type)){
			return "PC,移动";
		}
		return "未知";
	}

	public void setClassifyName(String classifyName) {
		this.classifyName = classifyName;
	}

	public Long getUserId() {
		return userId;
	}

	public void setUserId(Long userId) {
		this.userId = userId;
	}

	public String getOpenMode() {
		return openMode;
	}

	public void setOpenMode(String openMode) {
		this.openMode = openMode;
	}


	public String getTypeAppName() {
		return typeAppName;
	}

	public void setTypeAppName(String typeAppName) {
		this.typeAppName = typeAppName;
	}

	public String getAppAddPath() {
		return appAddPath;
	}

	public void setAppAddPath(String appAddPath) {
		this.appAddPath = appAddPath;
	}
}
