package com.ejianc.foundation.sync.api;

import java.util.List;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import com.ejianc.foundation.sync.hystrix.SyncHystrix;
import com.ejianc.foundation.sync.vo.SyncEmployeeAndUserVO;
import com.ejianc.foundation.sync.vo.SyncJobVO;
import com.ejianc.foundation.sync.vo.SyncOrgAndDeptVO;
import com.ejianc.framework.core.response.CommonResponse;

/**
 * 同步数据的rpc服务
 * 
 * @author liyongjia
 *
 */
@FeignClient(name= "ejc-idm-web", url="${common.env.feign-client-url}", path="ejc-idm-web", fallback = SyncHystrix.class)
public interface ISyncApi {

	/**
	 * 组织+部门
	 *
	 * @param orgAndDeptVO
	 * @return
	 */
	@PostMapping(value = "api/sync/syncOrgAndDeptList")
    CommonResponse<String> syncOrgAndDeptList(List<SyncOrgAndDeptVO> orgAndDeptVOs);

	/**
	 * 人员+用户
	 *
	 * @param employeeAndUserVOs
	 * @return
	 */
	@PostMapping(value = "api/sync/syncEmployeeAndUserList")
    CommonResponse<String> syncEmployeeAndUserList(List<SyncEmployeeAndUserVO> employeeAndUserVOs);
	
	/**
	 * 兼职
	 *
	 * @param jobVO
	 * @return
	 */
	@PostMapping(value = "api/sync/syncJobList")
    CommonResponse<String> syncJobList(@RequestBody List<SyncJobVO> jobVO);

}
