package com.ejianc.foundation.orgcenter.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

/**
 * 岗位VO
 * 
 * @author guominga
 *
 */
public class PostVO extends BaseVO {

	private static final long serialVersionUID = 1L;

	/**
	 * 岗位状态：启用
	 */
	public static Integer POST_STATE_ACTIVE = 1;

	/**
	 * 岗位状态：停用
	 */
	public static Integer POST_STATE_INACTIVE = 0;

	/**
	 * 岗位编码
	 */
	private String code;

	/**
	 * 岗位名称
	 */
	private String name;

	/**
	 * 备注
	 */
	private String note;

	/**
	 * 状态（1：启用， 0：停用）
	 */
	private Integer state;

	/**
	 * 排序号
	 */
	private Integer sequence;

	/**
	 * 岗位类型：1-公共档案，0-自定义
	 */
	private Integer type;
	
	private Long pid;// 上级Id
	
	private String innerCode; // 内码

	/**
	 * 岗位来源数据Id
	 */
	private String sourceId;
	
	private Long orgId;

	private Integer postType;

	private String systemId; // 系统id

	private String orgName; // 组织名称

	private Long postDictId;

	public String getOrgName() {
		return orgName;
	}

	public void setOrgName(String orgName) {
		this.orgName = orgName;
	}

	@ReferSerialTransfer(referCode="idm-postdict")
	public Long getPostDictId() {
		return postDictId;
	}

	@ReferDeserialTransfer
	public void setPostDictId(Long postDictId) {
		this.postDictId = postDictId;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getNote() {
		return note;
	}

	public void setNote(String note) {
		this.note = note;
	}

	public Integer getState() {
		return state;
	}

	public void setState(Integer state) {
		this.state = state;
	}

	public Integer getSequence() {
		return sequence;
	}

	public void setSequence(Integer sequence) {
		this.sequence = sequence;
	}

	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}

	public String getSourceId() {
		return sourceId;
	}

	public void setSourceId(String sourceId) {
		this.sourceId = sourceId;
	}

	public Long getOrgId() {
		return orgId;
	}

	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public Integer getPostType() {
		return postType;
	}

	public void setPostType(Integer postType) {
		this.postType = postType;
	}

	public Long getPid() {
		return pid;
	}

	public void setPid(Long pid) {
		this.pid = pid;
	}

	public String getInnerCode() {
		return innerCode;
	}

	public void setInnerCode(String innerCode) {
		this.innerCode = innerCode;
	}

	public String getSystemId() {
		return systemId;
	}

	public void setSystemId(String systemId) {
		this.systemId = systemId;
	}
}
