package com.ejianc.foundation.usercenter.hystrix;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.usercenter.api.IFaceAndIdCardService;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * @author CJ
 * @Description:
 * @date 2020/8/6 13:56
 */
@Component
public class FaceHystrix implements IFaceAndIdCardService {

    /**
     * 校验照片是否包含可用人脸，通过，返回true，不通过返回false
     *
     * @param imgUrl 人脸照片地址
     *
     * @return {@link CommonResponse}<{@link Boolean}>
     */
    @Override
    public CommonResponse<Boolean> checkFaceQuality(String imgUrl) {
        return CommonResponse.error("网络问题，查询失败。");
    }


    /**
     * 校验照片是否包含可用人脸，通过，返回true，不通过返回false
     *
     * @param bytes 人脸照片byte数组
     *
     * @return {@link CommonResponse}<{@link Boolean}>
     */
    @Override
    public CommonResponse<Boolean> checkFaceQualityByte(byte[] bytes) {
        return CommonResponse.error("网络问题，查询失败。");
    }

    /**
     * 人脸照片活体检查
     * 通过，返回true，不通过返回false
     *
     * @param imgUrl
     *
     * @return
     */
    @Override
    public CommonResponse<Boolean> liveCheck(String imgUrl) {
        return CommonResponse.error("网络问题，查询失败。");
    }

    /**
     * 对比两张图片是否是同一个人
     * 是，返回true，不是返回false
     * 支持URL与Base64编码字符串混合输入。
     * 例如：输入imgUrlA和imgBase64B的值，不输入imgUrlB和imgBase64A的值,合法。
     *
     * @return
     */
    @Override
    public CommonResponse<Boolean> compareFace(JSONObject param) {
        return CommonResponse.error("网络问题，查询失败。");
    }

    /**
     * 对比两张图片是否是同一个人 支持戴口罩进行识别
     * <p>
     * 仅支持Base64编码字符串输入。
     *
     * @return 是，返回true，不是返回false
     */
    @Override
    public CommonResponse<Boolean> compareFaceWithMask(JSONObject param) {
        return CommonResponse.error("网络问题，查询失败。");
    }

    /**
     * 创建人脸数据库用户
     *
     * @param userId
     * @param userName
     * @return
     */
    @Override
    public CommonResponse<Boolean> createFaceDbUser(Long userId, String userName) {
        return CommonResponse.error("网络问题，查询失败。");
    }

    /**
     * 更新人脸数据库用户
     *
     * @param userId
     * @param userName
     * @return
     */
    @Override
    public CommonResponse<Boolean> updateFaceDbUser(Long userId, String userName) {
        return CommonResponse.error("网络问题，查询失败。");
    }

    /**
     * 删除人脸数据库用户
     *
     * @param userId
     * @return
     */
    @Override
    public CommonResponse<Boolean> deleteFaceDbUser(Long userId) {
        return CommonResponse.error("网络问题，查询失败。");
    }

    /**
     * 查询人脸数据库用户是否存在
     * true 已存在，false不存在
     *
     * @param userId
     * @return
     */
    @Override
    public CommonResponse<Boolean> getFaceDbUser(Long userId) {
        return CommonResponse.error("网络问题，查询失败。");
    }

    /**
     * 根据照片，查询符合照片的员工id
     *
     * @param imgUrl
     * @return userId
     */
    @Override
    public CommonResponse<List<Long>> getUserByFaceImg(String imgUrl) {
        return CommonResponse.error("网络问题，查询失败。");
    }

    /**
     * 根据照片，查询符合照片的员工id
     *
     * @param bytes
     * @return userId
     */
    @Override
    public CommonResponse<List<Long>> getUserByFaceImgByte(byte[] bytes) {
        return CommonResponse.error("网络问题，查询失败。");
    }

    /**
     * 添加人脸数据到指定用户
     *
     * @param userId
     * @param imageUrl
     * @return
     */
    @Override
    public CommonResponse<Boolean> addFaceToUser(Long userId, String imageUrl) {
        return CommonResponse.error("网络问题，查询失败。");
    }

    /**
     * 身份证件是否翻拍校验
     * true 翻拍，false 直拍
     *
     * @param imageUrl
     * @return
     */
    @Override
    public CommonResponse<Boolean> detectCardScreenshot(String imageUrl) {
        return CommonResponse.error("网络问题，查询失败。");
    }

    /**
     * 身份证件 信息识别
     * true 翻拍，false 直拍
     * @param imageUrl
     * @param side face：人像面  back：国徽面
     * @return side 是 back 才返回startDate，endDate，issue
     *
     * {
     *     name:姓名,
     *     gender:性别：男、女,
     *     nationality:民族:汉,
     *     birthDate:出生19901122,
     *     address:住址,
     *     idNumber:身份证号,
     *
     *     startDate:起始有效期20200102,
     *     endDate:截止有效期20290102,
     *     issue:颁发机关：xxx公安局
     * }
     */
    @Override
    public CommonResponse<JSONObject> recognizeIdentityCardInfo(String imageUrl, String side) {
        return CommonResponse.error("网络问题，查询失败。");
    }

    /**
     * 发票识别
     *
     * @param url  图片或者pdf的地址 必填
     * @param type 文件类型：png、jpg、jpeg、bmp、pdf,小写文件类型后缀 必填
     *             <p>
     *             return JSONObject字段解释
     *             <p>
     *             PayerAddress 购买方地址、电话。
     *             PayeeRegisterNo 销售方纳税人识别号。
     *             PayeeBankName 销售方开户行及账号。
     *             InvoiceNo 发票号码。
     *             PayerRegisterNo 购买方纳税人识别号。
     *             Checker 复核人。
     *             TaxAmount 合计税额。
     *             InvoiceDate 开票日期。
     *             WithoutTaxAmount 合计金额。
     *             InvoiceAmount 价税合计（小写）。
     *             AntiFakeCode 校验码。
     *             PayerName 购买方名称。
     *             Payee 收款人。
     *             SumAmount 价税合计（大写）。
     *             PayerBankName 购买方开户行及账号。
     *             Clerk 开票人。
     *             PayeeName 销售方名称。
     *             PayeeAddress 销售方地址、电话。
     *             InvoiceCode 发票代码。
     *             ItemName array<string> 货物或应税劳务、服务名称。
     */
    @Override
    public CommonResponse<JSONObject> recognizeInvoiceInfo(String url, String type) {
        return CommonResponse.error("网络问题，查询失败。");
    }

    /**
     * 发票验证
     *
     * @param param Map<String, String>
     *            {
     *              fpdm：发票代码 【注意：全电票可不传，其他必传】
     *              fphm：发票号码【必填】
     *              kprq：开票日期 格式YYYYMMDD【必填】
     *              xym：校验码 【注意：专票、全电票可不传，其他必填。校验码支持全位和后6位】
     *              bhsje：不含税金额 【注意：普票可不传，其他发票必填 。全电票请传含税金额，其他发票需传 不含税金额】
     *            }
     * @return JSONObject字段解释
     *        {
     *          "result": 1,//1 一致  ； 2 不一致 ； 3  查无此票；
     *          "message"："一致", // result对应的描述
     *          "info": {//发票信息，仅在一致时返回
     *            "salerName": "",//销方名称
     *            "salerAccount":"",//销方开户行及账号
     *            "blueInvoiceCode":"",//蓝票发票代码
     *            "blueInvoiceNo":"",//蓝票发票号码
     *            "idNo":"",//购方身份证号/组织机(机动车发票)
     *            "vehicleType":"",//车辆类型(机动车\二手车发票)
     *            "bandModel":"",//厂牌型号(机动车\二手车发票)
     *            "produceArea":"",//产地(机动车发票)
     *            "qualifiedNo":"",//合格证号(机动车发票)
     *            "commodityInspectionNo":"",//商检单号(机动车发票)
     *            "engineNo":"",//商检单号(机动车发票)
     *            "vehicleIdentificationNo":"",//车辆识别代号/车架号码(机动车发票)
     *            "certificateOfImport":"",//进口证明书号(机动车发票)
     *            "taxAuthorityCode":"",//主管税务机关代码(机动车发票)
     *            "taxPaymentCertificateNo":"",//完税凭证号码(机动车发票)
     *            "limitedPeopleCount":"",//限乘人数(机动车发票)
     *            "taxAuthorityName":"",//主管税务机关名称(机动车发票)
     *            "tonnage":"",//吨位(机动车发票)
     *            "taxRate":"",//税率(机动车发票)
     *            "salerAddress":"",//销方地址(机动车发票)
     *            "salerPhone":"",//销方电话(机动车发票)
     *            "salerBankName":"",//销方开户银行(机动车发票)
     *            "salerBankAccount":"",//销方开户账号(机动车发票)
     *            "carrierName":"",//承运人名称(货运发票)
     *            "carrierTaxNo":"",//承运人识别号(货运发票)
     *            "draweeName":"",//受票方名称(货运发票)
     *            "draweeTaxNo":"",//受票方识别号(货运发票)
     *            "receiveName":"",//收货人名称(货运发票)
     *            "receiveTaxNo":"",//收货人识别号(货运发票)
     *            "consignorName":"",//发货人名称(货运发票)
     *            "consignorTaxNo":"",//发货人识别号(货运发票)
     *            "transportGoodsInfo":"",//运输货物信息(货运发票)
     *            "throughAddress":"",//起运地、经由、到达地(货运发票)
     *            "taxDiskNumber":"",//税控盘号(货运发票)
     *            "carNumber":"",//车种车号(货运发票)
     *            "vehicleTonnage":"",//车船吨位(货运发票)
     *            "trafficFeeFlag":"",//通行费发票 Y-可抵扣通行费 N-不可抵扣通行费
     *            "zeroTaxRateFlag":"",//零税率标志(通行费发票) 非零税率 1：税率栏位显示“免税”，2：税率栏位显示“不征税”，3：零税率
     *            "licensePlate":"",//车牌照号(二手车发票)
     *            "registrationNo":"",//登记证号(二手车发票)
     *            "carPrice":"",//车价合计(二手车发票)
     *            "transferredVehicleOffice":"",//转入地车辆车管所名称
     *            "buyerUnitOrIndividual":"",//买方单位/个人(二手车发票)
     *            "buyerUnitCodeOrIdNo":"",//买方单位代码/身份证号(二手车发票)
     *            "buyerUnitOrIndividualAddress":"",//买方单位/个人住址(二手车发票)
     *            "buyerPhone":"",//买方电话(二手车发票)
     *            "sellerUnitOrIndividual":"",//卖方单位/个人(二手车发票)
     *            "sellerUnitCodeOrIdNo":"",//卖方单位代码/身份证号(二手车发票)
     *            "sellerUnitOrIndividualAddress":"",//卖方单位/个人住址(二手车发票)
     *            "sellerPhone":"",//卖方电话(二手车发票)
     *            "businessUnit":"",//经营、拍卖单位(二手车发票)
     *            "businessUnitAddress":"",//经营、拍卖单位地址(二手车发票)
     *            "businessUnitTaxNo":"",//经营、拍卖单位纳税人识别号(二手车发票)
     *            "businessUnitBankAndAccount":"",//开户银行及账号(二手车发票)
     *            "businessUnitPhone":"",//经营、拍卖单位电话(二手车发票)
     *            "lemonMarket":"",//二手车市场(二手车发票)
     *            "lemonMarketTaxNo":"",//二手车市场纳税人识别号(二手车发票)
     *            "lemonMarketAddress":"",//二手车市场地址(二手车发票)
     *            "lemonMarketBankAndAccount":"",//二手车市场开户银行及账号(二手车发票)
     *            "lemonMarketPhone":"",//二手车市场电话(二手车发票)
     *            "remark_b64": "",//备注base64
     *            "invoiceAmount": "0.00",//发票金额
     *            "remark": "",//备注
     *            "payee": "",//收款人
     *            "salerTaxNo": "",//销方税号
     *            "invoiceType": "01",//发票类型，详见发票类型
     *            "machineNo": "",//机器编号
     *            "invoiceNo": "",//发票号码
     *            "buyerAddressPhone": "",//购方地址、电话
     *            "qdbz": "0",//清单标记  0-sh
     *            "cancellationMark": "0",// 作废标志  1-已作废  0-未作废
     *            "hcbz": "0",//红冲标记  0-未红冲，1-全额红冲，2-部分红冲
     *            "buyerTaxNo": "",//购方税号
     *            "salerBankAccount": "招商银行股份有限公司",//销方开户账号(机动车发票)
     *            "checkCount": 12,//查验次数
     *            "drawer": "",//开票人
     *            "reviewer": "",//复核人
     *            "invoiceDate": "20211117",//开票日期 yyyMMdd
     *            "buyerName": "",//购方名称
     *            "invoiceCode": "",//发票代码
     *            "checkCode": "",//校验码
     *            "totalAmount": "1440",//价税合计
     *            "salerAddressPhone": "浙江省杭州市余杭区余杭街道",//销方地址、电话
     *            "buyerAccount": "",//购方开户行及账号
     *            "taxAmount": "81.51",//发票税额
     *            "detailList": [//明细
     *              {
     *              "unitPrice": "1358",//不含税单价
     *              "taxRate": "6.0",//税率
     *              "taxUnitPrice": "",//含税单价
     *              "unit": "",//计量单位
     *              "expenseItem":"",//费用项目
     *              "plateNo":"",//车牌号
     *              "type":"",//类型(货运发票)
     *              "trafficDateStart":"",//通行日期起(通行费发票)
     *              "trafficDateEnd":"",//通行日起止(通行费发票)
     *              "specificationModel": "",//规格型号
     *              "num": "1",//数量
     *              "detailNo": "1",//明细编号
     *              "detailAmount": "1358.49",//金额
     *              "taxAmount": "81.51",//税额
     *              "goodsName": "*现代服务*技术服务费",//货物名称
     *              "flbm": "",//发票编号
     *              "taxDetailAmount": ""//含税金额
     *              }
     *            ]
     *          }
     *        }
     */
    @Override
    public CommonResponse<JSONObject> authInvoiceInfo(Map<String, String> param) {
        return CommonResponse.error("网络问题，查询失败。");
    }

    /**
     * 获取识别发票次数
     *
     * @return
     */
    @Override
    public CommonResponse<String> getRecognizeInvoiceNum() {
        return CommonResponse.error("网络问题，查询失败。");
    }

    /**
     * 获取鉴权发票次数
     *
     * @return
     */
    @Override
    public CommonResponse<String> getAuthInvoiceNum() {
        return CommonResponse.error("网络问题，查询失败。");
    }
}
