package com.ejianc.foundation.comment.api;

import com.ejianc.foundation.comment.hystrix.CommentHystrix;
import com.ejianc.foundation.comment.vo.CommentVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 评论的rpc服务
 *
 * @author liyongjia
 *
 */
@FeignClient(name= "ejc-idm-web", url="${common.env.feign-client-url}", path="ejc-idm-web", fallback = CommentHystrix.class)
public interface ICommentApi {

	/**
	 * 查询列表
	 */
	@RequestMapping(value = "/api/comment/queryListByBillId", method=RequestMethod.GET)
    CommonResponse<List<CommentVO>> queryListByBillId(@RequestParam(value = "billId") Long billId);

}
