package com.ejianc.foundation.usercenter.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.permission.vo.AppVO;
import com.ejianc.foundation.usercenter.hystrix.AppHystrix;
import com.ejianc.foundation.usercenter.hystrix.SupplierUserProjectHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * @date 2022/2/22 11:57
 */
@FeignClient(name= "ejc-idm-web", url="${common.env.feign-client-url}", path="ejc-idm-web", fallback = AppHystrix.class)
public interface IAppApi {

    /**
     * 查询当前用户下的应用
     * @return
     */
    @GetMapping(value = "/api/app/getAppByUserList")
    CommonResponse<JSONObject> getAppByUserList(@RequestParam(value = "pageIndex") Integer pageIndex, @RequestParam(value = "pageSize") Integer pageSize,Long userId) ;


    /**
     * 创建cfs 应用
     *
     * @param
     * @return
     */
    @GetMapping(value = "/api/app/createCfsApp")
    CommonResponse<String> createCfsApp(@RequestParam(value = "cfsAppCode") String cfsAppCode,@RequestParam(value = "cfsAppName") String cfsAppName);


}
