/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.usercenter.pm.encoder;

import com.ejianc.foundation.usercenter.pm.encoder.PasswordEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;

public class UsernameSaltPasswordEncoder
implements PasswordEncoder {
    private String username;
    private String salt;

    private UsernameSaltPasswordEncoder() {
    }

    public UsernameSaltPasswordEncoder(String username, String salt) {
        this.username = username;
        this.salt = salt;
    }

    @Override
    public String encode(String rawPassword) {
        String encodePassword = this.encodeBySHA1AndHex(rawPassword);
        String encodedUsername = this.encodeBySHA1AndHex(this.username);
        return this.encodeBySHA1WithSaltAndHex(encodePassword + encodedUsername, this.decodeHex(this.salt));
    }

    private byte[] decodeHex(String input) {
        if (input == null) {
            return null;
        }
        try {
            return Hex.decodeHex((char[])input.toCharArray());
        }
        catch (DecoderException e) {
            throw new RuntimeException(e);
        }
    }

    private String encodeBySHA1AndHex(String input) {
        byte[] bytes = DigestUtils.sha1((byte[])input.getBytes());
        return Hex.encodeHexString((byte[])bytes);
    }

    private String encodeBySHA1WithSaltAndHex(String input, byte[] salt) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(salt);
            byte[] bytes = digest.digest(input.getBytes());
            return Hex.encodeHexString((byte[])bytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

