package com.ejianc.foundation.orgcenter.vo;

import java.util.List;

import com.ejianc.framework.skeleton.template.BaseVO;

/**
 * 组织VO
 * 
 * @author guominga
 */
public class OrgVO extends BaseVO {

	private static final long serialVersionUID = 1L;

	/**
	 * 项目部
	 */
	public static final Integer ORG_TYPE_DEPARTMENT = 5;

	private Long enterpriseId; // 企业ID

	private Long parentId; // 父ID

	private String code; // 组织编号

	private String name; // 组织名称

	private String shortName; // 组织简称

	private Integer orgType; // 组织类型(1：集团 ， 2：分（子）公司，3：经理部，4：虚拟组织，5：项目部)

	private String manager; // 负责人

	private String phone; // 联系电话

	private String note; // 备注

	private String innerCode; // 组织内码

	private Integer state; // 状态标识（1：启用，0：停用）

	private Integer sequence; // 排序

	private Boolean isParent;

	private String sourceId; // 来源组织id

	private String systemId; // 系统id

	private List<OrgVO> children;

	private Boolean isLeaf;	//是否叶子节点

	private String pFName; //父级节点名称（全称）

	private String pSName; //父级节点名称（简称）

	private String pCode; //父级节点编码

	//组织部门参照使用
	private String referType; //UM:部门，UN:组织

	//组织部门参照使用
	private String referIcon; //file:部门，folder:组织

	//项目部组织对应的项目档案编码，目前云南建投使用
	private String projectCode; //file:部门，folder:组织

	//当前组织本下员工人数 目前小程序通讯录使用
	private Integer totalEmpNum;

	private Integer projectState; // 项目状态（1：在建项目， 2：全部项目）

	public Integer getTotalEmpNum() {
		return totalEmpNum;
	}

	public void setTotalEmpNum(Integer totalEmpNum) {
		this.totalEmpNum = totalEmpNum;
	}

	public String getpCode() {
		return pCode;
	}

	public void setpCode(String pCode) {
		this.pCode = pCode;
	}

	public Long getEnterpriseId() {
		return enterpriseId;
	}

	public void setEnterpriseId(Long enterpriseId) {
		this.enterpriseId = enterpriseId;
	}

	public Long getParentId() {
		return parentId;
	}

	public void setParentId(Long parentId) {
		this.parentId = parentId;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getShortName() {
		return shortName;
	}

	public void setShortName(String shortName) {
		this.shortName = shortName;
	}

	public Integer getOrgType() {
		return orgType;
	}

	public void setOrgType(Integer orgType) {
		this.orgType = orgType;
	}

	public String getManager() {
		return manager;
	}

	public void setManager(String manager) {
		this.manager = manager;
	}

	public String getPhone() {
		return phone;
	}

	public void setPhone(String phone) {
		this.phone = phone;
	}

	public String getNote() {
		return note;
	}

	public void setNote(String note) {
		this.note = note;
	}

	public String getInnerCode() {
		return innerCode;
	}

	public void setInnerCode(String innerCode) {
		this.innerCode = innerCode;
	}

	public Integer getState() {
		return state;
	}

	public void setState(Integer state) {
		this.state = state;
	}

	public Integer getSequence() {
		return sequence;
	}

	public void setSequence(Integer sequence) {
		this.sequence = sequence;
	}

	public Boolean getIsParent() {
		return isParent;
	}

	public void setIsParent(Boolean isParent) {
		this.isParent = isParent;
	}

	public String getSourceId() {
		return sourceId;
	}

	public void setSourceId(String sourceId) {
		this.sourceId = sourceId;
	}

	public String getSystemId() {
		return systemId;
	}

	public void setSystemId(String systemId) {
		this.systemId = systemId;
	}

	public List<OrgVO> getChildren() {
		return children;
	}

	public void setChildren(List<OrgVO> children) {
		this.children = children;
	}

	public Boolean getIsLeaf() {
		return isLeaf;
	}

	public void setIsLeaf(Boolean isLeaf) {
		this.isLeaf = isLeaf;
	}

	public String getpFName() {
		return pFName;
	}

	public void setpFName(String pFName) {
		this.pFName = pFName;
	}

	public String getpSName() {
		return pSName;
	}

	public void setpSName(String pSName) {
		this.pSName = pSName;
	}

	public String getReferType() {
		return referType;
	}

	public void setReferType(String referType) {
		this.referType = referType;
	}

	public String getReferIcon() {
		return referIcon;
	}

	public void setReferIcon(String referIcon) {
		this.referIcon = referIcon;
	}

	public String getProjectCode() {
		return projectCode;
	}

	public void setProjectCode(String projectCode) {
		this.projectCode = projectCode;
	}

	public Integer getProjectState() {
		return projectState;
	}

	public void setProjectState(Integer projectState) {
		this.projectState = projectState;
	}
}
