package com.ejianc.foundation.tenant.api;

import java.util.List;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import com.ejianc.foundation.tenant.hystrix.EnterpriseHystrix;
import com.ejianc.foundation.tenant.vo.EnterpriseVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author CJ
 * @Description:
 * @date 2020/8/6 11:57
 */
@FeignClient(name= "ejc-oms-web", url="${common.env.feign-client-url}", path="ejc-oms-web", fallback = EnterpriseHystrix.class)
public interface IEnterpriseApi {

	//供方协同（生成企业信息、租户、超级管理员等信息）
	@PostMapping(value = "/api/enterprise/supplierCollaboration")
    CommonResponse<EnterpriseVO> supplierCollaboration(@RequestBody EnterpriseVO enterpriseVO);

	//根据所给租户id查询租户所属企业信息
	@GetMapping(value = "/api/enterprise/getEnterpriseByTenantId")
    CommonResponse<EnterpriseVO> getEnterpriseByTenantId(@RequestParam("tenantId") Long tenantId);
	
	//获取所有企业列表
	@GetMapping(value = "/api/enterprise/getAllEnterpriseList")
	CommonResponse<List<EnterpriseVO>> getAllEnterpriseList();

}
