package com.ejianc.framework.idmclient.cas;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.jasig.cas.client.authentication.AuthenticationRedirectStrategy;
import org.jasig.cas.client.authentication.DefaultAuthenticationRedirectStrategy;
import org.jasig.cas.client.authentication.DefaultGatewayResolverImpl;
import org.jasig.cas.client.authentication.ExactUrlPatternMatcherStrategy;
import org.jasig.cas.client.authentication.GatewayResolver;
import org.jasig.cas.client.authentication.RegexUrlPatternMatcherStrategy;
import org.jasig.cas.client.authentication.UrlPatternMatcherStrategy;
import org.jasig.cas.client.util.AbstractCasFilter;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.util.ReflectUtils;
import org.jasig.cas.client.validation.Assertion;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

import com.ejianc.framework.core.util.Utils;
import com.ejianc.framework.idmclient.IdmFilterConfiguration;
import com.ejianc.framework.idmclient.cas.logout.entity.TenantUser;
import com.ejianc.framework.idmclient.esapi.EncryptException;
import com.ejianc.framework.idmclient.sdk.RedisUtils;
import com.ejianc.framework.idmclient.utils.CookieUtil;
import com.ejianc.framework.idmclient.utils.IRequestMatcherStrategy;
import com.ejianc.framework.idmclient.utils.TokenGenerator;

public class AuthenticationFilter extends AbstractCasFilter {

	private String casServerLoginUrl;
	private IRequestMatcherStrategy ignoreUrlClass;
	private boolean renew = false;
	private boolean gateway = false;
	private GatewayResolver gatewayStorage = new DefaultGatewayResolverImpl();
	private AuthenticationRedirectStrategy authenticationRedirectStrategy = new DefaultAuthenticationRedirectStrategy();
	private UrlPatternMatcherStrategy ignoreUrlPatternMatcherStrategyClass = null;
	private static final Map<String, Class<? extends UrlPatternMatcherStrategy>> PATTERN_MATCHER_TYPES = new HashMap<>();

	private String myServerName;
	private String myService;
	private boolean myEncodeServiceUrl = true;
	private String simpleReg = "72941b226fa7bff1fcac9ec5ccba2d05038cd881";
	private final static String SSO_PORTAL_URL = "/portal/sso/index";
	private IdmFilterConfiguration idmFilterConfiguration ;
	
	public void init() {
		super.init();
		CommonUtils.assertNotNull(this.casServerLoginUrl, "casServerLoginUrl cannot be null.");
	}

	protected void initInternal(FilterConfig filterConfig) throws ServletException {
		ServletContext context = filterConfig.getServletContext();  
		ApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext(context);
		idmFilterConfiguration = ctx.getBean("idmFilterConfiguration",IdmFilterConfiguration.class);
		
		if (!isIgnoreInitConfiguration()) {
			super.initInternal(filterConfig);
			String casUrl = idmFilterConfiguration.getCasRedirectUrl();
			if (StringUtils.isNotBlank(casUrl))
				setCasServerLoginUrl(casUrl);
			else {
				setCasServerLoginUrl(getPropertyFromInitParams(filterConfig, "casServerLoginUrl", null));
			}

			String ignoreUrlClassPath = getPropertyFromInitParams(filterConfig, "ignoreUrlClassPath", null);

			if (StringUtils.isNotBlank(ignoreUrlClassPath)) {
				this.ignoreUrlClass = ((IRequestMatcherStrategy) ReflectUtils.newInstance(ignoreUrlClassPath,new Object[0]));
			}
			this.logger.trace("Loaded CasServerLoginUrl parameter: {}", this.casServerLoginUrl);
			setRenew(parseBoolean(getPropertyFromInitParams(filterConfig, "renew", "false")));
			this.logger.trace("Loaded renew parameter: {}", Boolean.valueOf(this.renew));
			setGateway(parseBoolean(getPropertyFromInitParams(filterConfig, "gateway", "false")));
			this.logger.trace("Loaded gateway parameter: {}", Boolean.valueOf(this.gateway));

			String ignorePattern = getPropertyFromInitParams(filterConfig, "ignorePattern", null);
			this.logger.trace("Loaded ignorePattern parameter: {}", ignorePattern);
			String ignoreUrlPatternType = getPropertyFromInitParams(filterConfig, "ignoreUrlPatternType", "REGEX");
			this.logger.trace("Loaded ignoreUrlPatternType parameter: {}", ignoreUrlPatternType);

			if (ignorePattern != null) {
				Class<? extends UrlPatternMatcherStrategy> ignoreUrlMatcherClass = (Class<? extends UrlPatternMatcherStrategy>) PATTERN_MATCHER_TYPES.get(ignoreUrlPatternType);

				if (ignoreUrlMatcherClass != null)
					this.ignoreUrlPatternMatcherStrategyClass = ((UrlPatternMatcherStrategy) ReflectUtils.newInstance(ignoreUrlMatcherClass.getName(), new Object[0]));
				else {
					try {
						this.logger.trace("Assuming {} is a qualified class name...", ignoreUrlPatternType);
						this.ignoreUrlPatternMatcherStrategyClass = ((UrlPatternMatcherStrategy) ReflectUtils.newInstance(ignoreUrlPatternType, new Object[0]));
					} catch (IllegalArgumentException e) {
						this.logger.error("Could not instantiate class [{}]", ignoreUrlPatternType, e);
					}
				}
				if (this.ignoreUrlPatternMatcherStrategyClass != null) {
					this.ignoreUrlPatternMatcherStrategyClass.setPattern(ignorePattern);
				}
			}

			String gatewayStorageClass = getPropertyFromInitParams(filterConfig, "gatewayStorageClass", null);

			if (gatewayStorageClass != null) {
				this.gatewayStorage = ((GatewayResolver) ReflectUtils.newInstance(gatewayStorageClass, new Object[0]));
			}

			String authenticationRedirectStrategyClass = getPropertyFromInitParams(filterConfig,"authenticationRedirectStrategyClass", null);

			if (authenticationRedirectStrategyClass != null) {
				this.authenticationRedirectStrategy = ((AuthenticationRedirectStrategy) ReflectUtils.newInstance(authenticationRedirectStrategyClass, new Object[0]));
			}
		}

		String servername = idmFilterConfiguration.getServerName();
		if (StringUtils.isNotBlank(servername)) {
			setMyServerName(servername);
			setServerName(servername);
		} else {
			setMyServerName(getPropertyFromInitParams(filterConfig, "serverName", null));
			setServerName(getPropertyFromInitParams(filterConfig, "serverName", null));
		}

		setMyService(getPropertyFromInitParams(filterConfig, "service", null));
		setMyEncodeServiceUrl(parseBoolean(getPropertyFromInitParams(filterConfig, "encodeServiceUrl", "true")));
	}

	public final void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
		HttpServletRequest request = (HttpServletRequest) servletRequest;
		HttpServletResponse response = (HttpServletResponse) servletResponse;
		
		//入驻钉钉应用市场而修改
		String modifiedServiceUrl = null;
		String serverName = request.getServerName();
		
		if(Utils.getDingDingDomain().contains(serverName)) {
			String casServerName = Utils.getDingDingDomain();
			setMyServerName(casServerName);
			setServerName(casServerName);
			
			setCasServerLoginUrl(casServerName+"/sso/login");
			
			modifiedServiceUrl = casServerName + "/portal/sso/login";
		}else{
			if("localhost".equals(serverName) || "127.0.0.1".equals(serverName) 
					|| idmFilterConfiguration.getServerName().contains(serverName)
					|| "false".equals(idmFilterConfiguration.getMultiDomain())) {
				String servername = idmFilterConfiguration.getServerName();
				if (StringUtils.isNotBlank(servername)) {
					setMyServerName(servername);
					setServerName(servername);
					
					String casUrl = idmFilterConfiguration.getCasRedirectUrl();
					if (StringUtils.isNotBlank(casUrl)) {
						setCasServerLoginUrl(casUrl);
					}
					
					modifiedServiceUrl = idmFilterConfiguration.getCasServer();
				}
			}else{
				String servername = "http://"+request.getServerName();
				if(idmFilterConfiguration.getCasServer().startsWith("https")) {
					servername = "https://"+request.getServerName();
				}
				if (StringUtils.isNotBlank(servername)) {
					setMyServerName(servername);
					setServerName(servername);
					
					String casUrl = servername + "/sso/login";
					if (StringUtils.isNotBlank(casUrl)) {
						setCasServerLoginUrl(casUrl);
					}
					
					modifiedServiceUrl = servername + "/portal/sso/login";
				}
			}
		}
		
		if (isRequestUrlExcluded(request)) {
			this.logger.debug("Request is ignored.");
			filterChain.doFilter(request, response);
			return;
		}
		
		//根据token单点系统（/portal/sso/index为单点url）
		String ssoUrl = request.getRequestURI();
		if(SSO_PORTAL_URL.equals(ssoUrl)) {
			filterChain.doFilter(request, response);
			return;
		}

		String tokenStr = CookieUtil.findCookieValue(request.getCookies(), "tenant_token");
		String username = CookieUtil.findCookieValue(request.getCookies(), "tenant_username");
		TenantUser user = RedisUtils.getUserCache(new StringBuilder().append("user.info.login.tenant:").append(username).toString());
		String cookieValue = "";
		if (user != null) {
			try {
				cookieValue = TokenGenerator.genToken(username, user.getLoginTs(), RedisUtils.findSeed());
			} catch (EncryptException e) {
				e.printStackTrace();
			}
			if (cookieValue.equalsIgnoreCase(tokenStr)) {
				HttpSession session = request.getSession(true);
				Assertion assertion = session != null ? (Assertion) session.getAttribute("_const_cas_assertion_") : null;
				if (assertion == null) {
					assertion = (Assertion) RedisUtils.getSessionCacheAttribute("tenant_assertion", username);
					if (assertion != null) {
						session.setAttribute("_const_cas_assertion_", assertion);
					}
				}
				filterChain.doFilter(request, response);
				return;
			}

		}
		String issimpleregister = idmFilterConfiguration.getIssimpleregister();
		String serviceUrl = constructServiceUrl2(request, response);
		String ticket = retrieveTicketFromRequest(request);
		boolean wasGatewayed = (this.gateway) && (this.gatewayStorage.hasGatewayedAlready(request, serviceUrl));

		if ((CommonUtils.isNotBlank(ticket)) || (wasGatewayed)) {
			filterChain.doFilter(request, response);
			return;
		}

		this.logger.debug("no ticket and no assertion found");
		String urlToRedirectTo = CommonUtils.constructRedirectUrl(this.casServerLoginUrl, getServiceParameterName(), modifiedServiceUrl, this.renew, this.gateway);
		String current_sys_id = CookieUtil.findCookieValue(request.getCookies(), "current_sys_id");
		if(StringUtils.isNotBlank(current_sys_id)) {
			urlToRedirectTo = urlToRedirectTo.split("service=")[0]+"sysid="+current_sys_id+"&service="+urlToRedirectTo.split("service=")[1];
		}
		if ("1".equalsIgnoreCase(issimpleregister)) {
			urlToRedirectTo = new StringBuilder().append(urlToRedirectTo).append("&registertype=").append(this.simpleReg).toString();
		}

		this.logger.debug("redirecting to \"{}\"", urlToRedirectTo);
		
		this.authenticationRedirectStrategy.redirect(request, response, urlToRedirectTo);
	}

	public final void setRenew(boolean renew) {
		this.renew = renew;
	}

	public final void setGateway(boolean gateway) {
		this.gateway = gateway;
	}

	public final void setCasServerLoginUrl(String casServerLoginUrl) {
		this.casServerLoginUrl = casServerLoginUrl;
	}

	public final void setGatewayStorage(GatewayResolver gatewayStorage) {
		this.gatewayStorage = gatewayStorage;
	}

	private boolean isRequestUrlExcluded(HttpServletRequest request) {
		if ((this.ignoreUrlClass == null) && (this.ignoreUrlPatternMatcherStrategyClass == null)) {
			return false;
		}

		StringBuffer urlBuffer = request.getRequestURL();
		if (request.getQueryString() != null) {
			urlBuffer.append("?").append(request.getQueryString());
		}
		String requestUri = urlBuffer.toString();

		if (this.ignoreUrlClass != null) {
			return this.ignoreUrlClass.matches(request);
		}
		return this.ignoreUrlPatternMatcherStrategyClass.matches(requestUri);
	}

	protected final String constructServiceUrl2(HttpServletRequest request, HttpServletResponse response) {
		if (CommonUtils.isNotBlank(this.myService)) {
			return this.myEncodeServiceUrl ? response.encodeURL(this.myService) : this.myService;
		}

		StringBuilder buffer = new StringBuilder();

		String returnServerName = findMatchingServerName(request, this.myServerName);
		

		if ((!returnServerName.startsWith("https://")) && (!returnServerName.startsWith("http://"))) {
			buffer.append(request.isSecure() ? "https://" : "http://");
		}

		buffer.append(returnServerName);

		if (StringUtils.isNotBlank(request.getRequestURI()) && request.getRequestURI().indexOf("sso/login") != -1) {
			buffer.append(request.getRequestURI());
		} else {
			String rURL = idmFilterConfiguration.getContextName();
			String loginUrl = idmFilterConfiguration.getLoginUrl();
			loginUrl = rURL + "/" + loginUrl + "?r=" + Base64.encodeBase64URLSafeString(rURL.getBytes());
			buffer.append(loginUrl);
		}

		if (CommonUtils.isNotBlank(request.getQueryString())) {
			int location = request.getQueryString().indexOf(new StringBuilder().append(getArtifactParameterName()).append("=").toString());

			if (location == 0) {
				String returnValue = this.myEncodeServiceUrl ? response.encodeURL(buffer.toString()) : buffer.toString();

				this.logger.debug("serviceUrl generated: {}", returnValue);
				return returnValue;
			}

			buffer.append("?");

			if (location == -1) {
				buffer.append(request.getQueryString());
			} else if (location > 0) {
				int actualLocation = request.getQueryString().indexOf(new StringBuilder().append("&").append(getArtifactParameterName()).append("=").toString());

				if (actualLocation == -1)
					buffer.append(request.getQueryString());
				else if (actualLocation > 0) {
					buffer.append(request.getQueryString().substring(0, actualLocation));
				}
			}
		}

		String returnValue = this.myEncodeServiceUrl ? response.encodeURL(buffer.toString()) : buffer.toString();
		this.logger.debug("serviceUrl generated: {}", returnValue);
		return returnValue;
	}

	public final void setMyServerName(String serverName) {
		if ((serverName != null) && (serverName.endsWith("/"))) {
			this.myServerName = serverName.substring(0, serverName.length() - 1);
			this.logger.info("Eliminated extra slash from serverName [{}].  It is now [{}]", serverName,
					this.myServerName);
		} else {
			this.myServerName = serverName;
		}
	}

	public final void setMyService(String service) {
		this.myService = service;
	}

	public final void setMyEncodeServiceUrl(boolean encodeServiceUrl) {
		this.myEncodeServiceUrl = encodeServiceUrl;
	}

	private String findMatchingServerName(HttpServletRequest request, String myServerName) {
		String[] serverNames = myServerName.split(" ");

		if ((serverNames == null) || (serverNames.length == 0) || (serverNames.length == 1)) {
			return myServerName;
		}

		String host = request.getHeader("Host");
		String xHost = request.getHeader("X-Forwarded-Host");
		String comparisonHost;
		if ((xHost != null) && (host == "localhost"))
			comparisonHost = xHost;
		else {
			comparisonHost = host;
		}

		if (comparisonHost == null) {
			return myServerName;
		}

		for (String server : serverNames) {
			String lowerCaseServer = server.toLowerCase();

			if (lowerCaseServer.contains(comparisonHost)) {
				return server;
			}
		}

		return serverNames[0];
	}

	static {
		PATTERN_MATCHER_TYPES.put("CONTAINS", MutiContainsPatternUrlPatternMatcherStrategy.class);
		PATTERN_MATCHER_TYPES.put("MUTICONTAINS", MutiContainsPatternUrlPatternMatcherStrategy.class);
		PATTERN_MATCHER_TYPES.put("REGEX", RegexUrlPatternMatcherStrategy.class);
		PATTERN_MATCHER_TYPES.put("EXACT", ExactUrlPatternMatcherStrategy.class);
	}
}
