/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.idmclient.cas;

import com.ejianc.framework.core.util.Utils;
import com.ejianc.framework.idmclient.IdmFilterConfiguration;
import com.ejianc.framework.idmclient.cas.logout.entity.TenantUser;
import com.ejianc.framework.idmclient.esapi.EncryptException;
import com.ejianc.framework.idmclient.sdk.RedisUtils;
import com.ejianc.framework.idmclient.utils.TokenGenerator;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import javax.net.ssl.HostnameVerifier;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.proxy.AbstractEncryptedProxyGrantingTicketStorageImpl;
import org.jasig.cas.client.proxy.Cas20ProxyRetriever;
import org.jasig.cas.client.proxy.CleanUpTimerTask;
import org.jasig.cas.client.proxy.ProxyGrantingTicketStorage;
import org.jasig.cas.client.proxy.ProxyGrantingTicketStorageImpl;
import org.jasig.cas.client.proxy.ProxyRetriever;
import org.jasig.cas.client.ssl.HttpURLConnectionFactory;
import org.jasig.cas.client.ssl.HttpsURLConnectionFactory;
import org.jasig.cas.client.util.AbstractCasFilter;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.util.ReflectUtils;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.Cas20ProxyTicketValidator;
import org.jasig.cas.client.validation.Cas20ServiceTicketValidator;
import org.jasig.cas.client.validation.TicketValidationException;
import org.jasig.cas.client.validation.TicketValidator;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class TenantProxyReceivingTicketValidationFilter
extends AbstractCasFilter {
    private static final String[] RESERVED_INIT_PARAMS = new String[]{"proxyGrantingTicketStorageClass", "proxyReceptorUrl", "acceptAnyProxy", "allowedProxyChains", "casServerUrlPrefix", "proxyCallbackUrl", "renew", "exceptionOnValidationFailure", "redirectAfterValidation", "useSession", "serverName", "service", "artifactParameterName", "serviceParameterName", "encodeServiceUrl", "millisBetweenCleanUps", "hostnameVerifier", "encoding", "config", "ticketValidatorClass"};
    private String proxyReceptorUrl;
    private Timer timer;
    private TimerTask timerTask;
    private int millisBetweenCleanUps;
    private static final String TENANT_ASSERTION = "tenant_assertion";
    private TicketValidator ticketValidator;
    private boolean redirectAfterValidation = true;
    private boolean exceptionOnValidationFailure = false;
    private boolean useSession = true;
    private ProxyGrantingTicketStorage proxyGrantingTicketStorage = new ProxyGrantingTicketStorageImpl();
    private IdmFilterConfiguration idmFilterConfiguration;

    public void init() {
        super.init();
        CommonUtils.assertNotNull((Object)this.proxyGrantingTicketStorage, (String)"proxyGrantingTicketStorage cannot be null.");
        CommonUtils.assertNotNull((Object)this.ticketValidator, (String)"ticketValidator cannot be null.");
        if (this.timer == null) {
            this.timer = new Timer(true);
        }
        if (this.timerTask == null) {
            this.timerTask = new CleanUpTimerTask(this.proxyGrantingTicketStorage);
        }
        this.timer.schedule(this.timerTask, this.millisBetweenCleanUps, (long)this.millisBetweenCleanUps);
    }

    protected void initInternal(FilterConfig filterConfig) throws ServletException {
        ServletContext context = filterConfig.getServletContext();
        WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)context);
        this.idmFilterConfiguration = (IdmFilterConfiguration)ctx.getBean("idmFilterConfiguration", IdmFilterConfiguration.class);
        this.setProxyReceptorUrl(this.getPropertyFromInitParams(filterConfig, "proxyReceptorUrl", null));
        String proxyGrantingTicketStorageClass = this.getPropertyFromInitParams(filterConfig, "proxyGrantingTicketStorageClass", null);
        if (proxyGrantingTicketStorageClass != null) {
            this.proxyGrantingTicketStorage = (ProxyGrantingTicketStorage)ReflectUtils.newInstance((String)proxyGrantingTicketStorageClass, (Object[])new Object[0]);
            if (this.proxyGrantingTicketStorage instanceof AbstractEncryptedProxyGrantingTicketStorageImpl) {
                AbstractEncryptedProxyGrantingTicketStorageImpl servername = (AbstractEncryptedProxyGrantingTicketStorageImpl)this.proxyGrantingTicketStorage;
                String cipherAlgorithm = this.getPropertyFromInitParams(filterConfig, "cipherAlgorithm", "DESede");
                String secretKey = this.getPropertyFromInitParams(filterConfig, "secretKey", null);
                servername.setCipherAlgorithm(cipherAlgorithm);
                try {
                    if (secretKey != null) {
                        servername.setSecretKey(secretKey);
                    }
                }
                catch (Exception arg6) {
                    throw new RuntimeException(arg6);
                }
            }
        }
        this.logger.trace("Setting proxyReceptorUrl parameter: {}", (Object)this.proxyReceptorUrl);
        this.millisBetweenCleanUps = Integer.parseInt(this.getPropertyFromInitParams(filterConfig, "millisBetweenCleanUps", Integer.toString(60000)));
        this.setExceptionOnValidationFailure(this.parseBoolean(this.getPropertyFromInitParams(filterConfig, "exceptionOnValidationFailure", "false")));
        this.logger.trace("Setting exceptionOnValidationFailure parameter: {}", (Object)this.exceptionOnValidationFailure);
        this.setRedirectAfterValidation(this.parseBoolean(this.getPropertyFromInitParams(filterConfig, "redirectAfterValidation", "true")));
        this.logger.trace("Setting redirectAfterValidation parameter: {}", (Object)this.redirectAfterValidation);
        this.setUseSession(this.parseBoolean(this.getPropertyFromInitParams(filterConfig, "useSession", "true")));
        this.logger.trace("Setting useSession parameter: {}", (Object)this.useSession);
        if (!this.useSession && this.redirectAfterValidation) {
            this.logger.warn("redirectAfterValidation parameter may not be true when useSession parameter is false. Resetting it to false in order to prevent infinite redirects.");
            this.setRedirectAfterValidation(false);
        }
        this.setTicketValidator(this.getTicketValidator(filterConfig));
        super.initInternal(filterConfig);
        String serverName = this.idmFilterConfiguration.getServerName();
        if (StringUtils.isNotBlank((String)serverName)) {
            this.setServerName(serverName);
        } else {
            this.setServerName(this.getPropertyFromInitParams(filterConfig, "serverName", null));
        }
    }

    private <T> T createNewTicketValidator(String ticketValidatorClass, String casServerUrlPrefix, Class<T> clazz) {
        return (T)(CommonUtils.isBlank((String)ticketValidatorClass) ? ReflectUtils.newInstance(clazz, (Object[])new Object[]{casServerUrlPrefix}) : ReflectUtils.newInstance((String)ticketValidatorClass, (Object[])new Object[]{casServerUrlPrefix}));
    }

    protected final TicketValidator getTicketValidator(FilterConfig filterConfig) {
        Cas20ServiceTicketValidator validator;
        String allowAnyProxy = this.getPropertyFromInitParams(filterConfig, "acceptAnyProxy", null);
        String allowedProxyChains = this.getPropertyFromInitParams(filterConfig, "allowedProxyChains", null);
        String casServerUrlPrefix = this.getCasUrl(filterConfig);
        String ticketValidatorClass = this.getPropertyFromInitParams(filterConfig, "ticketValidatorClass", null);
        if (!CommonUtils.isNotBlank((String)allowAnyProxy) && !CommonUtils.isNotBlank((String)allowedProxyChains)) {
            validator = this.createNewTicketValidator(ticketValidatorClass, casServerUrlPrefix, Cas20ServiceTicketValidator.class);
        } else {
            Cas20ProxyTicketValidator factory = this.createNewTicketValidator(ticketValidatorClass, casServerUrlPrefix, Cas20ProxyTicketValidator.class);
            factory.setAcceptAnyProxy(this.parseBoolean(allowAnyProxy));
            factory.setAllowedProxyChains(CommonUtils.createProxyList((String)allowedProxyChains));
            validator = factory;
        }
        validator.setProxyCallbackUrl(this.getPropertyFromInitParams(filterConfig, "proxyCallbackUrl", null));
        validator.setProxyGrantingTicketStorage(this.proxyGrantingTicketStorage);
        HttpsURLConnectionFactory factory1 = new HttpsURLConnectionFactory(this.getHostnameVerifier(filterConfig), this.getSSLConfig(filterConfig));
        validator.setURLConnectionFactory((HttpURLConnectionFactory)factory1);
        validator.setProxyRetriever((ProxyRetriever)new Cas20ProxyRetriever(casServerUrlPrefix, this.getPropertyFromInitParams(filterConfig, "encoding", null), (HttpURLConnectionFactory)factory1));
        validator.setRenew(this.parseBoolean(this.getPropertyFromInitParams(filterConfig, "renew", "false")));
        validator.setEncoding(this.getPropertyFromInitParams(filterConfig, "encoding", null));
        HashMap<String, String> additionalParameters = new HashMap<String, String>();
        List<String> params = Arrays.asList(RESERVED_INIT_PARAMS);
        Enumeration e = filterConfig.getInitParameterNames();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            if (params.contains(s)) continue;
            additionalParameters.put(s, filterConfig.getInitParameter(s));
        }
        validator.setCustomParameters(additionalParameters);
        return (TicketValidator)validator;
    }

    public void destroy() {
        super.destroy();
        this.timer.cancel();
    }

    protected final boolean preFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String requestUri = request.getRequestURI();
        if (!CommonUtils.isEmpty((String)this.proxyReceptorUrl) && requestUri.endsWith(this.proxyReceptorUrl)) {
            try {
                CommonUtils.readAndRespondToProxyReceptorRequest((HttpServletRequest)request, (HttpServletResponse)response, (ProxyGrantingTicketStorage)this.proxyGrantingTicketStorage);
                return false;
            }
            catch (RuntimeException arg7) {
                this.logger.error(arg7.getMessage(), (Throwable)arg7);
                throw arg7;
            }
        }
        return true;
    }

    public final void setProxyReceptorUrl(String proxyReceptorUrl) {
        this.proxyReceptorUrl = proxyReceptorUrl;
    }

    public void setProxyGrantingTicketStorage(ProxyGrantingTicketStorage storage) {
        this.proxyGrantingTicketStorage = storage;
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
    }

    public void setTimerTask(TimerTask timerTask) {
        this.timerTask = timerTask;
    }

    public void setMillisBetweenCleanUps(int millisBetweenCleanUps) {
        this.millisBetweenCleanUps = millisBetweenCleanUps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties getSSLConfig(FilterConfig filterConfig) {
        Properties properties = new Properties();
        String fileName = this.getPropertyFromInitParams(filterConfig, "sslConfigFile", null);
        if (fileName != null) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(fileName);
                properties.load(fis);
                this.logger.trace("Loaded {} entries from {}", (Object)properties.size(), (Object)fileName);
            }
            catch (IOException arg8) {
                try {
                    this.logger.error(arg8.getMessage(), (Throwable)arg8);
                }
                catch (Throwable throwable) {
                    CommonUtils.closeQuietly(fis);
                    throw throwable;
                }
                CommonUtils.closeQuietly((Closeable)fis);
            }
            CommonUtils.closeQuietly((Closeable)fis);
        }
        return properties;
    }

    protected HostnameVerifier getHostnameVerifier(FilterConfig filterConfig) {
        String className = this.getPropertyFromInitParams(filterConfig, "hostnameVerifier", null);
        this.logger.trace("Using hostnameVerifier parameter: {}", (Object)className);
        String config = this.getPropertyFromInitParams(filterConfig, "hostnameVerifierConfig", null);
        this.logger.trace("Using hostnameVerifierConfig parameter: {}", (Object)config);
        return className != null ? (config != null ? (HostnameVerifier)ReflectUtils.newInstance((String)className, (Object[])new Object[]{config}) : (HostnameVerifier)ReflectUtils.newInstance((String)className, (Object[])new Object[0])) : null;
    }

    protected void onSuccessfulValidation(HttpServletRequest request, HttpServletResponse response, Assertion assertion) {
    }

    protected void onFailedValidation(HttpServletRequest request, HttpServletResponse response) {
    }

    public final void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (this.preFilter(servletRequest, servletResponse, filterChain)) {
            String casUrl;
            String casServerName;
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            String redirectUrl = this.idmFilterConfiguration.getCasServer();
            String serverName = request.getServerName();
            if (Utils.getDingDingDomain().contains(serverName)) {
                casServerName = Utils.getDingDingDomain();
                this.setServerName(casServerName);
                redirectUrl = casServerName + "/portal/sso/login";
                ((Cas20ServiceTicketValidator)this.ticketValidator).setCasServerUrlPrefix(casServerName + "/sso");
            } else if ("localhost".equals(serverName) || "127.0.0.1".equals(serverName) || this.idmFilterConfiguration.getServerName().contains(serverName) || "false".equals(this.idmFilterConfiguration.getMultiDomain())) {
                casServerName = this.idmFilterConfiguration.getServerName();
                if (StringUtils.isNotBlank((String)casServerName)) {
                    this.setServerName(casServerName);
                }
                redirectUrl = this.idmFilterConfiguration.getCasServer();
                casUrl = this.idmFilterConfiguration.getCasUrl();
                ((Cas20ServiceTicketValidator)this.ticketValidator).setCasServerUrlPrefix(casUrl);
            } else {
                casServerName = "http://" + request.getServerName();
                if (this.idmFilterConfiguration.getCasServer().startsWith("https")) {
                    casServerName = "https://" + request.getServerName();
                }
                if (StringUtils.isNotBlank((String)casServerName)) {
                    this.setServerName(casServerName);
                }
                redirectUrl = casServerName + "/portal/sso/login";
                casUrl = casServerName + "/sso";
                ((Cas20ServiceTicketValidator)this.ticketValidator).setCasServerUrlPrefix(casUrl);
            }
            String ticket = this.retrieveTicketFromRequest(request);
            if (CommonUtils.isNotBlank((String)ticket)) {
                this.logger.debug("Attempting to validate ticket: {}", (Object)ticket);
                try {
                    Assertion e = this.ticketValidator.validate(ticket, this.constructServiceUrl(request, response));
                    this.logger.debug("Successfully authenticated user: {}", (Object)e.getPrincipal().getName());
                    request.setAttribute("_const_cas_assertion_", (Object)e);
                    if (this.useSession) {
                        request.getSession().setAttribute("_const_cas_assertion_", (Object)e);
                    }
                    this.createToken(ticket, e, response);
                    this.saveAssertion(ticket, e);
                    this.onSuccessfulValidation(request, response, e);
                    if (this.redirectAfterValidation) {
                        this.logger.debug("Redirecting after successful ticket validation.");
                        response.sendRedirect(redirectUrl);
                        return;
                    }
                }
                catch (TicketValidationException arg7) {
                    this.logger.debug(arg7.getMessage(), (Throwable)arg7);
                    this.onFailedValidation(request, response);
                    if (this.exceptionOnValidationFailure) {
                        throw new ServletException((Throwable)arg7);
                    }
                    response.sendError(403, arg7.getMessage());
                    return;
                }
            }
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    public final void setTicketValidator(TicketValidator ticketValidator) {
        this.ticketValidator = ticketValidator;
    }

    public final void setRedirectAfterValidation(boolean redirectAfterValidation) {
        this.redirectAfterValidation = redirectAfterValidation;
    }

    public final void setExceptionOnValidationFailure(boolean exceptionOnValidationFailure) {
        this.exceptionOnValidationFailure = exceptionOnValidationFailure;
    }

    public final void setUseSession(boolean useSession) {
        this.useSession = useSession;
    }

    private void createToken(String ticket, Assertion assertion, HttpServletResponse response) {
        Map saveUserid;
        Object existUser;
        AttributePrincipal principal = assertion.getPrincipal();
        String userID = "";
        if (principal != null && (existUser = (saveUserid = principal.getAttributes()).get("userId")) != null) {
            userID = existUser.toString();
        }
        if (!StringUtils.isBlank((String)userID)) {
            String saveUserid1 = ticket + "__" + userID;
            TenantUser existUser1 = RedisUtils.getUserCache("user.info.login.tenant:" + saveUserid1);
            if (existUser1 == null) {
                TenantUser ts = new TenantUser();
                ts.setUserId(saveUserid1);
                long ts1 = System.currentTimeMillis();
                ts.setLoginTs(ts1);
                String cookiesMap = "";
                try {
                    cookiesMap = TokenGenerator.genToken(saveUserid1, ts1, RedisUtils.findSeed());
                }
                catch (EncryptException arg17) {
                    this.logger.error("Fail to generate cookie!", (Throwable)arg17);
                }
                HashMap<String, String> iterator = new HashMap<String, String>();
                iterator.put("tenant_username", saveUserid1);
                iterator.put("tenant_token", cookiesMap);
                Iterator key = iterator.keySet().iterator();
                try {
                    while (key.hasNext()) {
                        String cookie = (String)key.next();
                        Cookie cookie1 = new Cookie(cookie, URLEncoder.encode((String)iterator.get(cookie), "utf-8"));
                        if (StringUtils.isNotBlank((String)this.idmFilterConfiguration.getContextName())) {
                            cookie1.setPath(this.idmFilterConfiguration.getContextName());
                        } else {
                            cookie1.setPath("/");
                        }
                        cookie1.setMaxAge(-1);
                        cookie1.setHttpOnly(true);
                        response.addCookie(cookie1);
                    }
                    RedisUtils.cacheUser(saveUserid1, ts);
                }
                catch (Exception arg16) {
                    this.logger.error("\u767b\u9646\u4fe1\u606f\u5199\u5165\u5230redis\u7f13\u5b58\u4e2d\u5931\u8d25", (Throwable)arg16);
                }
            } else {
                long ts2 = existUser1.getLoginTs();
                String cookieValue = "";
                try {
                    cookieValue = TokenGenerator.genToken(saveUserid1, ts2, RedisUtils.findSeed());
                }
                catch (EncryptException arg15) {
                    this.logger.error("Fail to generate cookie!", (Throwable)arg15);
                }
                HashMap<String, String> cookiesMap1 = new HashMap<String, String>();
                cookiesMap1.put("tenant_username", saveUserid1);
                cookiesMap1.put("tenant_token", cookieValue);
                Iterator iterator1 = cookiesMap1.keySet().iterator();
                while (iterator1.hasNext()) {
                    try {
                        String key1 = (String)iterator1.next();
                        Cookie cookie2 = new Cookie(key1, URLEncoder.encode((String)cookiesMap1.get(key1), "utf-8"));
                        if (StringUtils.isNotBlank((String)this.idmFilterConfiguration.getContextName())) {
                            cookie2.setPath("/");
                        } else {
                            cookie2.setPath("/");
                        }
                        cookie2.setMaxAge(-1);
                        cookie2.setHttpOnly(true);
                        response.addCookie(cookie2);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private void saveAssertion(String ticket, Assertion assertion) {
        if (assertion != null) {
            Map saveUserid;
            Object userId;
            AttributePrincipal principal = assertion.getPrincipal();
            String userID = "";
            if (principal != null && (userId = (saveUserid = principal.getAttributes()).get("userId")) != null) {
                userID = userId.toString();
            }
            if (userID != null && !userID.equalsIgnoreCase("")) {
                String saveUserid1 = ticket + "__" + userID;
                RedisUtils.putSessionCacheAttribute(TENANT_ASSERTION, saveUserid1, assertion);
            }
        }
    }

    private String getCasUrl(FilterConfig filterConfig) {
        String casUrl = this.idmFilterConfiguration.getCasUrl();
        if (StringUtils.isBlank((String)casUrl)) {
            casUrl = this.getPropertyFromInitParams(filterConfig, "casServerUrlPrefix", null);
        }
        return casUrl;
    }
}

