/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.idmclient.utils;

import com.ejianc.framework.idmclient.cas.logout.entity.TenantUser;
import com.ejianc.framework.idmclient.esapi.EncryptException;
import com.ejianc.framework.idmclient.sdk.RedisUtils;
import com.ejianc.framework.idmclient.utils.CookieUtil;
import com.ejianc.framework.idmclient.utils.TokenGenerator;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CasClientUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)"CasClientUtils");

    public static void destroyToken(HttpServletRequest request, HttpServletResponse response) {
        String tokenStr = CookieUtil.findCookieValue(request.getCookies(), "tenant_token");
        String username = CookieUtil.findCookieValue(request.getCookies(), "tenant_username");
        TenantUser user = RedisUtils.getUserCache("user.info.login.tenant:" + username);
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            Cookie[] cookieValue = cookies;
            for (int i = 0; i < cookies.length; ++i) {
                Cookie c = cookieValue[i];
                if (!c.getName().equals("tenant_token") && !c.getName().equals("tenant_username")) continue;
                c.setValue((String)null);
                c.setMaxAge(0);
                c.setHttpOnly(true);
                c.setPath("/");
                response.addCookie(c);
            }
        }
        String token = "";
        if (user != null) {
            try {
                token = TokenGenerator.genToken(user.getUserId(), user.getLoginTs(), RedisUtils.findSeed());
                if (token.equalsIgnoreCase(tokenStr)) {
                    RedisUtils.disCacheUser(username);
                    RedisUtils.removeSessionCacheAttribute("tenant_assertion", username);
                }
            }
            catch (EncryptException arg9) {
                logger.error("Fail to delete cookie!", (Throwable)arg9);
            }
        }
    }
}

