package com.ejianc.framework.idmclient.sdk;

import java.io.Serializable;

import com.ejianc.framework.idmclient.cas.logout.entity.TenantUser;

public class RedisUtils {
	public static TenantUser getUserCache(String userName) {
		UserCacheManagerUtils userCache = UserCacheManagerUtils.getInstance();
		return userCache.getUserCache(userName);

	}

	public static String findSeed() {
		UserCacheManagerUtils userCache = UserCacheManagerUtils.getInstance();
		return userCache.findSeed();
	}

	public static <T extends Serializable> T getSessionCacheAttribute(String sid, String key) {
		UserCacheManagerUtils userCache = UserCacheManagerUtils.getInstance();
		return userCache.getSessionCacheAttribute(sid, key);
	}

	public static <T> void cacheUser(String uname, T user) {
		UserCacheManagerUtils userCache = UserCacheManagerUtils.getInstance();
		userCache.cacheUser(uname, user);
	}

	public static <T> void putSessionCacheAttribute(String sid, String key, T value) {
		UserCacheManagerUtils userCache = UserCacheManagerUtils.getInstance();
		userCache.putSessionCacheAttribute(sid, key, value);
	}

	public static void disCacheUser(String uname) {
		UserCacheManagerUtils userCache = UserCacheManagerUtils.getInstance();
		userCache.disCacheUser(uname);
	}

	public static void removeSessionCacheAttribute(String sid, String key) {
		UserCacheManagerUtils userCache = UserCacheManagerUtils.getInstance();
		userCache.removeSessionCacheAttribute(sid, key);
	}
}
