/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.idmclient.cas;

import com.ejianc.framework.core.util.Utils;
import com.ejianc.framework.idmclient.IdmFilterConfiguration;
import com.ejianc.framework.idmclient.cas.MutiContainsPatternUrlPatternMatcherStrategy;
import com.ejianc.framework.idmclient.cas.logout.entity.TenantUser;
import com.ejianc.framework.idmclient.esapi.EncryptException;
import com.ejianc.framework.idmclient.sdk.RedisUtils;
import com.ejianc.framework.idmclient.utils.CookieUtil;
import com.ejianc.framework.idmclient.utils.IRequestMatcherStrategy;
import com.ejianc.framework.idmclient.utils.TokenGenerator;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.jasig.cas.client.authentication.AuthenticationRedirectStrategy;
import org.jasig.cas.client.authentication.DefaultAuthenticationRedirectStrategy;
import org.jasig.cas.client.authentication.DefaultGatewayResolverImpl;
import org.jasig.cas.client.authentication.ExactUrlPatternMatcherStrategy;
import org.jasig.cas.client.authentication.GatewayResolver;
import org.jasig.cas.client.authentication.RegexUrlPatternMatcherStrategy;
import org.jasig.cas.client.authentication.UrlPatternMatcherStrategy;
import org.jasig.cas.client.util.AbstractCasFilter;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.util.ReflectUtils;
import org.jasig.cas.client.validation.Assertion;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class AuthenticationFilter
extends AbstractCasFilter {
    private String casServerLoginUrl;
    private IRequestMatcherStrategy ignoreUrlClass;
    private boolean renew = false;
    private boolean gateway = false;
    private GatewayResolver gatewayStorage = new DefaultGatewayResolverImpl();
    private AuthenticationRedirectStrategy authenticationRedirectStrategy = new DefaultAuthenticationRedirectStrategy();
    private UrlPatternMatcherStrategy ignoreUrlPatternMatcherStrategyClass = null;
    private static final Map<String, Class<? extends UrlPatternMatcherStrategy>> PATTERN_MATCHER_TYPES = new HashMap<String, Class<? extends UrlPatternMatcherStrategy>>();
    private String myServerName;
    private String myService;
    private boolean myEncodeServiceUrl = true;
    private String simpleReg = "72941b226fa7bff1fcac9ec5ccba2d05038cd881";
    private static final String SSO_PORTAL_URL = "/portal/sso/index";
    private IdmFilterConfiguration idmFilterConfiguration;

    public void init() {
        super.init();
        CommonUtils.assertNotNull((Object)this.casServerLoginUrl, (String)"casServerLoginUrl cannot be null.");
    }

    protected void initInternal(FilterConfig filterConfig) throws ServletException {
        String servername;
        ServletContext context = filterConfig.getServletContext();
        WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)context);
        this.idmFilterConfiguration = (IdmFilterConfiguration)ctx.getBean("idmFilterConfiguration", IdmFilterConfiguration.class);
        if (!this.isIgnoreInitConfiguration()) {
            String authenticationRedirectStrategyClass;
            String gatewayStorageClass;
            super.initInternal(filterConfig);
            String casUrl = this.idmFilterConfiguration.getCasRedirectUrl();
            if (StringUtils.isNotBlank((String)casUrl)) {
                this.setCasServerLoginUrl(casUrl);
            } else {
                this.setCasServerLoginUrl(this.getPropertyFromInitParams(filterConfig, "casServerLoginUrl", null));
            }
            String ignoreUrlClassPath = this.getPropertyFromInitParams(filterConfig, "ignoreUrlClassPath", null);
            if (StringUtils.isNotBlank((String)ignoreUrlClassPath)) {
                this.ignoreUrlClass = (IRequestMatcherStrategy)ReflectUtils.newInstance((String)ignoreUrlClassPath, (Object[])new Object[0]);
            }
            this.logger.trace("Loaded CasServerLoginUrl parameter: {}", (Object)this.casServerLoginUrl);
            this.setRenew(this.parseBoolean(this.getPropertyFromInitParams(filterConfig, "renew", "false")));
            this.logger.trace("Loaded renew parameter: {}", (Object)this.renew);
            this.setGateway(this.parseBoolean(this.getPropertyFromInitParams(filterConfig, "gateway", "false")));
            this.logger.trace("Loaded gateway parameter: {}", (Object)this.gateway);
            String ignorePattern = this.getPropertyFromInitParams(filterConfig, "ignorePattern", null);
            this.logger.trace("Loaded ignorePattern parameter: {}", (Object)ignorePattern);
            String ignoreUrlPatternType = this.getPropertyFromInitParams(filterConfig, "ignoreUrlPatternType", "REGEX");
            this.logger.trace("Loaded ignoreUrlPatternType parameter: {}", (Object)ignoreUrlPatternType);
            if (ignorePattern != null) {
                Class<? extends UrlPatternMatcherStrategy> ignoreUrlMatcherClass = PATTERN_MATCHER_TYPES.get(ignoreUrlPatternType);
                if (ignoreUrlMatcherClass != null) {
                    this.ignoreUrlPatternMatcherStrategyClass = (UrlPatternMatcherStrategy)ReflectUtils.newInstance((String)ignoreUrlMatcherClass.getName(), (Object[])new Object[0]);
                } else {
                    try {
                        this.logger.trace("Assuming {} is a qualified class name...", (Object)ignoreUrlPatternType);
                        this.ignoreUrlPatternMatcherStrategyClass = (UrlPatternMatcherStrategy)ReflectUtils.newInstance((String)ignoreUrlPatternType, (Object[])new Object[0]);
                    }
                    catch (IllegalArgumentException e) {
                        this.logger.error("Could not instantiate class [{}]", (Object)ignoreUrlPatternType, (Object)e);
                    }
                }
                if (this.ignoreUrlPatternMatcherStrategyClass != null) {
                    this.ignoreUrlPatternMatcherStrategyClass.setPattern(ignorePattern);
                }
            }
            if ((gatewayStorageClass = this.getPropertyFromInitParams(filterConfig, "gatewayStorageClass", null)) != null) {
                this.gatewayStorage = (GatewayResolver)ReflectUtils.newInstance((String)gatewayStorageClass, (Object[])new Object[0]);
            }
            if ((authenticationRedirectStrategyClass = this.getPropertyFromInitParams(filterConfig, "authenticationRedirectStrategyClass", null)) != null) {
                this.authenticationRedirectStrategy = (AuthenticationRedirectStrategy)ReflectUtils.newInstance((String)authenticationRedirectStrategyClass, (Object[])new Object[0]);
            }
        }
        if (StringUtils.isNotBlank((String)(servername = this.idmFilterConfiguration.getServerName()))) {
            this.setMyServerName(servername);
            this.setServerName(servername);
        } else {
            this.setMyServerName(this.getPropertyFromInitParams(filterConfig, "serverName", null));
            this.setServerName(this.getPropertyFromInitParams(filterConfig, "serverName", null));
        }
        this.setMyService(this.getPropertyFromInitParams(filterConfig, "service", null));
        this.setMyEncodeServiceUrl(this.parseBoolean(this.getPropertyFromInitParams(filterConfig, "encodeServiceUrl", "true")));
    }

    public final void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        boolean wasGatewayed;
        String casUrl;
        String servername;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String modifiedServiceUrl = null;
        String serverName = request.getServerName();
        if (Utils.getDingDingDomain().contains(serverName)) {
            String casServerName = Utils.getDingDingDomain();
            this.setMyServerName(casServerName);
            this.setServerName(casServerName);
            this.setCasServerLoginUrl(casServerName + "/sso/login");
            modifiedServiceUrl = casServerName + "/portal/sso/login";
        } else if ("localhost".equals(serverName) || "127.0.0.1".equals(serverName) || this.idmFilterConfiguration.getServerName().contains(serverName) || "false".equals(this.idmFilterConfiguration.getMultiDomain())) {
            servername = this.idmFilterConfiguration.getServerName();
            if (StringUtils.isNotBlank((String)servername)) {
                this.setMyServerName(servername);
                this.setServerName(servername);
                casUrl = this.idmFilterConfiguration.getCasRedirectUrl();
                if (StringUtils.isNotBlank((String)casUrl)) {
                    this.setCasServerLoginUrl(casUrl);
                }
                modifiedServiceUrl = this.idmFilterConfiguration.getCasServer();
            }
        } else {
            servername = "http://" + request.getServerName();
            if (this.idmFilterConfiguration.getCasServer().startsWith("https")) {
                servername = "https://" + request.getServerName();
            }
            if (StringUtils.isNotBlank((String)servername)) {
                this.setMyServerName(servername);
                this.setServerName(servername);
                casUrl = servername + "/sso/login";
                if (StringUtils.isNotBlank((String)casUrl)) {
                    this.setCasServerLoginUrl(casUrl);
                }
                modifiedServiceUrl = servername + "/portal/sso/login";
            }
        }
        if (this.isRequestUrlExcluded(request)) {
            this.logger.debug("Request is ignored.");
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String ssoUrl = request.getRequestURI();
        if (SSO_PORTAL_URL.equals(ssoUrl)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String tokenStr = CookieUtil.findCookieValue(request.getCookies(), "tenant_token");
        String username = CookieUtil.findCookieValue(request.getCookies(), "tenant_username");
        TenantUser user = RedisUtils.getUserCache("user.info.login.tenant:" + username);
        String cookieValue = "";
        if (user != null) {
            try {
                cookieValue = TokenGenerator.genToken(username, user.getLoginTs(), RedisUtils.findSeed());
            }
            catch (EncryptException e) {
                e.printStackTrace();
            }
            if (cookieValue.equalsIgnoreCase(tokenStr)) {
                Assertion assertion;
                HttpSession session = request.getSession(true);
                Assertion assertion2 = assertion = session != null ? (Assertion)session.getAttribute("_const_cas_assertion_") : null;
                if (assertion == null && (assertion = (Assertion)RedisUtils.getSessionCacheAttribute("tenant_assertion", username)) != null) {
                    session.setAttribute("_const_cas_assertion_", (Object)assertion);
                }
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
        }
        String issimpleregister = this.idmFilterConfiguration.getIssimpleregister();
        String serviceUrl = this.constructServiceUrl2(request, response);
        String ticket = this.retrieveTicketFromRequest(request);
        boolean bl = wasGatewayed = this.gateway && this.gatewayStorage.hasGatewayedAlready(request, serviceUrl);
        if (CommonUtils.isNotBlank((String)ticket) || wasGatewayed) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        this.logger.debug("no ticket and no assertion found");
        String urlToRedirectTo = CommonUtils.constructRedirectUrl((String)this.casServerLoginUrl, (String)this.getServiceParameterName(), (String)modifiedServiceUrl, (boolean)this.renew, (boolean)this.gateway);
        String current_sys_id = CookieUtil.findCookieValue(request.getCookies(), "current_sys_id");
        if (StringUtils.isNotBlank((String)current_sys_id)) {
            urlToRedirectTo = urlToRedirectTo.split("service=")[0] + "sysid=" + current_sys_id + "&service=" + urlToRedirectTo.split("service=")[1];
        }
        if ("1".equalsIgnoreCase(issimpleregister)) {
            urlToRedirectTo = urlToRedirectTo + "&registertype=" + this.simpleReg;
        }
        this.logger.debug("redirecting to \"{}\"", (Object)urlToRedirectTo);
        this.authenticationRedirectStrategy.redirect(request, response, urlToRedirectTo);
    }

    public final void setRenew(boolean renew) {
        this.renew = renew;
    }

    public final void setGateway(boolean gateway) {
        this.gateway = gateway;
    }

    public final void setCasServerLoginUrl(String casServerLoginUrl) {
        this.casServerLoginUrl = casServerLoginUrl;
    }

    public final void setGatewayStorage(GatewayResolver gatewayStorage) {
        this.gatewayStorage = gatewayStorage;
    }

    private boolean isRequestUrlExcluded(HttpServletRequest request) {
        if (this.ignoreUrlClass == null && this.ignoreUrlPatternMatcherStrategyClass == null) {
            return false;
        }
        StringBuffer urlBuffer = request.getRequestURL();
        if (request.getQueryString() != null) {
            urlBuffer.append("?").append(request.getQueryString());
        }
        String requestUri = urlBuffer.toString();
        if (this.ignoreUrlClass != null) {
            return this.ignoreUrlClass.matches(request);
        }
        return this.ignoreUrlPatternMatcherStrategyClass.matches(requestUri);
    }

    protected final String constructServiceUrl2(HttpServletRequest request, HttpServletResponse response) {
        if (CommonUtils.isNotBlank((String)this.myService)) {
            return this.myEncodeServiceUrl ? response.encodeURL(this.myService) : this.myService;
        }
        StringBuilder buffer = new StringBuilder();
        String returnServerName = this.findMatchingServerName(request, this.myServerName);
        if (!returnServerName.startsWith("https://") && !returnServerName.startsWith("http://")) {
            buffer.append(request.isSecure() ? "https://" : "http://");
        }
        buffer.append(returnServerName);
        if (StringUtils.isNotBlank((String)request.getRequestURI()) && request.getRequestURI().indexOf("sso/login") != -1) {
            buffer.append(request.getRequestURI());
        } else {
            String rURL = this.idmFilterConfiguration.getContextName();
            String loginUrl = this.idmFilterConfiguration.getLoginUrl();
            loginUrl = rURL + "/" + loginUrl + "?r=" + Base64.encodeBase64URLSafeString((byte[])rURL.getBytes());
            buffer.append(loginUrl);
        }
        if (CommonUtils.isNotBlank((String)request.getQueryString())) {
            int location = request.getQueryString().indexOf(this.getArtifactParameterName() + "=");
            if (location == 0) {
                String returnValue = this.myEncodeServiceUrl ? response.encodeURL(buffer.toString()) : buffer.toString();
                this.logger.debug("serviceUrl generated: {}", (Object)returnValue);
                return returnValue;
            }
            buffer.append("?");
            if (location == -1) {
                buffer.append(request.getQueryString());
            } else if (location > 0) {
                int actualLocation = request.getQueryString().indexOf("&" + this.getArtifactParameterName() + "=");
                if (actualLocation == -1) {
                    buffer.append(request.getQueryString());
                } else if (actualLocation > 0) {
                    buffer.append(request.getQueryString().substring(0, actualLocation));
                }
            }
        }
        String returnValue = this.myEncodeServiceUrl ? response.encodeURL(buffer.toString()) : buffer.toString();
        this.logger.debug("serviceUrl generated: {}", (Object)returnValue);
        return returnValue;
    }

    public final void setMyServerName(String serverName) {
        if (serverName != null && serverName.endsWith("/")) {
            this.myServerName = serverName.substring(0, serverName.length() - 1);
            this.logger.info("Eliminated extra slash from serverName [{}].  It is now [{}]", (Object)serverName, (Object)this.myServerName);
        } else {
            this.myServerName = serverName;
        }
    }

    public final void setMyService(String service) {
        this.myService = service;
    }

    public final void setMyEncodeServiceUrl(boolean encodeServiceUrl) {
        this.myEncodeServiceUrl = encodeServiceUrl;
    }

    private String findMatchingServerName(HttpServletRequest request, String myServerName) {
        String[] serverNames = myServerName.split(" ");
        if (serverNames == null || serverNames.length == 0 || serverNames.length == 1) {
            return myServerName;
        }
        String host = request.getHeader("Host");
        String xHost = request.getHeader("X-Forwarded-Host");
        String comparisonHost = xHost != null && host == "localhost" ? xHost : host;
        if (comparisonHost == null) {
            return myServerName;
        }
        for (String server : serverNames) {
            String lowerCaseServer = server.toLowerCase();
            if (!lowerCaseServer.contains(comparisonHost)) continue;
            return server;
        }
        return serverNames[0];
    }

    static {
        PATTERN_MATCHER_TYPES.put("CONTAINS", MutiContainsPatternUrlPatternMatcherStrategy.class);
        PATTERN_MATCHER_TYPES.put("MUTICONTAINS", MutiContainsPatternUrlPatternMatcherStrategy.class);
        PATTERN_MATCHER_TYPES.put("REGEX", RegexUrlPatternMatcherStrategy.class);
        PATTERN_MATCHER_TYPES.put("EXACT", ExactUrlPatternMatcherStrategy.class);
    }
}

