package com.ejianc.foundation.workbench.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.util.ArrayList;
import java.util.List;

/**
 * 菜单表
 * 
 * @author guominga
 *
 */
@TableName("ejc_idm_menu")
public class MenuEntity extends BaseEntity {

	private static final long serialVersionUID = 1L;

	@TableField(value = "menu_category_id")
	private Long menuCategoryId; // 菜单分类id

	@TableField(value = "app_id")
	private Long appId; // 应用ID

	@TableField(value = "parent_id")
	private Long parentId; // 父Id

	@TableField(value = "code")
	private String code; // 菜单编号

	@TableField(value = "name")
	private String name; // 菜单名称

	@TableField(value = "icon")
	private String icon; // 图标

	@TableField(value = "vitual_flag")
	private Integer virtualFlag; // 是否虚拟菜单（0：不是 ，1：是）

	@TableField(value = "mobile")
	private Integer mobile; // 是否移动菜单（0：不是 ，1：是）

	@TableField(value = "sequence")
	private Integer sequence; // 排序号

	@TableField(value = "system_id")
	private Long systemId; // 系统ID

	/**
	 * 父菜单Id
	 */
	@TableField(value = "inner_code")
	private String innerCode;

	@TableField(exist = false)
	private String type;// 来源（自定义，平台，同步修改）

	@TableField(exist = false)
	private List<MenuEntity> children = new ArrayList<>();//

	@TableField(exist = false)
	private Integer collectFlag; // 是否已收藏

	public Long getAppId() {
		return appId;
	}

	public void setAppId(Long appId) {
		this.appId = appId;
	}

	public Long getParentId() {
		return parentId;
	}

	public void setParentId(Long parentId) {
		this.parentId = parentId;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getIcon() {
		return icon;
	}

	public void setIcon(String icon) {
		this.icon = icon;
	}

	public Integer getVirtualFlag() {
		return virtualFlag;
	}

	public void setVirtualFlag(Integer virtualFlag) {
		this.virtualFlag = virtualFlag;
	}

	public Integer getSequence() {
		return sequence;
	}

	public void setSequence(Integer sequence) {
		this.sequence = sequence;
	}

	public Long getSystemId() {
		return systemId;
	}

	public void setSystemId(Long systemId) {
		this.systemId = systemId;
	}

	public String getInnerCode() {
		return innerCode;
	}

	public void setInnerCode(String innerCode) {
		this.innerCode = innerCode;
	}

	public Integer getMobile() {
		return mobile;
	}

	public void setMobile(Integer mobile) {
		this.mobile = mobile;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public Long getMenuCategoryId() {
		return menuCategoryId;
	}

	public void setMenuCategoryId(Long menuCategoryId) {
		this.menuCategoryId = menuCategoryId;
	}

	public List<MenuEntity> getChildren() {
		return children;
	}

	public void setChildren(List<MenuEntity> children) {
		this.children = children;
	}

	public Integer getCollectFlag() {
		return collectFlag;
	}

	public void setCollectFlag(Integer collectFlag) {
		this.collectFlag = collectFlag;
	}

}
