/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.workbench.service.impl;

import com.ejianc.foundation.cache.PermissionCacheManage;
import com.ejianc.foundation.orgcenter.service.IOrgService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.workbench.bean.LayoutEntity;
import com.ejianc.foundation.workbench.mapper.LayoutMapper;
import com.ejianc.foundation.workbench.mapper.LayoutOrgRelationMapper;
import com.ejianc.foundation.workbench.service.ILayoutService;
import com.ejianc.foundation.workbench.vo.LayoutOrgVO;
import com.ejianc.foundation.workbench.vo.LayoutVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LayoutServiceImpl
extends BaseServiceImpl<LayoutMapper, LayoutEntity>
implements ILayoutService {
    @Autowired
    private PermissionCacheManage permissionCacheManage;
    @Autowired
    private LayoutMapper layoutMapper;
    @Autowired
    private IOrgService orgService;
    @Autowired
    private LayoutOrgRelationMapper layoutOrgRelationMapper;

    @Override
    public LayoutVO queryLayoutById(Long layoutId) {
        LayoutEntity entity = (LayoutEntity)((Object)((LayoutMapper)this.baseMapper).selectById(layoutId));
        if (null != entity) {
            return (LayoutVO)BeanMapper.map((Object)((Object)entity), LayoutVO.class);
        }
        return null;
    }

    @Override
    public LayoutEntity getById(Long id) {
        return (LayoutEntity)((Object)((LayoutMapper)this.baseMapper).selectById(id));
    }

    @Override
    public void saveLayoutDesign(Long layoutId, String setting) {
        LayoutEntity entity = (LayoutEntity)((Object)((LayoutMapper)this.baseMapper).selectById(layoutId));
        if (null == entity) {
            throw new BusinessException("\u4fdd\u5b58\u5e03\u5c40\u8bbe\u8ba1\u5931\u8d25\uff0c\u5e03\u5c40\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        }
        entity.setSetting(setting);
        super.saveOrUpdate((Object)entity);
    }

    @Override
    public List<LayoutVO> queryLayoutByCurrentUser(String type, String systemId) {
        Long userId = InvocationInfoProxy.getUserid();
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<Long> roleIdList = this.permissionCacheManage.getUserRoleCache(userId, tenantId);
        List<LayoutEntity> roleLayouts = null;
        if (roleIdList != null && roleIdList.size() > 0) {
            String roleIds = "";
            for (Long roleId : roleIdList) {
                roleIds = roleIds + roleId + ",";
            }
            if (StringUtils.isNotBlank((CharSequence)roleIds)) {
                roleIds = roleIds.substring(0, roleIds.length() - 1);
                roleLayouts = this.layoutMapper.queryLayoutByRoleIds(roleIds, type, systemId);
            }
        }
        HashMap<Long, Long> roleLayoutMap = new HashMap<Long, Long>();
        if (roleLayouts != null) {
            for (LayoutEntity layoutEntity : roleLayouts) {
                roleLayoutMap.put(layoutEntity.getId(), layoutEntity.getId());
            }
        }
        List<OrgVO> orgVos = this.orgService.queryJobOrgs(userId);
        HashMap<Long, OrgVO> orgVoMap = new HashMap<Long, OrgVO>();
        if (orgVos != null && orgVos.size() > 0) {
            for (OrgVO orgVo : orgVos) {
                orgVoMap.put(orgVo.getId(), orgVo);
            }
        }
        ArrayList<Long> layoutIds = new ArrayList<Long>();
        List<LayoutOrgVO> layoutOrgVos = this.layoutOrgRelationMapper.queryListByTenantId(tenantId);
        if (layoutOrgVos != null && layoutOrgVos.size() > 0) {
            block3: for (LayoutOrgVO layoutOrgVo : layoutOrgVos) {
                OrgVO currentOrg;
                if (1 == layoutOrgVo.getLimitFlag()) {
                    if (!orgVoMap.containsKey(layoutOrgVo.getOrgId())) continue;
                    layoutIds.add(layoutOrgVo.getLayoutId());
                    continue;
                }
                if (2 != layoutOrgVo.getLimitFlag() || (currentOrg = this.orgService.queryDetail(layoutOrgVo.getOrgId())) == null || orgVos == null || orgVos.size() <= 0) continue;
                for (OrgVO orgVo : orgVos) {
                    if (!orgVo.getInnerCode().startsWith(currentOrg.getInnerCode())) continue;
                    layoutIds.add(layoutOrgVo.getLayoutId());
                    continue block3;
                }
            }
        }
        if (layoutIds != null && layoutIds.size() > 0) {
            if (roleLayouts == null) {
                roleLayouts = new ArrayList<LayoutEntity>();
            }
            for (Long layoutId : layoutIds) {
                if (roleLayoutMap.containsKey(layoutId)) continue;
                roleLayoutMap.put(layoutId, layoutId);
                LayoutEntity layoutEntity = this.layoutMapper.queryUniqueLayout(layoutId, systemId);
                if (layoutEntity == null || layoutEntity.getEnabled() == null || !layoutEntity.getEnabled().equals(1) || !StringUtils.isBlank((CharSequence)type) && !StringUtils.equals((CharSequence)layoutEntity.getType(), (CharSequence)type)) continue;
                roleLayouts.add(layoutEntity);
            }
        }
        if (roleLayouts != null) {
            LayoutEntity[] entities = new LayoutEntity[roleLayouts.size()];
            entities = this.sortlayouts(roleLayouts.toArray(entities));
            ArrayList<LayoutEntity> layoutList = new ArrayList<LayoutEntity>(Arrays.asList(entities));
            return BeanMapper.mapList(layoutList, LayoutVO.class);
        }
        return null;
    }

    private LayoutEntity[] sortlayouts(LayoutEntity[] layouts) {
        if (layouts != null && layouts.length > 0) {
            for (int i = 0; i < layouts.length; ++i) {
                for (int j = 0; j < layouts.length - i - 1; ++j) {
                    if (layouts[j + 1].getSequence() >= layouts[j].getSequence()) continue;
                    LayoutEntity temp = layouts[j + 1];
                    layouts[j + 1] = layouts[j];
                    layouts[j] = temp;
                }
            }
        }
        return layouts;
    }

    @Override
    public void deleteCustomLayout(String layoutId, Long userId) {
        this.layoutMapper.deleteCustomLayout(layoutId, userId);
    }

    @Override
    public void deleteAllCustomLayout(Long layoutId) {
        this.layoutMapper.deleteAllCustomLayout(layoutId);
    }
}

