package com.ejianc.foundation.oms.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.oms.bean.ComboAppEntity;
import com.ejianc.foundation.oms.mapper.ComboAppMapper;
import com.ejianc.foundation.oms.mapper.ComboRoleMapper;
import com.ejianc.foundation.oms.service.IComboAppService;
import com.ejianc.foundation.oms.service.IComboEnterpriseService;
import com.ejianc.foundation.oms.vo.ComboAppVO;
import com.ejianc.foundation.permission.bean.RoleAppRelationEntity;
import com.ejianc.foundation.permission.service.IAppService;
import com.ejianc.foundation.permission.service.IRoleAppRelationService;
import com.ejianc.foundation.permission.vo.AppVO;
import com.ejianc.foundation.permission.vo.RoleAppVO;
import com.ejianc.foundation.permission.vo.RoleVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

/**
 * 套餐应用关系
 * 
 * @author generator
 * 
 */
@Service
public class ComboAppServiceImpl extends BaseServiceImpl<ComboAppMapper, ComboAppEntity> implements IComboAppService{

	@Autowired
	private ComboAppMapper mapper;
	@Autowired
	private ComboRoleMapper comboRoleMapper;
    
    @Value("${oms.tenantid}")
    private Long omsTenantId;
	
	@Autowired
	private IComboEnterpriseService comboEnterpriseService;
	@Autowired
	private IRoleAppRelationService roleAppRelationService;
	
	@Autowired
	private IAppService appService;
	
	@Override
	public IPage<AppVO> queryPage(Map<String, Object> params, boolean isEs) {
		if(params.get("pageIndex")!=null){
			Integer pn = Integer.parseInt(params.get("pageIndex").toString());
			pn = pn - 1 < 0 ? 1 : pn;
	        long startLine = (pn - 1) * Integer.parseInt(params.get("pageSize").toString());
	        params.put("startLine", startLine);
		}
		Long count = mapper.countByProPerties(params);
		IPage<AppVO> page = new Page<AppVO>();
		if(count>0){
			List<AppVO> appVO = mapper.queryPageByProperties(params);
			page.setRecords(appVO);
		}else{
			page.setRecords(null);
		}
		if(params.get("pageIndex")!=null){
			page.setCurrent(Integer.parseInt(params.get("pageIndex").toString()));
			page.setSize(Integer.parseInt(params.get("pageSize").toString()));
			page.setTotal(count);
		}
		return page;
	}

	@Override
	@Transactional
	public CommonResponse<String> delete(List<ComboAppEntity> appVos) {
		List<RoleAppRelationEntity> roleAppRelation = new ArrayList<>();
		for(ComboAppEntity appVo:appVos) {
			//先删除应用
			mapper.deleteAuthApp(appVo.getComboId(),appVo.getAppId());
			
			//删除已推送给租户的应用数据
			//1、查询该套餐是否分配租户
			List<Long> tenantIds = comboEnterpriseService.queryTenantIdBycomboId(appVo.getComboId());
			if(tenantIds!=null&&tenantIds.size()>0){
				//获取该应用在套餐中存在哪些角色有该应用的权限
				if(appVo.getClassify()!=1){
					//业务类的应用需要推送角色授权
					for(Long tenantId : tenantIds){
						List<RoleVO> roleVOs = comboRoleMapper.queryRoleByAppAndComboId(appVo.getComboId(), tenantId, omsTenantId, appVo.getAppId());
						if(roleVOs!=null&&roleVOs.size()>0){
							roleVOs.forEach(e -> {
								RoleAppRelationEntity entity = new RoleAppRelationEntity();
								entity.setAppId(appVo.getAppId());
								entity.setDataType("app");
								entity.setRoleId(e.getId());
								roleAppRelation.add(entity);
							});
						}
						//若该租户下没有其余的套餐有该应用的权限，则删除该租户下所有的有该应用的关系数据
						Long exit = mapper.exitAppNotComboId(appVo.getComboId(), appVo.getAppId(), tenantId);
						if(exit==0){
							QueryWrapper<RoleAppRelationEntity> queryWrapper = new QueryWrapper<>();
							queryWrapper.eq("dr", 0);
							queryWrapper.eq("tenant_id", tenantId);
							queryWrapper.eq("app_id", appVo.getAppId());
							//该应用在租户下已无权限，查询该应用被分配的所有角色应用关系数据并删除
							List<RoleAppRelationEntity> list = roleAppRelationService.list(queryWrapper );
							if(list!=null&&list.size()>0){
								list.forEach(e -> {
									e.setDataType("app");
								});
								roleAppRelation.addAll(list);
							}
						}
					}
					
					roleAppRelationService.delete(roleAppRelation);
				}
			}
			
		}
		return CommonResponse.success("删除成功");
	}

	/**
	 * 保存套餐应用关系
	 */
	@Override
	public CommonResponse<String> saveComboApp(ComboAppVO comboAppVO) {
		if(comboAppVO.getComboId()!=null){
			List<AppVO> appVo = comboAppVO.getAppVO();
			if(appVo!=null&&appVo.size()>0){
				List<ComboAppEntity> appList = new ArrayList<>();
				for(AppVO vo : appVo){
					ComboAppEntity entity = new ComboAppEntity();
					entity.setAppId(vo.getId());
					entity.setComboId(comboAppVO.getComboId());
					appList.add(entity);
				}
				if(appList.size()>0){
					this.saveOrUpdateBatch(appList, appList.size(), false);
				}
				
				//推送分配该套参的租户的角色应用（业务应用，运营类的应用不需要给角色授权）数据
				//1、查询该套餐是否分配租户
				List<Long> tenantIds = comboEnterpriseService.queryTenantIdBycomboId(comboAppVO.getComboId());
				if(tenantIds!=null&&tenantIds.size()>0){
					//获取该应用在套餐中存在哪些角色有该应用的权限
					for(AppVO vo : appVo){
						if(vo.getClassify()!=1){
							//业务类的应用需要推送角色授权
							for(Long tenantId : tenantIds){
								List<RoleVO> roleVOs = comboRoleMapper.queryRoleByAppAndComboId(comboAppVO.getComboId(), tenantId, omsTenantId, vo.getId());
								if(roleVOs!=null&&roleVOs.size()>0){
									roleVOs.forEach(e -> {
										RoleAppVO roleAppVO = new RoleAppVO();
										List<AppVO> app = new ArrayList<>();
										app.add(vo);
										roleAppVO.setAppVO(app);
										roleAppVO.setRoleId(e.getId());
										appService.saveRoleApp(roleAppVO);
									});
								}
							}
						}else{
							//运营类的应用不需要推送数据
						}
					}
				}
			}else{
				return CommonResponse.error("保存应用数据为空");
			}
		}else{
			return CommonResponse.error("套餐id不能为空");
		}
		
		return CommonResponse.success("保存成功");
	}

	@Override
	public IPage<AppVO> comboAppRefList(Map<String, Object> params) {
		IPage<AppVO> page = new Page<AppVO>();
		if(params.get("pageIndex")!=null){
			Integer pn = Integer.parseInt(params.get("pageIndex").toString());
			pn = pn - 1 < 0 ? 1 : pn;
	        long startLine = (pn - 1) * Integer.parseInt(params.get("pageSize").toString());
	        params.put("startLine", startLine);
		}
		Long count = mapper.countComboAppRefList(params);
		if(count>0){
			List<AppVO> appVO = mapper.comboAppRefList(params);
			appVO.forEach(e -> {
				e.setChildren(null);
			});
			page.setRecords(appVO);
		}else{
			page.setRecords(null);
		}
		if(params.get("pageIndex")!=null){
			page.setCurrent(Integer.parseInt(params.get("pageIndex").toString()));
			page.setSize(Integer.parseInt(params.get("pageSize").toString()));
			page.setTotal(count);
		}
		return page;
	}
}
