package com.ejianc.foundation.resource.service.impl;

import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.foundation.resource.mapper.ResourceTypeMapper;
import com.ejianc.foundation.resource.bean.ResourceTypeEntity;
import com.ejianc.foundation.resource.service.IResourceTypeService;

import java.util.List;

/**
 * 系统资源类型
 * 
 * @author generator
 * 
 */
@Service("resourceTypeService")
public class ResourceTypeServiceImpl extends BaseServiceImpl<ResourceTypeMapper, ResourceTypeEntity> implements IResourceTypeService{

    @Override
    public ResourceTypeEntity queryByCode(String code) {
        if(StringUtils.isEmpty(code)){
            return null;
        }
        QueryParam param = new QueryParam();
        param.getParams().put("code",new Parameter(QueryParam.EQ,code));
        List<ResourceTypeEntity> list = queryList(param);
        if(ListUtil.isNotEmpty(list)){
            return list.get(0);
        }
        return null;
    }
}
