package com.ejianc.foundation.tenant.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.foundation.permission.bean.AppEntity;
import com.ejianc.foundation.permission.service.IAppService;
import com.ejianc.foundation.tenant.vo.TenantMenuVO;
import com.ejianc.foundation.workbench.bean.MenuEntity;
import com.ejianc.foundation.workbench.service.IMenuService;
import com.ejianc.framework.core.exception.BusinessException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.tenant.bean.TenantMenuEntity;
import com.ejianc.foundation.tenant.mapper.TenantMenuMapper;
import com.ejianc.foundation.tenant.service.ITenantMenuService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

/**
 * 租户自定义菜单
 * 
 * @author generator
 * 
 */
@Service("tenantMenuService")
public class TenantMenuServiceImpl extends BaseServiceImpl<TenantMenuMapper, TenantMenuEntity> implements ITenantMenuService{

    @Autowired
    private TenantMenuMapper tenantMenuMapper;
    @Autowired
    private IMenuService menuService;
    @Autowired
    private IAppService appService;

    @Value("${oms.tenantid}")
    private String OMS_TENANT;

    @Override
    public void delteMenu(Long menuId){
        UpdateWrapper<TenantMenuEntity> wrapper = new UpdateWrapper<>();
        wrapper.eq("menu_id", menuId);
        wrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
        wrapper.set("del", 1);
        this.update(null, wrapper);
    }

    public Boolean isChangeParent(Long oldId, Long id){
        Boolean change = false;
        if(oldId != null && id == null){
            change = true;
        } else if (oldId == null && id != null) {
            change = true;
        } else if (oldId != null && id != null && !oldId.equals(id)) {
            change = true;
        }
        return  change;
    }

    @Override
    public void updateDetail(MenuEntity entity){
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(!tenantId.toString().equals(OMS_TENANT) && entity.getTenantId().toString().equals(OMS_TENANT)){
            //当前数据租户不是平台租户且当前租户要修改平台档案--关系表新增一条修改记录
            MenuEntity menuEntity = menuService.selectById(entity.getId());

            TenantMenuEntity relationEntity = BeanMapper.map(entity, TenantMenuEntity.class);
            relationEntity.setMenuId(relationEntity.getId());
            relationEntity.setId(null);
            relationEntity.setTenantId(null);
            relationEntity.setCreateTime(null);
            relationEntity.setCreateUserCode(null);
            relationEntity.setUpdateTime(null);
            relationEntity.setDel(0);
            relationEntity.setUpdateUserCode(null);

            //当父级变更时，需要同步修改下级所有自己的innerCode
            if(menuEntity!=null && isChangeParent(menuEntity.getParentId(), entity.getParentId())){
                //上级组织变了，改变下级innercode=
                String innerCode = entity.getId().toString();
                if(entity.getParentId()!=null){
                    MenuEntity pmenuEntity = menuService.getOneById(entity.getParentId());
                    if(pmenuEntity!=null){
                        innerCode = (pmenuEntity.getInnerCode()+"|"+entity.getId());
                    }
                }
                relationEntity.setInnerCode(innerCode);

                //获取当前租户的套餐分配的应用
                List<AppEntity> apps = appService.queryComboApp();
                List<Long> appIds = new ArrayList<>();
                if(apps!=null && apps.size()>0){
                    for(AppEntity e : apps) {
                        appIds.add(e.getId());
                    }
                }

                QueryWrapper<MenuEntity> wrapper = new QueryWrapper<>();
                wrapper.eq("tenant_id", OMS_TENANT);
                wrapper.like("inner_code", menuEntity.getInnerCode());
                wrapper.eq("dr", 0);
                wrapper.ne("id", entity.getId());
                List<MenuEntity> list = menuService.list(wrapper);//获取所有下级数据
                List<TenantMenuEntity> entitys = new ArrayList<>();
                entitys.add(relationEntity);
                if(list!=null && list.size()>0){
                    //判断数据是否已经私有化，若私有化则忽略掉
                    List<Long> ids = new ArrayList<>();
                    for(MenuEntity e : list){
                        if((e.getAppId()!=null & appIds.contains(e.getAppId())) || e.getVirtualFlag() == 1){
                            //是虚拟菜单或者是这个套餐内的应用
                            ids.add(e.getId());
                        }
                    }
                    List<Long> exitIds = new ArrayList<>();
                    QueryWrapper<TenantMenuEntity> tqueryWrapper = new QueryWrapper<>();
                    tqueryWrapper.eq("dr", 0);
                    tqueryWrapper.eq("tenant_id", tenantId);
                    tqueryWrapper.in("menu_id", ids);
                    List<TenantMenuEntity> trelationEntitys = this.list(tqueryWrapper);
                    if(trelationEntitys!=null && trelationEntitys.size()>0){
                        for(TenantMenuEntity item : trelationEntitys){
                            exitIds.add(item.getMenuId());
                        }
                    }
                    for(MenuEntity e : list){
                        if(exitIds!=null && exitIds.contains(e.getId())){
                            continue;
                        }
                        if(e.getAppId()!=null & !appIds.contains(e.getAppId())){
                            //是虚拟菜单或者是这个套餐内的应用
                            continue;
                        }
                        TenantMenuEntity r = BeanMapper.map(e, TenantMenuEntity.class);
                        r.setMenuId(e.getId());
                        r.setId(null);
                        r.setTenantId(null);
                        r.setCreateTime(null);
                        r.setCreateUserCode(null);
                        r.setUpdateTime(null);
                        r.setDel(0);
                        r.setUpdateUserCode(null);
                        r.setInnerCode((r.getInnerCode().replace((menuEntity.getInnerCode()), innerCode)));
                        entitys.add(r);
                    }
                }
                this.saveOrUpdateBatch(entitys, entitys.size(), false);
            }else{
                this.saveOrUpdate(relationEntity, false);
            }
        }else if(!tenantId.toString().equals(OMS_TENANT) && tenantId.equals(entity.getTenantId())){
            //修改的是用户自己的数据
            QueryWrapper<MenuEntity> wrapper = new QueryWrapper<>();
            wrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
            wrapper.eq("id", entity.getId());
            wrapper.eq("dr", 0);
            List<MenuEntity> list = menuService.list(wrapper);
            if(list!=null && list.size()>0){
                MenuEntity old = list.get(0);
                //修改的是用户自己建的
                if(isChangeParent(entity.getParentId(), old.getParentId())){
                    //上级组织变了，改变下级innercode=
                    String innerCode = entity.getId().toString();
                    if(entity.getParentId()!=null){
                        MenuEntity pmenuEntity = menuService.getOneById(entity.getParentId());
                        if(pmenuEntity!=null){
                            innerCode = (pmenuEntity.getInnerCode()+"|"+entity.getId());
                        }
                    }
                    entity.setInnerCode(innerCode);
                    //查询该菜单的所有下级，批量修改innercode
                    QueryWrapper<MenuEntity> cqueryWrapper = new QueryWrapper<>();
                    cqueryWrapper.eq("dr", 0);
                    cqueryWrapper.eq("tenant_id", tenantId);
                    cqueryWrapper.ne("id", entity.getId());//排除自己
                    cqueryWrapper.like("inner_code", old.getInnerCode());
                    List<MenuEntity> crelationEntitys = menuService.list(cqueryWrapper);
                    if(crelationEntitys!=null && crelationEntitys.size()>0){
                        for(MenuEntity item : crelationEntitys){
                            item.setInnerCode((item.getInnerCode().replace((old.getInnerCode()), innerCode)));
                        }
                        menuService.saveOrUpdateBatch(crelationEntitys, crelationEntitys.size(), false);
                    }

                    //查询该菜单的所有下级，批量修改innercode
                    QueryWrapper<TenantMenuEntity> ctqueryWrapper = new QueryWrapper<>();
                    ctqueryWrapper.eq("dr", 0);
                    ctqueryWrapper.eq("tenant_id", tenantId);
                    ctqueryWrapper.like("inner_code", old.getInnerCode());
                    List<TenantMenuEntity> ctrelationEntitys = this.list(ctqueryWrapper);
                    if(ctrelationEntitys!=null && ctrelationEntitys.size()>0){
                        for(MenuEntity item : crelationEntitys){
                            item.setInnerCode((item.getInnerCode().replace((old.getInnerCode()), innerCode)));
                        }
                        this.saveOrUpdateBatch(ctrelationEntitys, ctrelationEntitys.size(), false);
                    }
                }
                menuService.saveOrUpdate(entity, false);
            }else{
                //是原先平台档案但是后来修改过的
                QueryWrapper<TenantMenuEntity> queryWrapper = new QueryWrapper<>();
                queryWrapper.eq("dr", 0);
                queryWrapper.eq("tenant_id", tenantId);
                queryWrapper.eq("menu_id", entity.getId());
                TenantMenuEntity relationEntity = this.getOne(queryWrapper);
                relationEntity.setName(entity.getName());
                relationEntity.setCode(entity.getCode());
                relationEntity.setSequence(entity.getSequence());
                if(isChangeParent(entity.getParentId(), relationEntity.getParentId())){
                    //上级组织变了，改变下级innercode
                    relationEntity.setParentId(entity.getParentId());

                    String innerCode = entity.getId().toString();
                    if(entity.getParentId()!=null){
                        MenuEntity pmenuEntity = menuService.getOneById(entity.getParentId());
                        if(pmenuEntity!=null){
                            innerCode = (pmenuEntity.getInnerCode()+"|"+entity.getId());
                        }
                    }
                    relationEntity.setInnerCode(innerCode);

                    //获取当前租户的套餐分配的应用
                    List<AppEntity> apps = appService.queryComboApp();
                    List<Long> appIds = new ArrayList<>();
                    if(apps!=null && apps.size()>0){
                        for(AppEntity e : apps) {
                            appIds.add(e.getId());
                        }
                    }

                    //获取当前菜单本租户的所有下级----将平台的全部初始化冗余数据
                    Map<String, Object> param = new HashMap<>();
                    param.put("innerCode", entity.getInnerCode());
                    List<MenuEntity> menuEntityList = menuService.queryList(param);

                    List<TenantMenuEntity> entitys = new ArrayList<>();
                    for(MenuEntity e : menuEntityList){
                        if(e.getId().equals(entity.getId())){
                            //查询到的是本条数据--忽略
                            continue;
                        }
                        if(e.getTenantId().equals(tenantId)){
                            //查询到的是本租户的数据（自定义或者已修改平台的数据）--忽略
                            continue;
                        }
                        if((e.getAppId()!=null & appIds.contains(e.getAppId())) || e.getVirtualFlag() == 1){
                            //是虚拟菜单或者是这个套餐内的应用,并且是平台数据，
                            TenantMenuEntity r = BeanMapper.map(e, TenantMenuEntity.class);
                            r.setMenuId(e.getId());
                            r.setId(null);
                            r.setTenantId(null);
                            r.setCreateTime(null);
                            r.setCreateUserCode(null);
                            r.setUpdateTime(null);
                            r.setDel(0);
                            r.setUpdateUserCode(null);
                            r.setInnerCode((r.getInnerCode().replace((entity.getInnerCode()), innerCode)));
                            entitys.add(r);
                        }
                    }

                    //查询该菜单的所有下级，批量修改innercode
                    QueryWrapper<TenantMenuEntity> cqueryWrapper = new QueryWrapper<>();
                    cqueryWrapper.eq("dr", 0);
                    cqueryWrapper.eq("tenant_id", tenantId);
                    cqueryWrapper.ne("menu_id", entity.getId());//排除自己
                    cqueryWrapper.like("inner_code", entity.getInnerCode());
                    List<TenantMenuEntity> crelationEntitys = this.list(cqueryWrapper);
                    if(crelationEntitys!=null && crelationEntitys.size()>0){
                        for(TenantMenuEntity item : crelationEntitys){
                            item.setInnerCode((item.getInnerCode().replace((entity.getInnerCode()), innerCode)));
                        }
                        entitys.addAll(crelationEntitys);
                    }
                    if(entitys!=null && entitys.size()>0){
                        this.saveOrUpdateBatch(entitys, entitys.size(), false);
                    }
                }
                relationEntity.setIcon(entity.getIcon());
                relationEntity.setMobile(entity.getMobile());
                relationEntity.setVirtualFlag(entity.getVirtualFlag());
                relationEntity.setAppId(entity.getAppId());
                relationEntity.setSystemId(entity.getSystemId());
                this.saveOrUpdate(relationEntity, false);
            }
        }else{
            //平台数据修改
            MenuEntity menuEntity = menuService.selectById(entity.getId());
            //当父级变更时，需要同步修改下级所有自己的innerCode
            if(menuEntity!=null && isChangeParent(menuEntity.getParentId(), entity.getParentId())){
                //上级组织变了，改变下级innercode=
                String innerCode = entity.getId().toString();
                if(entity.getParentId()!=null){
                    MenuEntity pmenuEntity = menuService.getOneById(entity.getParentId());
                    if(pmenuEntity!=null){
                        innerCode = (pmenuEntity.getInnerCode()+"|"+entity.getId());
                    }
                }
                entity.setInnerCode(innerCode);

                QueryWrapper<MenuEntity> wrapper = new QueryWrapper<>();
                wrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
                wrapper.like("inner_code", menuEntity.getInnerCode());
                wrapper.eq("dr", 0);
                wrapper.ne("id", entity.getId());
                List<MenuEntity> list = menuService.list(wrapper);//获取所有下级数据
                List<MenuEntity> entitys = new ArrayList<>();
                entitys.add(entity);
                if(list!=null && list.size()>0){
                    for(MenuEntity e : list){
                        e.setInnerCode((e.getInnerCode().replace((menuEntity.getInnerCode()), innerCode)));
                        entitys.add(e);
                    }
                }
                menuService.saveOrUpdateBatch(entitys, entitys.size(), false);
            }else{
                menuService.saveOrUpdate(entity, false);
            }
        }
    }

    @Override
    public void delete(Long id) {
        Map<String, Object> param = new HashMap<>();
        param.put("parentId", id);
        List<MenuEntity> clist = menuService.queryList(param);
        if(clist!=null && clist.size()>0){
            throw new BusinessException("该菜单下存在此菜单，不能进行删除操作！");
        }
        MenuEntity vo = menuService.getOneById(id);
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(!tenantId.toString().equals(OMS_TENANT) && vo.getTenantId().toString().equals(OMS_TENANT)){
            //当前租户不是平台租户且当前租户要删除平台档案
            TenantMenuEntity relationEntity = BeanMapper.map(vo, TenantMenuEntity.class);
            relationEntity.setMenuId(relationEntity.getId());
            relationEntity.setId(null);
            relationEntity.setTenantId(null);
            relationEntity.setCreateTime(null);
            relationEntity.setCreateUserCode(null);
            relationEntity.setUpdateTime(null);
            relationEntity.setDel(1);
            relationEntity.setUpdateUserCode(null);
            this.saveOrUpdate(relationEntity, false);
        }else if(!tenantId.toString().equals(OMS_TENANT) && tenantId.equals(vo.getTenantId())){
            //删除的是用户自己的数据
            QueryWrapper<MenuEntity> wrapper = new QueryWrapper<>();
            wrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
            wrapper.eq("id", vo.getId());
            wrapper.eq("dr", 0);
            List<MenuEntity> list = menuService.list(wrapper);
            if(list!=null && list.size()>0){
                //删除的是用户自己建的
                menuService.removeById(vo.getId(), false);
            }else{
                //删除是原先平台档案但是后来修改过的
                this.delteMenu(id);
            }
        }else{
            //平台数据删除
            //校验该菜单是否被其他租户引用了，若引用则不允许删除
            QueryWrapper<TenantMenuEntity> tqueryWrapper = new QueryWrapper<>();
            tqueryWrapper.eq("dr", 0);
            tqueryWrapper.eq("del", 0);
            tqueryWrapper.eq("tenant_id", tenantId);
            tqueryWrapper.eq("menu_id", vo.getId());
            List<TenantMenuEntity> trelationEntitys = this.list(tqueryWrapper);
            if(trelationEntitys!=null && trelationEntitys.size()>0){
                throw new BusinessException("该菜单已被其他租户修改使用，不允许删除");
            }
            menuService.removeById(vo.getId(), false);
        }
    }

    @Override
    public void reduction(Integer mobile) {
        //删除本租户新建的
        QueryWrapper<MenuEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("dr", 0);
        if(mobile!=null && mobile == 1){
            wrapper.eq("mobile", 1);
        }else{
            wrapper.ne("mobile", 1);
        }
        wrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
        menuService.remove(wrapper);
        //删除修改的平台数据
        tenantMenuMapper.deleteByTenantId(InvocationInfoProxy.getTenantid(), mobile);
    }

    @Override
    public void saveBatchList(List<TenantMenuVO> list) {
        String innerCodes = "";
        for(TenantMenuVO vo : list){
            if(innerCodes.length()>0){
                innerCodes += ("(`innerCode` like concat('%', '"+vo.getInnerCode()+"', '%')) or ");
            }else{
                innerCodes += ("(`innerCode` like concat('%', '"+vo.getInnerCode()+"', '%'))");
            }
        }
        //先手动获取所有的下级数据
        Map<String, Object> param = new HashMap<>();
        param.put("innerCodes", innerCodes);
        param.put("tenantId", InvocationInfoProxy.getTenantid());
        List<MenuEntity> clist = menuService.queryList(param);
        for(MenuEntity entity : clist){
            entity.setSystemId(list.get(0).getSystemId());
            this.updateDetail(entity);
        }
    }

}
