package com.ejianc.foundation.weixinpay.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.usercenter.bean.ThirdSystemEntity;
import com.ejianc.foundation.usercenter.service.IThirdSystemService;
import com.ejianc.foundation.weixinpay.bean.WeixinpayInvoiceEntity;
import com.ejianc.foundation.weixinpay.bean.WeixinpayInvoiceHeaderEntity;
import com.ejianc.foundation.weixinpay.bean.WeixinpayInvoiceOrderEntity;
import com.ejianc.foundation.weixinpay.bean.WeixinpayOrderEntity;
import com.ejianc.foundation.weixinpay.mapper.WeixinpayInvoiceMapper;
import com.ejianc.foundation.weixinpay.service.IWeixinpayInvoiceHeaderService;
import com.ejianc.foundation.weixinpay.service.IWeixinpayInvoiceService;
import com.ejianc.foundation.weixinpay.service.IWeixinpayOrderService;
import com.ejianc.foundation.weixinpay.vo.WeixinpayInvoiceOrderVO;
import com.ejianc.foundation.weixinpay.vo.WeixinpayInvoiceVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service
public class WeixinpayInvoiceServiceImpl extends BaseServiceImpl<WeixinpayInvoiceMapper, WeixinpayInvoiceEntity> implements IWeixinpayInvoiceService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IWeixinpayOrderService orderService;
    @Autowired
    private IWeixinpayInvoiceHeaderService invoiceHeaderService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IThirdSystemService thirdSystemService;
    @Autowired
    private EnvironmentTools environmentTools;

    private static final String BILL_CODE = "WEIXINPAYINVOICE";//此处需要根据实际修改

    @Override
    public WeixinpayInvoiceVO insertOrUpdate(WeixinpayInvoiceVO saveOrUpdateVO) {
        Boolean sendMsg = false;
        if(saveOrUpdateVO.getOrderList().size()==0){
            throw new BusinessException("缺少订单信息，请选择订单！");
        }
        if(saveOrUpdateVO.getId() == null){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                saveOrUpdateVO.setCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            saveOrUpdateVO.setInvoiceState("开票中");
            //新增发送消息
            sendMsg = true;
        }
        //获取订单信息并修改
        WeixinpayInvoiceEntity entity = BeanMapper.map(saveOrUpdateVO, WeixinpayInvoiceEntity.class);
        List<WeixinpayInvoiceOrderEntity> list = entity.getOrderList();
        if(list!=null && list.size()>0){
            List<Long> ids = new ArrayList<>();
            for (WeixinpayInvoiceOrderEntity en : list){
                ids.add(en.getOrderId());
            }
            UpdateWrapper<WeixinpayOrderEntity> wrapper = new UpdateWrapper<>();
            wrapper.in("id", ids);
            wrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
            wrapper.set("invoice_state", "开票中");
            orderService.update(null, wrapper);
        }
        this.saveOrUpdate(entity, false);
        WeixinpayInvoiceVO vo = BeanMapper.map(entity, WeixinpayInvoiceVO.class);
        vo.setEnterpriseName(saveOrUpdateVO.getEnterpriseName());
        vo.setTaxNo(saveOrUpdateVO.getTaxNo());
        vo.setAddress(saveOrUpdateVO.getAddress());
        vo.setPhone(saveOrUpdateVO.getPhone());
        vo.setBankName(saveOrUpdateVO.getBankName());
        vo.setBankAccount(saveOrUpdateVO.getBankAccount());
        //处理子表信息
        if(vo.getOrderList()!=null && vo.getOrderList().size()>0){
            List<WeixinpayInvoiceOrderVO> orderList = vo.getOrderList();
            for (WeixinpayInvoiceOrderVO ovo : orderList){
                WeixinpayOrderEntity order = orderService.selectById(ovo.getOrderId());
                ovo.setMchid(order.getMchid());
                ovo.setOrderNo(order.getOrderNo());
                ovo.setType(order.getType());
                ovo.setNum(order.getNum());
                ovo.setMoney(order.getMoney());
            }
        }


        if(sendMsg){
            //获取通知人id
            ThirdSystemEntity invoiceNoticer = thirdSystemService.queryThirdSystemByCode("invoiceNoticer");
            if(invoiceNoticer!=null && StringUtils.isNotBlank(invoiceNoticer.getConfigInfo())){
                PushMsgParameter parameter = new PushMsgParameter();
                List<String> channel = new ArrayList<>();
                // 系统消息
                channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);

                String[] receivers = invoiceNoticer.getConfigInfo().split(",");

                parameter.setReceivers(receivers);// 收信人
                parameter.setMsgType("notice");
                String subject = "您有一条新的订单发票需要开票，请尽快处理";
                parameter.setSubject(subject);// 标题
                parameter.setContent(subject);// 内容
                String pcUrl = environmentTools.getBaseHost() + "ejc-idm-frontend/#/omsInvoice?id="+vo.getId();
                parameter.setPcUrl(pcUrl);//
                parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
                parameter.setSendUserId(InvocationInfoProxy.getUserid());
                //获取微信公众号消息模板
                ThirdSystemEntity invoiceNoticerTemplate = thirdSystemService.queryThirdSystemByCode("invoiceNoticerTemplate");
                if(invoiceNoticerTemplate!=null && StringUtils.isNotBlank(invoiceNoticerTemplate.getConfigInfo())) {
                    // 微信公众号消息
                    channel.add(PushMsgParameter.CHANNEL_TYPE_WEIXIN);
                    JSONObject weixinParams = new JSONObject();
                    weixinParams.put("template_id", invoiceNoticerTemplate.getConfigInfo());
                    JSONObject wxparams = new JSONObject();
                    wxparams.put("first", subject);
                    wxparams.put("keyword1", "费用中心");
                    wxparams.put("keyword2", "订单开票");
                    wxparams.put("keyword3", subject);
                    wxparams.put("keyword4", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                    wxparams.put("remark", "请及时处理！");
                    weixinParams.put("data", wxparams);
                    parameter.setWeixinParams(weixinParams);
                }
                parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
                try {
                    CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
                    if (result.isSuccess()) {
                        logger.error("消息发送成功---------------->" + result.getMsg());
                    } else {
                        logger.error("消息发送失败---------------->" + result.getMsg());
                    }
                } catch (Exception e) {
                    logger.error("调用消息中心RPC服务异常--------------" + e);
                }
            }
        }
        return vo;
    }

    @Override
    public WeixinpayInvoiceVO queryDetail(Long id) {
        WeixinpayInvoiceEntity entity = this.selectById(id);
        WeixinpayInvoiceVO vo = null;
        if(entity!=null){
            vo = BeanMapper.map(entity, WeixinpayInvoiceVO.class);
            WeixinpayInvoiceHeaderEntity invoiceHeaderEntity = invoiceHeaderService.selectById(entity.getInvoiceHeaderId());
            if(invoiceHeaderEntity!=null){
                vo.setEnterpriseName(invoiceHeaderEntity.getEnterpriseName());
                vo.setTaxNo(invoiceHeaderEntity.getTaxNo());
                vo.setAddress(invoiceHeaderEntity.getAddress());
                vo.setPhone(invoiceHeaderEntity.getPhone());
                vo.setBankName(invoiceHeaderEntity.getBankName());
                vo.setBankAccount(invoiceHeaderEntity.getBankAccount());
            }
            //处理子表信息
            if(vo.getOrderList()!=null && vo.getOrderList().size()>0){
                List<WeixinpayInvoiceOrderVO> orderList = vo.getOrderList();
                for (WeixinpayInvoiceOrderVO ovo : orderList){
                    WeixinpayOrderEntity order = orderService.selectById(ovo.getOrderId());
                    ovo.setMchid(order.getMchid());
                    ovo.setOrderNo(order.getOrderNo());
                    ovo.setType(order.getType());
                    ovo.setNum(order.getNum());
                    ovo.setMoney(order.getMoney());
                }
            }
        }
        return vo;
    }

    @Override
    public void delete(WeixinpayInvoiceVO vo) {
        WeixinpayInvoiceEntity entity = this.selectById(vo.getId());
        List<WeixinpayInvoiceOrderEntity> list = entity.getOrderList();
        if(list!=null && list.size()>0){
            List<Long> ids = new ArrayList<>();
            for (WeixinpayInvoiceOrderEntity en : list){
                ids.add(en.getOrderId());
            }
            UpdateWrapper<WeixinpayOrderEntity> wrapper = new UpdateWrapper<>();
            wrapper.in("id", ids);
            wrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
            wrapper.set("invoice_state", "待开票");
            orderService.update(null, wrapper);
        }
        this.removeById(vo.getId());
    }

    @Override
    public CommonResponse<String> invoicing(Long id) {
        WeixinpayInvoiceEntity entity = this.selectById(id);
        entity.setInvoiceState("已开票");
        List<WeixinpayInvoiceOrderEntity> list = entity.getOrderList();
        if(list!=null && list.size()>0){
            List<Long> ids = new ArrayList<>();
            for (WeixinpayInvoiceOrderEntity en : list){
                ids.add(en.getOrderId());
            }
            UpdateWrapper<WeixinpayOrderEntity> wrapper = new UpdateWrapper<>();
            wrapper.in("id", ids);
            wrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
            wrapper.set("invoice_state", "已开票");
            orderService.update(null, wrapper);
        }
        this.saveOrUpdate(entity, false);
        return CommonResponse.success("开票成功");
    }
}
