package com.ejianc.foundation.workbench.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.foundation.cache.PermissionCacheManage;
import com.ejianc.foundation.orgcenter.service.IOrgService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.workbench.bean.LayoutEntity;
import com.ejianc.foundation.workbench.mapper.LayoutMapper;
import com.ejianc.foundation.workbench.mapper.LayoutOrgRelationMapper;
import com.ejianc.foundation.workbench.service.ILayoutService;
import com.ejianc.foundation.workbench.vo.LayoutOrgVO;
import com.ejianc.foundation.workbench.vo.LayoutVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

/**
 * 模板信息数据服务
 */
@Service
public class LayoutServiceImpl extends BaseServiceImpl<LayoutMapper, LayoutEntity> implements ILayoutService {

	@Autowired
	private PermissionCacheManage permissionCacheManage;
	@Autowired
	private LayoutMapper layoutMapper;
	@Autowired
	private IOrgService orgService;
	@Autowired
	private LayoutOrgRelationMapper layoutOrgRelationMapper;
	
	@Override
	public LayoutVO queryLayoutById(Long layoutId) {
		LayoutEntity entity = baseMapper.selectById(layoutId);
		if(null != entity) {
			return BeanMapper.map(entity, LayoutVO.class);
		}
		return null;
	}

	@Override
	public LayoutEntity getById(Long id) {
		return baseMapper.selectById(id);
	}

	@Override
	public void saveLayoutDesign(Long layoutId, String setting) {
		LayoutEntity entity = baseMapper.selectById(layoutId);
		if(null == entity) {
			throw new BusinessException("保存布局设计失败，布局信息不存在！");
		}
		entity.setSetting(setting);
		super.saveOrUpdate(entity);
	}

	@Override
	public List<LayoutVO> queryLayoutByCurrentUser(String type, String systemId) {
		Long userId = InvocationInfoProxy.getUserid();
		Long tenantId = InvocationInfoProxy.getTenantid();
		
		//查询当前用户的所有角色的布局
		List<Long> roleIdList = permissionCacheManage.getUserRoleCache(userId, tenantId);
		List<LayoutEntity> roleLayouts = null;
		if(roleIdList != null && roleIdList.size() > 0) {
			String roleIds = "";
			for(Long roleId:roleIdList) {
				roleIds += roleId + ",";
			}
			if(StringUtils.isNotBlank(roleIds)) {
				roleIds = roleIds.substring(0, roleIds.length()-1);
				roleLayouts = layoutMapper.queryLayoutByRoleIds(roleIds, type, systemId);
			}
		}
		
		Map<Long, Long> roleLayoutMap = new HashMap<>();
		if(roleLayouts != null) {
			for(LayoutEntity layoutEntity:roleLayouts) {
				roleLayoutMap.put(layoutEntity.getId(), layoutEntity.getId());
			}
		}
		//查询当前用户的组织级门户
		//查询当前登录人的所有任职组织
		List<OrgVO> orgVos = orgService.queryJobOrgs(userId);
		Map<Long, OrgVO> orgVoMap = new HashMap<>();
		if(orgVos != null && orgVos.size() > 0) {
			for(OrgVO orgVo:orgVos) {
				orgVoMap.put(orgVo.getId(), orgVo);
			}
		}
		
		//查询当前租户下的所有组织级门户
		List<Long> layoutIds = new ArrayList<Long>();
		List<LayoutOrgVO> layoutOrgVos = layoutOrgRelationMapper.queryListByTenantId(tenantId);
		if(layoutOrgVos != null && layoutOrgVos.size() > 0) {
			for(LayoutOrgVO layoutOrgVo:layoutOrgVos) {
				if(1 == layoutOrgVo.getLimitFlag()) {
					if(orgVoMap.containsKey(layoutOrgVo.getOrgId())) {
						layoutIds.add(layoutOrgVo.getLayoutId());
					}
				}else if(2 == layoutOrgVo.getLimitFlag()) {
					OrgVO currentOrg = orgService.queryDetail(layoutOrgVo.getOrgId());
					if(currentOrg != null && orgVos != null && orgVos.size() > 0) {
						for(OrgVO orgVo:orgVos) {
							if(orgVo.getInnerCode().startsWith(currentOrg.getInnerCode())) {
								layoutIds.add(layoutOrgVo.getLayoutId());
								break;
							}
						}
					}
				}
			}
		}
		
		if(layoutIds != null && layoutIds.size() > 0) {
			if(roleLayouts == null) {
				roleLayouts = new ArrayList<>();
			}
			for(Long layoutId:layoutIds) {
				if(!roleLayoutMap.containsKey(layoutId)) {
					roleLayoutMap.put(layoutId, layoutId);
					LayoutEntity layoutEntity = layoutMapper.queryUniqueLayout(layoutId, systemId);
					if(layoutEntity == null) {
						continue;
					}
					if(layoutEntity.getEnabled()!=null&&layoutEntity.getEnabled().equals(1) && (StringUtils.isBlank(type) || StringUtils.equals(layoutEntity.getType(), type))){
						//只返回启用的门户信息
						roleLayouts.add(layoutEntity);
					}
				}
			}
		}
		
		if(roleLayouts != null) {
			LayoutEntity[] entities = new LayoutEntity[roleLayouts.size()];
			entities = sortlayouts(roleLayouts.toArray(entities));
			List<LayoutEntity> layoutList = new ArrayList<>(Arrays.asList(entities));
			return BeanMapper.mapList(layoutList, LayoutVO.class);
		}
		return  null;
	}

	private LayoutEntity[] sortlayouts(LayoutEntity[] layouts) {
		if(layouts != null && layouts.length > 0) {
			for(int i=0;i<layouts.length;i++) {
				for(int j=0;j<layouts.length-i-1;j++) {
					if(layouts[j+1].getSequence() < layouts[j].getSequence()) {
						LayoutEntity temp = layouts[j+1];
						layouts[j+1] = layouts[j];
						layouts[j] = temp;
					}
				}
			}
		}
		return layouts;
	}

	@Override
	public void deleteCustomLayout(String layoutId, Long userId) {
		layoutMapper.deleteCustomLayout(layoutId, userId);
	}

	@Override
	public void deleteAllCustomLayout(Long layoutId) {
		layoutMapper.deleteAllCustomLayout(layoutId);
	}
}
