/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.permission.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.cache.PermissionCacheManage;
import com.ejianc.foundation.permission.bean.RolePostRelationEntity;
import com.ejianc.foundation.permission.mapper.RolePostRelationMapper;
import com.ejianc.foundation.permission.service.IRolePostRelationService;
import com.ejianc.foundation.permission.vo.RolePostRelationVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RolePostRelationServiceImpl
extends BaseServiceImpl<RolePostRelationMapper, RolePostRelationEntity>
implements IRolePostRelationService {
    @Autowired
    private RolePostRelationMapper rolePostRelationMapper;
    @Autowired
    private PermissionCacheManage permissionCacheManage;

    @Override
    public CommonResponse<String> delete(List<Long> ids) {
        for (Long id : ids) {
            RolePostRelationEntity entity = (RolePostRelationEntity)((Object)this.rolePostRelationMapper.selectById(id));
            this.permissionCacheManage.removeRolePostsCache(entity.getRoleId(), entity.getPostId());
        }
        this.rolePostRelationMapper.deleteRolePostRelation(null, ids);
        return CommonResponse.success((String)"\u5220\u9664\u89d2\u8272\u5c97\u4f4d\u5b57\u5178\u6210\u529f");
    }

    @Override
    public CommonResponse<String> saveRolePost(List<RolePostRelationVO> data) {
        List entityList = BeanMapper.mapList(data, RolePostRelationEntity.class);
        if (entityList != null && entityList.size() > 0) {
            this.saveOrUpdateBatch(entityList, entityList.size(), false);
            this.permissionCacheManage.putRolePostsCache(data.get(0).getRoleId(), data);
            return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
        return CommonResponse.error((String)"\u672a\u9009\u62e9\u5c97\u4f4d\u5b57\u5178");
    }

    @Override
    public void deleteByRoleIds(List<Long> roleIds) {
        this.rolePostRelationMapper.deleteRolePostRelation(roleIds, null);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"role_id", roleIds);
        List list = this.list((Wrapper)wrapper);
        if (list != null && list.size() > 0) {
            for (RolePostRelationEntity entity : list) {
                this.permissionCacheManage.removeRolePostsCache(entity.getRoleId(), entity.getPostId());
            }
        }
    }
}

