/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.resource.service.impl;

import com.ejianc.foundation.resource.bean.ResourceLogEntity;
import com.ejianc.foundation.resource.bean.ResourceTenantEntity;
import com.ejianc.foundation.resource.bean.ResourceTypeEntity;
import com.ejianc.foundation.resource.mapper.ResourceTenantMapper;
import com.ejianc.foundation.resource.service.IResourceLogService;
import com.ejianc.foundation.resource.service.IResourceTenantService;
import com.ejianc.foundation.resource.service.IResourceTypeService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="resourceTenantService")
public class ResourceTenantServiceImpl
extends BaseServiceImpl<ResourceTenantMapper, ResourceTenantEntity>
implements IResourceTenantService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IResourceLogService logService;
    @Autowired
    private IResourceTypeService typeService;
    @Autowired
    private ResourceTenantMapper tenantMapper;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<Boolean> checkAndUseResource(String resourceCode, Long tenantId, BigDecimal useNum, String opType, String describe) {
        ResourceTypeEntity typeEntity = this.typeService.queryByCode(resourceCode);
        if (typeEntity == null) {
            this.logger.info("checkAndUseResource \u6ca1\u627e\u5230\u8be5\u8d44\u6e90\uff0c\u8ba4\u4e3a\u53ef\u4ee5\u901a\u8fc7,resourceCode={}, tenantId={}, useNum={}, opType={},describe={}", new Object[]{resourceCode, tenantId, useNum, opType, describe});
            return CommonResponse.error((String)("\u8d44\u6e90\u7f16\u7801\u4e3a\u3010" + resourceCode + "\u3011\u7684\u8d44\u6e90\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u7f16\u7801\u662f\u5426\u6b63\u786e\uff01\uff01"));
        }
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)tenantId));
        param.getParams().put("code", new Parameter("eq", (Object)resourceCode));
        param.getParams().put("state", new Parameter("eq", (Object)"open"));
        List tenantEntities = this.queryList(param, false);
        if (!ListUtil.isNotEmpty((List)tenantEntities)) return CommonResponse.error((String)("\u8d35\u516c\u53f8\u5c1a\u672a\u8d2d\u4e70\u3010" + typeEntity.getName() + "\u3011\u589e\u503c\u670d\u52a1\uff0c\u8be5\u529f\u80fd\u4e0d\u53ef\u7528\uff01\u5982\u6709\u9700\u6c42\u8bf7\u8054\u7cfb\u5b9e\u65bd\u4eba\u5458\uff01"));
        ResourceLogEntity logEntity = new ResourceLogEntity();
        logEntity.setOpValue(useNum.toPlainString());
        ResourceTenantEntity entity = (ResourceTenantEntity)((Object)tenantEntities.get(0));
        logEntity.setTenantId(tenantId);
        logEntity.setBeforeValue(entity.getNum());
        logEntity.setCode(resourceCode);
        logEntity.setName(typeEntity.getName());
        logEntity.setOpType(describe);
        if ("add".equals(opType)) {
            try {
                BigDecimal before = new BigDecimal(entity.getNum());
                BigDecimal after = before.add(useNum);
                entity.setNum(after.toPlainString());
                logEntity.setAfterValue(entity.getNum());
            }
            catch (NumberFormatException e) {
                return CommonResponse.error((String)"\u8d44\u6e90\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e\uff01\u53ea\u80fd\u586b\u5199\u6574\u6570\u3001\u5c0f\u6570\u7b49\uff01");
            }
            this.saveOrUpdate((Object)entity, false);
        } else {
            try {
                BigDecimal before = new BigDecimal(entity.getNum());
                BigDecimal after = before.subtract(useNum);
                if (after.compareTo(new BigDecimal("0")) < 0) {
                    return CommonResponse.error((String)(typeEntity.getName() + "\u5269\u4f59\u6570\u91cf\u4e0d\u8db3\u4ee5\u8fdb\u884c\u6b64\u6b21\u6263\u51cf\u64cd\u4f5c\uff01"));
                }
                int res = this.tenantMapper.updateTenantResourceNum(useNum.toPlainString(), tenantId, InvocationInfoProxy.getUsercode(), resourceCode);
                if (res == 0) {
                    return CommonResponse.error((String)(typeEntity.getName() + "\u5269\u4f59\u6570\u91cf\u4e0d\u8db3\u4ee5\u8fdb\u884c\u6b64\u6b21\u6263\u51cf\u64cd\u4f5c\uff01"));
                }
                entity = (ResourceTenantEntity)((Object)this.selectById(entity.getId()));
                logEntity.setAfterValue(entity.getNum());
                logEntity.setBeforeValue(new BigDecimal(entity.getNum()).add(useNum).toPlainString());
            }
            catch (NumberFormatException e) {
                return CommonResponse.error((String)"\u8d44\u6e90\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e\uff01\u53ea\u80fd\u662f\u6574\u6570\u6216\u8005\u5c0f\u6570\uff01");
            }
        }
        this.logService.saveOrUpdate((Object)logEntity, false);
        return CommonResponse.success((Object)true);
    }

    @Override
    public CommonResponse<Boolean> checkResource(String resourceCode, Long tenantId) {
        ResourceTypeEntity typeEntity = this.typeService.queryByCode(resourceCode);
        if (typeEntity == null) {
            this.logger.info("checkResource \u6ca1\u627e\u5230\u8be5\u8d44\u6e90\uff0c\u8ba4\u4e3a\u53ef\u4ee5\u901a\u8fc7,resourceCode={}, tenantId={} ", (Object)resourceCode, (Object)tenantId);
            return CommonResponse.error((String)("\u8d44\u6e90\u7f16\u7801\u4e3a\u3010" + resourceCode + "\u3011\u7684\u8d44\u6e90\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u7f16\u7801\u662f\u5426\u6b63\u786e\uff01\uff01"));
        }
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)tenantId));
        param.getParams().put("code", new Parameter("eq", (Object)resourceCode));
        param.getParams().put("state", new Parameter("eq", (Object)"open"));
        List tenantEntities = this.queryList(param, false);
        if (ListUtil.isEmpty((List)tenantEntities)) {
            return CommonResponse.error((String)("\u8d35\u516c\u53f8\u5c1a\u672a\u8d2d\u4e70\u3010" + typeEntity.getName() + "\u3011\u589e\u503c\u670d\u52a1\uff0c\u8be5\u529f\u80fd\u4e0d\u53ef\u7528\uff01\u5982\u6709\u9700\u6c42\u8bf7\u8054\u7cfb\u5b9e\u65bd\u4eba\u5458\uff01"));
        }
        return CommonResponse.success((Object)true);
    }

    @Override
    public CommonResponse<String> getResourceNum(String resourceCode, Long tenantId) {
        ResourceTypeEntity typeEntity = this.typeService.queryByCode(resourceCode);
        if (typeEntity == null) {
            this.logger.info("checkResource \u6ca1\u627e\u5230\u8be5\u8d44\u6e90\uff0c\u8ba4\u4e3a\u53ef\u4ee5\u901a\u8fc7,resourceCode={}, tenantId={} ", (Object)resourceCode, (Object)tenantId);
            return CommonResponse.error((String)("\u8d44\u6e90\u7f16\u7801\u4e3a\u3010" + resourceCode + "\u3011\u7684\u8d44\u6e90\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u7f16\u7801\u662f\u5426\u6b63\u786e\uff01\uff01"));
        }
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)tenantId));
        param.getParams().put("code", new Parameter("eq", (Object)resourceCode));
        param.getParams().put("state", new Parameter("eq", (Object)"open"));
        List tenantEntities = this.queryList(param, false);
        if (ListUtil.isEmpty((List)tenantEntities)) {
            return CommonResponse.error((String)("\u8d35\u516c\u53f8\u5c1a\u672a\u8d2d\u4e70\u3010" + typeEntity.getName() + "\u3011\u589e\u503c\u670d\u52a1\uff0c\u8be5\u529f\u80fd\u4e0d\u53ef\u7528\uff01\u5982\u6709\u9700\u6c42\u8bf7\u8054\u7cfb\u5b9e\u65bd\u4eba\u5458\uff01"));
        }
        return CommonResponse.success((String)"\u83b7\u53d6\u6210\u529f\uff01", (Object)((ResourceTenantEntity)((Object)tenantEntities.get(0))).getNum());
    }
}

