/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.wzxtUserProject.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.usercenter.service.IUserService;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.foundation.wzxtUserProject.bean.WzxtUserProjectRelationEntity;
import com.ejianc.foundation.wzxtUserProject.mapper.WzxtUserProjectRelationMapper;
import com.ejianc.foundation.wzxtUserProject.service.IWzxtUserProjectRelationService;
import com.ejianc.foundation.wzxtUserProject.vo.WzxtUserProjectRelationVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WzxtUserProjectRelationServiceImpl
extends BaseServiceImpl<WzxtUserProjectRelationMapper, WzxtUserProjectRelationEntity>
implements IWzxtUserProjectRelationService {
    @Autowired
    private WzxtUserProjectRelationMapper wzxtUserProjectRelationMapper;
    @Autowired
    private IUserService userService;

    @Override
    @Transactional
    public CommonResponse<String> save(List<WzxtUserProjectRelationVO> relationVO) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("userId", new Parameter("eq", (Object)relationVO.get(0).getUserId()));
        List projectList = this.queryList(queryParam, false);
        String message = "";
        List<Object> entitys = new ArrayList();
        if (projectList != null && projectList.size() > 0) {
            HashMap map = new HashMap();
            projectList.forEach(e -> map.put(e.getProjectId(), e.getProjectId()));
            for (WzxtUserProjectRelationVO vo : relationVO) {
                if (map.get(vo.getProjectId()) != null) {
                    if (message.length() > 0) {
                        message = message + "\u3001" + vo.getProjectName();
                        continue;
                    }
                    message = message + vo.getProjectName();
                    continue;
                }
                entitys.add(BeanMapper.map((Object)vo, WzxtUserProjectRelationEntity.class));
            }
            if (entitys != null && entitys.size() > 0) {
                this.saveOrUpdateBatch(entitys, entitys.size(), false);
            }
        } else {
            entitys = BeanMapper.mapList(relationVO, WzxtUserProjectRelationEntity.class);
            this.saveOrUpdateBatch(entitys, entitys.size(), false);
        }
        if (message.length() > 0) {
            if (projectList.size() != entitys.size()) {
                return CommonResponse.success((String)("\u5173\u8054\u9879\u76ee\u6210\u529f\uff0c\u5176\u4e2d" + message + "\u5df2\u5b58\u5728"));
            }
            return CommonResponse.success((String)"\u5173\u8054\u7684\u9879\u76ee\u5168\u90e8\u5df2\u5b58\u5728");
        }
        return CommonResponse.success((String)"\u5173\u8054\u9879\u76ee\u6210\u529f");
    }

    @Override
    @Transactional
    public CommonResponse<String> delete(List<WzxtUserProjectRelationVO> relationVO) {
        ArrayList projectIds = new ArrayList();
        relationVO.forEach(e -> projectIds.add(e.getProjectId()));
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"user_id", (Object)relationVO.get(0).getUserId());
        wrapper.in((Object)"project_id", projectIds);
        this.wzxtUserProjectRelationMapper.delete((Wrapper)wrapper);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @Override
    public CommonResponse<List<WzxtUserProjectRelationVO>> queryProjectByUserId(Long userId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"user_id", (Object)userId);
        queryWrapper.eq((Object)"dr", (Object)0);
        List listEntity = this.list((Wrapper)queryWrapper);
        if (listEntity != null && listEntity.size() > 0) {
            return CommonResponse.success((Object)BeanMapper.mapList((Iterable)listEntity, WzxtUserProjectRelationVO.class));
        }
        return CommonResponse.success();
    }

    @Override
    public CommonResponse<List<UserVO>> queryUserByProjectAndTenant(Long projectId, Long tenantId) {
        List<UserVO> list;
        ArrayList<UserVO> backData = new ArrayList<UserVO>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"project_id", (Object)projectId);
        queryWrapper.eq((Object)"tenant_id", (Object)tenantId);
        queryWrapper.eq((Object)"dr", (Object)0);
        List listEntity = this.list((Wrapper)queryWrapper);
        if (listEntity != null && listEntity.size() > 0) {
            ArrayList userIds = new ArrayList();
            listEntity.forEach(e -> userIds.add(e.getUserId()));
            List entitys = (List)this.userService.listByIds(userIds);
            if (entitys != null && entitys.size() > 0) {
                backData.addAll(BeanMapper.mapList((Iterable)entitys, UserVO.class));
            }
        }
        if ((list = this.wzxtUserProjectRelationMapper.queryUserByProjectAndTenant(tenantId)) != null && list.size() > 0) {
            backData.addAll(list);
        }
        return CommonResponse.success(backData);
    }
}

