/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.dataCompare.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.dataCompare.entity.DataCompareDetailEntity;
import com.ejianc.foundation.dataCompare.mapper.DataCompareDetailMapper;
import com.ejianc.foundation.dataCompare.service.IDataCompareDetailService;
import com.ejianc.foundation.dataCompare.vo.DataCompareDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service
public class DataCompareDetailServiceImpl
extends BaseServiceImpl<DataCompareDetailMapper, DataCompareDetailEntity>
implements IDataCompareDetailService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private DataCompareDetailMapper mapper;

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        String appId = request.getParameter("appId");
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList dataList = new ArrayList();
        ArrayList<DataCompareDetailVO> successList = new ArrayList<DataCompareDetailVO>();
        ArrayList<DataCompareDetailVO> errorList = new ArrayList<DataCompareDetailVO>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        HashMap map = new HashMap();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        ArrayList<String> selfDataIdList = new ArrayList<String>();
        ArrayList exitList = new ArrayList();
        if (result != null && result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                DataCompareDetailVO vo = new DataCompareDetailVO();
                vo.setSelfDataId((String)datas.get(0));
                vo.setSelfDataCode((String)datas.get(1));
                vo.setSelfDataName((String)datas.get(2));
                vo.setAbutmentDataId((String)datas.get(3));
                vo.setAbutmentDataCode((String)datas.get(4));
                vo.setAbutmentDataName((String)datas.get(5));
                vo.setNotes((String)datas.get(6));
                vo.setAppId(Long.valueOf(Long.parseLong(appId)));
                if (StringUtils.isBlank((CharSequence)vo.getSelfDataCode())) {
                    vo.setId(Long.valueOf(IdWorker.getId()));
                    vo.setErrorMsg("\u672c\u7cfb\u7edf\u6570\u636e\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(vo);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)vo.getAbutmentDataCode())) {
                    vo.setId(Long.valueOf(IdWorker.getId()));
                    vo.setErrorMsg("\u5bf9\u63a5\u7cfb\u7edf\u6570\u636e\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(vo);
                    continue;
                }
                selfDataIdList.add(vo.getSelfDataId());
                successList.add(vo);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }
}

