/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.usercenter.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.dingtalkoauth2_1_0.Client;
import com.aliyun.dingtalkoauth2_1_0.models.GetCorpAccessTokenRequest;
import com.aliyun.dingtalkoauth2_1_0.models.GetCorpAccessTokenResponse;
import com.aliyun.dingtalkoauth2_1_0.models.GetUserTokenRequest;
import com.aliyun.dingtalkoauth2_1_0.models.GetUserTokenResponse;
import com.aliyun.dingtalkoauth2_1_0.models.GetUserTokenResponseBody;
import com.aliyun.tea.TeaException;
import com.aliyun.teaopenapi.models.Config;
import com.aliyun.teautil.Common;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.request.OapiGettokenRequest;
import com.dingtalk.api.request.OapiServiceGetAuthInfoRequest;
import com.dingtalk.api.request.OapiServiceGetSuiteTokenRequest;
import com.dingtalk.api.request.OapiV2UserGetuserinfoRequest;
import com.dingtalk.api.response.OapiGettokenResponse;
import com.dingtalk.api.response.OapiServiceGetAuthInfoResponse;
import com.dingtalk.api.response.OapiServiceGetSuiteTokenResponse;
import com.dingtalk.api.response.OapiV2UserGetuserinfoResponse;
import com.ejianc.foundation.tenant.bean.TenantEntity;
import com.ejianc.foundation.tenant.service.ITenantService;
import com.ejianc.foundation.usercenter.bean.SuiteTicketEntity;
import com.ejianc.foundation.usercenter.bean.ThirdSystemEntity;
import com.ejianc.foundation.usercenter.bean.UserEntity;
import com.ejianc.foundation.usercenter.mapper.ThirdSystemMapper;
import com.ejianc.foundation.usercenter.service.IThirdSystemService;
import com.ejianc.foundation.usercenter.service.IUserService;
import com.ejianc.foundation.usercenter.service.SuitTicketService;
import com.ejianc.foundation.usercenter.util.YonYouCloudSignHelper;
import com.ejianc.foundation.usercenter.vo.ThirdSystemVO;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.foundation.utils.WeixinRestUtil;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.taobao.api.ApiException;
import com.taobao.api.TaobaoRequest;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class ThirdSystemServiceImpl
extends BaseServiceImpl<ThirdSystemMapper, ThirdSystemEntity>
implements IThirdSystemService {
    private static Logger logger = LoggerFactory.getLogger(ThirdSystemServiceImpl.class);
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Value(value="${ejc.wechat.soterVrifyUrl}")
    private String soterVrifyUrl;
    @Autowired
    private IUserService userService;
    @Autowired
    private SuitTicketService suitTicketService;
    @Value(value="${ejc.yonYouCloud.accessTokenUrl:#{null}}")
    private String yonYouCloutAccessTokeUrl;
    @Value(value="${ejc.yonYouCloud.appKey:#{null}}")
    private String yonYouAppKey;
    @Value(value="${ejc.yonYouCloud.appSecret:#{null}}")
    private String yonYouAppSecret;
    @Value(value="${ejc.yonYouCloud.getBaseInfoByCodeUrl:#{null}}")
    private String yonYouCloudGetBaseInfoByCodeUrl;
    @Value(value="${ejc.yonYouCloud.getEmpInfoByUserIdUrl:#{null}}")
    private String yonYouCloudGetEmpInfoByUserIdUrl;
    @Value(value="${ejc.yonYouCloud.getTicketUrl:#{null}}")
    private String yonYouGetTicketUrl;
    @Value(value="${ejc.qunjeCloud.tokenUrl:#{null}}")
    private String tokenUrl;
    @Autowired
    private ITenantService iTenantService;
    private static final String YONYOUCLOUD_ACCESSTOEKN_KEY = "yonyoucloud::accessToken";
    private static final String YONYOUCLOUD_TICKET_KEY = "yonyoucloud::ticket";

    @Override
    public ThirdSystemEntity queryThirdSystemByCode(String systemCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"code", (Object)systemCode);
        ThirdSystemEntity entity = (ThirdSystemEntity)((Object)super.getOne((Wrapper)queryWrapper));
        return entity;
    }

    @Override
    public ThirdSystemVO findSysByCode(String sysCode, Long tenantId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"code", (Object)sysCode);
        queryWrapper.eq((Object)"tenant_id", (Object)tenantId);
        ThirdSystemEntity entity = (ThirdSystemEntity)((Object)super.getOne((Wrapper)queryWrapper));
        if (entity != null) {
            return (ThirdSystemVO)BeanMapper.map((Object)((Object)entity), ThirdSystemVO.class);
        }
        return null;
    }

    @Override
    public UserVO bindUserWithSoterSignature(String soterJsonStr, String appId, String secret) {
        UserVO resp = null;
        String msg = this.virifySoterSignature(soterJsonStr, appId, secret);
        JSONObject soterJson = JSONObject.parseObject((String)soterJsonStr);
        String openId = soterJson.getString("openId");
        Long userId = soterJson.getLong("userId");
        String type = soterJson.getString("loginType");
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            throw new BusinessException("\u8eab\u4efd\u6821\u9a8c\u672a\u901a\u8fc7\uff01");
        }
        QueryWrapper query = new QueryWrapper();
        query.or(r -> (QueryWrapper)r.eq((Object)"face_signature", (Object)openId));
        query.or(r -> (QueryWrapper)r.eq((Object)"finger_signature", (Object)openId));
        query.or(r -> (QueryWrapper)r.eq((Object)"weixin_minprogram_id", (Object)openId));
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        if (null != userId) {
            List userList = this.userService.list((Wrapper)query);
            if (CollectionUtils.isNotEmpty((Collection)userList)) {
                for (UserEntity u : userList) {
                    if (!u.getId().equals(userId)) {
                        u.setFingerSignature(null);
                        u.setWeixinMinprogramId(null);
                        u.setFaceSignature(null);
                        continue;
                    }
                    if (!openId.equals(u.getWeixinMinprogramId())) {
                        u.setWeixinMinprogramId(openId);
                    }
                    if (StringUtils.isBlank((CharSequence)u.getFingerSignature())) {
                        if ("finger".equals(type)) {
                            u.setFingerSignature(openId);
                        } else if (!openId.equals(u.getFingerSignature())) {
                            u.setFingerSignature(null);
                        }
                    }
                    if (StringUtils.isBlank((CharSequence)u.getFaceSignature())) {
                        if ("facial".equals(type)) {
                            u.setFaceSignature(openId);
                        } else if (!openId.equals(u.getFaceSignature())) {
                            u.setFaceSignature(null);
                        }
                    }
                    resp = (UserVO)BeanMapper.map((Object)((Object)u), UserVO.class);
                }
            }
            if (null == resp) {
                UserEntity ue = (UserEntity)((Object)this.userService.getById(userId));
                ue.setWeixinMinprogramId(openId);
                if ("finger".equals(type)) {
                    ue.setFingerSignature(openId);
                    if (!openId.equals(ue.getFaceSignature())) {
                        ue.setFaceSignature(null);
                    }
                } else {
                    ue.setFaceSignature(openId);
                    if (!openId.equals(ue.getFingerSignature())) {
                        ue.setFingerSignature(null);
                    }
                }
                userList.add(ue);
                resp = (UserVO)BeanMapper.map((Object)((Object)ue), UserVO.class);
            }
            this.userService.saveOrUpdateBatch(userList);
        } else {
            UserEntity user = (UserEntity)((Object)this.userService.getOne((Wrapper)query));
            if (StringUtils.isBlank((CharSequence)user.getWeixinMinprogramId()) || !openId.equals(user.getWeixinMinprogramId())) {
                user.setWeixinMinprogramId(openId);
                this.userService.saveOrUpdate((Object)user, false);
            }
            if (null != user) {
                resp = (UserVO)BeanMapper.map((Object)((Object)user), UserVO.class);
            }
        }
        return resp;
    }

    @Override
    public String getYonYouCloudAccessToken(boolean reload) throws Exception {
        String accessToken = (String)this.redisTemplate.opsForValue().get((Object)YONYOUCLOUD_ACCESSTOEKN_KEY);
        logger.info("redis--yonyoucloud--accessToken=" + accessToken);
        if (StringUtils.isBlank((CharSequence)accessToken) || reload) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("appKey", this.yonYouAppKey);
            params.put("timestamp", String.valueOf(System.currentTimeMillis()));
            params.put("signature", YonYouCloudSignHelper.sign(params, this.yonYouAppSecret));
            logger.info("\u8bf7\u6c42\u53cb\u7a7a\u95f4\u83b7\u53d6\u63a5\u53e3\u4ee4\u724c\uff0curl-{}, \u53c2\u6570\uff1a{}", (Object)this.yonYouCloutAccessTokeUrl, params);
            String httpResultJsonStr = HttpTookit.get((String)this.yonYouCloutAccessTokeUrl, params, new HashMap());
            logger.info("\u8bf7\u6c42\u53cb\u7a7a\u95f4\u83b7\u53d6\u63a5\u53e3\u4ee4\u724c\u7ed3\u679c\uff1a{}", (Object)httpResultJsonStr);
            JSONObject httpResultJson = JSONObject.parseObject((String)httpResultJsonStr);
            if ("00000".equals(httpResultJson.getString("code"))) {
                JSONObject data = httpResultJson.getJSONObject("data");
                accessToken = data.getString("access_token");
                Long expire = data.getLong("expire");
                this.redisTemplate.opsForValue().set((Object)YONYOUCLOUD_ACCESSTOEKN_KEY, (Object)accessToken, expire - 3L, TimeUnit.SECONDS);
            } else {
                throw new BusinessException("\u8bf7\u6c42\u53cb\u7a7a\u95f4\u83b7\u53d6\u63a5\u53e3\u4ee4\u724c\u5931\u8d25: " + httpResultJson.getString("message"));
            }
        }
        return accessToken;
    }

    @Override
    public JSONObject getYhtBaseInfoByCode(String tmpCode) throws Exception {
        String accessToken = this.getYonYouCloudAccessToken(false);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("access_token", accessToken);
        params.put("code", tmpCode);
        logger.info("\u8bf7\u6c42\u53cb\u7a7a\u95f4\u6839\u636ecode\u83b7\u53d6\u514d\u767b\u4fe1\u606f\uff0curl-{}, \u53c2\u6570\uff1a{}", (Object)this.yonYouCloudGetBaseInfoByCodeUrl, params);
        String httpResultJsonStr = HttpTookit.get((String)this.yonYouCloudGetBaseInfoByCodeUrl, params, new HashMap());
        logger.info("\u8bf7\u6c42\u53cb\u7a7a\u95f4\u6839\u636ecode\u83b7\u53d6\u514d\u767b\u4fe1\u606f\uff1a{}", (Object)httpResultJsonStr);
        JSONObject httpResultJson = JSONObject.parseObject((String)httpResultJsonStr);
        if (httpResultJson.getInteger("code") != 0) {
            throw new BusinessException("\u8bf7\u6c42\u53cb\u7a7a\u95f4\u6839\u636ecode\u83b7\u53d6\u514d\u767b\u4fe1\u606f\u5931\u8d25\uff0c" + httpResultJson.getString("msg"));
        }
        return httpResultJson.getJSONObject("data");
    }

    @Override
    public JSONObject getYhtEmployeeInfoByYhtUserId(String yhtUserId) throws Exception {
        String accessToken = this.getYonYouCloudAccessToken(false);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("access_token", accessToken);
        params.put("yhtUserId", yhtUserId);
        logger.info("\u6839\u636e\u53cb\u4e92\u901auserId\u4fe1\u606f\u67e5\u8be2\u53cb\u4e92\u901a\u4eba\u5458\u4fe1\u606f\uff0curl-{}, \u53c2\u6570\uff1a{}", (Object)this.yonYouCloudGetEmpInfoByUserIdUrl, params);
        String httpResultJsonStr = HttpTookit.get((String)this.yonYouCloudGetEmpInfoByUserIdUrl, params, new HashMap());
        logger.info("\u6839\u636e\u53cb\u4e92\u901auserId\u4fe1\u606f\u67e5\u8be2\u53cb\u4e92\u901a\u4eba\u5458\u4fe1\u606f\uff1a{}", (Object)httpResultJsonStr);
        JSONObject httpResultJson = JSONObject.parseObject((String)httpResultJsonStr);
        if (httpResultJson.getInteger("code") != 0) {
            throw new BusinessException("\u6839\u636e\u53cb\u4e92\u901auserId\u4fe1\u606f\u67e5\u8be2\u53cb\u4e92\u901a\u4eba\u5458\u4fe1\u606f\u5931\u8d25\uff0c" + httpResultJson.getString("msg"));
        }
        return httpResultJson.getJSONArray("data").getJSONObject(0);
    }

    private String virifySoterSignature(String soterJsonStr, String appId, String secret) {
        JSONObject resultJson;
        String accessToke = this.getMiniProgramAccessToken(appId, secret);
        String url = this.soterVrifyUrl + "?access_token=" + accessToke;
        JSONObject soterJson = JSONObject.parseObject((String)soterJsonStr);
        JSONObject param = new JSONObject();
        param.put("openid", soterJson.get((Object)"openId"));
        param.put("json_string", (Object)soterJson.getString("json_string"));
        param.put("json_signature", soterJson.get((Object)"json_signature"));
        String result = WeixinRestUtil.doPostByURL(url, param.toJSONString());
        logger.info("verifySoterResult: {}", (Object)result);
        if (StringUtils.isNotBlank((CharSequence)result) && !"true".equals((resultJson = JSON.parseObject((String)result)).getString("is_ok"))) {
            return "\u8eab\u4efd\u6821\u9a8c\u672a\u901a\u8fc7\uff01";
        }
        return null;
    }

    @Override
    public String getWeixinAccessToken(String appid, String secret, Boolean refresh) {
        String key = appid + "_" + secret;
        String accessToken = null;
        if (!refresh.booleanValue()) {
            accessToken = (String)this.redisTemplate.opsForValue().get((Object)key);
            logger.info("redis----accessToken=" + accessToken);
            System.out.println("redis----accessToken=" + accessToken);
        }
        if (StringUtils.isBlank(accessToken)) {
            String accessResult = WeixinRestUtil.doGetByURL("https://api.weixin.qq.com/cgi-bin/token", "grant_type=client_credential&appid=" + appid + "&secret=" + secret);
            logger.info("accessResult=" + accessResult);
            System.out.println("accessResult=" + accessResult);
            if (StringUtils.isNotBlank((CharSequence)accessResult)) {
                JSONObject accessJson = JSON.parseObject((String)accessResult);
                accessToken = accessJson.getString("access_token");
                String errmsg = accessJson.getString("errmsg");
                if ("ok".equals(errmsg) && StringUtils.isNotBlank((CharSequence)accessToken)) {
                    this.redisTemplate.opsForValue().set((Object)key, (Object)accessToken, 7000L, TimeUnit.SECONDS);
                }
            }
        }
        return accessToken;
    }

    @Override
    public String getWeixineeAccessToken(String corpAppId, String corpSecret, Boolean refresh) {
        String key = corpAppId + "_" + corpSecret;
        String accessToken = null;
        if (!refresh.booleanValue()) {
            accessToken = (String)this.redisTemplate.opsForValue().get((Object)key);
            logger.info("redis----accessToken=" + accessToken);
            System.out.println("redis----accessToken=" + accessToken);
        }
        if (StringUtils.isBlank(accessToken)) {
            HashMap<String, String> param = new HashMap<String, String>();
            String accessResult = null;
            param.put("corpid", corpAppId);
            param.put("corpsecret", corpSecret);
            try {
                accessResult = ReferHttpClientUtils.get((String)"https://qyapi.weixin.qq.com/cgi-bin/gettoken", param, new HashMap());
            }
            catch (GeneralSecurityException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            logger.info("accessResult=" + accessResult);
            System.out.println("accessResult=" + accessResult);
            if (StringUtils.isNotBlank((CharSequence)accessResult)) {
                JSONObject accessJson = JSON.parseObject((String)accessResult);
                accessToken = accessJson.getString("access_token");
                String errmsg = accessJson.getString("errmsg");
                if ("ok".equals(errmsg) && StringUtils.isNotBlank((CharSequence)accessToken)) {
                    this.redisTemplate.opsForValue().set((Object)key, (Object)accessToken, 7000L, TimeUnit.SECONDS);
                }
            }
        }
        return accessToken;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getDdOpenAppAccessToken(String customKey, String customSecret, String corpId) {
        String accessToken = null;
        if (StringUtils.isBlank((CharSequence)customKey)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.like((Object)"code", (Object)"DingTalk");
            queryWrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
            List entitys = this.list((Wrapper)queryWrapper);
            if (entitys == null || entitys.size() <= 0) return accessToken;
            String configInfo = ((ThirdSystemEntity)((Object)entitys.get(0))).getConfigInfo();
            JSONObject json = JSONObject.parseObject((String)configInfo);
            customKey = json.getString("customKey");
            customSecret = json.getString("customSecret");
            corpId = json.getString("corpId");
            String key = customKey + "_" + customSecret;
            accessToken = (String)this.redisTemplate.opsForValue().get((Object)key);
            logger.info("redis----accessToken=" + accessToken);
            System.out.println("redis----accessToken=" + accessToken);
            if (!StringUtils.isBlank((CharSequence)accessToken)) return accessToken;
            try {
                Config config = new Config();
                config.protocol = "https";
                config.regionId = "central";
                Client client = new Client(config);
                GetCorpAccessTokenRequest getCorpAccessTokenRequest = new GetCorpAccessTokenRequest().setSuiteKey(customKey).setSuiteSecret(customSecret).setAuthCorpId(corpId).setSuiteTicket(corpId);
                GetCorpAccessTokenResponse res = client.getCorpAccessToken(getCorpAccessTokenRequest);
                logger.info("accessToken---------\u300b\u300b\u300b\u300b" + res.getBody().getAccessToken());
                accessToken = res.getBody().getAccessToken();
                this.redisTemplate.opsForValue().set((Object)key, (Object)accessToken, 7000L, TimeUnit.SECONDS);
                return accessToken;
            }
            catch (TeaException err) {
                if (!Common.empty((String)err.code) && Common.empty((String)err.message)) return accessToken;
            }
            catch (Exception _err) {
                TeaException err = new TeaException(_err.getMessage(), (Throwable)_err);
                if (!Common.empty((String)err.code) && Common.empty((String)err.message)) return accessToken;
            }
            return accessToken;
        }
        String key = customKey + "_" + customSecret;
        accessToken = (String)this.redisTemplate.opsForValue().get((Object)key);
        logger.info("redis----accessToken=" + accessToken);
        logger.info("customKey:{},customSecret:{},corpId:{}" + customKey, (Object)customSecret, (Object)corpId);
        System.out.println("redis----accessToken=" + accessToken);
        if (!StringUtils.isBlank((CharSequence)accessToken)) return accessToken;
        try {
            Config config = new Config();
            config.protocol = "https";
            config.regionId = "central";
            Client client = new Client(config);
            GetCorpAccessTokenRequest getCorpAccessTokenRequest = new GetCorpAccessTokenRequest().setSuiteKey(customKey).setSuiteSecret(customSecret).setAuthCorpId(corpId).setSuiteTicket("suiteTicket");
            GetCorpAccessTokenResponse res = client.getCorpAccessToken(getCorpAccessTokenRequest);
            logger.info("accessToken---------\u300b\u300b\u300b\u300b" + res.getBody().getAccessToken());
            accessToken = res.getBody().getAccessToken();
            this.redisTemplate.opsForValue().set((Object)key, (Object)accessToken, 7000L, TimeUnit.SECONDS);
            return accessToken;
        }
        catch (TeaException err) {
            if (!Common.empty((String)err.code) && Common.empty((String)err.message)) return accessToken;
        }
        catch (Exception _err) {
            TeaException err = new TeaException(_err.getMessage(), (Throwable)_err);
            if (!Common.empty((String)err.code) && Common.empty((String)err.message)) return accessToken;
        }
        return accessToken;
    }

    @Override
    public String getDingDingAccessToken(String corpAppId, String corpSecret, Boolean refresh) {
        String key = corpAppId + "_" + corpSecret;
        String accessToken = null;
        if (!refresh.booleanValue()) {
            accessToken = (String)this.redisTemplate.opsForValue().get((Object)key);
            logger.info("redis----accessToken=" + accessToken);
            System.out.println("redis----accessToken=" + accessToken);
        }
        if (StringUtils.isBlank(accessToken)) {
            DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/gettoken");
            OapiGettokenRequest request = new OapiGettokenRequest();
            request.setAppkey(corpAppId);
            request.setAppsecret(corpSecret);
            request.setHttpMethod("GET");
            OapiGettokenResponse response = null;
            try {
                response = (OapiGettokenResponse)client.execute((TaobaoRequest)request);
            }
            catch (ApiException e) {
                e.printStackTrace();
                throw new BusinessException("\u83b7\u53d6\u9489\u9489\u6743\u9650\u4fe1\u606f\u5931\u8d25");
            }
            JSONObject body = JSONObject.parseObject((String)response.getBody());
            logger.info("accessToken---------\u300b\u300b\u300b\u300b" + response.getBody());
            if ("0".equals(body.getString("errcode"))) {
                accessToken = body.getString("access_token");
                this.redisTemplate.opsForValue().set((Object)key, (Object)accessToken, 7000L, TimeUnit.SECONDS);
            }
        }
        return accessToken;
    }

    @Override
    public String getDingDingUserInfo(String code, String token) {
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/v2/user/getuserinfo");
        OapiV2UserGetuserinfoRequest req = new OapiV2UserGetuserinfoRequest();
        req.setCode(code);
        OapiV2UserGetuserinfoResponse rsp = null;
        try {
            rsp = (OapiV2UserGetuserinfoResponse)client.execute((TaobaoRequest)req, token);
        }
        catch (ApiException e) {
            e.printStackTrace();
            throw new BusinessException("\u83b7\u53d6\u9489\u9489\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        logger.info("\u83b7\u53d6\u5230\u7684\u7528\u6237\u4fe1\u606f--------------" + rsp.getBody());
        JSONObject body = JSONObject.parseObject((String)rsp.getBody());
        if ("0".equals(body.getString("errcode"))) {
            return body.getString("result");
        }
        throw new BusinessException("\u83b7\u53d6\u9489\u9489\u7528\u6237\u4fe1\u606f\u5931\u8d25");
    }

    @Override
    public String getMiniProgramAccessToken(String appId, String appSecret) {
        String key = appId + "_" + appSecret;
        String accessToken = (String)this.redisTemplate.opsForValue().get((Object)key);
        logger.info("redis----MiniProgramaccessToken=" + accessToken);
        System.out.println("redis----MiniProgramaccessToken=" + accessToken);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            HashMap<String, String> param = new HashMap<String, String>();
            String accessResult = null;
            param.put("grant_type", "client_credential");
            param.put("appid", appId);
            param.put("secret", appSecret);
            try {
                accessResult = ReferHttpClientUtils.get((String)"https://api.weixin.qq.com/cgi-bin/token", param, new HashMap());
            }
            catch (GeneralSecurityException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            logger.info("MiniProgramaccessTokenaccessResult=" + accessResult);
            System.out.println("MiniProgramaccessTokenaccessResult=" + accessResult);
            if (StringUtils.isNotBlank((CharSequence)accessResult)) {
                JSONObject accessJson = JSON.parseObject((String)accessResult);
                accessToken = accessJson.getString("access_token");
                String errmsg = accessJson.getString("errcode");
                if ("0".equals(errmsg) && StringUtils.isNotBlank((CharSequence)accessToken)) {
                    this.redisTemplate.opsForValue().set((Object)key, (Object)accessToken, 7000L, TimeUnit.SECONDS);
                }
            }
        }
        return accessToken;
    }

    @Override
    public String getMiniProgramJsapiTicket(String corpAppId, String accessToken) {
        String key = corpAppId + "_jsapi_ticket";
        String jsapiTicket = (String)this.redisTemplate.opsForValue().get((Object)key);
        logger.info("redis----jsapiTicket=" + jsapiTicket);
        System.out.println("redis----jsapiTicket=" + jsapiTicket);
        if (StringUtils.isBlank((CharSequence)jsapiTicket)) {
            HashMap<String, String> param = new HashMap<String, String>();
            String accessResult = null;
            param.put("access_token", accessToken);
            param.put("type", "jsapi");
            try {
                accessResult = ReferHttpClientUtils.get((String)"https://api.weixin.qq.com/cgi-bin/ticket/getticket", param, new HashMap());
            }
            catch (GeneralSecurityException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            System.out.println("accessResult=" + accessResult);
            logger.info("accessResult=" + accessResult);
            if (StringUtils.isNotBlank((CharSequence)accessResult)) {
                JSONObject accessJson = JSON.parseObject((String)accessResult);
                jsapiTicket = accessJson.getString("ticket");
                String errmsg = accessJson.getString("errcode");
                if ("0".equals(errmsg) && StringUtils.isNotBlank((CharSequence)jsapiTicket)) {
                    this.redisTemplate.opsForValue().set((Object)key, (Object)jsapiTicket, 7000L, TimeUnit.SECONDS);
                }
            }
        }
        return jsapiTicket;
    }

    @Override
    public String getWeixineeJsapiTicket(String corpAppId, String accessToken) {
        String key = corpAppId + "_jsapi_ticket";
        String jsapiTicket = (String)this.redisTemplate.opsForValue().get((Object)key);
        logger.info("redis----jsapiTicket=" + jsapiTicket);
        System.out.println("redis----jsapiTicket=" + jsapiTicket);
        if (StringUtils.isBlank((CharSequence)jsapiTicket)) {
            HashMap<String, String> param = new HashMap<String, String>();
            String accessResult = null;
            param.put("access_token", accessToken);
            try {
                accessResult = ReferHttpClientUtils.get((String)"https://qyapi.weixin.qq.com/cgi-bin/get_jsapi_ticket", param, new HashMap());
            }
            catch (GeneralSecurityException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            System.out.println("accessResult=" + accessResult);
            logger.info("accessResult=" + accessResult);
            if (StringUtils.isNotBlank((CharSequence)accessResult)) {
                JSONObject accessJson = JSON.parseObject((String)accessResult);
                jsapiTicket = accessJson.getString("ticket");
                String errmsg = accessJson.getString("errmsg");
                if ("ok".equals(errmsg) && StringUtils.isNotBlank((CharSequence)jsapiTicket)) {
                    this.redisTemplate.opsForValue().set((Object)key, (Object)jsapiTicket, 7000L, TimeUnit.SECONDS);
                }
            }
        }
        return jsapiTicket;
    }

    @Override
    public String getWeixineeAppJsapiTicket(String corpAppId, String accessToken) {
        String key = corpAppId + "_app_jsapi_ticket";
        String jsapiTicket = (String)this.redisTemplate.opsForValue().get((Object)key);
        logger.info("redis----app--jsapiTicket=" + jsapiTicket);
        if (StringUtils.isBlank((CharSequence)jsapiTicket)) {
            HashMap<String, String> param = new HashMap<String, String>();
            String accessResult = null;
            param.put("access_token", accessToken);
            param.put("type", "agent_config");
            try {
                accessResult = ReferHttpClientUtils.get((String)"https://qyapi.weixin.qq.com/cgi-bin/ticket/get", param, new HashMap());
            }
            catch (IOException | GeneralSecurityException e) {
                e.printStackTrace();
            }
            logger.info("accessResult=" + accessResult);
            if (StringUtils.isNotBlank((CharSequence)accessResult)) {
                JSONObject accessJson = JSON.parseObject((String)accessResult);
                jsapiTicket = accessJson.getString("ticket");
                String errmsg = accessJson.getString("errmsg");
                if ("ok".equals(errmsg) && StringUtils.isNotBlank((CharSequence)jsapiTicket)) {
                    this.redisTemplate.opsForValue().set((Object)key, (Object)jsapiTicket, 7000L, TimeUnit.SECONDS);
                }
            }
        }
        return jsapiTicket;
    }

    @Override
    public String getYonYouCloudAccessTicket(boolean reload) throws Exception {
        String accessToken = this.getYonYouCloudAccessToken(reload);
        String jsTicket = (String)this.redisTemplate.opsForValue().get((Object)YONYOUCLOUD_TICKET_KEY);
        logger.info("redis--yonyoucloud--jsTicket=" + jsTicket);
        if (StringUtils.isBlank((CharSequence)jsTicket) || reload) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("access_token", accessToken);
            logger.info("\u8bf7\u6c42\u53cb\u7a7a\u95f4\u83b7\u53d6\u7968\u636e\uff0curl-{}, \u53c2\u6570\uff1a{}", (Object)this.yonYouGetTicketUrl, params);
            String httpResultJsonStr = HttpTookit.get((String)this.yonYouGetTicketUrl, params, new HashMap());
            logger.info("\u8bf7\u6c42\u53cb\u7a7a\u95f4\u83b7\u53d6\u7968\u636e\u7ed3\u679c\uff1a{}", (Object)httpResultJsonStr);
            JSONObject httpResultJson = JSONObject.parseObject((String)httpResultJsonStr);
            if ("200".equals(httpResultJson.getString("code"))) {
                JSONObject data = httpResultJson.getJSONObject("data");
                jsTicket = data.getString("js_ticket");
                Long expire = data.getLong("expires_in");
                this.redisTemplate.opsForValue().set((Object)YONYOUCLOUD_TICKET_KEY, (Object)jsTicket, expire - 3L, TimeUnit.SECONDS);
            } else {
                throw new BusinessException("\u8bf7\u6c42\u53cb\u7a7a\u95f4\u83b7\u53d6\u63a5\u53e3\u4ee4\u724c\u5931\u8d25: " + httpResultJson.getString("message"));
            }
        }
        return jsTicket;
    }

    @Override
    public String getQunjeToken(String restname, String password, Boolean refresh) {
        String key = "qunje_" + restname + "_" + password;
        String token = null;
        if (!refresh.booleanValue()) {
            token = (String)this.redisTemplate.opsForValue().get((Object)key);
            logger.info("redis----qunje_token=" + token);
        }
        if (StringUtils.isBlank(token)) {
            String getTokenUrl = this.tokenUrl + "/token/getToken";
            logger.info("getTokenUrl=" + getTokenUrl);
            try {
                String status;
                HashMap<String, String> paramMap = new HashMap<String, String>();
                paramMap.put("restname", restname);
                paramMap.put("password", password);
                String responseStr = HttpTookit.postParameters((String)getTokenUrl, paramMap, (String)"application/x-www-form-urlencoded");
                logger.info("responseStr=" + responseStr);
                JSONObject responseJson = JSON.parseObject((String)responseStr);
                if (responseJson != null && "0".equals(status = responseJson.getString("status"))) {
                    JSONObject dataJson = responseJson.getJSONObject("data");
                    token = dataJson.getString("token");
                    this.redisTemplate.opsForValue().set((Object)key, (Object)token, 2L, TimeUnit.HOURS);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return token;
    }

    @Override
    public String getWXEESuiteAccessToken(JSONObject body, String suiteId) {
        String accessToken = (String)this.redisTemplate.opsForValue().get((Object)("EJB_SuiteAccessToken" + suiteId));
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            try {
                JSONObject token;
                String res = WeixinRestUtil.doPostByURL("https://qyapi.weixin.qq.com/cgi-bin/service/get_suite_token", body.toJSONString());
                logger.info("\u8bf7\u6c42\u83b7\u53d6suite_access_token:{}   \u54cd\u5e94\uff1a{}", (Object)"https://qyapi.weixin.qq.com/cgi-bin/service/get_suite_token", (Object)res);
                if (StringUtils.isNotEmpty((CharSequence)res)) {
                    token = JSONObject.parseObject((String)res);
                    if (!StringUtils.isEmpty((CharSequence)token.getString("errcode")) && token.getInteger("errcode") != 0) {
                        logger.info("\u83b7\u53d6suite_access_token\u5931\u8d25\uff01suiteId:{}  \u8bf7\u6c42\u4f53\uff1a{}\uff0c\u54cd\u5e94\uff1a{}", new Object[]{suiteId, body, res});
                        throw new BusinessException("errcode:" + token.getString("errcode"));
                    }
                } else {
                    logger.info("\u83b7\u53d6suite_access_token\u5931\u8d25\uff01suiteId:{}  \u8bf7\u6c42\u4f53\uff1a{}\uff0c\u54cd\u5e94\u4e3a\u7a7a", (Object)suiteId, (Object)body);
                    throw new BusinessException("\u54cd\u5e94\u4e3a\u7a7a\uff01");
                }
                accessToken = token.getString("suite_access_token");
                this.redisTemplate.opsForValue().set((Object)("EJB_SuiteAccessToken" + suiteId), (Object)accessToken, 7000L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                logger.info("\u83b7\u53d6suite_access_token\u5931\u8d25\uff01{}", (Object)e.getMessage());
                e.printStackTrace();
                throw new BusinessException("\u83b7\u53d6suite_access_token\u5931\u8d25\uff01" + e.getMessage());
            }
        }
        return accessToken;
    }

    @Override
    public String getWXEEPreAuthCode(String suiteAccessToken) {
        String pre_auth_code = null;
        try {
            JSONObject token;
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("suite_access_token", suiteAccessToken);
            String res = WeixinRestUtil.doGetByURL("https://qyapi.weixin.qq.com/cgi-bin/service/get_pre_auth_code?suite_access_token=" + suiteAccessToken, null);
            logger.info("\u8bf7\u6c42\u83b7\u53d6pre_auth_code:{}   \u54cd\u5e94\uff1a{}", (Object)("https://qyapi.weixin.qq.com/cgi-bin/service/get_pre_auth_code?suite_access_token=" + suiteAccessToken), (Object)res);
            if (StringUtils.isNotEmpty((CharSequence)res)) {
                token = JSONObject.parseObject((String)res);
                if (!StringUtils.isEmpty((CharSequence)token.getString("errcode")) && token.getInteger("errcode") != 0) {
                    logger.info("\u83b7\u53d6pre_auth_code\u5931\u8d25\uff01suiteAccessToken:{}  \u54cd\u5e94\uff1a{}", (Object)suiteAccessToken, (Object)res);
                    throw new BusinessException("errcode:" + token.getString("errcode"));
                }
            } else {
                logger.info("\u83b7\u53d6pre_auth_code\u5931\u8d25\uff01suiteAccessToken:{} \uff0c\u54cd\u5e94\u4e3a\u7a7a", (Object)suiteAccessToken);
                throw new BusinessException("\u54cd\u5e94\u4e3a\u7a7a\uff01");
            }
            pre_auth_code = token.getString("pre_auth_code");
        }
        catch (Exception e) {
            logger.info("\u83b7\u53d6pre_auth_code\u5931\u8d25\uff01{}", (Object)e.getMessage());
            e.printStackTrace();
            throw new BusinessException("\u83b7\u53d6pre_auth_code\u5931\u8d25\uff01" + e.getMessage());
        }
        return pre_auth_code;
    }

    @Override
    public String setWXEESessionInfo(String suiteAccessToken, JSONObject body) {
        block4: {
            try {
                String res = WeixinRestUtil.doPostByURL("https://qyapi.weixin.qq.com/cgi-bin/service/set_session_info?suite_access_token=" + suiteAccessToken, body.toJSONString());
                logger.info("\u8bf7\u6c42\u8bbe\u7f6e\u6388\u6743\u914d\u7f6e:{}   \u54cd\u5e94\uff1a{}", (Object)("https://qyapi.weixin.qq.com/cgi-bin/service/set_session_info?suite_access_token=" + suiteAccessToken), (Object)res);
                if (StringUtils.isNotEmpty((CharSequence)res)) {
                    JSONObject token = JSONObject.parseObject((String)res);
                    if (!StringUtils.isEmpty((CharSequence)token.getString("errcode")) && token.getInteger("errcode") != 0) {
                        logger.info("\u8bbe\u7f6e\u6388\u6743\u914d\u7f6e\u5931\u8d25\uff01suiteAccessToken:{}  \u8bf7\u6c42\u4f53\uff1a{}\uff0c\u54cd\u5e94\uff1a{}", new Object[]{suiteAccessToken, body, res});
                        throw new BusinessException("errcode:" + token.getString("errcode"));
                    }
                    break block4;
                }
                logger.info("\u8bbe\u7f6e\u6388\u6743\u914d\u7f6e\u5931\u8d25\uff01suiteAccessToken:{}  \u8bf7\u6c42\u4f53\uff1a{}\uff0c\u54cd\u5e94\u4e3a\u7a7a", (Object)suiteAccessToken, (Object)body);
                throw new BusinessException("\u54cd\u5e94\u4e3a\u7a7a\uff01");
            }
            catch (Exception e) {
                logger.info("\u8bbe\u7f6e\u6388\u6743\u914d\u7f6e\u5931\u8d25\uff01{}", (Object)e.getMessage());
                e.printStackTrace();
                throw new BusinessException("\u8bbe\u7f6e\u6388\u6743\u914d\u7f6e\u5931\u8d25\uff01" + e.getMessage());
            }
        }
        return null;
    }

    @Override
    public JSONObject getWXEEPermanentCode(String suiteAccessToken, JSONObject body) {
        try {
            String res = WeixinRestUtil.doPostByURL("https://qyapi.weixin.qq.com/cgi-bin/service/get_permanent_code?suite_access_token=" + suiteAccessToken, body.toJSONString());
            logger.info("\u8bf7\u6c42\u83b7\u53d6\u4f01\u4e1a\u6c38\u4e45\u6388\u6743\u7801:{}   \u54cd\u5e94\uff1a{}", (Object)("https://qyapi.weixin.qq.com/cgi-bin/service/get_permanent_code?suite_access_token=" + suiteAccessToken), (Object)res);
            if (StringUtils.isNotEmpty((CharSequence)res)) {
                JSONObject token = JSONObject.parseObject((String)res);
                if (StringUtils.isEmpty((CharSequence)token.getString("errcode")) || token.getInteger("errcode") == 0) {
                    return token;
                }
                logger.info("\u83b7\u53d6\u4f01\u4e1a\u6c38\u4e45\u6388\u6743\u7801\u5931\u8d25\uff01suiteAccessToken:{}  \u8bf7\u6c42\u4f53\uff1a{}\uff0c\u54cd\u5e94\uff1a{}", new Object[]{suiteAccessToken, body, res});
                throw new BusinessException("errcode:" + token.getString("errcode"));
            }
            logger.info("\u83b7\u53d6\u4f01\u4e1a\u6c38\u4e45\u6388\u6743\u7801\u5931\u8d25\uff01suiteAccessToken:{}  \u8bf7\u6c42\u4f53\uff1a{}\uff0c\u54cd\u5e94\u4e3a\u7a7a", (Object)suiteAccessToken, (Object)body);
            throw new BusinessException("\u54cd\u5e94\u4e3a\u7a7a\uff01");
        }
        catch (Exception e) {
            logger.info("\u83b7\u53d6\u4f01\u4e1a\u6c38\u4e45\u6388\u6743\u7801\u5931\u8d25\uff01{}", (Object)e.getMessage());
            e.printStackTrace();
            throw new BusinessException("\u83b7\u53d6\u4f01\u4e1a\u6c38\u4e45\u6388\u6743\u7801\u5931\u8d25\uff01" + e.getMessage());
        }
    }

    @Override
    public JSONObject getWXEEAuthInfo(String suiteAccessToken, JSONObject body) {
        try {
            String res = WeixinRestUtil.doPostByURL("https://qyapi.weixin.qq.com/cgi-bin/service/get_auth_info?suite_access_token=" + suiteAccessToken, body.toJSONString());
            logger.info("\u8bf7\u6c42\u83b7\u53d6\u4f01\u4e1a\u6388\u6743\u4fe1:{}   \u54cd\u5e94\uff1a{}", (Object)("https://qyapi.weixin.qq.com/cgi-bin/service/get_auth_info?suite_access_token=" + suiteAccessToken), (Object)res);
            if (StringUtils.isNotEmpty((CharSequence)res)) {
                JSONObject token = JSONObject.parseObject((String)res);
                if (StringUtils.isEmpty((CharSequence)token.getString("errcode")) || token.getInteger("errcode") == 0) {
                    return token;
                }
                logger.info("\u83b7\u53d6\u4f01\u4e1a\u6388\u6743\u4fe1\u606f\u5931\u8d25\uff01suiteAccessToken:{}  \u8bf7\u6c42\u4f53\uff1a{}\uff0c\u54cd\u5e94\uff1a{}", new Object[]{suiteAccessToken, body, res});
                throw new BusinessException("errcode:" + token.getString("errcode"));
            }
            logger.info("\u83b7\u53d6\u4f01\u4e1a\u6388\u6743\u4fe1\u606f\u5931\u8d25\uff01suiteAccessToken:{}  \u8bf7\u6c42\u4f53\uff1a{}\uff0c\u54cd\u5e94\u4e3a\u7a7a", (Object)suiteAccessToken, (Object)body);
            throw new BusinessException("\u54cd\u5e94\u4e3a\u7a7a\uff01");
        }
        catch (Exception e) {
            logger.info("\u83b7\u53d6\u4f01\u4e1a\u6388\u6743\u4fe1\u606f\u5931\u8d25\uff01{}", (Object)e.getMessage());
            e.printStackTrace();
            throw new BusinessException("\u83b7\u53d6\u4f01\u4e1a\u6388\u6743\u4fe1\u606f\u5931\u8d25\uff01" + e.getMessage());
        }
    }

    @Override
    public String getWXEECorpToken(String corpid, String suiteAccessToken, JSONObject body) {
        String accessToken = (String)this.redisTemplate.opsForValue().get((Object)("EJB_corpid_AccessToken" + corpid));
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            try {
                JSONObject token;
                String res = WeixinRestUtil.doPostByURL("https://qyapi.weixin.qq.com/cgi-bin/service/get_corp_token?suite_access_token=" + suiteAccessToken, body.toJSONString());
                logger.info("\u8bf7\u6c42\u83b7\u53d6\u4f01\u4e1aaccess_token:{}   \u54cd\u5e94\uff1a{}", (Object)("https://qyapi.weixin.qq.com/cgi-bin/service/get_corp_token?suite_access_token=" + suiteAccessToken), (Object)res);
                if (StringUtils.isNotEmpty((CharSequence)res)) {
                    token = JSONObject.parseObject((String)res);
                    if (!StringUtils.isEmpty((CharSequence)token.getString("errcode")) && token.getInteger("errcode") != 0) {
                        logger.info("\u83b7\u53d6\u4f01\u4e1aaccess_token\u5931\u8d25\uff01corpid:{},suiteAccessToken:{},  \u8bf7\u6c42\u4f53\uff1a{}\uff0c\u54cd\u5e94\uff1a{}", new Object[]{corpid, suiteAccessToken, body, res});
                        throw new BusinessException("errcode:" + token.getString("errcode"));
                    }
                } else {
                    logger.info("\u83b7\u53d6\u4f01\u4e1aaccess_token\u5931\u8d25\uff01corpid:{} \uff0csuiteAccessToken:{}, \u8bf7\u6c42\u4f53\uff1a{}\uff0c\u54cd\u5e94\u4e3a\u7a7a", new Object[]{corpid, suiteAccessToken, body});
                    throw new BusinessException("\u54cd\u5e94\u4e3a\u7a7a\uff01");
                }
                accessToken = token.getString("access_token");
                this.redisTemplate.opsForValue().set((Object)("EJB_corpid_AccessToken" + corpid), (Object)accessToken, 7000L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                logger.info("\u83b7\u53d6\u4f01\u4e1aaccess_token\u5931\u8d25\uff01{}", (Object)e.getMessage());
                e.printStackTrace();
                throw new BusinessException("\u83b7\u53d6\u4f01\u4e1aaccess_token\u5931\u8d25\uff01" + e.getMessage());
            }
        }
        return accessToken;
    }

    @Override
    public JSONObject getWXEEUserInfo(String access_token, String userId) {
        try {
            String res = WeixinRestUtil.doGetByURL("https://qyapi.weixin.qq.com/cgi-bin/user/get?access_token=" + access_token + "&userid=" + userId, null);
            logger.info("\u8bf7\u6c42\u8bfb\u53d6\u4f01\u4e1a\u5fae\u4fe1\u6210\u5458\u8be6\u7ec6\u4fe1\u606f:{}   \u54cd\u5e94\uff1a{}", (Object)("https://qyapi.weixin.qq.com/cgi-bin/user/get?access_token=" + access_token + "&userid=" + userId), (Object)res);
            if (StringUtils.isNotEmpty((CharSequence)res)) {
                JSONObject userInfo = JSONObject.parseObject((String)res);
                if (StringUtils.isEmpty((CharSequence)userInfo.getString("errcode")) || userInfo.getInteger("errcode") == 0) {
                    return userInfo;
                }
                logger.info("\u8bfb\u53d6\u4f01\u4e1a\u5fae\u4fe1\u6210\u5458\u8be6\u7ec6\u4fe1\u606f\u5931\u8d25\uff01access_token:{}  userId\uff1a{}\uff0c\u54cd\u5e94\uff1a{}", new Object[]{access_token, userId, res});
                throw new BusinessException("errcode:" + userInfo.getString("errcode"));
            }
            logger.info("\u8bfb\u53d6\u4f01\u4e1a\u5fae\u4fe1\u6210\u5458\u8be6\u7ec6\u4fe1\u606f\u5931\u8d25\uff01access_token:{}  userId\uff1a{}\uff0c\u54cd\u5e94\u4e3a\u7a7a", (Object)access_token, (Object)userId);
            throw new BusinessException("\u54cd\u5e94\u4e3a\u7a7a\uff01");
        }
        catch (Exception e) {
            logger.info("\u8bfb\u53d6\u4f01\u4e1a\u5fae\u4fe1\u6210\u5458\u8be6\u7ec6\u4fe1\u606f\u5931\u8d25\uff01{}", (Object)e.getMessage());
            e.printStackTrace();
            throw new BusinessException("\u8bfb\u53d6\u4f01\u4e1a\u5fae\u4fe1\u6210\u5458\u8be6\u7ec6\u4fe1\u606f\u5931\u8d25\uff01" + e.getMessage());
        }
    }

    @Override
    public JSONArray getWXEEDeptUserList(String access_token, String department_id) {
        try {
            String res = WeixinRestUtil.doGetByURL("https://qyapi.weixin.qq.com/cgi-bin/user/simplelist?access_token=" + access_token + "&department_id=" + department_id, null);
            logger.info("\u8bf7\u6c42\u8bfb\u53d6\u4f01\u4e1a\u5fae\u4fe1\u90e8\u95e8\u6210\u5458:{}   \u54cd\u5e94\uff1a{}", (Object)("https://qyapi.weixin.qq.com/cgi-bin/user/simplelist?access_token=" + access_token + "&department_id=" + department_id), (Object)res);
            if (StringUtils.isNotEmpty((CharSequence)res)) {
                JSONObject userlist = JSONObject.parseObject((String)res);
                if (StringUtils.isEmpty((CharSequence)userlist.getString("errcode")) || userlist.getInteger("errcode") == 0) {
                    return userlist.getJSONArray("userlist");
                }
                logger.info("\u8bfb\u53d6\u4f01\u4e1a\u5fae\u4fe1\u90e8\u95e8\u6210\u5458\u5931\u8d25\uff01access_token:{}  department_id\uff1a{}\uff0c\u54cd\u5e94\uff1a{}", new Object[]{access_token, department_id, res});
                throw new BusinessException("errcode:" + userlist.getString("errcode"));
            }
            logger.info("\u8bfb\u53d6\u4f01\u4e1a\u5fae\u4fe1\u90e8\u95e8\u6210\u5458\u5931\u8d25\uff01access_token:{}  department_id\uff1a{}\uff0c\u54cd\u5e94\u4e3a\u7a7a", (Object)access_token, (Object)department_id);
            throw new BusinessException("\u54cd\u5e94\u4e3a\u7a7a\uff01");
        }
        catch (Exception e) {
            logger.info("\u8bfb\u53d6\u4f01\u4e1a\u5fae\u4fe1\u90e8\u95e8\u6210\u5458\u5931\u8d25\uff01{}", (Object)e.getMessage());
            e.printStackTrace();
            throw new BusinessException("\u8bfb\u53d6\u4f01\u4e1a\u5fae\u4fe1\u90e8\u95e8\u6210\u5458\u5931\u8d25\uff01" + e.getMessage());
        }
    }

    @Override
    public JSONObject getWXEEUser3rd(String suite_access_token, String code) {
        try {
            String res = WeixinRestUtil.doGetByURL("https://qyapi.weixin.qq.com/cgi-bin/service/auth/getuserinfo3rd?suite_access_token=" + suite_access_token + "&code=" + code, null);
            logger.info("\u8bf7\u6c42\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1\u8bbf\u95ee\u7528\u6237\u8eab\u4efd:{}   \u54cd\u5e94\uff1a{}", (Object)("https://qyapi.weixin.qq.com/cgi-bin/service/auth/getuserinfo3rd?suite_access_token=" + suite_access_token + "&code=" + code), (Object)res);
            if (StringUtils.isNotEmpty((CharSequence)res)) {
                JSONObject user = JSONObject.parseObject((String)res);
                if (StringUtils.isEmpty((CharSequence)user.getString("errcode")) || user.getInteger("errcode") == 0) {
                    return user;
                }
                logger.info("\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1\u8bbf\u95ee\u7528\u6237\u8eab\u4efd\u5931\u8d25\uff01suite_access_token:{}  department_id\uff1a{}\uff0c\u54cd\u5e94\uff1a{}", new Object[]{suite_access_token, code, res});
                throw new BusinessException("errcode:" + user.getString("errcode"));
            }
            logger.info("\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1\u8bbf\u95ee\u7528\u6237\u8eab\u4efd\u5931\u8d25\uff01suite_access_token:{}  department_id\uff1a{}\uff0c\u54cd\u5e94\u4e3a\u7a7a", (Object)suite_access_token, (Object)code);
            throw new BusinessException("\u54cd\u5e94\u4e3a\u7a7a\uff01");
        }
        catch (Exception e) {
            logger.info("\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1\u8bbf\u95ee\u7528\u6237\u8eab\u4efd\u5931\u8d25\uff01{}", (Object)e.getMessage());
            e.printStackTrace();
            throw new BusinessException("\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1\u8bbf\u95ee\u7528\u6237\u8eab\u4efd\u5931\u8d25\uff01" + e.getMessage());
        }
    }

    @Override
    public String getWXEEProviderToken() {
        String accessToken = (String)this.redisTemplate.opsForValue().get((Object)"ww2dd60a57572d9031");
        if (StringUtils.isEmpty((CharSequence)accessToken)) {
            String getProviderToken = "https://qyapi.weixin.qq.com/cgi-bin/service/get_provider_token";
            JSONObject providerTokenParam = new JSONObject();
            providerTokenParam.put("corpid", (Object)"ww2dd60a57572d9031");
            providerTokenParam.put("provider_secret", (Object)"PU6smE7tG5B48tJD-aoSI3WEV2tP8K9yvrENwnVS5DTeGVCj2x8hfGtN7lOuqYDS");
            String providerTokenResp = WeixinRestUtil.doPostByURL(getProviderToken, JSON.toJSONString((Object)providerTokenParam));
            JSONObject providerTokenJson = JSON.parseObject((String)providerTokenResp);
            accessToken = providerTokenJson.getString("provider_access_token");
            this.redisTemplate.opsForValue().set((Object)"ww2dd60a57572d9031", (Object)accessToken, 7000L, TimeUnit.SECONDS);
        }
        return accessToken;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getDdThirdAppAccessToken(String corpId, String suiteTicket) {
        try {
            Config config = new Config();
            config.protocol = "https";
            config.regionId = "central";
            Client client = new Client(config);
            GetCorpAccessTokenRequest getCorpAccessTokenRequest = new GetCorpAccessTokenRequest().setSuiteKey("suiteannkyh3fazc7iqlj").setSuiteSecret("pDh8br7SjZh1hbzYBQrYITm6GabGmcmRO98LtoxelyAKPz7RuBsqJyp3XJ37C8-a").setAuthCorpId(corpId).setSuiteTicket(suiteTicket);
            GetCorpAccessTokenResponse response = client.getCorpAccessToken(getCorpAccessTokenRequest);
            return response.getBody().getAccessToken();
        }
        catch (TeaException err) {
            if (!Common.empty((String)err.code) && Common.empty((String)err.message)) return null;
        }
        catch (Exception _err) {
            TeaException err = new TeaException(_err.getMessage(), (Throwable)_err);
            if (!Common.empty((String)err.code) && Common.empty((String)err.message)) return null;
        }
        return null;
    }

    @Override
    public String getDdThirdAppSuiteAccessToken(String suiteTicket) {
        String suiteAccessToken = null;
        String key = "ejc-ddThirdApp-suiteAccessToken";
        if (this.redisTemplate.opsForValue().get((Object)key) != null) {
            suiteAccessToken = this.redisTemplate.opsForValue().get((Object)key).toString();
        }
        if (StringUtils.isNotBlank(suiteAccessToken)) {
            return suiteAccessToken;
        }
        try {
            DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/service/get_suite_token");
            OapiServiceGetSuiteTokenRequest req = new OapiServiceGetSuiteTokenRequest();
            req.setSuiteKey("suiteannkyh3fazc7iqlj");
            req.setSuiteSecret("pDh8br7SjZh1hbzYBQrYITm6GabGmcmRO98LtoxelyAKPz7RuBsqJyp3XJ37C8-a");
            req.setSuiteTicket(suiteTicket);
            OapiServiceGetSuiteTokenResponse response = (OapiServiceGetSuiteTokenResponse)client.execute((TaobaoRequest)req);
            JSONObject body = JSONObject.parseObject((String)response.getBody());
            logger.info("suiteAccessToken---------\u300b\u300b\u300b\u300b" + response.getBody());
            if ("0".equals(body.getString("errcode"))) {
                suiteAccessToken = body.getString("suite_access_token");
                this.redisTemplate.opsForValue().set((Object)key, (Object)suiteAccessToken, 7000L, TimeUnit.SECONDS);
            }
        }
        catch (ApiException e) {
            e.printStackTrace();
        }
        return suiteAccessToken;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getDdUserAccessToken(String code) {
        String key = "ejc-ddThirdApp-accessToken";
        String accessToken = null;
        if (this.redisTemplate.opsForValue().get((Object)key) != null) {
            accessToken = this.redisTemplate.opsForValue().get((Object)key).toString();
        }
        if (StringUtils.isNotBlank(accessToken)) {
            return accessToken;
        }
        if (!StringUtils.isBlank(accessToken)) return accessToken;
        try {
            Config config = new Config();
            config.protocol = "https";
            config.regionId = "central";
            Client client = new Client(config);
            GetUserTokenRequest getUserTokenRequest = new GetUserTokenRequest().setClientSecret("pDh8br7SjZh1hbzYBQrYITm6GabGmcmRO98LtoxelyAKPz7RuBsqJyp3XJ37C8-a").setClientId("suiteannkyh3fazc7iqlj").setCode(code).setGrantType("authorization_code");
            GetUserTokenResponse response = client.getUserToken(getUserTokenRequest);
            GetUserTokenResponseBody body = response.getBody();
            accessToken = body.getAccessToken();
            logger.info("body === " + ((JSONObject)BeanMapper.map((Object)body, JSONObject.class)).toJSONString());
            logger.info("accessToken === " + accessToken);
            this.redisTemplate.opsForValue().set((Object)key, (Object)accessToken, 5000L, TimeUnit.SECONDS);
            return accessToken;
        }
        catch (TeaException err) {
            if (!Common.empty((String)err.code) && Common.empty((String)err.message)) return accessToken;
        }
        catch (Exception _err) {
            TeaException err = new TeaException(_err.getMessage(), (Throwable)_err);
            if (!Common.empty((String)err.code) && Common.empty((String)err.message)) return accessToken;
        }
        return accessToken;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getDdThirdAgentid(String corpid) {
        String key = corpid + "-Agentid";
        String agentid = null;
        if (this.redisTemplate.opsForValue().get((Object)key) != null) {
            agentid = this.redisTemplate.opsForValue().get((Object)key).toString();
        }
        if (StringUtils.isNotBlank(agentid)) {
            logger.info("agentid === " + agentid);
            return agentid;
        }
        if (!StringUtils.isBlank(agentid)) return agentid;
        try {
            DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/service/get_auth_info");
            OapiServiceGetAuthInfoRequest req = new OapiServiceGetAuthInfoRequest();
            req.setAuthCorpid(corpid);
            String suiteTicket = this.getThirdAppSuiteTicket("27781002", "ddThirdApp");
            OapiServiceGetAuthInfoResponse rsp = (OapiServiceGetAuthInfoResponse)client.execute((TaobaoRequest)req, "suiteannkyh3fazc7iqlj", "pDh8br7SjZh1hbzYBQrYITm6GabGmcmRO98LtoxelyAKPz7RuBsqJyp3XJ37C8-a", suiteTicket);
            logger.info("AuthInfoResponse === " + ((JSONObject)BeanMapper.map((Object)rsp, JSONObject.class)).toJSONString());
            List agentList = rsp.getAuthInfo().getAgent();
            if (agentList != null && agentList.size() > 0) {
                for (OapiServiceGetAuthInfoResponse.Agent agent : agentList) {
                    if (!"120489".equals(agent.getAppid().toString())) continue;
                    agentid = agent.getAgentid().toString();
                    break;
                }
            }
            logger.info("agentid === " + agentid);
            this.redisTemplate.opsForValue().set((Object)key, (Object)agentid, 10000L, TimeUnit.SECONDS);
            return agentid;
        }
        catch (TeaException err) {
            if (!Common.empty((String)err.code) && Common.empty((String)err.message)) return agentid;
        }
        catch (Exception _err) {
            TeaException err = new TeaException(_err.getMessage(), (Throwable)_err);
            if (!Common.empty((String)err.code) && Common.empty((String)err.message)) return agentid;
        }
        return agentid;
    }

    @Override
    public String getTenantPromiseCode(String corpid) {
        QueryWrapper tenantWrapper = new QueryWrapper();
        ((QueryWrapper)tenantWrapper.eq((Object)"corpid", (Object)corpid)).eq((Object)"dr", (Object)0);
        TenantEntity exitTenantEntity = (TenantEntity)((Object)this.iTenantService.getOne((Wrapper)tenantWrapper));
        if (exitTenantEntity != null) {
            return exitTenantEntity.getPermanentCode();
        }
        return null;
    }

    @Override
    public TenantEntity getTenantByThirdCorpid(String corpid) {
        QueryWrapper tenantWrapper = new QueryWrapper();
        ((QueryWrapper)tenantWrapper.eq((Object)"corpid", (Object)corpid)).eq((Object)"dr", (Object)0);
        return (TenantEntity)((Object)this.iTenantService.getOne((Wrapper)tenantWrapper));
    }

    @Override
    public String getThirdAppSuiteTicket(String suiteId, String sys) {
        QueryParam param = new QueryParam();
        param.getParams().put("suiteId", new Parameter("eq", (Object)suiteId));
        param.getParams().put("sourceSys", new Parameter("eq", (Object)sys));
        List ticketEntities = this.suitTicketService.queryList(param, false);
        if (ListUtil.isNotEmpty((List)ticketEntities)) {
            return ((SuiteTicketEntity)((Object)ticketEntities.get(0))).getTicket();
        }
        return null;
    }

    @Override
    public String getThirdAppAccessToken(String corpid, String sys) {
        if ("wxee".equals(sys)) {
            String promiseCode = this.getTenantPromiseCode(corpid);
            String suite_ticket = this.getThirdAppSuiteTicket("wwdca16158f8d411bd", "wxee");
            JSONObject body = new JSONObject();
            body.put("suite_id", (Object)"wwdca16158f8d411bd");
            body.put("suite_secret", (Object)"px7JbJ6tKLbv_ukZxnpg_vvyjyHw5dpexwoz61-LGTY");
            body.put("suite_ticket", (Object)suite_ticket);
            String suite_access_token = this.getWXEESuiteAccessToken(body, "wwdca16158f8d411bd");
            body = new JSONObject();
            body.put("auth_corpid", (Object)corpid);
            body.put("permanent_code", (Object)promiseCode);
            return this.getWXEECorpToken(corpid, suite_access_token, body);
        }
        if ("ddThirdApp".equals(sys)) {
            String suite_ticket = this.getThirdAppSuiteTicket("27781002", "ddThirdApp");
            return this.getDdThirdAppAccessToken(corpid, suite_ticket);
        }
        return null;
    }

    @Override
    public void setThirdAppSuiteTicket(String suiteTicket, String suiteId, String sys) {
        QueryParam param = new QueryParam();
        param.getParams().put("suiteId", new Parameter("eq", (Object)suiteId));
        param.getParams().put("sourceSys", new Parameter("eq", (Object)sys));
        List ticketEntities = this.suitTicketService.queryList(param, false);
        SuiteTicketEntity entity = ListUtil.isNotEmpty((List)ticketEntities) ? (SuiteTicketEntity)((Object)ticketEntities.get(0)) : new SuiteTicketEntity();
        entity.setSourceSys(sys);
        entity.setTicket(suiteTicket);
        entity.setSuiteId(suiteId);
        this.suitTicketService.saveOrUpdate((Object)entity, false);
    }

    @Override
    public ThirdSystemVO queryThirdSystemByTargetTenantId(Long tenantId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"target_tenant_id", (Object)tenantId);
        List thirdSystemList = ((ThirdSystemMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (thirdSystemList != null && thirdSystemList.size() > 0) {
            return (ThirdSystemVO)BeanMapper.map(thirdSystemList.get(0), ThirdSystemVO.class);
        }
        return null;
    }
}

