package com.ejianc.foundation.apigateway.service;

import java.util.List;

import com.ejianc.foundation.apigateway.bean.GroupEntity;
import com.ejianc.foundation.apigateway.vo.GroupVO;
import com.ejianc.framework.skeleton.template.IBaseService;

public interface IGroupService extends IBaseService<GroupEntity> {

	/**
	 * 查询分组详情
	 * 
	 * @param id
	 * @return
	 */
	GroupEntity queryDetail(Long id);

	/**
	 * 根据父ID查询其子节点
	 * 
	 * @param parentId
	 * @return
	 */
	List<GroupVO> queyrListByPid(Long parentId);

	/**
	 * 根据主键删除对象
	 * 
	 * @param id
	 */
	void delete(Long id);

}
