/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.cache;

import com.alibaba.fastjson.JSON;
import com.ejianc.foundation.workbench.vo.MenuItemVO;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.cache.serializer.Serializer;
import com.ejianc.framework.cache.serializer.impl.DefaultJDKSerializer;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MenuItemCacheManage {
    public static final String DEFAULT_CHARSET = "UTF-8";
    private static final String MENUITEM_LIST_KEY = "menuitem_list_key:";
    @Autowired
    private CacheManager cacheManager;
    private Serializer serializer = new DefaultJDKSerializer();

    public void putMenuItemCache(Long tenantId, List<MenuItemVO> menuItemList) {
        if (menuItemList != null && menuItemList.size() > 0) {
            this.cacheManager.piplineExecute(pipeline -> {
                pipeline.multi();
                String key = MENUITEM_LIST_KEY + tenantId;
                for (MenuItemVO menuItemVo : menuItemList) {
                    byte[] keyBytes = key.getBytes(Charset.forName(DEFAULT_CHARSET));
                    byte[] fieldBytes = menuItemVo.getId().toString().getBytes(Charset.forName(DEFAULT_CHARSET));
                    byte[] contentBytes = this.serializer.marshalToByte((Serializable)((Object)JSON.toJSONString((Object)menuItemVo)));
                    pipeline.hset(keyBytes, fieldBytes, contentBytes);
                }
                pipeline.exec();
            });
        }
    }

    public List<MenuItemVO> getMenuItemsCache(Long tenantId) {
        ArrayList<MenuItemVO> menuItemList = new ArrayList<MenuItemVO>();
        String key = MENUITEM_LIST_KEY + tenantId;
        Map resultMap = this.cacheManager.hgetAll(key);
        if (resultMap != null && !resultMap.isEmpty()) {
            MenuItemVO menuItemVo = null;
            for (Map.Entry entry : resultMap.entrySet()) {
                byte[] content = (byte[])entry.getValue();
                String menuItemJson = (String)((Object)this.serializer.unMarshal(content));
                menuItemVo = (MenuItemVO)JSON.parseObject((String)menuItemJson, MenuItemVO.class);
                menuItemList.add(menuItemVo);
            }
        }
        return menuItemList;
    }

    public void removeMenuItemCache(Long tenantId, MenuItemVO menuItemVo) {
        String key = MENUITEM_LIST_KEY + tenantId;
        this.cacheManager.hdel(key, menuItemVo.getId().toString());
    }
}

