package com.ejianc.foundation.apply.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.apply.bean.UserJoinEnterpriseApplyEntity;
import com.ejianc.foundation.apply.mapper.UserJoinEnterpriseApplyMapper;
import com.ejianc.foundation.apply.service.IUserJoinEnterpriseApplyService;
import com.ejianc.foundation.apply.vo.EnterpriseAppRelationVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.bean.JobEntity;
import com.ejianc.foundation.orgcenter.service.IJobService;
import com.ejianc.foundation.orgcenter.service.IOrgService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.tenant.vo.EnterpriseVO;
import com.ejianc.foundation.usercenter.bean.UserTenantRelationEntity;
import com.ejianc.foundation.usercenter.service.IUserTenantRelationService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

/**
 * 用户加入企业申请单
 * 
 * @author generator
 * 
 */
@Service("userJoinEnterpriseApplyService")
public class UserJoinEnterpriseApplyServiceImpl extends BaseServiceImpl<UserJoinEnterpriseApplyMapper, UserJoinEnterpriseApplyEntity> implements IUserJoinEnterpriseApplyService{
    private final Logger logger = LoggerFactory.getLogger(getClass());
    
    @Autowired
    private IUserTenantRelationService userTenantRelationService;
    @Autowired
    private UserJoinEnterpriseApplyMapper userJoinEnterpriseApplyMapper;
    @Autowired
    private IJobService jobService;
    @Autowired
    private IOrgService orgService;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private EnvironmentTools environmentTools;
    /**
     * 查询列表
     * @param params
     * @return
     */
    @Override
    public IPage<EnterpriseAppRelationVO> pageList(Map<String, Object> params) {
        List<EnterpriseAppRelationVO> voList = new ArrayList<>();
        IPage<EnterpriseAppRelationVO> page = new Page<>();
        page.setCurrent(Integer.valueOf(params.get("pageIndex").toString()));
        page.setSize(Integer.valueOf(params.get("pageSize").toString()));

        long total = userJoinEnterpriseApplyMapper.count(params);
        page.setTotal(total);
        if(total == 0) {
            page.setRecords(voList);
            return page;
        }
        long startLine = (page.getCurrent() < 1 ? 0 : page.getCurrent() -  1) * page.getSize();
        params.put("startLine", startLine);
        params.put("pageSize", page.getSize());
        voList = userJoinEnterpriseApplyMapper.getList(params);
        page.setRecords(voList);
        return page;
    }

    /**
     * 审核
     * @param id
     * @param state
     */
    public void updateExamine(Long id, String state) {
        UserJoinEnterpriseApplyEntity enterpriseApplyEntity =this.selectById(id);
        enterpriseApplyEntity.setState(state);
        if(state.equals("4")){
            saveOrUpdateRelation(enterpriseApplyEntity);
        }
        this.saveOrUpdate(enterpriseApplyEntity);
    }

    /**
     * 保存一条用户租户关系表
     * @param enterpriseApplyEntity
     */
    public void saveOrUpdateRelation(UserJoinEnterpriseApplyEntity enterpriseApplyEntity){
        List<UserTenantRelationEntity> list =queryEnterpriseIdByUserIdList(enterpriseApplyEntity.getUserId(),enterpriseApplyEntity.getEnterpriseId());
        if(CollectionUtil.isEmpty(list)){
            OrgVO orgVo =orgService.findOrgByTenantId(enterpriseApplyEntity.getTenantId());
            UserTenantRelationEntity userTenantRelationEntity = new UserTenantRelationEntity();
            userTenantRelationEntity.setUserId(enterpriseApplyEntity.getUserId());//用户id
            userTenantRelationEntity.setTenantId(enterpriseApplyEntity.getTenantId());//租户id
            userTenantRelationEntity.setTypeId(2);
            userTenantRelationEntity.setMainSpaceFlag(0);
            userTenantRelationEntity.setState(1);
            userTenantRelationEntity.setOrgId(orgVo.getId());
            userTenantRelationEntity.setEmployeeId(enterpriseApplyEntity.getUserId());
            userTenantRelationService.saveOrUpdate(userTenantRelationEntity);
            JobEntity jobEntity = new JobEntity();
            jobEntity.setEmployeeId(enterpriseApplyEntity.getUserId());
            jobEntity.setTenantId(enterpriseApplyEntity.getTenantId());
            jobEntity.setProperty(1);
            jobEntity.setJobStartTime(new Date());
            jobEntity.setOrgId(orgVo.getId());
            jobEntity.setCurState(0);
            jobService.saveOrUpdate(jobEntity);
        }else{
            throw new BusinessException("该用户已加入企业，不允许重复加入！");
        }

    }

    /**
     * 根据用户id查询企业申请表数据
     * @param userId
     * @return
     */
    public List<UserJoinEnterpriseApplyEntity> queryListByUserId(Long userId) {
        QueryWrapper<UserJoinEnterpriseApplyEntity> queryWrapper = new QueryWrapper<UserJoinEnterpriseApplyEntity>();
        queryWrapper.eq("user_id",userId);
        queryWrapper.eq("state","4");
        return this.list(queryWrapper);
    }

    /**
     * 根据userid和enterpriseId查询
     * @param userId
     * @param enterpriseId
     * @return
     */
    public List<UserTenantRelationEntity> queryEnterpriseIdByUserIdList(Long userId,Long enterpriseId){
        QueryWrapper<UserTenantRelationEntity> queryWrapper = new QueryWrapper<UserTenantRelationEntity>();
        queryWrapper.eq("user_id",userId);
        queryWrapper.eq("tenant_id",enterpriseId);
        queryWrapper.ne("type_id",1);
        return userTenantRelationService.list(queryWrapper);
    }

    /**
     * 发送预警消息
     * @param
     * @return
     */
    public void sendMessage(EnterpriseVO enterpriseVO,UserJoinEnterpriseApplyEntity entity) {
        try{
            String[] receivers = new String[1];
            receivers[0] = enterpriseVO.getUserId().toString();
            logger.info("发送消息开始！===========");
            PushMsgParameter parameter = new PushMsgParameter();
            List<String> channel = new ArrayList<>();
            channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);
            parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
            parameter.setReceivers(receivers);// 收信人
            parameter.setMsgType("notice");

            parameter.setSubject("您收到一条企业申请信息");// 标题
            String url = environmentTools.getBaseHost() + "ejc-idm-frontend/#/personnelManagement";
            parameter.setContent("您收到一条企业申请信息。<a href="+'"'+url+'"'+">点击查看</a>");// 内容

            parameter.setTenantId(String.valueOf(enterpriseVO.getTenantId()));
            parameter.setSendUserId(InvocationInfoProxy.getUserid());

            try {
                CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
                if (result.isSuccess()) {
                    logger.error("消息发送成功---------------->" + result.getMsg()+"---");
                } else {
                    logger.error("消息发送失败---------------->" + result.getMsg());
                }
            } catch (Exception e) {
                logger.error("调用消息中心RPC服务异常--------------" + e);
            }
        }catch (Exception e){
            e.printStackTrace();
        }

    }


    /**
     * 验证保存
     * @param userId
     * @param enterpriseId
     * @return
     */
    public UserJoinEnterpriseApplyEntity checkSaveOrUpdate(Long userId,Long enterpriseId) {
        QueryWrapper<UserJoinEnterpriseApplyEntity> queryWrapper = new QueryWrapper<UserJoinEnterpriseApplyEntity>();
        queryWrapper.eq("user_id",userId);
        queryWrapper.eq("enterprise_id",enterpriseId);
        queryWrapper.eq("state",2);
        List<UserJoinEnterpriseApplyEntity> list =this.list(queryWrapper);
        if(CollectionUtil.isNotEmpty(list)){
            return list.get(0);
        }
        return null;
    }
}
