/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.oms.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.oms.bean.ComboRoleEntity;
import com.ejianc.foundation.oms.mapper.ComboRoleMapper;
import com.ejianc.foundation.oms.service.IComboAppService;
import com.ejianc.foundation.oms.service.IComboEnterpriseService;
import com.ejianc.foundation.oms.service.IComboRoleService;
import com.ejianc.foundation.oms.vo.ComboRoleVO;
import com.ejianc.foundation.orgcenter.service.IEmployeeService;
import com.ejianc.foundation.orgcenter.service.IOrgService;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.permission.bean.RoleEntity;
import com.ejianc.foundation.permission.service.IAppService;
import com.ejianc.foundation.permission.service.IRoleAppRelationService;
import com.ejianc.foundation.permission.service.IRoleService;
import com.ejianc.foundation.permission.service.IRoleUserRelationService;
import com.ejianc.foundation.permission.vo.AppVO;
import com.ejianc.foundation.permission.vo.RoleAppVO;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.foundation.permission.vo.RoleVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.builder.BuilderException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ComboRoleServiceImpl
extends BaseServiceImpl<ComboRoleMapper, ComboRoleEntity>
implements IComboRoleService {
    private static final String ROLE_BILL_CODE = "IDM_ROLE";
    @Autowired
    private ComboRoleMapper mapper;
    @Autowired
    private IComboEnterpriseService comboEnterpriseService;
    @Autowired
    private IRoleService roleService;
    @Autowired
    private IEmployeeService employeeService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IRoleUserRelationService roleUserRelationService;
    @Autowired
    private IOrgService orgService;
    @Autowired
    private IRoleAppRelationService roleAppRelationService;
    @Autowired
    private IComboAppService comboAppService;
    @Autowired
    private IAppService appService;

    @Override
    public IPage<RoleVO> queryPage(Map<String, Object> params, boolean isEs) {
        if (params.get("pageIndex") != null) {
            Integer pn = Integer.parseInt(params.get("pageIndex").toString());
            pn = pn - 1 < 0 ? 1 : pn;
            long startLine = (pn - 1) * Integer.parseInt(params.get("pageSize").toString());
            params.put("startLine", startLine);
        }
        Long count = this.mapper.countByProPerties(params);
        Page page = new Page();
        if (count > 0L) {
            List<RoleVO> roleVO = this.mapper.queryPageByProperties(params);
            page.setRecords(roleVO);
        } else {
            page.setRecords(null);
        }
        if (params.get("pageIndex") != null) {
            page.setCurrent((long)Integer.parseInt(params.get("pageIndex").toString()));
            page.setSize((long)Integer.parseInt(params.get("pageSize").toString()));
            page.setTotal(count.longValue());
        }
        return page;
    }

    @Override
    @Transactional
    public CommonResponse<String> delete(List<ComboRoleEntity> roleVos) {
        for (ComboRoleEntity roleVo : roleVos) {
            this.mapper.deleteAuthRole(roleVo.getComboId(), roleVo.getRoleId());
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CommonResponse<String> saveComboRole(ComboRoleVO comboRoleVO) {
        List<Long> tenantIds;
        if (comboRoleVO.getComboId() == null) return CommonResponse.error((String)"\u5957\u9910id\u4e0d\u80fd\u4e3a\u7a7a");
        List<RoleVO> roleVo = comboRoleVO.getRoleVO();
        if (roleVo == null || roleVo.size() <= 0) return CommonResponse.error((String)"\u4fdd\u5b58\u89d2\u8272\u6570\u636e\u4e3a\u7a7a");
        ArrayList<ComboRoleEntity> roleList = new ArrayList<ComboRoleEntity>();
        for (RoleVO vo : roleVo) {
            ComboRoleEntity entity = new ComboRoleEntity();
            entity.setRoleId(vo.getId());
            entity.setComboId(comboRoleVO.getComboId());
            roleList.add(entity);
        }
        if (roleList.size() > 0) {
            this.saveOrUpdateBatch(roleList, roleList.size(), false);
        }
        HashMap<String, Object> params1 = new HashMap<String, Object>();
        params1.put("comboId", comboRoleVO.getComboId());
        IPage<AppVO> pageData = this.comboAppService.queryPage(params1, false);
        HashMap<Long, AppVO> comboAppMap = new HashMap<Long, AppVO>();
        if (pageData.getRecords() != null && pageData.getRecords().size() > 0) {
            for (AppVO app : pageData.getRecords()) {
                comboAppMap.put(app.getId(), app);
            }
        }
        if ((tenantIds = this.comboEnterpriseService.queryTenantIdBycomboId(comboRoleVO.getComboId())) == null || tenantIds.size() <= 0) return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
        for (Long tenantId : tenantIds) {
            List<RoleVO> roleVOs = this.mapper.queryRoleByEnterpriseId(tenantId);
            if (roleVOs == null || roleVOs.size() == 0) {
                for (RoleVO roleVO : roleVo) {
                    OrgVO orgVo = this.orgService.findOrgByTenantId(tenantId);
                    EmployeeVO employeeVO = this.employeeService.querySuperEmployeeByTenantId(tenantId);
                    if (employeeVO == null) {
                        throw new BusinessException("\u672a\u67e5\u8be2\u5230\u79df\u6237:" + tenantId + "\u7684\u8d85\u7ea7\u7ba1\u7406\u5458\u4fe1\u606f");
                    }
                    RoleEntity entity = (RoleEntity)((Object)BeanMapper.map((Object)roleVO, RoleEntity.class));
                    CommonResponse roleResponse = this.billCodeApi.getCodeBatchByRuleCode(ROLE_BILL_CODE, tenantId);
                    if (!roleResponse.isSuccess()) {
                        throw new BuilderException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                    }
                    entity.setCode((String)roleResponse.getData());
                    entity.setSourceId(roleVO.getId());
                    entity.setId(null);
                    entity.setCreateTime(null);
                    entity.setCreateUserCode(null);
                    entity.setUpdateTime(null);
                    entity.setUpdateUserCode(null);
                    entity.setTenantId(tenantId);
                    entity.setOrgId(orgVo.getId());
                    this.roleService.saveOrUpdate((Object)entity, false);
                    ArrayList<RoleUserRelationVO> data = new ArrayList<RoleUserRelationVO>();
                    RoleUserRelationVO roleUserRelationVO = new RoleUserRelationVO();
                    roleUserRelationVO.setAuthOrgId(employeeVO.getOrgId());
                    roleUserRelationVO.setEmployeeId(employeeVO.getId());
                    roleUserRelationVO.setJobId(employeeVO.getJobId());
                    roleUserRelationVO.setProperty(String.valueOf(employeeVO.getJobType()));
                    roleUserRelationVO.setRoleId(entity.getId());
                    roleUserRelationVO.setUserId(employeeVO.getUserId());
                    roleUserRelationVO.setTenantId(tenantId);
                    roleUserRelationVO.setCreateUserCode("");
                    data.add(roleUserRelationVO);
                    this.roleUserRelationService.saveRoleUser(data);
                    if (comboAppMap == null || comboAppMap.size() <= 0) continue;
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("roleId", roleVO.getId());
                    IPage<AppVO> dataApp = this.roleAppRelationService.queryPage(params, false);
                    if (dataApp.getRecords().size() <= 0) continue;
                    ArrayList<AppVO> addApps = new ArrayList<AppVO>();
                    for (Object app : dataApp.getRecords()) {
                        if (comboAppMap.get(app.getId()) == null) continue;
                        addApps.add((AppVO)app);
                    }
                    if (addApps == null || addApps.size() <= 0) continue;
                    RoleAppVO roleAppVO = new RoleAppVO();
                    roleAppVO.setAppVO(addApps);
                    roleAppVO.setRoleId(entity.getId());
                    this.appService.saveRoleApp(roleAppVO);
                }
                continue;
            }
            if (roleVOs == null || roleVOs.size() <= 0) continue;
            HashMap roleMap = new HashMap();
            roleVOs.forEach(e -> roleMap.put(e.getSourceId(), e));
            for (RoleVO roleVO : roleVo) {
                Object app;
                if (roleMap.get(roleVO.getId()) != null) continue;
                OrgVO orgVo = this.orgService.findOrgByTenantId(tenantId);
                EmployeeVO employeeVO = this.employeeService.querySuperEmployeeByTenantId(tenantId);
                if (employeeVO == null) {
                    throw new BusinessException("\u672a\u67e5\u8be2\u5230\u79df\u6237:" + tenantId + "\u7684\u8d85\u7ea7\u7ba1\u7406\u5458\u4fe1\u606f");
                }
                RoleEntity entity = (RoleEntity)((Object)BeanMapper.map((Object)roleVO, RoleEntity.class));
                CommonResponse roleResponse = this.billCodeApi.getCodeBatchByRuleCode(ROLE_BILL_CODE, tenantId);
                if (!roleResponse.isSuccess()) {
                    throw new BuilderException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
                entity.setCode((String)roleResponse.getData());
                entity.setSourceId(roleVO.getId());
                entity.setId(null);
                entity.setCreateTime(null);
                entity.setCreateUserCode(null);
                entity.setUpdateTime(null);
                entity.setUpdateUserCode(null);
                entity.setTenantId(tenantId);
                entity.setOrgId(orgVo.getId());
                this.roleService.saveOrUpdate((Object)entity, false);
                ArrayList<RoleUserRelationVO> data = new ArrayList<RoleUserRelationVO>();
                RoleUserRelationVO roleUserRelationVO = new RoleUserRelationVO();
                roleUserRelationVO.setAuthOrgId(employeeVO.getOrgId());
                roleUserRelationVO.setEmployeeId(employeeVO.getId());
                roleUserRelationVO.setJobId(employeeVO.getJobId());
                roleUserRelationVO.setProperty(String.valueOf(employeeVO.getJobType()));
                roleUserRelationVO.setRoleId(entity.getId());
                roleUserRelationVO.setUserId(employeeVO.getUserId());
                roleUserRelationVO.setTenantId(tenantId);
                roleUserRelationVO.setCreateUserCode("");
                data.add(roleUserRelationVO);
                this.roleUserRelationService.saveRoleUser(data);
                if (comboAppMap == null || comboAppMap.size() <= 0) continue;
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("roleId", roleVO.getId());
                IPage<AppVO> dataApp = this.roleAppRelationService.queryPage(params, false);
                if (dataApp.getRecords().size() <= 0) continue;
                ArrayList<AppVO> addApps = new ArrayList<AppVO>();
                app = dataApp.getRecords().iterator();
                while (app.hasNext()) {
                    AppVO app2 = (AppVO)app.next();
                    if (comboAppMap.get(app2.getId()) == null) continue;
                    addApps.add(app2);
                }
                if (addApps == null || addApps.size() <= 0) continue;
                RoleAppVO roleAppVO = new RoleAppVO();
                roleAppVO.setAppVO(addApps);
                roleAppVO.setRoleId(entity.getId());
                this.appService.saveRoleApp(roleAppVO);
            }
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
    }
}

