package com.ejianc.foundation.orgcenter.bean;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 员工bean
 * 
 * @author guominga
 *
 */
@TableName("ejc_idm_employee")
public class EmployeeEntity extends BaseEntity {

	private static final long serialVersionUID = 1L;

	/**
	 * 公司ID
	 */
	@TableField(value = "org_id")
	private Long orgId;

	/**
	 * 部门ID
	 */
	@TableField(value = "dept_id")
	private Long deptId;

	/**
	 * 岗位ID
	 */
	@TableField(value = "post_id")
	private Long postId;

	/**
	 * 用户ID
	 */
	@TableField(value = "user_id")
	private Long userId;

	/**
	 * 员工编号
	 */
	@TableField(value = "code")
	private String code;

	/**
	 * 员工名称
	 */
	@TableField(value = "name")
	private String name;

	/**
	 * 头像
	 */
	@TableField(value = "photo_path")
	private String photoPath;

	/**
	 * 身份证号
	 */
	@TableField(value = "idcard")
	private String idcard;

	/**
	 * 出生日期
	 */
	@TableField(value = "birthday")
	private Date birthday;

	/**
	 * 性别 1：男 2：女
	 */
	@TableField(value = "sex")
	private Integer sex;

	/**
	 * 手机号码
	 */
	@TableField(value = "mobile_phone")
	private String mobilePhone;

	/**
	 * 其他电话
	 */
	@TableField(value = "other_phone")
	private String otherPhone;

	/**
	 * 员工状态（1:在职，2：离职， 3：退休， 4：退休返聘,5：派驻人员，6：外借人员，7：外聘员工，8：待岗人员，9：过路人员，10：三庄人员，
	 * 	       11：挂证人员，12：应聘人员，13：其它, 14:劳务派遣）
	 */
	@TableField(value = "employee_type")
	private Integer employeeType;

	/**
	 * 备注
	 */
	@TableField(value = "note")
	private String note;

	/**
	 * 状态标识 (1:启用，0：停用)
	 */
	@TableField(value = "state")
	private Integer state;

	/**
	 * 排序
	 */
	@TableField(value = "sequence")
	private Integer sequence;

	/**
	 * 入职时间
	 */
	@TableField(value = "work_time")
	private Date workTime;

	@TableField(value = "source_id")
	private String sourceId; // 来源组织id

	@TableField(value = "system_id")
	private String systemId; // 系统id

	@TableField(value = "nation")
	private String nation; // 民族 直接使用汉字

	@TableField(value = "confirmation_date")
	private Date confirmationDate; // 转正日期

	@TableField(value = "insured_date")
	private Date insuredDate; // 参保日期

	@TableField(value = "resignation_date")
	private Date resignationDate; // 离职日期

	@TableField(value = "insured_end_date")
	private Date insuredEndDate; // 停保日期

	@TableField(value = "term_of_labor")
	private String termOfLabor; // 劳动合同期限

	@TableField(value = "social_security_num")
	private String socialSecurityNum; // 社会保障号

	@TableField(value = "specialties")
	private String specialties; // 特长
	/**
	 * 用户签名图片路径
	 */
	@TableField(value = "user_signature_path")
	private String userSignaturePath;

	/**
	 * 华康医疗----start----
	 */
	@TableField(value = "post_rank_type")
	private String postRankType; // 职级类别

	@TableField(value = "post_rank")
	private String postRank; // 职级
	/**
	 * 华康医疗----end----
	 */

	@TableField(exist=false)
	@SubEntity(serviceName="empEduService")
	private List<EmpEduEntity> empEduList = new ArrayList<>(); // 学历信息
	@TableField(exist=false)
	@SubEntity(serviceName="empCareerService")
	private List<EmpCareerEntity> empCareerList = new ArrayList<>(); // 入职经历
	@TableField(exist=false)
	@SubEntity(serviceName="empBankService")
	private List<EmpBankEntity> empBankList = new ArrayList<>(); // 员工银行信息

	public String getUserSignaturePath() {
		return userSignaturePath;
	}

	public void setUserSignaturePath(String userSignaturePath) {
		this.userSignaturePath = userSignaturePath;
	}

	public Long getDeptId() {
		return deptId;
	}

	public void setDeptId(Long deptId) {
		this.deptId = deptId;
	}

	public Long getPostId() {
		return postId;
	}

	public void setPostId(Long postId) {
		this.postId = postId;
	}

	public Long getUserId() {
		return userId;
	}

	public void setUserId(Long userId) {
		this.userId = userId;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getPhotoPath() {
		return photoPath;
	}

	public void setPhotoPath(String photoPath) {
		this.photoPath = photoPath;
	}

	public String getIdcard() {
		return idcard;
	}

	public void setIdcard(String idcard) {
		this.idcard = idcard;
	}

	public Date getBirthday() {
		return birthday;
	}

	public void setBirthday(Date birthday) {
		this.birthday = birthday;
	}

	public Integer getSex() {
		return sex;
	}

	public void setSex(Integer sex) {
		this.sex = sex;
	}

	public String getMobilePhone() {
		return mobilePhone;
	}

	public void setMobilePhone(String mobilePhone) {
		this.mobilePhone = mobilePhone;
	}

	public String getOtherPhone() {
		return otherPhone;
	}

	public void setOtherPhone(String otherPhone) {
		this.otherPhone = otherPhone;
	}

	public Integer getEmployeeType() {
		return employeeType;
	}

	public void setEmployeeType(Integer employeeType) {
		this.employeeType = employeeType;
	}

	public String getNote() {
		return note;
	}

	public void setNote(String note) {
		this.note = note;
	}

	public Integer getState() {
		return state;
	}

	public void setState(Integer state) {
		this.state = state;
	}

	public Integer getSequence() {
		return sequence;
	}

	public void setSequence(Integer sequence) {
		this.sequence = sequence;
	}

	public Date getWorkTime() {
		return workTime;
	}

	public void setWorkTime(Date workTime) {
		this.workTime = workTime;
	}

	public Long getOrgId() {
		return orgId;
	}

	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public String getSourceId() {
		return sourceId;
	}

	public void setSourceId(String sourceId) {
		this.sourceId = sourceId;
	}

	public String getSystemId() {
		return systemId;
	}

	public void setSystemId(String systemId) {
		this.systemId = systemId;
	}

	public String getNation() {
		return nation;
	}

	public void setNation(String nation) {
		this.nation = nation;
	}

	public Date getConfirmationDate() {
		return confirmationDate;
	}

	public void setConfirmationDate(Date confirmationDate) {
		this.confirmationDate = confirmationDate;
	}

	public Date getInsuredDate() {
		return insuredDate;
	}

	public void setInsuredDate(Date insuredDate) {
		this.insuredDate = insuredDate;
	}

	public Date getResignationDate() {
		return resignationDate;
	}

	public void setResignationDate(Date resignationDate) {
		this.resignationDate = resignationDate;
	}

	public Date getInsuredEndDate() {
		return insuredEndDate;
	}

	public void setInsuredEndDate(Date insuredEndDate) {
		this.insuredEndDate = insuredEndDate;
	}

	public String getTermOfLabor() {
		return termOfLabor;
	}

	public void setTermOfLabor(String termOfLabor) {
		this.termOfLabor = termOfLabor;
	}

	public String getSocialSecurityNum() {
		return socialSecurityNum;
	}

	public void setSocialSecurityNum(String socialSecurityNum) {
		this.socialSecurityNum = socialSecurityNum;
	}

	public String getSpecialties() {
		return specialties;
	}

	public void setSpecialties(String specialties) {
		this.specialties = specialties;
	}

	public List<EmpEduEntity> getEmpEduList() {
		return empEduList;
	}

	public void setEmpEduList(List<EmpEduEntity> empEduList) {
		this.empEduList = empEduList;
	}

	public List<EmpCareerEntity> getEmpCareerList() {
		return empCareerList;
	}

	public void setEmpCareerList(List<EmpCareerEntity> empCareerList) {
		this.empCareerList = empCareerList;
	}

	public List<EmpBankEntity> getEmpBankList() {
		return empBankList;
	}

	public void setEmpBankList(List<EmpBankEntity> empBankList) {
		this.empBankList = empBankList;
	}

	public String getPostRankType() {
		return postRankType;
	}

	public void setPostRankType(String postRankType) {
		this.postRankType = postRankType;
	}

	public String getPostRank() {
		return postRank;
	}

	public void setPostRank(String postRank) {
		this.postRank = postRank;
	}
}
