package com.ejianc.foundation.workbench.element.node;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.ejianc.foundation.workbench.element.ElementTraverser;
import com.ejianc.foundation.workbench.element.visitor.ElementVisitor;

import java.io.Serializable;
import java.util.List;

public abstract class Element implements Serializable {

    private static final long serialVersionUID = 3653485705983776601L;

    private String tag;

    private JSONObject style;

    private List<Element> subElements;

    @JSONField(serialize = false, deserialize = false)
    private Element parent;

    @JSONField(serialize = false, deserialize = false)
    private Integer siblingIndex;


    protected Attributes attributes;

    private Element() {}

    public Element(String tag) {
        this.tag = tag;

        attributes = new Attributes();
    }

    public String getEid() {
        return attributes.get("eid");
    }

    public void setEid(String eid) {
        attributes.put("eid", eid);
    }

    public String getTag() {
        return tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public JSONObject getStyle() {
        return style;
    }

    public void setStyle(JSONObject style) {
        this.style = style;
    }

    public List<Element> getSubElements() {
        return subElements;
    }

    public void setSubElements(List<Element> subElements) {
        this.subElements = subElements;
    }


    public Element getParent() {
        return parent;
    }

    public void setParent(Element parent) {
        this.parent = parent;
    }

    public Integer getSiblingIndex() {
        return siblingIndex;
    }

    public void setSiblingIndex(Integer siblingIndex) {
        this.siblingIndex = siblingIndex;
    }

    public void attr(String key, String value) {
        attributes.put(key, value);
    }

    public String attr(String key) {
        return attributes.get(key);
    }

    public String html() {
        StringBuilder accumulation = new StringBuilder();

        html(accumulation);

        return accumulation.toString();
    }

    private  <T extends Appendable> T html(T accumulation) {
        ElementVisitor elementVisitor = new ElementVisitor(accumulation);
        ElementTraverser.traverse(elementVisitor, this);

        return accumulation;
    }
}