package com.ejianc.foundation.resource.service.impl;

import com.ejianc.foundation.resource.bean.ResourceLogEntity;
import com.ejianc.foundation.resource.bean.ResourceTypeEntity;
import com.ejianc.foundation.resource.service.IResourceLogService;
import com.ejianc.foundation.resource.service.IResourceTypeService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.foundation.resource.mapper.ResourceTenantMapper;
import com.ejianc.foundation.resource.bean.ResourceTenantEntity;
import com.ejianc.foundation.resource.service.IResourceTenantService;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.List;

/**
 * 租户已分配资源表
 *
 * @author generator
 */
@Service("resourceTenantService")
public class ResourceTenantServiceImpl extends BaseServiceImpl<ResourceTenantMapper, ResourceTenantEntity> implements IResourceTenantService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IResourceLogService logService;
    @Autowired
    private IResourceTypeService typeService;
    @Autowired
    private ResourceTenantMapper tenantMapper;

    @Override
    @Transactional( rollbackFor = Exception.class )
    public CommonResponse<Boolean> checkAndUseResource(String resourceCode, Long tenantId, BigDecimal useNum, String opType, String describe) {


        ResourceTypeEntity typeEntity = typeService.queryByCode(resourceCode);
        if(typeEntity == null){
            /** 没找到该资源，认为可以通过 */
            logger.info("checkAndUseResource 没找到该资源，认为可以通过,resourceCode={}, tenantId={}, useNum={}, opType={},describe={}",resourceCode, tenantId, useNum, opType,describe);
            return CommonResponse.error("资源编码为【"+resourceCode+"】的资源不存在，请确认编码是否正确！！");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, tenantId));
        param.getParams().put("code", new Parameter(QueryParam.EQ, resourceCode));
        param.getParams().put("state", new Parameter(QueryParam.EQ, "open"));
        List<ResourceTenantEntity> tenantEntities = queryList(param, false);
        if (ListUtil.isNotEmpty(tenantEntities)) {
            ResourceLogEntity logEntity = new ResourceLogEntity();
            logEntity.setOpValue(useNum.toPlainString());
            ResourceTenantEntity entity = tenantEntities.get(0);
            logEntity.setTenantId(tenantId);
            logEntity.setBeforeValue(entity.getNum());
            logEntity.setCode(resourceCode);
            logEntity.setName(typeEntity.getName());
            logEntity.setOpType(describe);
            if ("add".equals(opType)) {
                try {
                    BigDecimal before = new BigDecimal(entity.getNum());
                    BigDecimal after = before.add(useNum);
                    entity.setNum(after.toPlainString());
                    logEntity.setAfterValue(entity.getNum());
                } catch (NumberFormatException e) {
                    return CommonResponse.error("资源数量格式不正确！只能填写整数、小数等！");
                }
                saveOrUpdate(entity, false);
            } else {
                try {
                    BigDecimal before = new BigDecimal(entity.getNum());
                    BigDecimal after = before.subtract(useNum);
                    if (after.compareTo(new BigDecimal("0")) < 0) {
                        return CommonResponse.error(typeEntity.getName() + "剩余数量不足以进行此次扣减操作！");
                    }
                    int res = tenantMapper.updateTenantResourceNum(useNum.toPlainString(),tenantId, InvocationInfoProxy.getUsercode(),resourceCode);
                    if (res == 0) {
                        return CommonResponse.error(typeEntity.getName() + "剩余数量不足以进行此次扣减操作！");
                    }
                    entity = selectById(entity.getId());
                    logEntity.setAfterValue(entity.getNum());
                    logEntity.setBeforeValue((new BigDecimal(entity.getNum()).add(useNum)).toPlainString());
                } catch (NumberFormatException e) {
                    return CommonResponse.error("资源数量格式不正确！只能是整数或者小数！");
                }
            }
            logService.saveOrUpdate(logEntity, false);

        }else {
            return CommonResponse.error("贵公司尚未购买【"+typeEntity.getName()+"】增值服务，该功能不可用！如有需求请联系实施人员！");
        }
        return CommonResponse.success(true);
    }

    @Override
    public CommonResponse<Boolean> checkResource(String resourceCode, Long tenantId) {
        ResourceTypeEntity typeEntity = typeService.queryByCode(resourceCode);
        if(typeEntity == null){
            /** 没找到该资源，认为可以通过 */
            logger.info("checkResource 没找到该资源，认为可以通过,resourceCode={}, tenantId={} ",resourceCode, tenantId);
            return CommonResponse.error("资源编码为【"+resourceCode+"】的资源不存在，请确认编码是否正确！！");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, tenantId));
        param.getParams().put("code", new Parameter(QueryParam.EQ, resourceCode));
        param.getParams().put("state", new Parameter(QueryParam.EQ, "open"));
        List<ResourceTenantEntity> tenantEntities = queryList(param, false);
        if (ListUtil.isEmpty(tenantEntities)) {
            return CommonResponse.error("贵公司尚未购买【"+typeEntity.getName()+"】增值服务，该功能不可用！如有需求请联系实施人员！");
        }
        return CommonResponse.success(true);
    }
}
