/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.permission.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.foundation.cache.PermissionCacheManage;
import com.ejianc.foundation.oms.bean.ComboRoleEntity;
import com.ejianc.foundation.oms.service.IComboRoleService;
import com.ejianc.foundation.orgcenter.bean.OrgEntity;
import com.ejianc.foundation.orgcenter.service.IOrgService;
import com.ejianc.foundation.permission.bean.MangerUserRoleRelationEntity;
import com.ejianc.foundation.permission.bean.RoleAppRelationEntity;
import com.ejianc.foundation.permission.bean.RoleButtonRelationEntity;
import com.ejianc.foundation.permission.bean.RoleEntity;
import com.ejianc.foundation.permission.bean.RolePostRelationEntity;
import com.ejianc.foundation.permission.bean.RoleUserRelationEntity;
import com.ejianc.foundation.permission.mapper.RoleAppRelationMapper;
import com.ejianc.foundation.permission.mapper.RoleButtonRelationMapper;
import com.ejianc.foundation.permission.mapper.RoleMapper;
import com.ejianc.foundation.permission.mapper.RolePostRelationMapper;
import com.ejianc.foundation.permission.mapper.RoleUserRelationMapper;
import com.ejianc.foundation.permission.service.IMangerUserRoleRelationService;
import com.ejianc.foundation.permission.service.IRoleAppRelationService;
import com.ejianc.foundation.permission.service.IRoleButtonRelationService;
import com.ejianc.foundation.permission.service.IRolePostRelationService;
import com.ejianc.foundation.permission.service.IRoleService;
import com.ejianc.foundation.permission.service.IRoleUserRelationService;
import com.ejianc.foundation.permission.vo.AppVO;
import com.ejianc.foundation.permission.vo.ButtonVO;
import com.ejianc.foundation.permission.vo.RolePostRelationVO;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.foundation.permission.vo.RoleVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.usercenter.bean.UserEntity;
import com.ejianc.foundation.usercenter.service.IUserService;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RoleServiceImpl
extends BaseServiceImpl<RoleMapper, RoleEntity>
implements IRoleService {
    private static final String ROLE_BILL_CODE = "IDM_ROLE";
    private static final String CURRENTROLE_APP_KEY = "currentrole_app_key:";
    private static final String CURRENTROLE_USER_KEY = "currentrole_user_key:";
    private static final String CURRENTROLE_POST_KEY = "currentrole_post_key:";
    private static final String CURRENTROLE_APP_BUTTON_KEY = "currentrole_app_button_key:";
    @Autowired
    private IRoleAppRelationService roleAppRelationService;
    @Autowired
    private IRoleButtonRelationService roleButtonRelationService;
    @Autowired
    private RoleAppRelationMapper appmapper;
    @Autowired
    private RoleButtonRelationMapper buttonmapper;
    @Autowired
    private IRoleUserRelationService roleUserRelationService;
    @Autowired
    private RoleUserRelationMapper usermapper;
    @Autowired
    private RolePostRelationMapper rolePostRelationMapper;
    @Autowired
    private IRolePostRelationService rolePostRelationService;
    @Autowired
    private IUserService userService;
    @Autowired
    private IOrgService orgService;
    @Autowired
    private PermissionCacheManage permissionCacheManage;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IComboRoleService comboRoleService;
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private IMangerUserRoleRelationService roleRelationService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Transactional
    public CommonResponse<String> save(RoleVO roleVO, boolean syncEs, boolean levelAuthOpen) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        RoleEntity entity = new RoleEntity();
        if (roleVO.getFkCopy()) {
            Long sourceRoleId = roleVO.getId();
            if (roleVO.getCopyToOrgIds() == null || roleVO.getCopyToOrgIds().size() <= 0) {
                throw new BusinessException("\u7f3a\u5c11\u76ee\u7684\u7ec4\u7ec7\uff0c\u8bf7\u5148\u586b\u5199");
            }
            List codes = new ArrayList();
            ArrayList<RoleEntity> addRoleEntitys = new ArrayList<RoleEntity>();
            CommonResponse roleResponse = this.billCodeApi.getCodeBatchByRuleCode(ROLE_BILL_CODE, tenantId, roleVO.getCopyToOrgIds().size());
            if (!roleResponse.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            codes = (List)roleResponse.getData();
            roleVO.setDr(Integer.valueOf(0));
            if (StringUtils.isNotBlank((CharSequence)roleVO.getCompileUserName())) {
                roleVO.setCompileUserName(InvocationInfoProxy.getUsercode());
            }
            roleVO.setState(Integer.valueOf(1));
            roleVO.setId(null);
            if (StringUtils.isBlank((CharSequence)roleVO.getCompileUserName())) {
                UserEntity userEntity = (UserEntity)((Object)this.userService.getById(InvocationInfoProxy.getUserid()));
                roleVO.setCompileUserName(userEntity != null ? userEntity.getUserName() : "");
            }
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("roleId", sourceRoleId);
            List<AppVO> appvos = this.appmapper.queryPageByProperties(param);
            ArrayList<RoleAppRelationEntity> appList = new ArrayList<RoleAppRelationEntity>();
            List<ButtonVO> btnvos = this.buttonmapper.queryProperties(param);
            ArrayList<RoleButtonRelationEntity> btnList = new ArrayList<RoleButtonRelationEntity>();
            for (Long orgId : roleVO.getCopyToOrgIds()) {
                entity = (RoleEntity)((Object)BeanMapper.map((Object)roleVO, RoleEntity.class));
                entity.setId(IdWorker.getId());
                entity.setOrgId(orgId);
                entity.setCode((String)codes.get(roleVO.getCopyToOrgIds().indexOf(orgId)));
                addRoleEntitys.add(entity);
                for (AppVO appVO : appvos) {
                    RoleAppRelationEntity rentity = new RoleAppRelationEntity();
                    rentity.setAppId(appVO.getId());
                    rentity.setRoleId(entity.getId());
                    rentity.setDr(0);
                    appList.add(rentity);
                }
                for (ButtonVO buttonVO : btnvos) {
                    RoleButtonRelationEntity bentity = new RoleButtonRelationEntity();
                    bentity.setAppId(buttonVO.getAppId());
                    bentity.setButtonId(buttonVO.getId());
                    bentity.setRoleId(entity.getId());
                    btnList.add(bentity);
                }
            }
            if (addRoleEntitys.size() > 0) {
                this.saveOrUpdateBatch(addRoleEntitys, addRoleEntitys.size(), syncEs);
            }
            if (appList.size() > 0) {
                this.roleAppRelationService.saveOrUpdateBatch(appList, appList.size(), false);
            }
            if (btnList.size() > 0) {
                this.roleButtonRelationService.saveOrUpdateBatch(btnList, btnList.size(), false);
            }
            if (appList.size() > 0) {
                this.permissionCacheManage.putRoleAppsCache(entity.getId(), appvos);
            }
            if (!levelAuthOpen || Objects.equals("1", InvocationInfoProxy.getUserType()) || addRoleEntitys.size() <= 0) return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
            ArrayList<MangerUserRoleRelationEntity> roleRelationEntities = new ArrayList<MangerUserRoleRelationEntity>();
            for (RoleEntity role : addRoleEntitys) {
                OrgEntity orgEntity = (OrgEntity)((Object)this.orgService.selectById(role.getOrgId()));
                MangerUserRoleRelationEntity relationEntity = new MangerUserRoleRelationEntity();
                relationEntity.setOrgId(role.getOrgId());
                relationEntity.setOrgName(orgEntity.getName());
                relationEntity.setRoleId(role.getId());
                relationEntity.setRoleName(role.getName());
                relationEntity.setUserId(InvocationInfoProxy.getUserid());
                roleRelationEntities.add(relationEntity);
            }
            this.roleRelationService.saveOrUpdateBatch(roleRelationEntities);
            return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
        } else if (roleVO.getId() != null) {
            RoleEntity oldEntity = (RoleEntity)((Object)super.getById((Serializable)roleVO.getId()));
            oldEntity.setCode(roleVO.getCode());
            QueryParam param = new QueryParam();
            param.getParams().put("code", new Parameter("eq", (Object)roleVO.getCode()));
            param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            List list = this.queryList(param, false);
            if (ListUtil.isNotEmpty((List)list) && !((RoleEntity)((Object)list.get(0))).getId().equals(roleVO.getId())) {
                throw new BusinessException("\u89d2\u8272\u7f16\u7801\u91cd\u590d\uff01");
            }
            oldEntity.setName(roleVO.getName());
            oldEntity.setSequence(roleVO.getSequence());
            oldEntity.setNote(roleVO.getNote());
            oldEntity.setState(oldEntity.getState());
            oldEntity.setProperty(roleVO.getProperty());
            oldEntity.setCompileUserName(oldEntity.getCompileUserName());
            entity = (RoleEntity)((Object)BeanMapper.map((Object)((Object)oldEntity), RoleEntity.class));
            this.saveOrUpdate((Object)entity, syncEs);
            if (!levelAuthOpen) return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("roleId", new Parameter("eq", (Object)entity.getId()));
            List roleRelationEntities = this.roleRelationService.queryList(queryParam);
            if (!ListUtil.isNotEmpty((List)roleRelationEntities)) return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
            for (MangerUserRoleRelationEntity relationEntity : roleRelationEntities) {
                relationEntity.setRoleName(entity.getName());
            }
            this.roleRelationService.saveOrUpdateBatch(roleRelationEntities);
            return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
        } else {
            if (StringUtils.isEmpty((CharSequence)roleVO.getCode())) {
                CommonResponse roleResponse = this.billCodeApi.getCodeBatchByRuleCode(ROLE_BILL_CODE, tenantId);
                if (!roleResponse.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                roleVO.setCode((String)roleResponse.getData());
            } else {
                QueryParam param = new QueryParam();
                param.getParams().put("code", new Parameter("eq", (Object)roleVO.getCode()));
                param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
                List list = this.queryList(param, false);
                if (ListUtil.isNotEmpty((List)list)) {
                    throw new BusinessException("\u89d2\u8272\u7f16\u7801\u91cd\u590d\uff01");
                }
            }
            roleVO.setOrgId(InvocationInfoProxy.getOrgId());
            roleVO.setDr(Integer.valueOf(0));
            if (StringUtils.isNotBlank((CharSequence)roleVO.getCompileUserName())) {
                UserEntity userEntity = (UserEntity)((Object)this.userService.getById(InvocationInfoProxy.getUserid()));
                roleVO.setCompileUserName(userEntity != null ? userEntity.getUserName() : "");
            }
            roleVO.setState(Integer.valueOf(1));
            entity = (RoleEntity)((Object)BeanMapper.map((Object)roleVO, RoleEntity.class));
            this.saveOrUpdate((Object)entity, syncEs);
            if (!levelAuthOpen || Objects.equals("1", InvocationInfoProxy.getUserType())) return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
            MangerUserRoleRelationEntity relationEntity = new MangerUserRoleRelationEntity();
            OrgEntity orgVO = (OrgEntity)((Object)this.orgService.selectById(entity.getOrgId()));
            relationEntity.setOrgId(entity.getOrgId());
            relationEntity.setOrgName(orgVO.getName());
            relationEntity.setRoleId(entity.getId());
            relationEntity.setRoleName(entity.getName());
            relationEntity.setUserId(InvocationInfoProxy.getUserid());
            this.roleRelationService.saveOrUpdate((Object)relationEntity);
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    @Transactional
    public CommonResponse<String> delete(List<Long> ids) {
        QueryWrapper queryWrapper;
        OrgEntity orgEntity = (OrgEntity)((Object)this.orgService.getById(InvocationInfoProxy.getOrgId()));
        if ("ORG-OMS".equals(orgEntity.getCode())) {
            queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"dr", (Object)0);
            queryWrapper.in((Object)"role_id", ids);
            List list = this.comboRoleService.list((Wrapper)queryWrapper);
            if (list != null && list.size() > 0) {
                List roleIds = list.stream().map(ComboRoleEntity::getRoleId).collect(Collectors.toList());
                List role = (List)this.listByIds(roleIds);
                String message = "";
                for (RoleEntity r : role) {
                    if (message.length() > 0) {
                        message = message + "\u3001" + r.getName();
                        continue;
                    }
                    message = message + r.getName();
                }
                throw new BusinessException(message + "\u5df2\u88ab\u5957\u9910\u5f15\u7528\uff0c\u8bf7\u5148\u5220\u9664\u5957\u9910\u4e0e\u89d2\u8272\u7684\u5173\u7cfb");
            }
        }
        super.removeByIds(ids);
        queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"role_id", ids);
        queryWrapper.eq((Object)"dr", (Object)0);
        List roleAppRelationList = this.roleAppRelationService.list((Wrapper)queryWrapper);
        if (roleAppRelationList != null && roleAppRelationList.size() > 0) {
            this.roleAppRelationService.delete(roleAppRelationList);
        }
        QueryWrapper userwrapper = new QueryWrapper();
        userwrapper.in((Object)"role_id", ids);
        userwrapper.eq((Object)"dr", (Object)0);
        List roleUserRelationList = this.roleUserRelationService.list((Wrapper)userwrapper);
        if (roleUserRelationList != null && roleUserRelationList.size() > 0) {
            ArrayList<Long> userIds = new ArrayList<Long>();
            roleUserRelationList.forEach(e -> userIds.add(e.getId()));
            this.roleUserRelationService.delete(userIds);
        }
        this.rolePostRelationService.deleteByRoleIds(ids);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @Override
    public RoleVO queryDetail(Long id) {
        RoleEntity entity = (RoleEntity)((Object)((RoleMapper)this.baseMapper).selectById(id));
        if (entity != null) {
            return (RoleVO)BeanMapper.map((Object)((Object)entity), RoleVO.class);
        }
        return null;
    }

    @Override
    public void refreshAuthCache() {
        QueryWrapper queryWrapper = new QueryWrapper();
        List roleList = ((RoleMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (roleList != null && roleList.size() > 0) {
            for (RoleEntity roleEntity : roleList) {
                List<AppVO> appVos = null;
                if (999999L == roleEntity.getTenantId()) {
                    appVos = this.appmapper.queryAuthListByRoleId(roleEntity.getId());
                } else {
                    HashMap<String, Object> queryParam = new HashMap<String, Object>();
                    queryParam.put("tenantId", roleEntity.getTenantId());
                    queryParam.put("roleId", roleEntity.getId());
                    appVos = this.appmapper.queryPageByProperties(queryParam);
                }
                QueryWrapper roleUserQueryWrapper = new QueryWrapper();
                roleUserQueryWrapper.eq((Object)"role_id", (Object)roleEntity.getId());
                List roleUserRelationEntities = this.usermapper.selectList((Wrapper)roleUserQueryWrapper);
                List roleUserRelationVos = BeanMapper.mapList((Iterable)roleUserRelationEntities, RoleUserRelationVO.class);
                QueryWrapper rolePostQueryWrapper = new QueryWrapper();
                rolePostQueryWrapper.eq((Object)"role_id", (Object)roleEntity.getId());
                List rolePostRelationEntities = this.rolePostRelationMapper.selectList((Wrapper)rolePostQueryWrapper);
                List rolePostRelationVos = BeanMapper.mapList((Iterable)rolePostRelationEntities, RolePostRelationVO.class);
                this.cacheManager.removeCache(CURRENTROLE_APP_KEY + roleEntity.getId());
                this.cacheManager.removeCache(CURRENTROLE_USER_KEY + roleEntity.getId());
                this.cacheManager.removeCache(CURRENTROLE_POST_KEY + roleEntity.getId());
                this.cacheManager.removeCache(CURRENTROLE_APP_BUTTON_KEY + roleEntity.getId());
                if (ListUtil.isNotEmpty(appVos)) {
                    HashMap<String, Object> param = new HashMap<String, Object>();
                    for (AppVO app : appVos) {
                        param.put("roleId", roleEntity.getId());
                        param.put("appId", app.getId());
                        param.put("dr", 0);
                        List<ButtonVO> btnVos = this.buttonmapper.queryProperties(param);
                        if (!ListUtil.isNotEmpty(btnVos)) continue;
                        app.setChildren(btnVos);
                    }
                }
                this.permissionCacheManage.putRoleAppsCache(roleEntity.getId(), appVos);
                this.permissionCacheManage.putRoleUsersCache(roleEntity.getId(), roleUserRelationVos);
                this.permissionCacheManage.putRolePostsCache(roleEntity.getId(), rolePostRelationVos);
            }
        }
    }

    @Override
    public List<Long> queryRoleIdstByCurrentUserId(Long userId, Long tenantId, UserContext userContext) {
        List<RolePostRelationEntity> rolePostEntities;
        QueryParam roleUserRelationParam = new QueryParam();
        roleUserRelationParam.getParams().put("user_id", new Parameter("eq", (Object)userId));
        roleUserRelationParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
        List entities = this.roleUserRelationService.queryList(roleUserRelationParam, false);
        ArrayList<Long> roleIds = new ArrayList<Long>();
        HashMap<Long, Long> roleIdMap = new HashMap<Long, Long>();
        if (entities != null && entities.size() > 0) {
            for (RoleUserRelationEntity entity : entities) {
                roleIds.add(entity.getRoleId());
                roleIdMap.put(entity.getRoleId(), entity.getRoleId());
            }
        }
        if ((rolePostEntities = this.rolePostRelationMapper.queryRolePostByUserId(userId, tenantId)) != null && rolePostEntities.size() > 0) {
            for (RolePostRelationEntity rolePostEntity : rolePostEntities) {
                if (rolePostEntity.getJobOrgId() == null || roleIdMap.containsKey(rolePostEntity.getRoleId())) continue;
                roleIds.add(rolePostEntity.getRoleId());
            }
        }
        roleIdMap.clear();
        return roleIds;
    }

    @Override
    public List<RoleVO> queryRoleByUserId(Long userId, Long tenantId) {
        QueryParam roleUserRelationParam = new QueryParam();
        roleUserRelationParam.getParams().put("user_id", new Parameter("eq", (Object)userId));
        roleUserRelationParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
        List entities = this.roleUserRelationService.queryList(roleUserRelationParam, false);
        ArrayList<Long> roleIds = null;
        if (entities != null && entities.size() > 0) {
            roleIds = new ArrayList<Long>();
            for (RoleUserRelationEntity entity : entities) {
                roleIds.add(entity.getRoleId());
            }
        }
        List list = (List)this.listByIds(roleIds);
        List back = null;
        if (list != null && list.size() > 0) {
            back = BeanMapper.mapList((Iterable)list, RoleVO.class);
        }
        return back;
    }
}

