/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.usercenter.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.facebody20191230.Client;
import com.aliyun.facebody20191230.models.AddFaceAdvanceRequest;
import com.aliyun.facebody20191230.models.AddFaceEntityRequest;
import com.aliyun.facebody20191230.models.AddFaceEntityResponse;
import com.aliyun.facebody20191230.models.AddFaceResponse;
import com.aliyun.facebody20191230.models.CompareFaceAdvanceRequest;
import com.aliyun.facebody20191230.models.CompareFaceResponse;
import com.aliyun.facebody20191230.models.CompareFaceResponseBody;
import com.aliyun.facebody20191230.models.CreateFaceDbRequest;
import com.aliyun.facebody20191230.models.CreateFaceDbResponse;
import com.aliyun.facebody20191230.models.DeleteFaceDbRequest;
import com.aliyun.facebody20191230.models.DeleteFaceDbResponse;
import com.aliyun.facebody20191230.models.DeleteFaceEntityRequest;
import com.aliyun.facebody20191230.models.DeleteFaceEntityResponse;
import com.aliyun.facebody20191230.models.DetectFaceAdvanceRequest;
import com.aliyun.facebody20191230.models.DetectFaceResponse;
import com.aliyun.facebody20191230.models.DetectFaceResponseBody;
import com.aliyun.facebody20191230.models.DetectLivingFaceAdvanceRequest;
import com.aliyun.facebody20191230.models.DetectLivingFaceResponse;
import com.aliyun.facebody20191230.models.DetectLivingFaceResponseBody;
import com.aliyun.facebody20191230.models.GetFaceEntityRequest;
import com.aliyun.facebody20191230.models.GetFaceEntityResponse;
import com.aliyun.facebody20191230.models.SearchFaceAdvanceRequest;
import com.aliyun.facebody20191230.models.SearchFaceResponse;
import com.aliyun.facebody20191230.models.SearchFaceResponseBody;
import com.aliyun.facebody20191230.models.UpdateFaceEntityRequest;
import com.aliyun.facebody20191230.models.UpdateFaceEntityResponse;
import com.aliyun.facebody20191230.models.VerifyFaceMaskRequest;
import com.aliyun.facebody20191230.models.VerifyFaceMaskResponse;
import com.aliyun.facebody20191230.models.VerifyFaceMaskResponseBody;
import com.aliyun.ocr20191230.models.RecognizeIdentityCardAdvanceRequest;
import com.aliyun.ocr20191230.models.RecognizeIdentityCardResponse;
import com.aliyun.ocr20191230.models.RecognizeIdentityCardResponseBody;
import com.aliyun.ocr20191230.models.RecognizePdfAdvanceRequest;
import com.aliyun.ocr20191230.models.RecognizePdfResponse;
import com.aliyun.ocr20191230.models.RecognizePdfResponseBody;
import com.aliyun.ocr20191230.models.RecognizeVATInvoiceAdvanceRequest;
import com.aliyun.ocr20191230.models.RecognizeVATInvoiceResponse;
import com.aliyun.ocr20191230.models.RecognizeVATInvoiceResponseBody;
import com.aliyun.ocr_api20210707.models.RecognizeInvoiceRequest;
import com.aliyun.ocr_api20210707.models.RecognizeInvoiceResponse;
import com.aliyun.tea.TeaException;
import com.aliyun.teaopenapi.models.Config;
import com.aliyun.teautil.models.RuntimeOptions;
import com.ejianc.foundation.usercenter.service.IAliyunApiService;
import com.ejianc.foundation.usercenter.util.HttpUtils;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AliyunApiServiceImpl
implements IAliyunApiService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${openapi.aliyun.face.accessKeyId:1}")
    private String accessKeyId;
    @Value(value="${openapi.aliyun.face.accessKeySecret:1}")
    private String accessKeySecret;
    @Value(value="${openapi.aliyun.face.endpoint:facebody.cn-shanghai.aliyuncs.com}")
    private String faceEndpoint;
    @Value(value="${openapi.aliyun.face.confidence:85}")
    private Float confidence;
    @Value(value="${openapi.aliyun.face.defaultFaceDb:default}")
    private String defaultFaceDb;
    @Value(value="${openapi.aliyun.ocr.endpoint:ocr.cn-shanghai.aliyuncs.com}")
    private String ocrEndpoint;
    @Value(value="${openapi.aliyun.ocr.aliEndpoint:ocr-api.cn-hangzhou.aliyuncs.com}")
    private String aliOcrEndpoint;
    private Client client;
    private com.aliyun.ocr20191230.Client ocrClient;

    private synchronized Client createFaceClient() throws Exception {
        if (this.client != null) {
            return this.client;
        }
        Config config = new Config().setAccessKeyId(this.accessKeyId).setAccessKeySecret(this.accessKeySecret);
        config.endpoint = this.faceEndpoint;
        this.client = new Client(config);
        return this.client;
    }

    private synchronized com.aliyun.ocr20191230.Client createOcrClient() throws Exception {
        if (this.ocrClient != null) {
            return this.ocrClient;
        }
        Config config = new Config().setAccessKeyId(this.accessKeyId).setAccessKeySecret(this.accessKeySecret);
        config.endpoint = this.ocrEndpoint;
        this.ocrClient = new com.aliyun.ocr20191230.Client(config);
        return this.ocrClient;
    }

    private synchronized com.aliyun.ocr_api20210707.Client createOcrClientAli() throws Exception {
        Config config = new Config().setAccessKeyId(this.accessKeyId).setAccessKeySecret(this.accessKeySecret);
        config.endpoint = this.aliOcrEndpoint;
        return new com.aliyun.ocr_api20210707.Client(config);
    }

    private synchronized InputStream getOssUrlInputStream(String imgUrl) throws Exception {
        URL url = new URL(imgUrl);
        return url.openConnection().getInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CommonResponse<Boolean> checkFaceQualityStream(InputStream inputStream, byte[] imgBytes) {
        this.logger.info("\u6821\u9a8c\u7167\u7247\u662f\u5426\u5305\u542b\u53ef\u7528\u4eba\u8138,inputStream={}", (Object)inputStream);
        try {
            Client client = this.createFaceClient();
            DetectFaceAdvanceRequest detectFaceRequest = new DetectFaceAdvanceRequest();
            detectFaceRequest.setImageURLObject(inputStream);
            detectFaceRequest.setQuality(Boolean.valueOf(true));
            detectFaceRequest.setMaxFaceNumber(Long.valueOf(1L));
            DetectFaceResponse response = client.detectFaceAdvance(detectFaceRequest, new RuntimeOptions());
            if (response.getStatusCode() != 200) return CommonResponse.error((String)"\u4eba\u8138\u7167\u7247\u6821\u9a8c\u5931\u8d25\uff01", (Object)false);
            DetectFaceResponseBody.DetectFaceResponseBodyData faceData = response.getBody().getData();
            if (faceData.getFaceCount() > 1 || faceData.getFaceProbabilityList().size() > 1) {
                CommonResponse commonResponse = CommonResponse.error((String)"\u68c0\u6d4b\u5230\u591a\u5f20\u4eba\u8138\uff01", (Object)false);
                return commonResponse;
            }
            if (((Float)faceData.getFaceProbabilityList().get(0)).floatValue() < this.confidence.floatValue() / 100.0f || ((Float)faceData.getQualities().getScoreList().get(0)).floatValue() < this.confidence.floatValue()) {
                CommonResponse commonResponse = CommonResponse.error((String)"\u4eba\u8138\u7167\u7247\u6a21\u7cca\u4e0d\u5408\u683c\uff01", (Object)false);
                return commonResponse;
            }
            CommonResponse commonResponse = CommonResponse.success((Object)true);
            return commonResponse;
        }
        catch (Exception error) {
            this.logger.info("\u6821\u9a8c\u7167\u7247\u662f\u5426\u5305\u542b\u53ef\u7528\u4eba\u8138,inputStream={}  error={}", (Object)inputStream, (Object)error.getMessage());
            if (!(error instanceof TeaException)) return CommonResponse.error((String)"\u4eba\u8138\u7167\u7247\u6821\u9a8c\u5931\u8d25\uff01", (Object)false);
            if (!((TeaException)((Object)error)).getCode().contains("Throttling")) return CommonResponse.error((String)"\u4eba\u8138\u7167\u7247\u6821\u9a8c\u5931\u8d25\uff01", (Object)false);
            int time = new Random().nextInt(3000);
            this.logger.info("\u6821\u9a8c\u7167\u7247\u662f\u5426\u5305\u542b\u53ef\u7528\u4eba\u8138\uff0c\u56e0\u4e3a\u9650\u6d41\uff0c" + time + "\u6beb\u79d2\u540e\uff0c\u5373\u5c06\u91cd\u8bd5....");
            try {
                Thread.sleep(time);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            CommonResponse<Boolean> commonResponse = this.checkFaceQualityStream(new ByteArrayInputStream(imgBytes), imgBytes);
            return commonResponse;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonResponse<Boolean> liveCheck(String imgUrl) {
        block23: {
            this.logger.info("\u4eba\u8138\u7167\u7247\u6d3b\u4f53\u68c0\u67e5,imgUrl=" + imgUrl);
            InputStream inputStream = null;
            try {
                inputStream = this.getOssUrlInputStream(imgUrl);
                Client client = this.createFaceClient();
                DetectLivingFaceAdvanceRequest livingFaceRequest = new DetectLivingFaceAdvanceRequest();
                ArrayList<DetectLivingFaceAdvanceRequest.DetectLivingFaceAdvanceRequestTasks> tasks = new ArrayList<DetectLivingFaceAdvanceRequest.DetectLivingFaceAdvanceRequestTasks>();
                DetectLivingFaceAdvanceRequest.DetectLivingFaceAdvanceRequestTasks task = new DetectLivingFaceAdvanceRequest.DetectLivingFaceAdvanceRequestTasks();
                task.setImageURLObject(inputStream);
                tasks.add(task);
                livingFaceRequest.setTasks(tasks);
                DetectLivingFaceResponse livingFaceResponse = client.detectLivingFaceAdvance(livingFaceRequest, new RuntimeOptions());
                if (livingFaceResponse.getStatusCode() == 200) {
                    DetectLivingFaceResponseBody.DetectLivingFaceResponseBodyDataElements element = (DetectLivingFaceResponseBody.DetectLivingFaceResponseBodyDataElements)livingFaceResponse.getBody().getData().getElements().get(0);
                    if (((DetectLivingFaceResponseBody.DetectLivingFaceResponseBodyDataElementsResults)element.getResults().get(0)).getRate().floatValue() > this.confidence.floatValue() || "pass".equals(((DetectLivingFaceResponseBody.DetectLivingFaceResponseBodyDataElementsResults)element.getResults().get(0)).getSuggestion())) {
                        CommonResponse commonResponse = CommonResponse.success((Object)true);
                        return commonResponse;
                    }
                    CommonResponse commonResponse = CommonResponse.error((String)"\u975e\u76f4\u62cd\u7167\u7247\uff01", (Object)false);
                    return commonResponse;
                }
            }
            catch (Exception error) {
                this.logger.info("\u4eba\u8138\u7167\u7247\u6d3b\u4f53\u68c0\u67e5,imgUrl=" + imgUrl + "  error=" + error.getMessage());
                if (!(error instanceof TeaException) || !((TeaException)((Object)error)).getCode().contains("Throttling")) break block23;
                int time = new Random().nextInt(3000);
                this.logger.info("\u4eba\u8138\u7167\u7247\u6d3b\u4f53\u68c0\u67e5\uff0c\u56e0\u4e3a\u9650\u6d41\uff0c" + time + "\u6beb\u79d2\u540e\uff0c\u5373\u5c06\u91cd\u8bd5....");
                try {
                    Thread.sleep(time);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                CommonResponse<Boolean> commonResponse = this.liveCheck(imgUrl);
                return commonResponse;
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return CommonResponse.error((String)"\u4eba\u8138\u6d3b\u4f53\u6821\u9a8c\u5931\u8d25\uff01", (Object)false);
    }

    public static void main(String[] args) {
        int time = new Random().nextInt(3000);
        System.out.println("\u5f00\u59cb" + time + "   " + System.currentTimeMillis());
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println("\u7ed3\u675f" + System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonResponse<Boolean> compareFace(String imgUrlA, String imgUrlB, String imgBase64A, String imgBase64B) {
        block40: {
            InputStream inputStreamA = null;
            InputStream inputStreamB = null;
            try {
                CompareFaceResponse response;
                Client client = this.createFaceClient();
                CompareFaceAdvanceRequest compareFaceRequest = new CompareFaceAdvanceRequest();
                if (StringUtils.isNotEmpty((CharSequence)imgUrlA)) {
                    inputStreamA = this.getOssUrlInputStream(imgUrlA);
                    compareFaceRequest.setImageURLAObject(inputStreamA);
                }
                if (StringUtils.isNotEmpty((CharSequence)imgUrlB)) {
                    inputStreamB = this.getOssUrlInputStream(imgUrlB);
                    compareFaceRequest.setImageURLBObject(inputStreamB);
                }
                if (StringUtils.isNotEmpty((CharSequence)imgBase64A)) {
                    compareFaceRequest.setImageDataA(imgBase64A);
                }
                if (StringUtils.isNotEmpty((CharSequence)imgBase64B)) {
                    compareFaceRequest.setImageDataB(imgBase64B);
                }
                if ((response = client.compareFaceAdvance(compareFaceRequest, new RuntimeOptions())).getStatusCode() == 200) {
                    CompareFaceResponseBody.CompareFaceResponseBodyData faceData = response.getBody().getData();
                    if (faceData.getConfidence().floatValue() > this.confidence.floatValue()) {
                        CommonResponse commonResponse = CommonResponse.success((Object)true);
                        return commonResponse;
                    }
                    CommonResponse commonResponse = CommonResponse.error((String)"\u4eba\u8138\u9a8c\u8bc1\u4e0d\u901a\u8fc7\uff01", (Object)false);
                    return commonResponse;
                }
            }
            catch (Exception error) {
                this.logger.info("\u5bf9\u6bd4\u4e24\u5f20\u56fe\u7247\u662f\u5426\u662f\u540c\u4e00\u4e2a\u4eba,imgUrlA={}  imgUrlB={}  imgBase64A={}   imgBase64B={} error={}", new Object[]{imgUrlA, imgUrlB, imgBase64A, imgBase64B, error.getMessage()});
                if (!(error instanceof TeaException) || !((TeaException)((Object)error)).getCode().contains("Throttling")) break block40;
                int time = new Random().nextInt(3000);
                this.logger.info("\u5bf9\u6bd4\u4e24\u5f20\u56fe\u7247\u662f\u5426\u662f\u540c\u4e00\u4e2a\u4eba\uff0c\u56e0\u4e3a\u9650\u6d41\uff0c" + time + "\u6beb\u79d2\u540e\uff0c\u5373\u5c06\u91cd\u8bd5....");
                try {
                    Thread.sleep(time);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                CommonResponse<Boolean> commonResponse = this.compareFace(imgUrlA, imgUrlB, imgBase64A, imgBase64B);
                return commonResponse;
            }
            finally {
                if (inputStreamA != null) {
                    try {
                        inputStreamA.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (inputStreamB != null) {
                    try {
                        inputStreamB.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return CommonResponse.error((String)"\u4eba\u8138\u7167\u7247\u6821\u9a8c\u5931\u8d25\uff01", (Object)false);
    }

    @Override
    public CommonResponse<Boolean> compareFace(InputStream imgUrlA, InputStream imgUrlB, String imgBase64A, String imgBase64B, byte[] imgStrA, byte[] imgStrB) {
        block10: {
            try {
                CompareFaceResponse response;
                Client client = this.createFaceClient();
                CompareFaceAdvanceRequest compareFaceRequest = new CompareFaceAdvanceRequest();
                if (imgUrlA != null) {
                    compareFaceRequest.setImageURLAObject(imgUrlA);
                }
                if (imgUrlB != null) {
                    compareFaceRequest.setImageURLBObject(imgUrlB);
                }
                if (imgBase64A != null) {
                    compareFaceRequest.setImageDataA(imgBase64A);
                }
                if (imgBase64B != null) {
                    compareFaceRequest.setImageDataB(imgBase64B);
                }
                if ((response = client.compareFaceAdvance(compareFaceRequest, new RuntimeOptions())).getStatusCode() == 200) {
                    CompareFaceResponseBody.CompareFaceResponseBodyData faceData = response.getBody().getData();
                    if (faceData.getConfidence().floatValue() > this.confidence.floatValue()) {
                        return CommonResponse.success((Object)true);
                    }
                    return CommonResponse.error((String)"\u4eba\u8138\u9a8c\u8bc1\u4e0d\u901a\u8fc7\uff01", (Object)false);
                }
            }
            catch (Exception error) {
                this.logger.info("\u5bf9\u6bd4\u4e24\u5f20\u56fe\u7247\u662f\u5426\u662f\u540c\u4e00\u4e2a\u4eba,imgUrlA={}  imgUrlB={}  imgBase64A={}   imgBase64B={} error={}", new Object[]{imgUrlA, imgUrlB, imgBase64A, imgBase64B, error.getMessage()});
                if (!(error instanceof TeaException) || !((TeaException)((Object)error)).getCode().contains("Throttling")) break block10;
                int time = new Random().nextInt(3000);
                this.logger.info("\u5bf9\u6bd4\u4e24\u5f20\u56fe\u7247\u662f\u5426\u662f\u540c\u4e00\u4e2a\u4eba\uff0c\u56e0\u4e3a\u9650\u6d41\uff0c" + time + "\u6beb\u79d2\u540e\uff0c\u5373\u5c06\u91cd\u8bd5....");
                try {
                    Thread.sleep(time);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return this.compareFace(imgUrlA != null ? new ByteArrayInputStream(imgStrA) : null, imgUrlB != null ? new ByteArrayInputStream(imgStrB) : null, imgBase64A, imgBase64B, imgStrA, imgStrB);
            }
        }
        return CommonResponse.error((String)"\u4eba\u8138\u7167\u7247\u6821\u9a8c\u5931\u8d25\uff01", (Object)false);
    }

    @Override
    public CommonResponse<Boolean> compareFaceWithMask(String imgBase64A, String imgBase64B) {
        block6: {
            try {
                Client client = this.createFaceClient();
                VerifyFaceMaskRequest request = new VerifyFaceMaskRequest();
                request.setImageData(imgBase64A.getBytes(StandardCharsets.UTF_8));
                request.setRefData(imgBase64B.getBytes(StandardCharsets.UTF_8));
                VerifyFaceMaskResponse response = client.verifyFaceMask(request);
                if (response.getStatusCode() == 200) {
                    VerifyFaceMaskResponseBody.VerifyFaceMaskResponseBodyData faceData = response.getBody().getData();
                    if (faceData.getConfidence().floatValue() > this.confidence.floatValue()) {
                        return CommonResponse.success((Object)true);
                    }
                    return CommonResponse.error((String)"\u4eba\u8138\u9a8c\u8bc1\u4e0d\u901a\u8fc7\uff01", (Object)false);
                }
            }
            catch (Exception error) {
                this.logger.info("\u5bf9\u6bd4\u4e24\u5f20\u56fe\u7247\u662f\u5426\u662f\u540c\u4e00\u4e2a\u4eba \u652f\u6301\u6234\u53e3\u7f69\u8fdb\u884c\u8bc6\u522b,imgBase64A={}   imgBase64B={} error={}", new Object[]{imgBase64A, imgBase64B, error.getMessage()});
                if (!(error instanceof TeaException) || !((TeaException)((Object)error)).getCode().contains("Throttling")) break block6;
                int time = new Random().nextInt(3000);
                this.logger.info("\u6234\u53e3\u7f69\u8fdb\u884c\u8bc6\u522b\u5bf9\u6bd4\u4e24\u5f20\u56fe\u7247\u662f\u5426\u662f\u540c\u4e00\u4e2a\u4eba\uff0c\u56e0\u4e3a\u9650\u6d41\uff0c" + time + "\u6beb\u79d2\u540e\uff0c\u5373\u5c06\u91cd\u8bd5....");
                try {
                    Thread.sleep(time);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return this.compareFaceWithMask(imgBase64A, imgBase64B);
            }
        }
        return CommonResponse.error((String)"\u4eba\u8138\u7167\u7247\u6821\u9a8c\u5931\u8d25\uff01", (Object)false);
    }

    @Override
    public CommonResponse<Boolean> createFaceDb(String name) {
        this.logger.info("\u521b\u5efa\u4eba\u8138\u6570\u636e\u5e93,name={} ", (Object)name);
        try {
            Client client = this.createFaceClient();
            CreateFaceDbRequest request = new CreateFaceDbRequest();
            request.setName(name);
            CreateFaceDbResponse response = client.createFaceDb(request);
            if (response.getStatusCode() == 200) {
                return CommonResponse.success((String)"\u521b\u5efa\u6210\u529f\uff01", (Object)true);
            }
        }
        catch (Exception e) {
            this.logger.info("\u521b\u5efa\u4eba\u8138\u6570\u636e\u5e93,name={}  error={}", (Object)name, (Object)e.getMessage());
            e.printStackTrace();
        }
        return CommonResponse.error((String)"\u521b\u5efa\u5931\u8d25\uff01", (Object)false);
    }

    @Override
    public CommonResponse<Boolean> deleteFaceDb(String name) {
        this.logger.info("\u521b\u5efa\u4eba\u8138\u6570\u636e\u5e93,name={} ", (Object)name);
        try {
            Client client = this.createFaceClient();
            DeleteFaceDbRequest request = new DeleteFaceDbRequest();
            request.setName(name);
            DeleteFaceDbResponse response = client.deleteFaceDb(request);
            if (response.getStatusCode() == 200) {
                return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01", (Object)true);
            }
        }
        catch (Exception e) {
            this.logger.info("\u5220\u9664\u4eba\u8138\u6570\u636e\u5e93,name={}  error={}", (Object)name, (Object)e.getMessage());
            e.printStackTrace();
        }
        return CommonResponse.error((String)"\u5220\u9664\u5931\u8d25\uff01", (Object)false);
    }

    @Override
    public CommonResponse<Boolean> createFaceDbUser(Long userId, String userName) {
        this.logger.info("\u521b\u5efa\u4eba\u8138\u6570\u636e\u5e93\u7528\u6237,userId={}   userName={} ", (Object)userId, (Object)userName);
        try {
            Client client = this.createFaceClient();
            AddFaceEntityRequest request = new AddFaceEntityRequest();
            request.setDbName(this.defaultFaceDb);
            request.setEntityId("user_" + userId);
            request.setLabels(userName);
            AddFaceEntityResponse response = client.addFaceEntity(request);
            this.logger.info("\u521b\u5efa\u4eba\u8138\u6570\u636e\u5e93\u7528\u6237,userId={}   userName={}  response={} ", new Object[]{userId, userName, JSONObject.toJSONString((Object)response)});
            if (response.getStatusCode() == 200) {
                return CommonResponse.success((String)"\u521b\u5efa\u4eba\u8138\u7528\u6237\u6210\u529f\uff01", (Object)true);
            }
        }
        catch (Exception e) {
            this.logger.info("\u521b\u5efa\u4eba\u8138\u6570\u636e\u5e93\u7528\u6237,userId={}   userName={}  error={} ", new Object[]{userId, userName, e.getMessage()});
            e.printStackTrace();
        }
        return CommonResponse.error((String)"\u521b\u5efa\u4eba\u8138\u7528\u6237\u5931\u8d25\uff01", (Object)false);
    }

    @Override
    public CommonResponse<Boolean> updateFaceDbUser(Long userId, String userName) {
        try {
            Client client = this.createFaceClient();
            UpdateFaceEntityRequest request = new UpdateFaceEntityRequest();
            request.setDbName(this.defaultFaceDb);
            request.setEntityId("user_" + userId);
            request.setLabels(userName);
            UpdateFaceEntityResponse response = client.updateFaceEntity(request);
            this.logger.info("\u66f4\u65b0\u4eba\u8138\u6570\u636e\u5e93\u7528\u6237,userId={}   userName={}  response={} ", new Object[]{userId, userName, JSONObject.toJSONString((Object)response)});
            if (response.getStatusCode() == 200) {
                return CommonResponse.success((String)"\u66f4\u65b0\u4eba\u8138\u7528\u6237\u6210\u529f\uff01", (Object)true);
            }
        }
        catch (Exception e) {
            this.logger.info("\u66f4\u65b0\u4eba\u8138\u6570\u636e\u5e93\u7528\u6237,userId={}   userName={}  error={} ", new Object[]{userId, userName, e.getMessage()});
            e.printStackTrace();
        }
        return CommonResponse.error((String)"\u66f4\u65b0\u4eba\u8138\u7528\u6237\u5931\u8d25\uff01", (Object)false);
    }

    @Override
    public CommonResponse<Boolean> deleteFaceDbUser(Long userId) {
        this.logger.info("\u5220\u9664\u4eba\u8138\u6570\u636e\u5e93\u7528\u6237,userId={} ", (Object)userId);
        try {
            Client client = this.createFaceClient();
            DeleteFaceEntityRequest request = new DeleteFaceEntityRequest();
            request.setDbName(this.defaultFaceDb);
            request.setEntityId("user_" + userId);
            DeleteFaceEntityResponse response = client.deleteFaceEntity(request);
            this.logger.info("\u5220\u9664\u4eba\u8138\u6570\u636e\u5e93\u7528\u6237,userId={} response={} ", (Object)userId, (Object)JSONObject.toJSONString((Object)response));
            if (response.getStatusCode() == 200) {
                return CommonResponse.success((String)"\u5220\u9664\u4eba\u8138\u7528\u6237\u6210\u529f\uff01", (Object)true);
            }
        }
        catch (Exception e) {
            this.logger.info("\u5220\u9664\u4eba\u8138\u6570\u636e\u5e93\u7528\u6237,userId={} error={} ", (Object)userId, (Object)e.getMessage());
            e.printStackTrace();
        }
        return CommonResponse.error((String)"\u5220\u9664\u4eba\u8138\u7528\u6237\u5931\u8d25\uff01", (Object)false);
    }

    @Override
    public CommonResponse<Boolean> getFaceDbUser(Long userId) {
        block6: {
            this.logger.info("\u67e5\u8be2\u4eba\u8138\u6570\u636e\u5e93\u7528\u6237\u662f\u5426\u5b58\u5728,userId={} ", (Object)userId);
            try {
                Client client = this.createFaceClient();
                GetFaceEntityRequest request = new GetFaceEntityRequest();
                request.setDbName(this.defaultFaceDb);
                request.setEntityId("user_" + userId);
                GetFaceEntityResponse response = client.getFaceEntity(request);
                if (response.getStatusCode() == 200) {
                    if (response.getBody().getData() != null) {
                        return CommonResponse.success((String)"\u4eba\u8138\u7528\u6237\u5df2\u6ce8\u518c\uff01", (Object)true);
                    }
                    return CommonResponse.success((String)"\u4eba\u8138\u7528\u6237\u672a\u6ce8\u518c\uff01", (Object)false);
                }
            }
            catch (Exception error) {
                this.logger.info("\u67e5\u8be2\u4eba\u8138\u6570\u636e\u5e93\u7528\u6237\u662f\u5426\u5b58\u5728,userId={} error={} ", (Object)userId, (Object)error.getMessage());
                if (!(error instanceof TeaException) || !((TeaException)((Object)error)).getCode().contains("Throttling")) break block6;
                int time = new Random().nextInt(3000);
                this.logger.info("\u67e5\u8be2\u4eba\u8138\u6570\u636e\u5e93\u7528\u6237\u662f\u5426\u5b58\u5728\uff0c\u56e0\u4e3a\u9650\u6d41\uff0c" + time + "\u6beb\u79d2\u540e\uff0c\u5373\u5c06\u91cd\u8bd5....");
                try {
                    Thread.sleep(time);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return this.getFaceDbUser(userId);
            }
        }
        return CommonResponse.error((String)"\u67e5\u8be2\u4eba\u8138\u7528\u6237\u5931\u8d25\uff01", (Object)false);
    }

    @Override
    public CommonResponse<List<Long>> getUserByFaceStream(InputStream inputStream, byte[] imgBytes) {
        block7: {
            this.logger.info("\u6839\u636e\u7167\u7247\uff0c\u67e5\u8be2\u7b26\u5408\u7167\u7247\u7684\u5458\u5de5id,inputStream={} ", (Object)inputStream);
            try {
                Client client = this.createFaceClient();
                SearchFaceAdvanceRequest request = new SearchFaceAdvanceRequest();
                request.setDbName(this.defaultFaceDb);
                request.setImageUrlObject(inputStream);
                request.setQualityScoreThreshold(this.confidence);
                request.setMaxFaceNum(Long.valueOf(1L));
                request.setLimit(Integer.valueOf(10));
                SearchFaceResponse response = client.searchFaceAdvance(request, new RuntimeOptions());
                ArrayList<Long> res = new ArrayList<Long>();
                HashMap<String, String> map = new HashMap<String, String>();
                if (response.getStatusCode() == 200) {
                    SearchFaceResponseBody.SearchFaceResponseBodyDataMatchList list;
                    if (response.getBody().getData() != null && ListUtil.isNotEmpty((List)response.getBody().getData().getMatchList()) && ListUtil.isNotEmpty((List)(list = (SearchFaceResponseBody.SearchFaceResponseBodyDataMatchList)response.getBody().getData().getMatchList().get(0)).getFaceItems())) {
                        for (SearchFaceResponseBody.SearchFaceResponseBodyDataMatchListFaceItems items : list.getFaceItems()) {
                            if (!StringUtils.isEmpty((CharSequence)((CharSequence)map.get(items.getEntityId())))) continue;
                            Long userId = Long.parseLong(items.getEntityId().substring(5));
                            res.add(userId);
                            map.put(items.getEntityId(), items.getEntityId());
                        }
                        return CommonResponse.success(res);
                    }
                    return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u8be5\u4eba\u8138\u4fe1\u606f\uff01");
                }
            }
            catch (Exception error) {
                this.logger.info("\u6839\u636e\u7167\u7247\uff0c\u67e5\u8be2\u7b26\u5408\u7167\u7247\u7684\u5458\u5de5id,inputStream={} error={}", (Object)inputStream, (Object)error.getMessage());
                if (!(error instanceof TeaException) || !((TeaException)((Object)error)).getCode().contains("Throttling")) break block7;
                int time = new Random().nextInt(3000);
                this.logger.info("\u6839\u636e\u7167\u7247\uff0c\u67e5\u8be2\u7b26\u5408\u7167\u7247\u7684\u5458\u5de5id\uff0c\u56e0\u4e3a\u9650\u6d41\uff0c" + time + "\u6beb\u79d2\u540e\uff0c\u5373\u5c06\u91cd\u8bd5....");
                try {
                    Thread.sleep(time);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return this.getUserByFaceStream(new ByteArrayInputStream(imgBytes), imgBytes);
            }
        }
        return CommonResponse.error((String)"\u67e5\u8be2\u4eba\u8138\u7528\u6237\u5931\u8d25\uff01");
    }

    @Override
    public CommonResponse<Boolean> addFaceToUser(Long userId, InputStream imageUrl, byte[] imgBytes) {
        block5: {
            try {
                Client client = this.createFaceClient();
                AddFaceAdvanceRequest request = new AddFaceAdvanceRequest();
                request.setDbName(this.defaultFaceDb);
                request.setEntityId("user_" + userId);
                request.setImageUrlObject(imageUrl);
                request.setQualityScoreThreshold(this.confidence);
                request.setSimilarityScoreThresholdInEntity(this.confidence);
                AddFaceResponse response = client.addFaceAdvance(request, new RuntimeOptions());
                if (response.getStatusCode() == 200 && response.getBody().getData() != null) {
                    return CommonResponse.success((String)"\u6dfb\u52a0\u4eba\u8138\u6210\u529f\uff01", (Object)true);
                }
            }
            catch (Exception error) {
                this.logger.info("\u6dfb\u52a0\u4eba\u8138\u6570\u636e\u5230\u6307\u5b9a\u7528\u6237,userId={}   imageUrl={} error={}", new Object[]{userId, imageUrl, error.getMessage()});
                if (!(error instanceof TeaException) || !((TeaException)((Object)error)).getCode().contains("Throttling")) break block5;
                int time = new Random().nextInt(3000);
                this.logger.info("\u6dfb\u52a0\u4eba\u8138\u6570\u636e\u5230\u6307\u5b9a\u7528\u6237\uff0c\u56e0\u4e3a\u9650\u6d41\uff0c" + time + "\u6beb\u79d2\u540e\uff0c\u5373\u5c06\u91cd\u8bd5....");
                try {
                    Thread.sleep(time);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return this.addFaceToUser(userId, new ByteArrayInputStream(imgBytes), imgBytes);
            }
        }
        return CommonResponse.error((String)"\u6dfb\u52a0\u4eba\u8138\u5931\u8d25\uff01", (Object)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonResponse<JSONObject> recognizeIdentityCardInfo(InputStream imageInputStream, String side, byte[] imgBytes) {
        block22: {
            if (imageInputStream == null || StringUtils.isEmpty((CharSequence)side)) {
                return CommonResponse.error((String)"\u53c2\u6570\u6709\u7a7a\u503c\uff01");
            }
            if (!"face".equals(side) && !"back".equals(side)) {
                return CommonResponse.error((String)"side\u53c2\u6570\u503c\u5fc5\u987b\u662f\u5b57\u7b26\u4e32face\u6216\u8005back\uff01\u5176\u4e2dface\uff1a\u4eba\u50cf\u9762  back\uff1a\u56fd\u5fbd\u9762\uff01");
            }
            JSONObject res = new JSONObject();
            res.put("side", (Object)side);
            try {
                com.aliyun.ocr20191230.Client client = this.createOcrClient();
                RecognizeIdentityCardAdvanceRequest recognizeIdentityCardRequest = new RecognizeIdentityCardAdvanceRequest().setImageURLObject(imageInputStream).setSide(side);
                RecognizeIdentityCardResponse response = client.recognizeIdentityCardAdvance(recognizeIdentityCardRequest, new RuntimeOptions());
                if (response.getStatusCode() == 200 && response.getBody().getData() != null) {
                    RecognizeIdentityCardResponseBody.RecognizeIdentityCardResponseBodyDataFrontResult frontResult;
                    RecognizeIdentityCardResponseBody.RecognizeIdentityCardResponseBodyData data = response.getBody().getData();
                    if ("face".equals(side)) {
                        frontResult = data.getFrontResult();
                        res.put("name", (Object)frontResult.getName());
                        res.put("gender", (Object)frontResult.getGender());
                        res.put("nationality", (Object)frontResult.getNationality());
                        res.put("birthDate", (Object)frontResult.getBirthDate());
                        res.put("address", (Object)frontResult.getAddress());
                        res.put("idNumber", (Object)frontResult.getIDNumber());
                    } else {
                        frontResult = data.getBackResult();
                        res.put("startDate", (Object)frontResult.getStartDate());
                        res.put("endDate", (Object)frontResult.getEndDate());
                        res.put("issue", (Object)frontResult.getIssue());
                    }
                    CommonResponse commonResponse = CommonResponse.success((Object)res);
                    return commonResponse;
                }
            }
            catch (Exception error) {
                this.logger.info("\u8eab\u4efd\u8bc1\u4ef6 \u4fe1\u606f\u8bc6\u522b,side={} imageInputStream={} error={}", new Object[]{side, imageInputStream, error.getMessage()});
                if (!(error instanceof TeaException) || !((TeaException)((Object)error)).getCode().contains("Throttling")) break block22;
                int time = new Random().nextInt(3000);
                this.logger.info("\u8eab\u4efd\u8bc1\u4ef6 \u4fe1\u606f\u8bc6\u522b\uff0c\u56e0\u4e3a\u9650\u6d41\uff0c" + time + "\u6beb\u79d2\u540e\uff0c\u5373\u5c06\u91cd\u8bd5....");
                try {
                    Thread.sleep(time);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                CommonResponse<JSONObject> commonResponse = this.recognizeIdentityCardInfo(new ByteArrayInputStream(imgBytes), side, imgBytes);
                return commonResponse;
            }
            finally {
                try {
                    imageInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return CommonResponse.error((String)"\u8eab\u4efd\u8bc1\u8bc6\u522b\u5931\u8d25\uff01");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonResponse<List<String>> recognizePdfInfo(String pdfUrl) {
        block21: {
            if (StringUtils.isEmpty((CharSequence)pdfUrl)) {
                return CommonResponse.error((String)"\u53c2\u6570\u6709\u7a7a\u503c\uff01");
            }
            ArrayList<String> res = new ArrayList<String>();
            InputStream inputStream = null;
            try {
                inputStream = this.getOssUrlInputStream(pdfUrl);
                com.aliyun.ocr20191230.Client client = this.createOcrClient();
                RecognizePdfAdvanceRequest recognizePdfAdvanceRequest = new RecognizePdfAdvanceRequest();
                recognizePdfAdvanceRequest.setFileURLObject(inputStream);
                RecognizePdfResponse response = client.recognizePdfAdvance(recognizePdfAdvanceRequest, new RuntimeOptions());
                if (response.getStatusCode() == 200 && response.getBody().getData() != null) {
                    this.logger.info("pdf \u4fe1\u606f\u8bc6\u522b\u7ed3\u679c, pdfUrl={} ", (Object)pdfUrl);
                    RecognizePdfResponseBody.RecognizePdfResponseBodyData data = response.getBody().getData();
                    for (RecognizePdfResponseBody.RecognizePdfResponseBodyDataWordsInfo wordsInfo : data.getWordsInfo()) {
                        res.add(wordsInfo.getWord());
                        this.logger.info(wordsInfo.getWord());
                    }
                    CommonResponse commonResponse = CommonResponse.success(res);
                    return commonResponse;
                }
            }
            catch (Exception error) {
                this.logger.info("pdf \u4fe1\u606f\u8bc6\u522b, pdfUrl={} error={}", (Object)pdfUrl, (Object)error.getMessage());
                if (!(error instanceof TeaException) || !((TeaException)((Object)error)).getCode().contains("Throttling")) break block21;
                int time = new Random().nextInt(3000);
                this.logger.info("pdf \u4fe1\u606f\u8bc6\u522b\uff0c\u56e0\u4e3a\u9650\u6d41\uff0c" + time + "\u6beb\u79d2\u540e\uff0c\u5373\u5c06\u91cd\u8bd5....");
                try {
                    Thread.sleep(time);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                CommonResponse<List<String>> commonResponse = this.recognizePdfInfo(pdfUrl);
                return commonResponse;
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return CommonResponse.error((String)"pdf \u4fe1\u606f\u8bc6\u522b\u5931\u8d25\uff01");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonResponse<JSONObject> recognizeInvoiceInfo(String url, InputStream imageUrl) {
        block31: {
            if (StringUtils.isEmpty((CharSequence)url) && imageUrl == null) {
                return CommonResponse.error((String)"\u53d1\u7968\u8bc6\u522b\u53c2\u6570\u6709\u7a7a\u503c\uff01");
            }
            RecognizeVATInvoiceAdvanceRequest recognizeVATInvoiceRequest = new RecognizeVATInvoiceAdvanceRequest();
            recognizeVATInvoiceRequest.setFileType("jpg");
            InputStream inputStream = null;
            try {
                inputStream = StringUtils.isEmpty((CharSequence)url) ? imageUrl : this.getOssUrlInputStream(url);
                recognizeVATInvoiceRequest.setFileURLObject(inputStream);
                com.aliyun.ocr20191230.Client client = this.createOcrClient();
                RecognizeVATInvoiceResponse response = client.recognizeVATInvoiceAdvance(recognizeVATInvoiceRequest, new RuntimeOptions());
                if (response.getStatusCode() == 200 && response.getBody().getData() != null) {
                    RecognizeVATInvoiceResponseBody.RecognizeVATInvoiceResponseBodyData data = response.getBody().getData();
                    RecognizeVATInvoiceResponseBody.RecognizeVATInvoiceResponseBodyDataContent content = data.getContent();
                    this.logger.info("\u53d1\u7968\u8bc6\u522b \u4fe1\u606f\u8bc6\u522b\u7ed3\u679c, url={} ,content={}", (Object)url, (Object)JSONObject.toJSONString((Object)content));
                    JSONObject result = new JSONObject();
                    result.put("PayerAddress", (Object)content.getPayerAddress());
                    result.put("PayeeRegisterNo", (Object)content.getPayeeRegisterNo());
                    result.put("PayeeBankName", (Object)content.getPayeeBankName());
                    result.put("InvoiceNo", (Object)content.getInvoiceNo());
                    result.put("PayerRegisterNo", (Object)content.getPayerRegisterNo());
                    result.put("Checker", (Object)content.getChecker());
                    result.put("TaxAmount", (Object)content.getTaxAmount());
                    result.put("InvoiceDate", (Object)content.getInvoiceDate());
                    result.put("WithoutTaxAmount", (Object)content.getWithoutTaxAmount());
                    result.put("InvoiceAmount", (Object)content.getInvoiceAmount());
                    result.put("AntiFakeCode", (Object)content.getAntiFakeCode());
                    result.put("PayerName", (Object)content.getPayerName());
                    result.put("Payee", (Object)content.getPayee());
                    result.put("SumAmount", (Object)content.getSumAmount());
                    result.put("PayerBankName", (Object)content.getPayerBankName());
                    result.put("Clerk", (Object)content.getClerk());
                    result.put("PayeeName", (Object)content.getPayeeName());
                    result.put("PayeeAddress", (Object)content.getPayeeAddress());
                    result.put("InvoiceCode", (Object)content.getInvoiceCode());
                    result.put("ItemName", (Object)content.getItemName());
                    CommonResponse commonResponse = CommonResponse.success((Object)result);
                    return commonResponse;
                }
            }
            catch (Exception error) {
                this.logger.info("\u53d1\u7968\u8bc6\u522b, url={} error={}", (Object)url, (Object)error.getMessage());
                if (!(error instanceof TeaException) || !((TeaException)((Object)error)).getCode().contains("Throttling")) break block31;
                int time = new Random().nextInt(3000);
                this.logger.info("\u53d1\u7968\u8bc6\u522b\uff0c\u56e0\u4e3a\u9650\u6d41\uff0c" + time + "\u6beb\u79d2\u540e\uff0c\u5373\u5c06\u91cd\u8bd5....");
                try {
                    Thread.sleep(time);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                CommonResponse<JSONObject> commonResponse = this.recognizeInvoiceInfo(url, imageUrl);
                return commonResponse;
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (imageUrl != null) {
                    try {
                        imageUrl.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return CommonResponse.error((String)"\u53d1\u7968\u8bc6\u522b \u4fe1\u606f\u8bc6\u522b\u5931\u8d25\uff01");
    }

    @Override
    public CommonResponse<JSONObject> recognizeInvoiceInfoAli(String url) {
        block6: {
            if (StringUtils.isEmpty((CharSequence)url)) {
                return CommonResponse.error((String)"\u53d1\u7968\u8bc6\u522b\u53c2\u6570\u6709\u7a7a\u503c\uff01");
            }
            RecognizeInvoiceRequest request = new RecognizeInvoiceRequest();
            request.setUrl(url);
            try {
                com.aliyun.ocr_api20210707.Client client = this.createOcrClientAli();
                RecognizeInvoiceResponse response = client.recognizeInvoiceWithOptions(request, new RuntimeOptions());
                if (response.getStatusCode() == 200 && response.getBody().getData() != null) {
                    String data = response.getBody().getData();
                    this.logger.info("\u53d1\u7968\u8bc6\u522b \u4fe1\u606f\u8bc6\u522b\u7ed3\u679c, url={} ,content={}", (Object)url, (Object)data);
                    JSONObject result = JSONObject.parseObject((String)data);
                    return CommonResponse.success((Object)result.getJSONObject("data"));
                }
            }
            catch (Exception error) {
                this.logger.info("\u53d1\u7968\u8bc6\u522b, url={} error={}", (Object)url, (Object)error.getMessage());
                if (!(error instanceof TeaException) || !((TeaException)((Object)error)).getCode().contains("Throttling")) break block6;
                int time = new Random().nextInt(3000);
                this.logger.info("\u53d1\u7968\u8bc6\u522b\uff0c\u56e0\u4e3a\u9650\u6d41\uff0c" + time + "\u6beb\u79d2\u540e\uff0c\u5373\u5c06\u91cd\u8bd5....");
                try {
                    Thread.sleep(time);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return this.recognizeInvoiceInfoAli(url);
            }
        }
        return CommonResponse.error((String)"\u53d1\u7968\u8bc6\u522b \u4fe1\u606f\u8bc6\u522b\u5931\u8d25\uff01");
    }

    @Override
    public CommonResponse<JSONObject> authInvoiceInfo(Map<String, String> param) {
        String host = "https://jminvceins.market.alicloudapi.com";
        String path = "/invoice/query_validate";
        String method = "POST";
        String appcode = "0985fe705e9d4c9e9c5dc34e5e15d34d";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "APPCODE " + appcode);
        headers.put("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        HashMap<String, String> querys = new HashMap<String, String>();
        try {
            HttpResponse res = HttpUtils.doPost(host, path, method, headers, querys, param);
            String response = IOUtils.toString((InputStream)res.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
            this.logger.info("\u53d1\u7968\u9a8c\u8bc1 \u8bf7\u6c42--{}\uff0c\u53c2\u6570--{}\uff0c\u54cd\u5e94--{}", new Object[]{host, JSONObject.toJSONString(param), response});
            if (StringUtils.isNotEmpty((CharSequence)response)) {
                JSONObject object = JSONObject.parseObject((String)response);
                if (object.getInteger("code") == 200) {
                    return CommonResponse.success((Object)object.getJSONObject("data"));
                }
                String msg = this.getErrMsg(object.getString("code"));
                if (object.getInteger("code") == 400) {
                    msg = msg + object.getString("msg");
                }
                return CommonResponse.error((String)msg);
            }
            return CommonResponse.error((String)"\u53d1\u7968\u9a8c\u771f\u670d\u52a1\u63d0\u4f9b\u5546\u5546\u670d\u52a1\u5668\u54cd\u5e94\u4e3a\u7a7a\uff01");
        }
        catch (Exception e) {
            this.logger.info("\u53d1\u7968\u9a8c\u8bc1\u51fa\u9519\uff01 \u8bf7\u6c42--{}\uff0c\u53c2\u6570--{}\uff0c\u9519\u8bef--{}", new Object[]{host, JSONObject.toJSONString(param), e.getMessage()});
            e.printStackTrace();
            return CommonResponse.error((String)"\u53d1\u7968\u9a8c\u8bc1\u51fa\u9519\uff01");
        }
    }

    private String getErrMsg(String code) {
        String res = "\u672a\u77e5\u5f02\u5e38" + code;
        switch (code) {
            case "203": {
                res = "\u8d85\u8fc7\u8be5\u5f20\u7968\u5f53\u5929\u67e5\u9a8c\u6b21\u6570\uff0c\u7a0e\u5c40\u89c4\u5b9a\u7684\u6bcf\u5f20\u53d1\u7968\u4e00\u5929\u53ea\u80fd\u8c03\u75285\u6b21";
                break;
            }
            case "204": {
                res = "\u67e5\u9a8c\u53d1\u7968\u5f20\u6570\u8d85\u8fc7\u9650\u5236";
                break;
            }
            case "205": {
                res = "\u8d85\u8fc7\u4e94\u5e74\u7684\u53d1\u7968\u4e0d\u80fd\u67e5\u9a8c\uff0c\u8bf7\u6838\u5bf9\u5f00\u7968\u65e5\u671f\u662f\u5426\u6b63\u786e";
                break;
            }
            case "206": {
                res = "\u5f53\u524d\u53d1\u7968\u6b63\u5728\u67e5\u9a8c\u4e2d,\u8bf7\u7a0d\u540e\u91cd\u8bd5";
                break;
            }
            case "207": {
                res = "\u8be5\u5730\u533a\u6682\u4e0d\u652f\u6301\u8be5\u7968\u79cd\u67e5\u9a8c";
                break;
            }
            case "400": {
                res = "\u53c2\u6570\u9519\u8bef:";
                break;
            }
            case "411": {
                res = "\u67e5\u8be2\u53d1\u7968\u4e0d\u89c4\u8303, \u8bf7\u6838\u5bf9\u53c2\u6570\u662f\u5426\u7b26\u5408\u53d1\u7968\u89c4\u8303";
                break;
            }
            case "412": {
                res = "\u5f00\u7968\u65e5\u671f\u8d85\u8fc7\u5f53\u524d\u65e5\u671f\uff0c\u8bf7\u6838\u5bf9\u5f00\u7968\u65e5\u671f\u662f\u5426\u6b63\u786e";
                break;
            }
            case "500": {
                res = "\u670d\u52a1\u5546\u7ef4\u62a4\uff0c\u8bf7\u7a0d\u5019\u518d\u8bd5";
                break;
            }
            case "502": {
                res = "\u7f51\u7edc\u6545\u969c\uff0c\u8bf7\u7a0d\u5019\u518d\u8bd5";
                break;
            }
            case "999": {
                break;
            }
        }
        return res;
    }
}

