package com.ejianc.foundation.permission.bean;

import org.apache.commons.lang3.StringUtils;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

/**
 * 角色应用关系表
 * 
 * @author guominga
 *
 */
@TableName("ejc_idm_role_app_relation")
public class RoleAppRelationEntity extends BaseEntity {

	private static final long serialVersionUID = 1L;

	@TableField(value = "role_id")
	private Long roleId;// 角色ID

	@TableField(value = "app_id")
	private Long appId;// 应用ID

	@TableField(exist = false)
	private String dataType;

	@TableField(exist = false)
	private Long buttonId;

	public Long getRoleId() {
		return roleId;
	}

	public void setRoleId(Long roleId) {
		this.roleId = roleId;
	}

	public Long getAppId() {
		return appId;
	}

	public void setAppId(Long appId) {
		this.appId = appId;
	}

	public String getDataType() {
		return dataType;
	}

	public void setDataType(String dataType) {
		if(StringUtils.isBlank(dataType)) {
			dataType = "app";
		}
		this.dataType = dataType;
	}

	public Long getButtonId() {
		return buttonId;
	}

	public void setButtonId(Long buttonId) {
		this.buttonId = buttonId;
	}

}
