package com.ejianc.foundation.workbench.service.impl;

import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.tenant.bean.TenantEntity;
import com.ejianc.foundation.tenant.service.ITenantService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.workbench.bean.WidgetEntity;
import com.ejianc.foundation.workbench.bean.WidgetGroupEntity;
import com.ejianc.foundation.workbench.mapper.WidgetGroupMapper;
import com.ejianc.foundation.workbench.mapper.WidgetMapper;
import com.ejianc.foundation.workbench.service.IWidgetService;
import com.ejianc.foundation.workbench.vo.WidgetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;

@Service
public class WidgetServiceImpl extends BaseServiceImpl<WidgetMapper, WidgetEntity> implements IWidgetService {

	private static final String WIDGET_BILL_CODE = "IDM_WIDGET";
	
	@Autowired
	private IBillCodeApi billCodeApi;
	@Autowired
	private ITenantService tenantService;
	@Autowired
	private WidgetGroupMapper widgetGroupMapper;
	
	@Override
	public WidgetVO save(WidgetVO widgetVO) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		WidgetEntity saveEntity = null;

		if(widgetVO.getTenantId()!=null && widgetVO.getParentId()!=null){
			QueryWrapper<WidgetEntity> wrapper = new QueryWrapper<>();
			wrapper.eq("dr", 0);
			wrapper.eq("tenant_id", widgetVO.getTenantId());
			wrapper.eq("parent_id", widgetVO.getParentId());
			if(widgetVO.getId()!=null){
				wrapper.ne("id", widgetVO.getId());
			}
			List<WidgetEntity> list = this.list(wrapper);
			if(list!=null && list.size()>0){
				throw new BusinessException("该租户下已存在");
			}
		}
		if(widgetVO.getParentId()!=null && widgetVO.getTenantId()==999999){
			throw new BusinessException("平台租户不要新增子级小部件");
		}
		if(null != widgetVO.getId()) {
			saveEntity = BeanMapper.map(widgetVO, WidgetEntity.class);
		} else {
			CommonResponse<String> commonResponse = billCodeApi.getCodeBatchByRuleCode(WIDGET_BILL_CODE, tenantId);
			if(commonResponse.isSuccess()) {
				widgetVO.setCode(commonResponse.getData());
			}else{
				throw new BusinessException("网络异常，编码生成失败，请稍后再试！");
			}
			widgetVO.setId(IdWorker.getId());
			widgetVO.setSetting(StringUtils.isNotBlank(widgetVO.getSetting())?widgetVO.getSetting().replace("widgetid_value", widgetVO.getId().toString()):"");
			saveEntity = BeanMapper.map(widgetVO, WidgetEntity.class);
		}
		if(saveEntity.getTenantId()!=null){
			TenantEntity tenantEntity = tenantService.getById(saveEntity.getTenantId());
			saveEntity.setTenantName(tenantEntity.getName());
		}else{
			TenantEntity tenantEntity = tenantService.getById(InvocationInfoProxy.getTenantid());
			saveEntity.setTenantName(tenantEntity.getName());
		}
		super.saveOrUpdate(saveEntity, false);
		return BeanMapper.map(saveEntity, WidgetVO.class);
	}

	@Override
	public WidgetEntity getById(Long id) {
		//获取该租户下是否有，有的话采用，没有取平台数据
		QueryWrapper<WidgetEntity> wrapper = new QueryWrapper<>();
		wrapper.eq("parent_id", id);
		wrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
		List<WidgetEntity> entities = baseMapper.selectList(wrapper);
		if(entities != null && entities.size()>0) {
			return  entities.get(0);
		}else{
			return baseMapper.selectById(id);
		}
	}

	@Override
	public List<WidgetEntity> getWidgetByIds(String widgetIds) {
		List<WidgetEntity> widgetEntities = baseMapper.getWidgetByIds(widgetIds);
		return widgetEntities;
	}

	@Override
	public List<WidgetEntity> queryWidgetList(String searchText, Long groupId) {
		String innerCode = "";
		if(groupId != null && groupId > 0l) {
			WidgetGroupEntity widgetGroupEntity = widgetGroupMapper.selectById(groupId);
			innerCode = widgetGroupEntity.getInnerCode();
		}
		List<WidgetEntity> entities = baseMapper.queryWidgetList(searchText, innerCode);
		return entities;
	}

	@Override
	public List<WidgetVO> queryListByGroupId(Long id) {
		QueryWrapper<WidgetEntity> wrapper = new QueryWrapper<>();
		wrapper.eq("group_id", id);
		List<WidgetEntity> entities = baseMapper.selectList(wrapper);
		if(entities != null) {
			return BeanMapper.mapList(entities, WidgetVO.class);
		}
		return null;
	}

}
