package com.ejianc.foundation.oms.service.impl;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.ibatis.builder.BuilderException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.cache.PermissionCacheManage;
import com.ejianc.foundation.oms.bean.ComboEnterpriseEntity;
import com.ejianc.foundation.oms.mapper.ComboAppMapper;
import com.ejianc.foundation.oms.mapper.ComboDoorMapper;
import com.ejianc.foundation.oms.mapper.ComboEnterpriseMapper;
import com.ejianc.foundation.oms.mapper.ComboRoleMapper;
import com.ejianc.foundation.oms.service.IComboDoorService;
import com.ejianc.foundation.oms.service.IComboEnterpriseService;
import com.ejianc.foundation.oms.vo.ComboEnterpriseVO;
import com.ejianc.foundation.orgcenter.service.IEmployeeService;
import com.ejianc.foundation.orgcenter.service.IOrgService;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.permission.bean.RoleEntity;
import com.ejianc.foundation.permission.bean.RoleUserRelationEntity;
import com.ejianc.foundation.permission.mapper.RoleAppRelationMapper;
import com.ejianc.foundation.permission.mapper.RoleButtonRelationMapper;
import com.ejianc.foundation.permission.service.IAppService;
import com.ejianc.foundation.permission.service.IRoleService;
import com.ejianc.foundation.permission.service.IRoleUserRelationService;
import com.ejianc.foundation.permission.service.impl.RoleAppRelationServiceImpl;
import com.ejianc.foundation.permission.vo.AppVO;
import com.ejianc.foundation.permission.vo.ButtonVO;
import com.ejianc.foundation.permission.vo.RoleAppVO;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.foundation.permission.vo.RoleVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.tenant.vo.EnterpriseVO;
import com.ejianc.foundation.workbench.bean.LayoutEntity;
import com.ejianc.foundation.workbench.bean.LayoutOrgRelationEntity;
import com.ejianc.foundation.workbench.service.ILayoutOrgRelationService;
import com.ejianc.foundation.workbench.service.ILayoutService;
import com.ejianc.foundation.workbench.vo.LayoutVO;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

/**
 * 套餐租户关系
 * 
 * @author generator
 * 
 */
@Service
public class ComboEnterpriseServiceImpl extends BaseServiceImpl<ComboEnterpriseMapper, ComboEnterpriseEntity> implements IComboEnterpriseService{

	private static final String LAYOUT_BILL_CODE = "IDM_LAYOUT";

	private static final String ROLE_BILL_CODE = "IDM_ROLE";
	private final static String CURRENTROLE_APP_KEY = "currentrole_app_key:";
	private final static String CURRENTROLE_USER_KEY = "currentrole_user_key:";
	//当前角色的应用按钮KEY
	private final static String CURRENTROLE_APP_BUTTON_KEY = "currentrole_app_button_key:";
	@Autowired
	private ComboEnterpriseMapper mapper;
	@Autowired
	private ComboRoleMapper comboRoleMapper;
	@Autowired
	private ComboAppMapper comboAppMapper;
	@Autowired
	private ComboDoorMapper comboDoorMapper;
	@Autowired
	private RoleAppRelationMapper appmapper;
	@Autowired
	private CacheManager cacheManager;
	@Autowired
	private RoleAppRelationServiceImpl roleAppRelationServiceImpl;
	
	@Autowired
	private IOrgService orgService;
	
	@Autowired
	private IEmployeeService employeeService;

	@Autowired
	private ILayoutService layoutService;
	@Autowired
	private IBillCodeApi billCodeApi;
	
	@Autowired
	private IRoleService roleService;
	@Autowired
	private IAppService appService;
	@Autowired
	private RoleButtonRelationMapper buttonmapper;
    @Autowired
    private IComboDoorService comboDoorService; 
	@Autowired
	private IRoleUserRelationService roleUserRelationService;
    @Autowired
    private ILayoutOrgRelationService layoutOrgRelationService;
	@Autowired
	private PermissionCacheManage permissionCacheManage;
	@Autowired
	private ComboEnterpriseMapper comboEnterpriseMapper;
	
	@Override
	public IPage<EnterpriseVO> queryPage(Map<String, Object> params, boolean isEs) {
		if(params.get("pageIndex")!=null){
			Integer pn = Integer.parseInt(params.get("pageIndex").toString());
			pn = pn - 1 < 0 ? 1 : pn;
	        long startLine = (pn - 1) * Integer.parseInt(params.get("pageSize").toString());
	        params.put("startLine", startLine);
		}
		Long count = mapper.countByProPerties(params);
		IPage<EnterpriseVO> page = new Page<EnterpriseVO>();
		if(count>0){
			List<EnterpriseVO> enterpriseVO = mapper.queryPageByProperties(params);
			page.setRecords(enterpriseVO);
		}else{
			page.setRecords(null);
		}
		if(params.get("pageIndex")!=null){
			page.setCurrent(Integer.parseInt(params.get("pageIndex").toString()));
			page.setSize(Integer.parseInt(params.get("pageSize").toString()));
			page.setTotal(count);
		}
		return page;
	}

	@Override
	@Transactional
	public CommonResponse<String> delete(List<ComboEnterpriseEntity> enterpriseVOs) {
		for(ComboEnterpriseEntity enterpriseVO:enterpriseVOs) {
			//先删除应用
			mapper.deleteAuthEnterprise(enterpriseVO.getComboId(),enterpriseVO.getBuyerId());
			
		}
		return CommonResponse.success("删除成功");
	}

	/**
	 * 保存套餐租户关系及租户角色、应用、门户数据初始化
	 */
	@Override
	@Transactional
	public CommonResponse<String> saveComboEnterprise(ComboEnterpriseVO comboEnterpriseVO) {
    	ComboEnterpriseEntity comboEnterpriseEntity = BeanMapper.map(comboEnterpriseVO, ComboEnterpriseEntity.class);
    	boolean add = true;
    	if(comboEnterpriseVO.getId()!=null){
    		add = false;
    	}
		if(add){
			//根据租户查询根组织id
			OrgVO orgVO = orgService.findOrgByTenantId(comboEnterpriseVO.getBuyerId());
			if(orgVO==null){
				throw new BusinessException("未查询到该企业的根组织信息");
			}
			
//			查询分配的用户详情信息
			EmployeeVO employeeVO = employeeService.querySuperEmployeeByTenantId(comboEnterpriseVO.getBuyerId());
			if(employeeVO==null){
				throw new BusinessException("未查询到租户的超级管理员");
			}
//			EmployeeVO employeeVO = employeeService.queryEmployeeByUserId(comboEnterpriseVO.getUserId());
//			if(employeeVO==null){
//				throw new BusinessException("未查询到分配用户的信息");
//			}else{
//				JobEntity jobVO = jobService.getCurMainJob(employeeVO.getId());
//				if(jobVO!=null){
//					employeeVO.setJobId(jobVO.getId());
//					employeeVO.setJobType(jobVO.getProperty());
//				}
//			}
			
			Map<String, Object> params = new HashMap<>();
			params.put("comboId", comboEnterpriseVO.getComboId());
			
//			获取之前初始化套餐的门户
			List<LayoutVO> allDoorVOs = comboDoorMapper.queryDoorByEnterpriseId(comboEnterpriseVO.getBuyerId());
			//获取当前套餐的门户
			IPage<LayoutVO> pageData = comboDoorService.queryPage(params, false);
			List<LayoutVO> layoutVO = pageData.getRecords();
	        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
	        String authTime = formatter.format(new Date());
			if(allDoorVOs!=null && allDoorVOs.size()>0){
				if(layoutVO!=null && layoutVO.size()>0){
					Map<Long,LayoutVO> doorMap = new HashMap<>();
					allDoorVOs.forEach(e -> {
						if(e.getSourceId()!=null)
							doorMap.put(e.getSourceId(), e);
					});
					//保存租户关系表
			        List<LayoutOrgRelationEntity> saveList = new ArrayList<>();
					for(LayoutVO vo : layoutVO){
						if(doorMap.get(vo.getId())==null){
							//复制门户保存
							CommonResponse<String> layoutResponse = billCodeApi.getCodeBatchByRuleCode(LAYOUT_BILL_CODE, comboEnterpriseVO.getBuyerId());
				        	if(layoutResponse.isSuccess()) {
				        		vo.setCode(layoutResponse.getData());
				        	}else{
								Long code = IdWorker.getId();
								vo.setCode(code.toString());
				        	}
							LayoutEntity saveEntity = BeanMapper.map(vo, LayoutEntity.class);
							saveEntity.setSourceId(vo.getId());
							saveEntity.setOrgId(orgVO.getId());
							saveEntity.setId(null);
							saveEntity.setCreateTime(null);
							saveEntity.setCreateUserCode(null);
							saveEntity.setUpdateTime(null);
							saveEntity.setUpdateUserCode(null);
							saveEntity.setTenantId(comboEnterpriseVO.getBuyerId());
							layoutService.saveOrUpdate(saveEntity, false);
							
							LayoutOrgRelationEntity entity = new LayoutOrgRelationEntity();
							entity.setAuthTime(authTime);
							entity.setAuthUserId(comboEnterpriseVO.getUserId());
							entity.setLayoutId(saveEntity.getId());
							entity.setOrgId(orgVO.getId());
							entity.setLimitFlag(2);
							entity.setTenantId(comboEnterpriseVO.getBuyerId());
							saveList.add(entity);
						}else{ //修改门户
							//更新最新的门户信息到用户
							LayoutEntity saveEntity = BeanMapper.map(doorMap.get(vo.getId()), LayoutEntity.class);//用户已有的套餐信息
							saveEntity.setDesignType(vo.getDesignType());
							saveEntity.setSetting(vo.getSetting());
							saveEntity.setTemplateUrl(vo.getTemplateUrl());
							layoutService.saveOrUpdate(saveEntity, false);
						}
					}
					if(saveList!=null&&saveList.size()>0){
						layoutOrgRelationService.saveOrUpdateBatch(saveList, saveList.size() < 1000 ? saveList.size() : 1000, false);
					}
				}
				
			}else{
				if(layoutVO!=null && layoutVO.size()>0){
					//保存租户关系表
			        List<LayoutOrgRelationEntity> saveList = new ArrayList<>();
					layoutVO.forEach(e -> {
						//复制门户保存
						CommonResponse<String> layoutResponse = billCodeApi.getCodeBatchByRuleCode(LAYOUT_BILL_CODE, comboEnterpriseVO.getBuyerId());
			        	if(layoutResponse.isSuccess()) {
			        		e.setCode(layoutResponse.getData());
			        	}else{
							Long code = IdWorker.getId();
							e.setCode(code.toString());
			        	}
						LayoutEntity saveEntity = BeanMapper.map(e, LayoutEntity.class);
						saveEntity.setSourceId(e.getId());
						saveEntity.setOrgId(orgVO.getId());
						saveEntity.setId(null);
						saveEntity.setCreateTime(null);
						saveEntity.setCreateUserCode(null);
						saveEntity.setUpdateTime(null);
						saveEntity.setUpdateUserCode(null);
						saveEntity.setTenantId(comboEnterpriseVO.getBuyerId());
						layoutService.saveOrUpdate(saveEntity, false);
						
						LayoutOrgRelationEntity entity = new LayoutOrgRelationEntity();
						entity.setAuthTime(authTime);
						entity.setAuthUserId(comboEnterpriseVO.getUserId());
						entity.setLayoutId(saveEntity.getId());
						entity.setOrgId(orgVO.getId());
						entity.setLimitFlag(2);
						entity.setTenantId(comboEnterpriseVO.getBuyerId());
						saveList.add(entity);
					});
					if(saveList!=null&&saveList.size()>0){
						layoutOrgRelationService.saveOrUpdateBatch(saveList, saveList.size() < 1000 ? saveList.size() : 1000, false);
					}
				}
			}
			
			//获取当前套餐下的所有授权应用
			List<AppVO> appVO = comboAppMapper.queryPageByProperties(params);
			Map<Long,AppVO> mapApp = new HashMap<>();
			if(appVO!=null&&appVO.size()>0){
				appVO.forEach(e -> {
					mapApp.put(e.getId(), e);
				});
			}
			//获取当前套餐的角色(平台运营组织的角色)
			List<RoleVO> nowRoleVO = comboRoleMapper.queryPageByProperties(params);
			
			//获取当前租户下所有套餐的角色(已分配的)
			List<RoleVO> allRoleVOs = comboRoleMapper.queryRoleByEnterpriseId(comboEnterpriseVO.getBuyerId());
			if(allRoleVOs!=null&&allRoleVOs.size()>0){
				//当前租户有套餐角色，校验过滤
				
				//获取已有套餐角色下的应用
				Map<Long,RoleVO> mapRole = new HashMap<>();
				for(RoleVO roleVO : allRoleVOs){
//					mapRole.put(roleVO.getId(), roleVO);
					if(roleVO.getSourceId()!=null)
						mapRole.put(roleVO.getSourceId(), roleVO);
				}
				for(RoleVO roleVO : nowRoleVO){
					if(mapRole.get(roleVO.getId())!=null){
						//该角色已存在，不需要新增,只需要关联应用
						
						//获取该角色已分配的应用
						Map<String, Object> appParams = new HashMap<>();
						appParams.put("roleId", mapRole.get(roleVO.getId()).getId());
						IPage<AppVO> exitAppPage = roleAppRelationServiceImpl.queryPage(appParams, false);
						
						//获取该角色全部的应用
						appParams.put("roleId", roleVO.getId());
						IPage<AppVO> allAppPage = roleAppRelationServiceImpl.queryPage(appParams, false);
						if(exitAppPage.getRecords()!=null&&exitAppPage.getRecords().size()>0){
							//存在已分配的应用，查询所有数据并过滤
							List<AppVO> exitAppVO = exitAppPage.getRecords();
							for(AppVO vo : exitAppVO){
								if(mapApp.get(vo.getId())!=null){
									mapApp.remove(vo.getId());
								}
							}

							RoleAppVO roleAppVO = new RoleAppVO();
							List<AppVO> app = new ArrayList<>();
							if(allAppPage.getRecords()!=null&&allAppPage.getRecords().size()>0){
								for(AppVO vo: allAppPage.getRecords()){
									if(mapApp.get(vo.getId())!=null){
										vo.setTenantId(comboEnterpriseVO.getBuyerId());
										app.add(vo);
									}
								}
							}
							if(app!=null&&app.size()>0){
								roleAppVO.setAppVO(app);
								roleAppVO.setRoleId(mapRole.get(roleVO.getId()).getId());
								appService.saveRoleApp(roleAppVO);
							}
						}else{
							
							//该角色未分分配应用，直接将应用与角色绑定
							RoleAppVO roleAppVO = new RoleAppVO();
							List<AppVO> app = new ArrayList<>();
							if(allAppPage.getRecords()!=null&&allAppPage.getRecords().size()>0){
								for(AppVO vo: allAppPage.getRecords()){
									if(mapApp.get(vo.getId())!=null){
										vo.setTenantId(comboEnterpriseVO.getBuyerId());
										app.add(vo);
									}
								}
							}
							if(app!=null&&app.size()>0){
								roleAppVO.setAppVO(app);
								roleAppVO.setRoleId(roleVO.getId());
								appService.saveRoleApp(roleAppVO);
							}
						}
					}else{
						//该角色未存在，新增角色并新增授权应用
						RoleEntity entity = BeanMapper.map(roleVO, RoleEntity.class);
						entity.setTenantId(comboEnterpriseVO.getBuyerId());
						entity.setOrgId(orgVO.getId());
						CommonResponse<String> roleResponse = billCodeApi.getCodeBatchByRuleCode(ROLE_BILL_CODE, comboEnterpriseVO.getBuyerId());
			        	if(roleResponse.isSuccess()) {
			        		entity.setCode(roleResponse.getData());
			        	}else{
							Long code = IdWorker.getId();
							entity.setCode(code.toString());
			        	}
						entity.setSourceId(roleVO.getId());
						entity.setId(null);
						entity.setCreateTime(null);
						entity.setCreateUserCode(null);
						entity.setUpdateTime(null);
						entity.setUpdateUserCode(null);
						roleService.saveOrUpdate(entity, false);//新增角色
						
						//授权角色用户关系
						List<RoleUserRelationVO> data = new ArrayList<>();
						RoleUserRelationVO roleUserRelationVO = new RoleUserRelationVO();
						roleUserRelationVO.setAuthOrgId(employeeVO.getOrgId());
						roleUserRelationVO.setEmployeeId(employeeVO.getId());
						roleUserRelationVO.setJobId(employeeVO.getJobId());
						roleUserRelationVO.setProperty(String.valueOf(employeeVO.getJobType()));
						roleUserRelationVO.setRoleId(entity.getId());
						roleUserRelationVO.setUserId(employeeVO.getUserId());
						roleUserRelationVO.setTenantId(comboEnterpriseVO.getBuyerId());
						data.add(roleUserRelationVO);
						roleUserRelationService.saveRoleUser(data);
						
						Map<String, Object> appParams = new HashMap<>();
						appParams.put("roleId", roleVO.getId());
						IPage<AppVO> rolePage = roleAppRelationServiceImpl.queryPage(appParams, false);
						if(rolePage.getRecords()!=null&&rolePage.getRecords().size()>0){
							RoleAppVO roleAppVO = new RoleAppVO();
							List<AppVO> app = new ArrayList<>();
							for(AppVO vo: rolePage.getRecords()){
								if(mapApp.get(vo.getId())!=null){
									vo.setTenantId(comboEnterpriseVO.getBuyerId());
									app.add(vo);
								}
							}
							if(app!=null&&app.size()>0){
								roleAppVO.setAppVO(app);
								roleAppVO.setRoleId(entity.getId());
								appService.saveRoleApp(roleAppVO);
							}
						}
					}
				}
				//
			}else{
				//查询角色下的应用
				if(nowRoleVO!=null&&nowRoleVO.size()>0){
					for(RoleVO roleVO : nowRoleVO){
						//当前租户没有套餐角色，直接新增（不过滤校验）
						RoleEntity entity = BeanMapper.map(roleVO, RoleEntity.class);
						entity.setTenantId(comboEnterpriseVO.getBuyerId());
						entity.setOrgId(orgVO.getId());
						CommonResponse<String> roleResponse = billCodeApi.getCodeBatchByRuleCode(ROLE_BILL_CODE, comboEnterpriseVO.getBuyerId());
			        	if(roleResponse.isSuccess()) {
			        		entity.setCode(roleResponse.getData());
			        	}else{
							Long code = IdWorker.getId();
							entity.setCode(code.toString());
			        	}
						entity.setSourceId(roleVO.getId());
						entity.setId(null);
						entity.setCreateTime(null);
						entity.setCreateUserCode(null);
						entity.setUpdateTime(null);
						entity.setUpdateUserCode(null);
						roleService.saveOrUpdate(entity, false);//新增角色
						
						//授权角色用户关系
						List<RoleUserRelationVO> data = new ArrayList<>();
						RoleUserRelationVO roleUserRelationVO = new RoleUserRelationVO();
						roleUserRelationVO.setAuthOrgId(employeeVO.getOrgId());
						roleUserRelationVO.setEmployeeId(employeeVO.getId());
						roleUserRelationVO.setJobId(employeeVO.getJobId());
						roleUserRelationVO.setProperty(String.valueOf(employeeVO.getJobType()));
						roleUserRelationVO.setRoleId(entity.getId());
						roleUserRelationVO.setUserId(employeeVO.getUserId());
						roleUserRelationVO.setTenantId(comboEnterpriseVO.getBuyerId());
						data.add(roleUserRelationVO);
						roleUserRelationService.saveRoleUser(data);
						
						Map<String, Object> appParams = new HashMap<>();
						appParams.put("roleId", roleVO.getId());
						IPage<AppVO> rolePage = roleAppRelationServiceImpl.queryPage(appParams, false);
						if(rolePage.getRecords()!=null&&rolePage.getRecords().size()>0){
							RoleAppVO roleAppVO = new RoleAppVO();
							List<AppVO> app = new ArrayList<>();
							for(AppVO vo: rolePage.getRecords()){
								if(mapApp.get(vo.getId())!=null){
									vo.setTenantId(comboEnterpriseVO.getBuyerId());
									app.add(vo);
								}
							}
							if(app!=null&&app.size()>0){
								roleAppVO.setAppVO(app);
								roleAppVO.setRoleId(entity.getId());
								appService.saveRoleApp(roleAppVO);
							}
						}
						
					}
				}
			}
			
		}

    	this.saveOrUpdate(comboEnterpriseEntity , false);
    	if(!add){
			//启停用、续费等
//			刷新缓存
			refreshAuthCache(comboEnterpriseEntity.getBuyerId());
    	}
		return CommonResponse.success("保存成功");
	}

	/**
	 * 为供方挂载默认套餐角色等等
	 *
	 * @param comboEnterpriseVO
	 * @return
	 */
	@Override
	public CommonResponse<String> loadComboEnterprise(ComboEnterpriseVO comboEnterpriseVO,Long orgId,EmployeeVO employeeVO) {

		ComboEnterpriseEntity comboEnterpriseEntity = BeanMapper.map(comboEnterpriseVO, ComboEnterpriseEntity.class);

		//获取当前套餐的门户
		Map<String, Object> params = new HashMap<>();
		params.put("comboId", comboEnterpriseVO.getComboId());
		IPage<LayoutVO> pageData = comboDoorService.queryPage(params, false);
		List<LayoutVO> layoutVO = pageData.getRecords();
		SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
		String authTime = formatter.format(new Date());

		if(ListUtil.isNotEmpty(layoutVO)){
			//保存租户关系表
			List<LayoutOrgRelationEntity> saveList = new ArrayList<>();
			layoutVO.forEach(e -> {
				//复制门户保存
				CommonResponse<String> layoutResponse = billCodeApi.getCodeBatchByRuleCode(LAYOUT_BILL_CODE, comboEnterpriseVO.getBuyerId());
				if(layoutResponse.isSuccess()) {
					e.setCode(layoutResponse.getData());
				}else{
					e.setCode(comboEnterpriseVO.getBuyerId().toString());
				}
				LayoutEntity saveEntity = BeanMapper.map(e, LayoutEntity.class);
				saveEntity.setSourceId(e.getId());
				saveEntity.setOrgId(orgId);
				saveEntity.setId(null);
				saveEntity.setCreateTime(null);
				saveEntity.setCreateUserCode(null);
				saveEntity.setUpdateTime(null);
				saveEntity.setUpdateUserCode(null);
				saveEntity.setTenantId(comboEnterpriseVO.getBuyerId());
				layoutService.saveOrUpdate(saveEntity, false);

				LayoutOrgRelationEntity entity = new LayoutOrgRelationEntity();
				entity.setAuthTime(authTime);
				entity.setAuthUserId(comboEnterpriseVO.getUserId());
				entity.setLayoutId(saveEntity.getId());
				entity.setOrgId(orgId);
				entity.setLimitFlag(2);
				entity.setTenantId(comboEnterpriseVO.getBuyerId());
				saveList.add(entity);
			});
			if(saveList.size() > 0){
				layoutOrgRelationService.saveOrUpdateBatch(saveList, saveList.size(), false);
			}
		}

		//获取当前套餐下的所有授权应用
		List<AppVO> appVO = comboAppMapper.queryPageByProperties(params);
		Map<Long,AppVO> mapApp = new HashMap<>();
		if(appVO!=null&&appVO.size()>0){
			appVO.forEach(e -> {
				mapApp.put(e.getId(), e);
			});
		}
		//获取当前套餐的角色(平台运营组织的角色)
		List<RoleVO> nowRoleVO = comboRoleMapper.queryPageByProperties(params);

		//查询角色下的应用
		if(nowRoleVO!=null&&nowRoleVO.size()>0){
			for(RoleVO roleVO : nowRoleVO){
				//当前租户没有套餐角色，直接新增（不过滤校验）
				RoleEntity entity = BeanMapper.map(roleVO, RoleEntity.class);
				entity.setTenantId(comboEnterpriseVO.getBuyerId());
				entity.setOrgId(orgId);
				CommonResponse<String> roleResponse = billCodeApi.getCodeBatchByRuleCode(ROLE_BILL_CODE, comboEnterpriseVO.getBuyerId());
				if(roleResponse.isSuccess()) {
					entity.setCode(roleResponse.getData());
				}else{
					entity.setCode(comboEnterpriseVO.getBuyerId().toString());
				}
				entity.setSourceId(roleVO.getId());
				entity.setId(null);
				entity.setCreateTime(null);
				entity.setCreateUserCode(null);
				entity.setUpdateTime(null);
				entity.setUpdateUserCode(null);
				roleService.saveOrUpdate(entity, false);//新增角色

				//授权新角色与用户关系
				List<RoleUserRelationVO> data = new ArrayList<>();
				RoleUserRelationVO roleUserRelationVO = new RoleUserRelationVO();
				roleUserRelationVO.setAuthOrgId(orgId);
				roleUserRelationVO.setEmployeeId(employeeVO.getId());
				roleUserRelationVO.setJobId(employeeVO.getJobId());
				roleUserRelationVO.setProperty(String.valueOf(employeeVO.getJobType()));
				roleUserRelationVO.setRoleId(entity.getId());
				roleUserRelationVO.setUserId(employeeVO.getId());
				roleUserRelationVO.setTenantId(comboEnterpriseVO.getBuyerId());
				data.add(roleUserRelationVO);
				roleUserRelationService.saveRoleUser(data);

				Map<String, Object> appParams = new HashMap<>();
				appParams.put("roleId", roleVO.getId());
				/** 查询该角色下授权的应用 */
				IPage<AppVO> rolePage = roleAppRelationServiceImpl.queryPage(appParams, false);
				if(rolePage.getRecords()!=null&&rolePage.getRecords().size()>0){
					RoleAppVO roleAppVO = new RoleAppVO();
					List<AppVO> app = new ArrayList<>();
					for(AppVO vo: rolePage.getRecords()){
						if(mapApp.get(vo.getId())!=null){
							vo.setTenantId(comboEnterpriseVO.getBuyerId());
							app.add(vo);
						}
					}
					if(app!=null&&app.size()>0){
						roleAppVO.setAppVO(app);
						roleAppVO.setRoleId(entity.getId());
						appService.saveRoleApp(roleAppVO);
					}
				}

			}
		}


		this.saveOrUpdate(comboEnterpriseEntity , false);
		return CommonResponse.success("保存成功");
	}

	/**
	 * 为供方挂载默认套餐角色等等  中电四
	 *
	 * @param comboEnterpriseVO
	 * @param orgId
	 * @return
	 */
	@Override
	public CommonResponse<String> loadComboTenant(ComboEnterpriseVO comboEnterpriseVO, Long orgId) {

		ComboEnterpriseEntity comboEnterpriseEntity = BeanMapper.map(comboEnterpriseVO, ComboEnterpriseEntity.class);

		//获取当前套餐的门户
		Map<String, Object> params = new HashMap<>();
		params.put("comboId", comboEnterpriseVO.getComboId());
		IPage<LayoutVO> pageData = comboDoorService.queryPage(params, false);
		List<LayoutVO> layoutVO = pageData.getRecords();
		SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
		String authTime = formatter.format(new Date());

		if(ListUtil.isNotEmpty(layoutVO)){
			//保存租户关系表
			List<LayoutOrgRelationEntity> saveList = new ArrayList<>();
			layoutVO.forEach(e -> {
				//复制门户保存
				CommonResponse<String> layoutResponse = billCodeApi.getCodeBatchByRuleCode(LAYOUT_BILL_CODE, comboEnterpriseVO.getBuyerId());
				if(layoutResponse.isSuccess()) {
					e.setCode(layoutResponse.getData());
				}else{
					e.setCode(comboEnterpriseVO.getBuyerId().toString());
				}
				LayoutEntity saveEntity = BeanMapper.map(e, LayoutEntity.class);
				saveEntity.setSourceId(e.getId());
				saveEntity.setOrgId(orgId);
				saveEntity.setId(null);
				saveEntity.setCreateTime(null);
				saveEntity.setCreateUserCode(null);
				saveEntity.setUpdateTime(null);
				saveEntity.setUpdateUserCode(null);
				saveEntity.setTenantId(comboEnterpriseVO.getBuyerId());
				layoutService.saveOrUpdate(saveEntity, false);

				LayoutOrgRelationEntity entity = new LayoutOrgRelationEntity();
				entity.setAuthTime(authTime);
				entity.setLayoutId(saveEntity.getId());
				entity.setOrgId(orgId);
				entity.setLimitFlag(2);
				entity.setTenantId(comboEnterpriseVO.getBuyerId());
				saveList.add(entity);
			});
			if(saveList.size() > 0){
				layoutOrgRelationService.saveOrUpdateBatch(saveList, saveList.size(), false);
			}
		}

		//获取当前套餐下的所有授权应用
		List<AppVO> appVO = comboAppMapper.queryPageByProperties(params);
		Map<Long,AppVO> mapApp = new HashMap<>();
		if(appVO!=null&&appVO.size()>0){
			appVO.forEach(e -> {
				mapApp.put(e.getId(), e);
			});
		}
		//获取当前套餐的角色(平台运营组织的角色)
		List<RoleVO> nowRoleVO = comboRoleMapper.queryPageByProperties(params);

		//查询角色下的应用
		if(nowRoleVO!=null&&nowRoleVO.size()>0){
			for(RoleVO roleVO : nowRoleVO){
				//当前租户没有套餐角色，直接新增（不过滤校验）
				RoleEntity entity = BeanMapper.map(roleVO, RoleEntity.class);
				entity.setTenantId(comboEnterpriseVO.getBuyerId());
				entity.setOrgId(orgId);
				CommonResponse<String> roleResponse = billCodeApi.getCodeBatchByRuleCode(ROLE_BILL_CODE, comboEnterpriseVO.getBuyerId());
				if(roleResponse.isSuccess()) {
					entity.setCode(roleResponse.getData());
				}else{
					entity.setCode(comboEnterpriseVO.getBuyerId().toString());
				}
				entity.setSourceId(roleVO.getId());
				entity.setId(null);
				entity.setCreateTime(null);
				entity.setCreateUserCode(null);
				entity.setUpdateTime(null);
				entity.setUpdateUserCode(null);
				roleService.saveOrUpdate(entity, false);//新增角色

				Map<String, Object> appParams = new HashMap<>();
				appParams.put("roleId", roleVO.getId());
				/** 查询该角色下授权的应用 */
				IPage<AppVO> rolePage = roleAppRelationServiceImpl.queryPage(appParams, false);
				if(rolePage.getRecords()!=null&&rolePage.getRecords().size()>0){
					RoleAppVO roleAppVO = new RoleAppVO();
					List<AppVO> app = new ArrayList<>();
					for(AppVO vo: rolePage.getRecords()){
						if(mapApp.get(vo.getId())!=null){
							vo.setTenantId(comboEnterpriseVO.getBuyerId());
							app.add(vo);
						}
					}
					if(app!=null&&app.size()>0){
						roleAppVO.setAppVO(app);
						roleAppVO.setRoleId(entity.getId());
						appService.saveRoleApp(roleAppVO);
					}
				}

			}
		}
		this.saveOrUpdate(comboEnterpriseEntity , false);
		return CommonResponse.success("保存成功");
	}

	/**
	 * 为供方用户挂载默认套餐角色等等  中电四
	 *
	 * @param comboEnterpriseVO
	 * @param orgId
	 * @param employeeVO
	 * @return
	 */
	@Override
	public CommonResponse<String> loadComboUser(ComboEnterpriseVO comboEnterpriseVO, Long orgId, EmployeeVO employeeVO) {
		//获取当前套餐的门户
		Map<String, Object> params = new HashMap<>();
		params.put("comboId", comboEnterpriseVO.getComboId());
		//获取当前套餐的角色(平台运营组织的角色)
		List<RoleVO> nowRoleVO = comboRoleMapper.queryPageByProperties(params);
		//查询角色下的应用
		if(ListUtil.isNotEmpty(nowRoleVO)){
			QueryParam param = QueryParam.getInstance();
			param.getParams().put("tenantId", Parameter.getEqInstance(comboEnterpriseVO.getBuyerId()));
			param.getParams().put("orgId", Parameter.getEqInstance(orgId));
			for(RoleVO roleVO : nowRoleVO){
				param.getParams().put("sourceId", Parameter.getEqInstance(roleVO.getId()));
				List<RoleEntity> roleEntities = roleService.queryList(param,false);
				if(ListUtil.isEmpty(roleEntities)){
					System.out.println("租户的角色不存在！");
					continue;
				}
				//当前租户没有套餐角色，直接新增（不过滤校验）
				RoleEntity entity = roleEntities.get(0);
				//授权租户角色与用户关系
				List<RoleUserRelationVO> data = new ArrayList<>();
				RoleUserRelationVO roleUserRelationVO = new RoleUserRelationVO();
				roleUserRelationVO.setAuthOrgId(orgId);
				roleUserRelationVO.setEmployeeId(employeeVO.getId());
				roleUserRelationVO.setJobId(employeeVO.getJobId());
				roleUserRelationVO.setProperty(String.valueOf(employeeVO.getJobType()));
				roleUserRelationVO.setRoleId(entity.getId());
				roleUserRelationVO.setUserId(employeeVO.getId());
				roleUserRelationVO.setTenantId(comboEnterpriseVO.getBuyerId());
				data.add(roleUserRelationVO);
				roleUserRelationService.saveRoleUser(data);
			}
		}
		return CommonResponse.success("保存成功");
	}

	public void refreshAuthCache(Long tenantId) {
		QueryWrapper<RoleEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("tenant_id", tenantId);
		List<RoleEntity> roleList = roleService.list(queryWrapper);
		if (roleList != null && roleList.size() > 0) {
			//
			for (RoleEntity roleEntity : roleList) {
				List<AppVO> appVos = null;
				if(999999L == roleEntity.getTenantId()) {
					appVos = appmapper.queryAuthListByRoleId(roleEntity.getId());
				}else{
					Map<String, Object> queryParam = new HashMap<>();
					queryParam.put("tenantId", roleEntity.getTenantId());
					queryParam.put("roleId", roleEntity.getId());
					appVos = appmapper.queryPageByProperties(queryParam);
				}
				QueryWrapper<RoleUserRelationEntity> roleUserQueryWrapper = new QueryWrapper<>();
				roleUserQueryWrapper.eq("role_id", roleEntity.getId());
				List<RoleUserRelationEntity> roleUserRelationEntities = roleUserRelationService.list(roleUserQueryWrapper);
				List<RoleUserRelationVO> roleUserRelationVos = BeanMapper.mapList(roleUserRelationEntities, RoleUserRelationVO.class);
				
				cacheManager.removeCache(CURRENTROLE_APP_KEY + roleEntity.getId());
				cacheManager.removeCache(CURRENTROLE_USER_KEY + roleEntity.getId());

				/** 删除按钮权限缓存 */
				cacheManager.removeCache(CURRENTROLE_APP_BUTTON_KEY + roleEntity.getId());
				/** 查询角色应用下有权限的按钮 */
				if(ListUtil.isNotEmpty(appVos)){
					Map<String, Object> param = new HashMap<>();
					for(AppVO app:appVos){
						param.put("roleId", roleEntity.getId());
						param.put("appId", app.getId());
						param.put("dr", 0);
						List<ButtonVO> btnVos = buttonmapper.queryProperties(param);
						if(ListUtil.isNotEmpty(btnVos)){
							app.setChildren(btnVos);
						}
					}
				}
				permissionCacheManage.putRoleAppsCache(roleEntity.getId(), appVos);
				permissionCacheManage.putRoleUsersCache(roleEntity.getId(), roleUserRelationVos);
			}
		}
	}
	
	//查询套餐已分配的未过期的租户
	@Override
	public List<Long> queryTenantIdBycomboId(Long comboId){
		QueryWrapper<ComboEnterpriseEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("dr", 0);
		queryWrapper.eq("combo_id", comboId);
//		queryWrapper.gt("end_time", new Date());
		List<ComboEnterpriseEntity> list = this.list(queryWrapper);
		List<Long> tenantIds = new ArrayList<>();
		if(list!=null&&list.size()>0){
			list.forEach(e -> {
				tenantIds.add(e.getBuyerId());
			});
		}
		return tenantIds;
	}

	@Override
	public ComboEnterpriseVO queryComboEntityBean(Long tenantId, String comboCode) {
		ComboEnterpriseVO comboEnterpriseVo = comboEnterpriseMapper.queryComboEntityBean(tenantId,comboCode);
		return comboEnterpriseVo;
	}
}
