package com.ejianc.foundation.tenant.bean;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 企业
 * 
 * @author guominga
 *
 */
@TableName("ejc_idm_enterprise")
public class EnterpriseEntity extends BaseEntity {

	private static final long serialVersionUID = 1L;

	@TableField(value = "enterprise_type")
	private String enterpriseType; // 入驻客户类型： 1：企业， 2：个人，3：班组长

	@TableField(value = "business_type")
	private String businessType; // 申请类型： 1：建筑施工单位， 2： 供应商， 3：其它

	@TableField(value = "register_phone_num")
	private String registerPhoneNum;// 注册手机号

	@TableField(value = "code")
	private String code; // 企业编码

	@TableField(value = "name")
	private String name; // 企业名称

	@TableField(value = "full_name")
	private String fullName;// 企业全称

	@TableField(value = "area")
	private String area; // 所属地区

	@TableField(value = "industry")
	private String industry; // 所属行业

	@TableField(value = "enterprise_scale")
	private String enterpriseScale; // 企业规模

	@TableField(value = "tax_code")
	private String taxCode; // 纳税人识别码

	@TableField(value = "legal_name")
	private String legalName; // 法人姓名

	@TableField(value = "telephone")
	private String telephone; // 手机号、联系电话

	@TableField(value = "license_file")
	private String licenseFile; // 营业执照附件地址

	@TableField(value = "idcard")
	private String idCard; // 身份证号

	@TableField(value = "idcard_front_file")
	private String idCardFrontFile; // 身份证正面照

	@TableField(value = "idcard_back_file")
	private String idCardBackFile;// 身份证反面照

	@TableField(value = "commit_time")
	private Date commitTime; // 提交日期

	@TableField(value = "audit_name")
	private String auditName; // 审批人姓名

	@TableField(value = "audit_opinion")
	private String auditOpinion; // 审核意见

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	@TableField(value = "audit_time")
	private Date auditTime; // 审核时间

	@TableField(value = "user_id")
	private Long userId; // 企业用户账号ID--创建人

	@TableField(value = "examine_state")
	private String examineState; // 审核状态 (3:编辑态，0：待审，1：通过， 2：不通过)

	@TableField(value = "logo_path")
	private String logoPath;// 企业logo

	@TableField(value = "logo_css")
	private String logoCss; // 企业logo样式

	@TableField(value = "logout_url")
	private String logoutUrl; // 第三方自定义登录页。 退出url

	/************ 暂时不清理字段start ***************/

	@TableField(value = "website")
	private String website;// 公司官网地址

	@TableField(value = "email")
	private String email;// 公司邮箱

	@TableField(value = "social_credit_code")
	private String socialCreditCode;// 社会信用代码

	@TableField(value = "regist_capital")
	private String registCapital;// 注册资本

	@TableField(value = "description")
	private String description;// 企业描述

	@TableField(value = "sequence")
	private Integer sequence;// 排序号

	@TableField(value = "ways")
	private String ways;// 注册途径：1、官网注册2、企业认证3、供方协同4、供方门户推送，5、平台新增，6、企业微信或钉钉第三方应用安装生成

	@TableField(value = "data_host")
	private String dataHost;// 第三方平台数据服务器地址

	@TableField(value = "data_app_id")
	private String dataAppId;// 第三方平台数据服务器appId

	@TableField(value = "data_app_secret")
	private String dataAppSecret;// 第三方平台数据服务器appSecret

	/************ 暂时不清理字段end ***************/
	@TableField(exist = false)
	private java.lang.Long loadTenantId; // 分包供应商 挂载的供应商租户id 公有云的租户 分包负责人推送使用

	@TableField(value = "oem_host")
	private String oemHost; // oem地址

	@TableField(value = "supplier_id")
	private Long supplierId; // 供方id

	public Long getLoadTenantId() {
		return loadTenantId;
	}

	public void setLoadTenantId(Long loadTenantId) {
		this.loadTenantId = loadTenantId;
	}

	public String getEnterpriseType() {
		return enterpriseType;
	}

	public void setEnterpriseType(String enterpriseType) {
		this.enterpriseType = enterpriseType;
	}

	public String getBusinessType() {
		return businessType;
	}

	public void setBusinessType(String businessType) {
		this.businessType = businessType;
	}

	public String getRegisterPhoneNum() {
		return registerPhoneNum;
	}

	public void setRegisterPhoneNum(String registerPhoneNum) {
		this.registerPhoneNum = registerPhoneNum;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getFullName() {
		return fullName;
	}

	public void setFullName(String fullName) {
		this.fullName = fullName;
	}

	public String getArea() {
		return area;
	}

	public void setArea(String area) {
		this.area = area;
	}

	public String getIndustry() {
		return industry;
	}

	public void setIndustry(String industry) {
		this.industry = industry;
	}

	public String getEnterpriseScale() {
		return enterpriseScale;
	}

	public void setEnterpriseScale(String enterpriseScale) {
		this.enterpriseScale = enterpriseScale;
	}

	public String getTaxCode() {
		return taxCode;
	}

	public void setTaxCode(String taxCode) {
		this.taxCode = taxCode;
	}

	public String getLegalName() {
		return legalName;
	}

	public void setLegalName(String legalName) {
		this.legalName = legalName;
	}

	public String getTelephone() {
		return telephone;
	}

	public void setTelephone(String telephone) {
		this.telephone = telephone;
	}

	public String getLicenseFile() {
		return licenseFile;
	}

	public void setLicenseFile(String licenseFile) {
		this.licenseFile = licenseFile;
	}

	public String getIdCard() {
		return idCard;
	}

	public void setIdCard(String idCard) {
		this.idCard = idCard;
	}

	public String getIdCardFrontFile() {
		return idCardFrontFile;
	}

	public void setIdCardFrontFile(String idCardFrontFile) {
		this.idCardFrontFile = idCardFrontFile;
	}

	public String getIdCardBackFile() {
		return idCardBackFile;
	}

	public void setIdCardBackFile(String idCardBackFile) {
		this.idCardBackFile = idCardBackFile;
	}

	public Date getCommitTime() {
		return commitTime;
	}

	public void setCommitTime(Date commitTime) {
		this.commitTime = commitTime;
	}

	public String getAuditName() {
		return auditName;
	}

	public void setAuditName(String auditName) {
		this.auditName = auditName;
	}

	public String getAuditOpinion() {
		return auditOpinion;
	}

	public void setAuditOpinion(String auditOpinion) {
		this.auditOpinion = auditOpinion;
	}

	public Date getAuditTime() {
		return auditTime;
	}

	public void setAuditTime(Date auditTime) {
		this.auditTime = auditTime;
	}

	public Long getUserId() {
		return userId;
	}

	public void setUserId(Long userId) {
		this.userId = userId;
	}

	public String getExamineState() {
		return examineState;
	}

	public void setExamineState(String examineState) {
		this.examineState = examineState;
	}

	public String getLogoPath() {
		return logoPath;
	}

	public void setLogoPath(String logoPath) {
		this.logoPath = logoPath;
	}

	public String getLogoCss() {
		return logoCss;
	}

	public void setLogoCss(String logoCss) {
		this.logoCss = logoCss;
	}

	public String getLogoutUrl() {
		return logoutUrl;
	}

	public void setLogoutUrl(String logoutUrl) {
		this.logoutUrl = logoutUrl;
	}

	public String getWebsite() {
		return website;
	}

	public void setWebsite(String website) {
		this.website = website;
	}

	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public String getSocialCreditCode() {
		return socialCreditCode;
	}

	public void setSocialCreditCode(String socialCreditCode) {
		this.socialCreditCode = socialCreditCode;
	}

	public String getRegistCapital() {
		return registCapital;
	}

	public void setRegistCapital(String registCapital) {
		this.registCapital = registCapital;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public Integer getSequence() {
		return sequence;
	}

	public void setSequence(Integer sequence) {
		this.sequence = sequence;
	}

	public String getWays() {
		return ways;
	}

	public void setWays(String ways) {
		this.ways = ways;
	}

	public String getDataHost() {
		return dataHost;
	}

	public void setDataHost(String dataHost) {
		this.dataHost = dataHost;
	}

	public String getDataAppId() {
		return dataAppId;
	}

	public void setDataAppId(String dataAppId) {
		this.dataAppId = dataAppId;
	}

	public String getDataAppSecret() {
		return dataAppSecret;
	}

	public void setDataAppSecret(String dataAppSecret) {
		this.dataAppSecret = dataAppSecret;
	}

	public String getOemHost() {
		return oemHost;
	}

	public void setOemHost(String oemHost) {
		this.oemHost = oemHost;
	}

	public Long getSupplierId() {
		return supplierId;
	}

	public void setSupplierId(Long supplierId) {
		this.supplierId = supplierId;
	}
}
