package com.ejianc.foundation.oms.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.oms.bean.ComboRoleEntity;
import com.ejianc.foundation.oms.mapper.ComboRoleMapper;
import com.ejianc.foundation.oms.service.IComboAppService;
import com.ejianc.foundation.oms.service.IComboEnterpriseService;
import com.ejianc.foundation.oms.service.IComboRoleService;
import com.ejianc.foundation.oms.vo.ComboRoleVO;
import com.ejianc.foundation.orgcenter.service.IEmployeeService;
import com.ejianc.foundation.orgcenter.service.IOrgService;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.permission.bean.RoleEntity;
import com.ejianc.foundation.permission.service.IAppService;
import com.ejianc.foundation.permission.service.IRoleAppRelationService;
import com.ejianc.foundation.permission.service.IRoleService;
import com.ejianc.foundation.permission.service.IRoleUserRelationService;
import com.ejianc.foundation.permission.vo.AppVO;
import com.ejianc.foundation.permission.vo.RoleAppVO;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.foundation.permission.vo.RoleVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.ibatis.builder.BuilderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 套餐角色关系
 * 
 * @author generator
 * 
 */
@Service
public class ComboRoleServiceImpl extends BaseServiceImpl<ComboRoleMapper, ComboRoleEntity> implements IComboRoleService{

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	private static final String ROLE_BILL_CODE = "IDM_ROLE";
	@Autowired
	private ComboRoleMapper mapper;
	@Autowired
	private IComboEnterpriseService comboEnterpriseService;
	@Autowired
	private IRoleService roleService;
	@Autowired
	private IEmployeeService employeeService;
	@Autowired
	private IBillCodeApi billCodeApi;
	@Autowired
	private IRoleUserRelationService roleUserRelationService;
	@Autowired
	private IOrgService orgService;
	@Autowired
	private IRoleAppRelationService roleAppRelationService;

    @Autowired
    private IComboAppService comboAppService; 
	@Autowired
	private IAppService appService;
	
//	@Autowired
//	private PermissionCacheManage permissionCacheManage;
	
	@Override
	public IPage<RoleVO> queryPage(Map<String, Object> params, boolean isEs) {
		if(params.get("pageIndex")!=null){
			Integer pn = Integer.parseInt(params.get("pageIndex").toString());
			pn = pn - 1 < 0 ? 1 : pn;
	        long startLine = (pn - 1) * Integer.parseInt(params.get("pageSize").toString());
	        params.put("startLine", startLine);
		}
		Long count = mapper.countByProPerties(params);
		IPage<RoleVO> page = new Page<RoleVO>();
		if(count>0){
			List<RoleVO> roleVO = mapper.queryPageByProperties(params);
			page.setRecords(roleVO);
		}else{
			page.setRecords(null);
		}
		if(params.get("pageIndex")!=null){
			page.setCurrent(Integer.parseInt(params.get("pageIndex").toString()));
			page.setSize(Integer.parseInt(params.get("pageSize").toString()));
			page.setTotal(count);
		}
		return page;
	}

	@Override
	@Transactional
	public CommonResponse<String> delete(List<ComboRoleEntity> roleVos) {
		for(ComboRoleEntity roleVo:roleVos) {
			
			/*******************目前不删除推送给租户的角色*************************************/
			/*
			//删除角色时需要先判断该角色是否在租户的其他套餐中，若在则不删除租户的角色数据，若不再则删除租户的角色+角色应用关系+角色用户

			//1、查询该套餐是否分配租户
			List<Long> tenantIds = comboEnterpriseService.queryTenantIdBycomboId(roleVo.getComboId());
			if(tenantIds!=null&&tenantIds.size()>0){
				for(Long tenantId : tenantIds){
					//判断该角色是否在租户的其他套餐中
					List<ComboRoleEntity> roleRelationList = mapper.queryRoleRelationList(roleVo.getComboId(), roleVo.getRoleId(), tenantId);
					if(roleRelationList!=null&&roleRelationList.size()>0){
						//若在则不删除租户的角色数据
						continue;
					}else{
						//若不再则删除租户的角色+角色应用关系+角色用户
						QueryWrapper<RoleEntity> queryWrapper = new QueryWrapper<>();
						queryWrapper.eq("dr", 0);
						queryWrapper.eq("source_id", roleVo.getRoleId());
						queryWrapper.eq("tenant_id", tenantId);
						List<RoleEntity> roleEntity = roleService.list(queryWrapper);
						if(roleEntity!=null&&roleEntity.size()>0){
							List<Long> ids = new ArrayList<>();
							roleEntity.forEach(e -> {
								ids.add(e.getId());
							});
							roleService.delete(ids);
						}
					}
					
				}
			}
*/
			mapper.deleteAuthRole(roleVo.getComboId(),roleVo.getRoleId());
			
			//删除redis对应的角色应用
//			permissionCacheManage.removeRoleRolesCache(roleVo.getRoleId(), roleVo.getAppId());
		}
		return CommonResponse.success("删除成功");
	}

	/**
	 * 保存套餐应用关系+推送已分配用户套餐的角色
	 */
	@Override
	public CommonResponse<String> saveComboRole(ComboRoleVO comboRoleVO) {
		if(comboRoleVO.getComboId()!=null){
			List<RoleVO> roleVo = comboRoleVO.getRoleVO();
			if(roleVo!=null&&roleVo.size()>0){
				List<ComboRoleEntity> roleList = new ArrayList<>();
				for(RoleVO vo : roleVo){
					ComboRoleEntity entity = new ComboRoleEntity();
					entity.setRoleId(vo.getId());
					entity.setComboId(comboRoleVO.getComboId());
					roleList.add(entity);
				}
				if(roleList.size()>0){
					this.saveOrUpdateBatch(roleList, roleList.size(), false);
				}
				
				//获取套餐下的应用
				Map<String, Object>  params1 = new HashMap<>();
				params1.put("comboId", comboRoleVO.getComboId());
				IPage<AppVO> pageData = comboAppService.queryPage(params1, false);
				Map<Long,AppVO> comboAppMap = new HashMap<>();
				if(pageData.getRecords()!=null&&pageData.getRecords().size()>0){
					for(AppVO app:pageData.getRecords()){
						comboAppMap.put(app.getId(), app);
					}
				}
				
				//推送已分配用户套餐的角色关系
				//1、查询该套餐是否分配租户
				List<Long> tenantIds = comboEnterpriseService.queryTenantIdBycomboId(comboRoleVO.getComboId());
				if(tenantIds!=null&&tenantIds.size()>0){
					//复制角色
					for(Long tenantId : tenantIds){
						//查询该租户的所有角色
						List<RoleVO> roleVOs = mapper.queryRoleByEnterpriseId(tenantId);
						//2、查询该角色是否已在租户的套餐中，若在则忽略，不存在则新增
						if(roleVOs==null||roleVOs.size()==0){
							//用户不存在角色，直接新增
							for(RoleVO roleVO : roleVo){
								
								//3、将该角色推送给租户（角色表分配的租户各生成一条复制的角色）
								//查询分配的租户超级管理员用户详情信息
								OrgVO orgVo = orgService.findOrgByTenantId(tenantId);

								RoleEntity entity = BeanMapper.map(roleVO, RoleEntity.class);
								CommonResponse<String> roleResponse = billCodeApi.getCodeBatchByRuleCode(ROLE_BILL_CODE, tenantId);
					        	if(roleResponse.isSuccess()) {
					        		entity.setCode(roleResponse.getData());
					        	}else{
					        		throw new BuilderException("网络异常， 编码生成失败， 请稍后再试");
					        	}
								entity.setSourceId(roleVO.getId());
								entity.setId(null);
								entity.setCreateTime(null);
								entity.setCreateUserCode(null);
								entity.setUpdateTime(null);
								entity.setUpdateUserCode(null);
								entity.setTenantId(tenantId);
								entity.setOrgId(orgVo.getId());
								roleService.saveOrUpdate(entity, false);//新增角色

								EmployeeVO employeeVO = employeeService.querySuperEmployeeByTenantId(tenantId);
								if(employeeVO!=null){
									//授权角色用户关系
									List<RoleUserRelationVO> data = new ArrayList<>();
									RoleUserRelationVO roleUserRelationVO = new RoleUserRelationVO();
									roleUserRelationVO.setAuthOrgId(employeeVO.getOrgId());
									roleUserRelationVO.setEmployeeId(employeeVO.getId());
									roleUserRelationVO.setJobId(employeeVO.getJobId());
									roleUserRelationVO.setProperty(String.valueOf(employeeVO.getJobType()));
									roleUserRelationVO.setRoleId(entity.getId());
									roleUserRelationVO.setUserId(employeeVO.getUserId());
									roleUserRelationVO.setTenantId(tenantId);
									roleUserRelationVO.setCreateUserCode("");
									data.add(roleUserRelationVO);
									roleUserRelationService.saveRoleUser(data);
								}

								//4、添加已存在（套餐内）的应用的角色应用关系
								//获取该套餐中已存在的应用并判断该应用是否在这个角色下存在，若存在同时该角色是首次推送给租户，则需要将该应用一起推送给租户；
								if(comboAppMap!=null&&comboAppMap.size()>0){
									//套餐中有应用
									Map<String, Object>  params = new HashMap<>();
									params.put("roleId", roleVO.getId());
									//1)、获取角色下的应用
									IPage<AppVO> dataApp = roleAppRelationService.queryPage(params, false);
									if(dataApp.getRecords().size()>0){
										List<AppVO> addApps = new ArrayList<>();//需要添加的应用
										for(AppVO app : dataApp.getRecords()){
											if(comboAppMap.get(app.getId())!=null){
												addApps.add(app);
											}
										}
										if(addApps!=null&&addApps.size()>0){
											RoleAppVO roleAppVO = new RoleAppVO();
											roleAppVO.setAppVO(addApps);
											roleAppVO.setRoleId(entity.getId());
											appService.saveRoleApp(roleAppVO);
										}
									}
								}
								
							}
							continue;
						}
						if(roleVOs!=null&&roleVOs.size()>0){
							Map<Long,RoleVO> roleMap = new HashMap<>();
							roleVOs.forEach(e -> {
								roleMap.put(e.getSourceId(), e);
							});

							for(RoleVO roleVO : roleVo){
								if(roleMap.get(roleVO.getId())!=null){
									//说明这个角色在这个租户中已存在则不再进行分配角色
									continue;
								}

								RoleEntity entity = BeanMapper.map(roleVO, RoleEntity.class);
								CommonResponse<String> roleResponse = billCodeApi.getCodeBatchByRuleCode(ROLE_BILL_CODE, tenantId);
								if(roleResponse.isSuccess()) {
									entity.setCode(roleResponse.getData());
								}else{
									throw new BuilderException("网络异常， 编码生成失败， 请稍后再试");
								}
								entity.setSourceId(roleVO.getId());
								entity.setId(IdWorker.getId());

								//3、将该角色推送给租户（角色表分配的租户各生成一条复制的角色）
								//查询分配的租户超级管理员用户详情信息
								OrgVO orgVo = orgService.findOrgByTenantId(tenantId);
								EmployeeVO employeeVO = employeeService.querySuperEmployeeByTenantId(tenantId);
								if(employeeVO==null){
									logger.error("未查询到租户:{}的超级管理员信息,将跳过超级管理员与角色[id-{}, name-{}]进行关系绑定的逻辑！", tenantId, entity.getId(), entity.getName());
//									throw new BusinessException("未查询到租户:"+tenantId+"的超级管理员信息");
								}

								entity.setCreateTime(null);
								entity.setCreateUserCode(null);
								entity.setUpdateTime(null);
								entity.setUpdateUserCode(null);
								entity.setTenantId(tenantId);
								entity.setOrgId(orgVo.getId());
								roleService.saveOrUpdate(entity, false);//新增角色

								//授权角色用户关系
								if(null != employeeVO) {
									List<RoleUserRelationVO> data = new ArrayList<>();
									RoleUserRelationVO roleUserRelationVO = new RoleUserRelationVO();
									roleUserRelationVO.setAuthOrgId(employeeVO.getOrgId());
									roleUserRelationVO.setEmployeeId(employeeVO.getId());
									roleUserRelationVO.setJobId(employeeVO.getJobId());
									roleUserRelationVO.setProperty(String.valueOf(employeeVO.getJobType()));
									roleUserRelationVO.setRoleId(entity.getId());
									roleUserRelationVO.setUserId(employeeVO.getUserId());
									roleUserRelationVO.setTenantId(tenantId);
									roleUserRelationVO.setCreateUserCode("");
									data.add(roleUserRelationVO);
									roleUserRelationService.saveRoleUser(data);
								}
								
								//4、添加已存在（套餐内）的应用的角色应用关系
								//获取该套餐中已存在的应用并判断该应用是否在这个角色下存在，若存在同时该角色是首次推送给租户，则需要将该应用一起推送给租户；
								if(comboAppMap!=null&&comboAppMap.size()>0){
									//套餐中有应用
									Map<String, Object>  params = new HashMap<>();
									params.put("roleId", roleVO.getId());
									//1)、获取角色下的应用
									IPage<AppVO> dataApp = roleAppRelationService.queryPage(params, false);
									if(dataApp.getRecords().size()>0){
										List<AppVO> addApps = new ArrayList<>();//需要添加的应用
										for(AppVO app : dataApp.getRecords()){
											if(comboAppMap.get(app.getId())!=null){
												addApps.add(app);
											}
										}
										if(addApps!=null&&addApps.size()>0){
											RoleAppVO roleAppVO = new RoleAppVO();
											roleAppVO.setAppVO(addApps);
											roleAppVO.setRoleId(entity.getId());
											appService.saveRoleApp(roleAppVO);
										}
									}
								}
							}
						}
					}
				}
			}else{
				return CommonResponse.error("保存角色数据为空");
			}
		}else{
			return CommonResponse.error("套餐id不能为空");
		}
		
		return CommonResponse.success("保存成功");
	}
}
