/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.permission.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.foundation.cache.AppCacheManage;
import com.ejianc.foundation.cache.PermissionCacheManage;
import com.ejianc.foundation.permission.bean.AppEntity;
import com.ejianc.foundation.permission.bean.CollectAppEntity;
import com.ejianc.foundation.permission.mapper.AppMapper;
import com.ejianc.foundation.permission.mapper.CollectAppMapper;
import com.ejianc.foundation.permission.service.ICollectAppService;
import com.ejianc.foundation.permission.vo.AppVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CollectAppServiceImpl
extends BaseServiceImpl<CollectAppMapper, CollectAppEntity>
implements ICollectAppService {
    @Value(value="${oms.tenantid}")
    private Long omsTenantid;
    @Autowired
    private PermissionCacheManage permissionCacheManage;
    @Autowired
    private AppMapper appMapper;
    @Autowired
    private CollectAppMapper collectAppMapper;
    @Autowired
    private AppCacheManage appCacheManage;

    @Override
    public CommonResponse<List<AppVO>> queryListByUsrId() {
        List<AppEntity> list = this.collectAppMapper.queryListByUsrId(InvocationInfoProxy.getUserid(), InvocationInfoProxy.getUserType(), InvocationInfoProxy.getTenantid());
        ArrayList<AppVO> vos = new ArrayList<AppVO>();
        ArrayList<Long> ids = new ArrayList<Long>();
        if (list != null && list.size() > 0) {
            for (AppEntity entity : list) {
                if (ids.contains(entity.getId())) continue;
                ids.add(entity.getId());
                AppVO vo = (AppVO)BeanMapper.map((Object)((Object)entity), AppVO.class);
                vos.add(vo);
            }
            Comparator<AppVO> stuComparator = new Comparator<AppVO>(){

                @Override
                public int compare(AppVO o1, AppVO o2) {
                    if (StringUtils.isBlank((CharSequence)o1.getSequence()) && StringUtils.isBlank((CharSequence)o1.getSequence())) {
                        return -1;
                    }
                    if (StringUtils.isBlank((CharSequence)o1.getSequence())) {
                        return 1;
                    }
                    if (StringUtils.isBlank((CharSequence)o2.getSequence())) {
                        return -1;
                    }
                    Integer sequence1 = Integer.parseInt(o1.getSequence());
                    Integer sequence2 = Integer.parseInt(o2.getSequence());
                    return sequence1 - sequence2;
                }
            };
            Collections.sort(vos, stuComparator);
        }
        return CommonResponse.success(vos);
    }

    @Override
    public CommonResponse<String> saveList(List<AppVO> vos) {
        ArrayList<CollectAppEntity> addEEntitys = new ArrayList<CollectAppEntity>();
        ArrayList<Long> delIds = new ArrayList<Long>();
        if (vos != null && vos.size() > 0) {
            for (AppVO vo : vos) {
                if ("del".equals(vo.getRowState())) {
                    delIds.add(vo.getId());
                    continue;
                }
                if ("add".equals(vo.getRowState())) {
                    CollectAppEntity entity = new CollectAppEntity();
                    entity.setAppId(vo.getId());
                    entity.setUserId(InvocationInfoProxy.getUserid());
                    entity.setSequence(StringUtils.isNotBlank((CharSequence)vo.getSequence()) ? Integer.valueOf(Integer.parseInt(vo.getSequence())) : null);
                    addEEntitys.add(entity);
                    continue;
                }
                if (!"edit".equals(vo.getRowState())) continue;
                UpdateWrapper wrapper = new UpdateWrapper();
                wrapper.eq((Object)"app_id", (Object)vo.getId());
                wrapper.eq((Object)"user_id", (Object)InvocationInfoProxy.getUserid());
                wrapper.set((Object)"sequence", StringUtils.isNotBlank((CharSequence)vo.getSequence()) ? Integer.valueOf(Integer.parseInt(vo.getSequence())) : null);
                this.update((Wrapper)wrapper);
            }
        }
        if (delIds != null && delIds.size() > 0) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.in((Object)"app_id", delIds);
            wrapper.eq((Object)"user_id", (Object)InvocationInfoProxy.getUserid());
            this.remove((Wrapper)wrapper);
        }
        if (addEEntitys != null && addEEntitys.size() > 0) {
            this.saveOrUpdateBatch(addEEntitys, addEEntitys.size(), false);
        }
        return CommonResponse.success();
    }
}

