/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.permission.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.cache.AppCacheManage;
import com.ejianc.foundation.cache.PermissionCacheManage;
import com.ejianc.foundation.permission.bean.ButtonEntity;
import com.ejianc.foundation.permission.bean.RoleAppRelationEntity;
import com.ejianc.foundation.permission.mapper.RoleAppRelationMapper;
import com.ejianc.foundation.permission.mapper.RoleButtonRelationMapper;
import com.ejianc.foundation.permission.service.IButtonService;
import com.ejianc.foundation.permission.service.IRoleAppRelationService;
import com.ejianc.foundation.permission.vo.AppVO;
import com.ejianc.foundation.permission.vo.ButtonVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RoleAppRelationServiceImpl
extends BaseServiceImpl<RoleAppRelationMapper, RoleAppRelationEntity>
implements IRoleAppRelationService {
    private static final String BTN_KEY = "btn_key:";
    @Autowired
    private RoleAppRelationMapper mapper;
    @Autowired
    private RoleButtonRelationMapper buttonmapper;
    @Autowired
    private PermissionCacheManage permissionCacheManage;
    @Autowired
    private IButtonService buttonService;
    @Autowired
    private AppCacheManage appCacheManage;

    @Override
    public IPage<AppVO> queryPage(Map<String, Object> params, boolean isEs) {
        if (params.get("pageIndex") != null) {
            Integer pn = Integer.parseInt(params.get("pageIndex").toString());
            pn = pn - 1 < 0 ? 1 : pn;
            long startLine = (pn - 1) * Integer.parseInt(params.get("pageSize").toString());
            params.put("startLine", startLine);
        }
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        Long count = this.mapper.countByProPerties(params);
        Page page = new Page();
        if (count > 0L) {
            List<AppVO> appVO = this.mapper.queryPageByProperties(params);
            for (AppVO vo : appVO) {
                if (vo.getBtnPower() == 1) {
                    HashMap<String, Object> param = new HashMap<String, Object>();
                    param.put("roleId", params.get("roleId"));
                    param.put("appId", vo.getId());
                    param.put("dr", 0);
                    List<ButtonVO> btnvos = this.buttonmapper.queryProperties(param);
                    if (btnvos != null && btnvos.size() > 0) {
                        vo.setChildren(btnvos);
                        continue;
                    }
                    vo.setChildren(null);
                    continue;
                }
                vo.setChildren(null);
            }
            page.setRecords(appVO);
        } else {
            page.setRecords(null);
        }
        if (params.get("pageIndex") != null) {
            page.setCurrent((long)Integer.parseInt(params.get("pageIndex").toString()));
            page.setSize((long)Integer.parseInt(params.get("pageSize").toString()));
            page.setTotal(count.longValue());
        }
        return page;
    }

    @Override
    @Transactional
    public CommonResponse<String> delete(List<RoleAppRelationEntity> appVos) {
        for (RoleAppRelationEntity appVo : appVos) {
            if ("app".equals(appVo.getDataType())) {
                this.mapper.deleteAuthApp(appVo.getRoleId(), appVo.getAppId());
                this.permissionCacheManage.removeRoleAppsCache(appVo.getRoleId(), appVo.getAppId());
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("roleId", appVo.getRoleId());
                param.put("appId", appVo.getAppId());
                param.put("dr", 0);
                List<ButtonVO> btnvos = this.buttonmapper.queryProperties(param);
                if (ListUtil.isNotEmpty(btnvos)) {
                    for (ButtonVO btn : btnvos) {
                        this.permissionCacheManage.removeRoleAppsBtnCache(appVo.getRoleId(), btn.getPageCode() + btn.getCode());
                    }
                }
                this.buttonmapper.deleteAuthButtonByAppId(appVo.getRoleId(), appVo.getAppId());
                continue;
            }
            if (!"button".equals(appVo.getDataType())) continue;
            ButtonEntity btn = (ButtonEntity)((Object)this.buttonService.selectById(appVo.getButtonId()));
            this.permissionCacheManage.removeRoleAppsBtnCache(appVo.getRoleId(), btn.getPageCode() + btn.getCode());
            this.buttonmapper.deleteAuthButton(appVo.getRoleId(), appVo.getButtonId());
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @Override
    public List<AppVO> queryAuthListByRoleId(Long roleId) {
        List<AppVO> resultList = this.mapper.queryAuthListByRoleId(roleId);
        return resultList;
    }

    @Override
    public void delByRoleIds(List<Long> roleIdList) {
        QueryWrapper roleAppListQuery = new QueryWrapper();
        roleAppListQuery.in((Object)"role_id", roleIdList);
        roleAppListQuery.in((Object)"dr", new Object[]{BaseVO.DR_DELETED});
        List list = super.list((Wrapper)roleAppListQuery);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            this.delete(list);
        }
    }

    @Override
    public CommonResponse<Boolean> checkBtnHasPermission(String pageCode, String uiKey) {
        ButtonVO btn = this.appCacheManage.getBtnCache(pageCode, uiKey);
        if (btn != null) {
            List<Long> roleIds = this.permissionCacheManage.getUserRoleCache(InvocationInfoProxy.getUserid(), InvocationInfoProxy.getTenantid());
            if (ListUtil.isNotEmpty(roleIds)) {
                for (Long role : roleIds) {
                    boolean exist = this.permissionCacheManage.isExistInRoleAppBtnCache(role, pageCode + uiKey);
                    if (!exist) continue;
                    return CommonResponse.success((Object)true);
                }
                return CommonResponse.success((Object)false);
            }
            return CommonResponse.success((Object)false);
        }
        return CommonResponse.success((Object)true);
    }

    @Override
    public IPage<AppVO> queryBookRolePage(Map<String, Object> params, boolean b) {
        if (params.get("pageIndex") != null) {
            Integer pn = Integer.parseInt(params.get("pageIndex").toString());
            pn = pn - 1 < 0 ? 1 : pn;
            long startLine = (pn - 1) * Integer.parseInt(params.get("pageSize").toString());
            params.put("startLine", startLine);
        }
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        Long count = this.mapper.countBookRole(params);
        Page page = new Page();
        if (count > 0L) {
            List<AppVO> appVO = this.mapper.queryBookRolePage(params);
            for (AppVO vo : appVO) {
                if (vo.getBtnPower() == 1) {
                    HashMap<String, Object> param = new HashMap<String, Object>();
                    param.put("roleId", params.get("roleId"));
                    param.put("appId", vo.getId());
                    param.put("dr", 0);
                    List<ButtonVO> btnvos = this.buttonmapper.queryProperties(param);
                    if (btnvos != null && btnvos.size() > 0) {
                        vo.setChildren(btnvos);
                        continue;
                    }
                    vo.setChildren(null);
                    continue;
                }
                vo.setChildren(null);
            }
            page.setRecords(appVO);
        } else {
            page.setRecords(null);
        }
        if (params.get("pageIndex") != null) {
            page.setCurrent((long)Integer.parseInt(params.get("pageIndex").toString()));
            page.setSize((long)Integer.parseInt(params.get("pageSize").toString()));
            page.setTotal(count.longValue());
        }
        return page;
    }

    @Override
    public IPage<AppVO> queryBookAppPage(Map<String, Object> params, boolean b) {
        if (params.get("pageIndex") != null) {
            Integer pn = Integer.parseInt(params.get("pageIndex").toString());
            pn = pn - 1 < 0 ? 1 : pn;
            long startLine = (pn - 1) * Integer.parseInt(params.get("pageSize").toString());
            params.put("startLine", startLine);
        }
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        Long count = this.mapper.countBookApp(params);
        Page page = new Page();
        if (count > 0L) {
            List<AppVO> appVO = this.mapper.queryBookAppPage(params);
            for (AppVO vo : appVO) {
                if (vo.getBtnPower() == 1) {
                    HashMap<String, Object> param = new HashMap<String, Object>();
                    param.put("roleId", params.get("roleId"));
                    param.put("appId", vo.getId());
                    param.put("dr", 0);
                    List<ButtonVO> btnvos = this.buttonmapper.queryProperties(param);
                    if (btnvos != null && btnvos.size() > 0) {
                        vo.setChildren(btnvos);
                        continue;
                    }
                    vo.setChildren(null);
                    continue;
                }
                vo.setChildren(null);
            }
            page.setRecords(appVO);
        } else {
            page.setRecords(null);
        }
        if (params.get("pageIndex") != null) {
            page.setCurrent((long)Integer.parseInt(params.get("pageIndex").toString()));
            page.setSize((long)Integer.parseInt(params.get("pageSize").toString()));
            page.setTotal(count.longValue());
        }
        return page;
    }
}

