/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.permission.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.cache.PermissionCacheManage;
import com.ejianc.foundation.orgcenter.bean.OrgEntity;
import com.ejianc.foundation.orgcenter.service.IOrgService;
import com.ejianc.foundation.permission.bean.RoleUserRelationEntity;
import com.ejianc.foundation.permission.mapper.RoleUserRelationMapper;
import com.ejianc.foundation.permission.service.IRoleUserRelationService;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RoleUserRelationServiceImpl
extends BaseServiceImpl<RoleUserRelationMapper, RoleUserRelationEntity>
implements IRoleUserRelationService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgService orgService;
    @Autowired
    private RoleUserRelationMapper roleUserRelationMapper;
    @Autowired
    private PermissionCacheManage permissionCacheManage;

    @Override
    public List<RoleUserRelationVO> queryListByProperties(Map<String, Object> params) {
        return this.roleUserRelationMapper.queryListByProperties(params);
    }

    @Override
    public List<RoleUserRelationVO> queryExportList(Map<String, Object> params) {
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        params.remove("pageSize");
        return this.roleUserRelationMapper.queryPageByProperties(params);
    }

    @Override
    public IPage<RoleUserRelationVO> queryPage(Map<String, Object> params, boolean isEs) {
        if (params.get("pageIndex") != null) {
            Integer pn = Integer.parseInt(params.get("pageIndex").toString());
            pn = pn - 1 < 0 ? 1 : pn;
            long startLine = (pn - 1) * Integer.parseInt(params.get("pageSize").toString());
            params.put("startLine", startLine);
        }
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        Long count = this.roleUserRelationMapper.countByProPerties(params);
        Page page = new Page();
        if (count > 0L) {
            List<RoleUserRelationVO> appVO = this.roleUserRelationMapper.queryPageByProperties(params);
            page.setRecords(appVO);
        } else {
            page.setRecords(null);
        }
        if (params.get("pageIndex") != null) {
            page.setCurrent((long)Integer.parseInt(params.get("pageIndex").toString()));
            page.setSize((long)Integer.parseInt(params.get("pageSize").toString()));
            page.setTotal(count.longValue());
        }
        return page;
    }

    @Override
    public CommonResponse<String> delete(List<Long> ids) {
        for (Long id : ids) {
            RoleUserRelationEntity entity = (RoleUserRelationEntity)((Object)this.roleUserRelationMapper.selectById(id));
            this.roleUserRelationMapper.deleteByPkId(id);
            this.permissionCacheManage.removeRoleUsersCache(entity.getRoleId(), entity.getUserId(), entity.getAuthOrgId());
        }
        return CommonResponse.success((String)"\u5220\u9664\u89d2\u8272\u7528\u6237\u6210\u529f");
    }

    @Override
    public CommonResponse<String> saveRoleUser(List<RoleUserRelationVO> data) {
        List entityList = BeanMapper.mapList(data, RoleUserRelationEntity.class);
        if (entityList != null && entityList.size() > 0) {
            this.saveOrUpdateBatch(entityList, entityList.size(), false);
            this.permissionCacheManage.putRoleUsersCache(data.get(0).getRoleId(), data);
            return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
        return CommonResponse.error((String)"\u672a\u9009\u62e9\u7528\u6237");
    }

    @Override
    public List<RoleUserRelationVO> queryRoleUserList(List<Long> roleId, List<Long> authOrgId) {
        if (authOrgId != null && authOrgId.size() > 0) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.in((Object)"parent_id", authOrgId);
            wrapper.eq((Object)"dr", (Object)0);
            List orgChildList = this.orgService.list((Wrapper)wrapper);
            for (OrgEntity entity : orgChildList) {
                if (4 != entity.getOrgType()) continue;
                authOrgId.add(entity.getId());
            }
        }
        List<RoleUserRelationVO> list = this.roleUserRelationMapper.queryRoleUserList(roleId, authOrgId);
        List<RoleUserRelationVO> list2 = this.roleUserRelationMapper.queryRolePostUserList(roleId, authOrgId);
        ArrayList<RoleUserRelationVO> result = new ArrayList<RoleUserRelationVO>();
        if (list != null && list.size() > 0) {
            result.addAll(list);
        }
        if (list2 != null && list2.size() > 0) {
            result.addAll(list2);
        }
        return result;
    }

    @Override
    public CommonResponse<String> deleteByJobIds(List<Long> jobIds) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("jobIds", jobIds);
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        List<RoleUserRelationVO> roleList = this.roleUserRelationMapper.queryListByProperties(params);
        if (roleList != null && roleList.size() > 0) {
            ArrayList<Long> roleIds = new ArrayList<Long>();
            for (RoleUserRelationVO vo : roleList) {
                roleIds.add(vo.getId());
            }
            this.delete(roleIds);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @Override
    public List<Long> findAllUidsByRoleNames(List<String> roleNames, Long tenantId) {
        return this.roleUserRelationMapper.findAllUidsByRoleNames(roleNames, tenantId);
    }

    @Override
    public IPage<RoleUserRelationVO> queryRoleByEmployeeId(Map<String, Object> params, boolean isEs) {
        if (params.get("pageIndex") != null) {
            Integer pn = Integer.parseInt(params.get("pageIndex").toString());
            pn = pn - 1 < 0 ? 1 : pn;
            long startLine = (pn - 1) * Integer.parseInt(params.get("pageSize").toString());
            params.put("startLine", startLine);
        }
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        Long count = this.roleUserRelationMapper.countByEmployeeId(params);
        Page page = new Page();
        if (count > 0L) {
            List<RoleUserRelationVO> appVO = this.roleUserRelationMapper.queryRoleByEmployeeId(params);
            page.setRecords(appVO);
        } else {
            page.setRecords(null);
        }
        if (params.get("pageIndex") != null) {
            page.setCurrent((long)Integer.parseInt(params.get("pageIndex").toString()));
            page.setSize((long)Integer.parseInt(params.get("pageSize").toString()));
            page.setTotal(count.longValue());
        }
        return page;
    }

    @Override
    public IPage<RoleUserRelationVO> querybookAppRoleDetails(Map<String, Object> params, boolean b) {
        if (params.get("pageIndex") != null) {
            Integer pn = Integer.parseInt(params.get("pageIndex").toString());
            pn = pn - 1 < 0 ? 1 : pn;
            long startLine = (pn - 1) * Integer.parseInt(params.get("pageSize").toString());
            params.put("startLine", startLine);
        }
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        Long count = this.roleUserRelationMapper.countBookAppRole(params);
        Page page = new Page();
        if (count > 0L) {
            List<RoleUserRelationVO> appVO = this.roleUserRelationMapper.bookAppRoleDetailsList(params);
            page.setRecords(appVO);
        } else {
            page.setRecords(null);
        }
        if (params.get("pageIndex") != null) {
            page.setCurrent((long)Integer.parseInt(params.get("pageIndex").toString()));
            page.setSize((long)Integer.parseInt(params.get("pageSize").toString()));
            page.setTotal(count.longValue());
        }
        return page;
    }

    @Override
    public List<RoleUserRelationVO> queryByEmployeeIdsList(List<Long> employeeIds) {
        return this.roleUserRelationMapper.queryByEmployeeIdsList(InvocationInfoProxy.getTenantid(), employeeIds);
    }

    @Override
    public List<RoleUserRelationVO> findAllByRoleNameAndUserId(String roleName, Long userId) {
        return this.roleUserRelationMapper.findAllByRoleNameAndUserId(roleName, userId, null);
    }

    @Override
    public List<RoleUserRelationVO> findAllByRoleNameAndUserId(String roleName, Long userId, Long tenantId) {
        return this.roleUserRelationMapper.findAllByRoleNameAndUserId(roleName, userId, tenantId);
    }
}

