package com.ejianc.foundation.comment.service.impl;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.usercenter.bean.ThirdSystemEntity;
import com.ejianc.foundation.usercenter.service.IThirdSystemService;
import com.ejianc.framework.auth.session.SessionManager;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.foundation.comment.bean.CommentEntity;
import com.ejianc.foundation.comment.mapper.CommentMapper;
import com.ejianc.foundation.comment.service.ICommentService;
import com.ejianc.foundation.comment.vo.CommentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

/**
 * 评论
 * 
 * @author generator
 * 
 */
@Service("commentService")
public class CommentServiceImpl extends BaseServiceImpl<CommentMapper, CommentEntity> implements ICommentService{
    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Value("${weixinParam.sendCcUser:nFBuRUh66OVkyaJI4xnO2235TR7uf35fAxoRaWcNI5k}")
    private String sendCcUserTemplateId;//收到新的单据评价抄送提醒
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private ICommentService commentService;
    @Autowired
    private CommentMapper commentMapper;
    @Autowired
    private IThirdSystemService thirdSystemService;
    @Autowired
    private EnvironmentTools environmentTools;
    @Autowired
    private SessionManager sessionManager;

    /**
     * 保存
     * @param entity
     * @param b
     * @return
     */
    public CommentVO saveOrUpdates(CommentEntity entity, boolean b) {
        commentService.saveOrUpdate(entity);
        CommentVO vo = BeanMapper.map(entity, CommentVO.class);
        commentService.sendMessage(vo);
        return vo;
    }

    /**
     * 发消息
     * @param vo
     */
    public void sendMessage(CommentVO vo){
        try{
            //发送消息
            String attention = vo.getAttention();
            if(StringUtils.isEmpty(attention)){
                logger.info("评论保存时，没有@人，不发消息！");
                return;
            }
            if(attention.contains("1247777316689256450")){
                attention = attention.replaceAll("1247777316689256450", "303581417601122400");
            }
            String[] receivers = attention.split(",");
//            String [] receivers =vo.getAttention().split(",");
            if(receivers.length > 0){
                logger.info("发送消息开始！===========>{}",receivers);
                PushMsgParameter parameter = new PushMsgParameter();
                List<String> channel = new ArrayList<>();
                channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);
                channel.add(PushMsgParameter.CHANNEL_TYPE_WEIXIN);
                parameter.setChannel(channel.toArray(new String[0]));// 消息类型
                parameter.setReceivers(receivers);// 收信人
                parameter.setMsgType("commentcc");
//                String subject = "评论:"+vo.getUserName()+"@"+"了你";
                String subject = "您有一条评论消息，【"+vo.getUserName()+"】评论了【"+vo.getCreateBillUserName()+"】创建的【"+vo.getBillTypeName()+"】并@了你。";
                parameter.setSubject(subject);// 标题
                String url = environmentTools.getBaseHost() + vo.getProjectUrl()+"?"+vo.getBillTypeId();

                if(vo.getPcAndMobile()){
                    parameter.setContent(vo.getUserName()+"@"+"了你点击查看。<a href="+'"'+url+'"'+">点击查看</a>");// 内容
                }else{
                    parameter.setContent(vo.getUserName()+"@"+"了你"+"。<a href=" + '"' + vo.getProjectUrl() + '"' + ">前往点击</a>");// 内容
                }
                parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
                parameter.setSendUserId(vo.getUserId());

                String maUrl = vo.getMaUrl().contains("http")?vo.getMaUrl():(environmentTools.getBaseHost() +vo.getMaUrl());
                parameter.setMobileUrl(maUrl);//
                String pcUrl = vo.getProjectUrl();
                if(StringUtils.isNotBlank(pcUrl)&&!pcUrl.contains("http")){
                    pcUrl = (environmentTools.getBaseHost() + pcUrl);
                }
                parameter.setPcUrl(pcUrl);//

                // 微信公众号消息
                JSONObject weixinParams = new JSONObject();
                weixinParams.put("template_id", sendCcUserTemplateId);

                JSONObject wxparams = new JSONObject();
                wxparams.put("first", vo.getUserName()+"@"+"了你");
                wxparams.put("keyword1", vo.getBillTypeName());
                wxparams.put("keyword2", sessionManager.getUserContext().getUserName());
                wxparams.put("keyword3", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                wxparams.put("remark", "请您关注！");
                weixinParams.put("data", wxparams);
                weixinParams.put("url", maUrl+ "&openid={openid}");
                parameter.setWeixinParams(weixinParams);

                String customerChannel = sessionManager.getUserContext().getCustomerChannel();
                QueryWrapper<ThirdSystemEntity> thirdSystemWrapper = new QueryWrapper<>();
                thirdSystemWrapper.eq("tenant_id", "999999");
                if(StringUtils.isNotBlank(customerChannel)){
                    ThirdSystemEntity thirdSystemEntity = new ThirdSystemEntity();
                    if("weixinee_channel".equals(customerChannel)){
                        channel.add(PushMsgParameter.CHANNEL_TYPE_WEXINEE);
                        thirdSystemWrapper.eq("code", "weixineeThirdApp");
                        thirdSystemEntity = thirdSystemService.getOne(thirdSystemWrapper);
                        String configInfo = thirdSystemEntity.getConfigInfo();
                        JSONObject configJson = JSON.parseObject(configInfo);
                        String agentid = configJson.getString("agentid");
                        JSONObject weixineeParams = new JSONObject();
                        weixineeParams.put("agentid", agentid);
                        weixineeParams.put("msgtype", "textcard");
                        weixineeParams.put("title", "评论消息抄送通知");
                        weixineeParams.put("description", "评论:"+vo.getUserName()+"@"+"了你");
                        weixineeParams.put("url", (maUrl + "&userid={userid}"));
                        weixineeParams.put("btntxt", "点击查看");
                        parameter.setWeixineeParams(weixineeParams);

                    }else if("dingding_channel".equals(customerChannel)){
                        channel.add(PushMsgParameter.CHANNEL_TYPE_DDTHIRDAPP);
                        thirdSystemWrapper.eq("code", "ddThirdAppTemlateId");
                        thirdSystemEntity = thirdSystemService.getOne(thirdSystemWrapper);
                        String configInfo = thirdSystemEntity.getConfigInfo();
                        JSONObject configJson = JSON.parseObject(configInfo);
                        String templateId = configJson.getString("noticeId");
                        if (StringUtils.isNotBlank(templateId)) {
                            //钉钉
                            channel.add(PushMsgParameter.CHANNEL_TYPE_DDTHIRDAPP);
                            JSONObject dingdingParams = new JSONObject();
                            dingdingParams.put("type", "bpmNotice");
                            dingdingParams.put("title", "评论消息抄送通知");
                            dingdingParams.put("content", "评论:"+vo.getUserName()+"@"+"了你");
                            String ddPcurl = url;
                            ddPcurl = environmentTools.getBaseHost() + "portal/sso/index?userid={userid}&targeturl=" + ddPcurl;
                            dingdingParams.put("pcurl", ddPcurl);
                            dingdingParams.put("maurl", maUrl+ "&ddThirdAppid={ddThirdAppid}");
                            dingdingParams.put("billTypeName", vo.getBillTypeName());
                            dingdingParams.put("userLabel", "评论人：");
                            dingdingParams.put("userName", sessionManager.getUserContext().getUserName());
                            dingdingParams.put("timeLabel", "评论时间：");
                            dingdingParams.put("timeValue", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                            dingdingParams.put("templateId", templateId);
                            parameter.setDingdingParams(dingdingParams);
                        } else {
                            logger.info("---------------缺少钉钉第三方应用审批消息模板-------------------");
                        }
                    }
                }

                logger.info("parameter###{}",BeanMapper.map(parameter,JSONObject.class).toJSONString());
                try {
                    CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
                    if (result.isSuccess()) {
                        logger.error("消息发送成功---------------->" + result.getMsg());
                    } else {
                        logger.error("消息发送失败---------------->" + result.getMsg());
                    }
                } catch (Exception e) {
                    logger.error("调用消息中心RPC服务异常--------------" + e);
                }
            }
        }catch(Exception e){
            e.printStackTrace();
            logger.error("调用消息中心RPC服务异常--------------{}",e.getMessage() == null?"空指针了":e.getMessage());
        }
    }

    /**
     * 根据userId 和billTypeId删除
     * @param billTypeId
     * @param userId
     */
    public void removeUserById(Long billTypeId, Long userId) {
        QueryWrapper<CommentEntity> delWrapper = new QueryWrapper<>();
        delWrapper.eq("bill_type_id", billTypeId);
        delWrapper.eq("user_id", userId);
        this.remove(delWrapper);
    }

    /**
     * 查询提醒
     * @param billTypeId
     * @return
     */
    public List<CommentVO> queryTipsList(Long billTypeId) {
        QueryWrapper<CommentEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("bill_type_id", billTypeId);
        queryWrapper.eq("whether_tips",false);
        queryWrapper.orderByDesc("create_time");
        List<CommentEntity> list =commentMapper.selectList(queryWrapper);
        List<CommentVO> voList =BeanMapper.mapList(list,CommentVO.class);
        return voList;
    }

    /**
     * 处理提醒
     * @param id
     */
    public void updateHandleTips(Long billTypeId) {
        UpdateWrapper<CommentEntity> updateWrapper = new UpdateWrapper<>();
        updateWrapper.set("whether_tips",true);
        CommentEntity commentEntity =this.selectById(billTypeId);
        commentEntity.setWhetherTips(true);
        commentService.saveOrUpdate(commentEntity,false);
    }


}
