package com.ejianc.foundation.permission.mapper;

import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import com.ejianc.foundation.permission.bean.RoleUserRelationEntity;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;

import java.util.List;
import java.util.Map;

@Mapper
public interface RoleUserRelationMapper extends BaseCrudMapper<RoleUserRelationEntity> {

    /**
     * 根据条件查询人员角色关系列表
     *
     * @param params
     * @return
     */
    List<RoleUserRelationVO> queryListByProperties(Map<String, Object> params);

    Long countByProPerties(Map<String, Object> queryParam);
    
    List<RoleUserRelationVO> queryPageByProperties(Map<String, Object> queryParam);

	void deleteByPkId(@Param("id") Long id);

    List<RoleUserRelationVO> queryRoleUserList(@Param("roleId") List<Long> roleId,@Param("authOrgId") List<Long> authOrgId);

    List<RoleUserRelationVO> queryRolePostUserList(@Param("roleId") List<Long> roleId,@Param("authOrgId") List<Long> authOrgId);

    /**
     * 根据角色名称查询租户下所有绑定的用户Id列表
     *
     * @param roleNames
     * @param tenantId
     * @return
     */
    List<Long> findAllUidsByRoleNames(@Param("roleNames") List<String> roleNames, @Param("tenantId") Long tenantId);

    Long countByEmployeeId(Map<String, Object> queryParam);

    List<RoleUserRelationVO> queryRoleByEmployeeId(Map<String, Object> queryParam);


    public List<RoleUserRelationVO> bookAppRoleDetailsList(Map<String, Object> params);

    public Long countBookAppRole(Map<String, Object> params);

    List<RoleUserRelationVO> queryByEmployeeIdsList(@Param("tenantId") Long tenantId , @Param("employeeIds") List<Long> employeeIds);

    List<RoleUserRelationVO> findAllByRoleNameAndUserId(@Param("roleName") String roleName, @Param("userId") Long userId, @Param("tenantId") Long tenantId);
}
