package com.ejianc.foundation.permission.service;

import java.util.List;
import java.util.Map;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.permission.bean.RoleUserRelationEntity;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

public interface IRoleUserRelationService extends IBaseService<RoleUserRelationEntity> {

    /**
     * 根据条件查询匹配的人员角色列表
     *
     * @param params
     * @return
     */
    List<RoleUserRelationVO> queryListByProperties(Map<String, Object> params);

    List<RoleUserRelationVO> queryExportList(Map<String, Object> params);

	IPage<RoleUserRelationVO> queryPage(Map<String, Object> params, boolean isEs);

	CommonResponse<String> delete(List<Long> ids);

	CommonResponse<String> saveRoleUser(List<RoleUserRelationVO> data);

	/**
	 * 批量查询角色用户
	 * 
	 * @param queryParam 查询参数
	 * @param isEs 是否查询es
	 * @return
	 */
	List<RoleUserRelationVO> queryRoleUserList(List<Long> roleId, List<Long> authOrgId);

	//根据jobId删除用户角色授权
	CommonResponse<String> deleteByJobIds(List<Long> jobId);

	/**
	 * 根据角色名称查询租户下所有绑定的用户Id列表
	 *
	 * @param roleNames
	 * @param tenantId
	 * @return
	 */
    List<Long> findAllUidsByRoleNames(List<String> roleNames, Long tenantId);

	/**
	 * 根据人员id查询角色
	 * @return
	 */
    public IPage<RoleUserRelationVO>  queryRoleByEmployeeId(Map<String, Object> params, boolean isEs);

	public IPage<RoleUserRelationVO> querybookAppRoleDetails(Map<String, Object> params, boolean b);

	public List<RoleUserRelationVO> queryByEmployeeIdsList(List<Long> employeeIds);

	/**
	 * 根据用户ID查询用户在所有租户下关联指定角色名称的绑定关系列表
	 *
	 * @param roleName
	 * @param userName
	 * @return
	 */
    List<RoleUserRelationVO> findAllByRoleNameAndUserId(String roleName, Long userName);

	/**
	 * 根据用户ID查询用户在所有租户下关联指定角色名称的绑定关系列表
	 *
	 * @param roleName
	 * @param userName
	 * @return
	 */
    List<RoleUserRelationVO> findAllByRoleNameAndUserId(String roleName, Long userName, Long tenantId);
}
